/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.ReciprocalInitField;
import kd.fi.gl.reciprocal.AssistTypeValue;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.FlexUtils;
import org.apache.commons.lang3.tuple.Triple;

public class ReciprocalInitUtils {
    private static final int MAXDATA = 5000;
    private static final Log logger = LogFactory.getLog(ReciprocalInitUtils.class);

    public static DataSet getBalanceNoAccheck(AccountBookInfo accountBookInfo, DynamicObject account, Collection<FlexUtils.AssistFilterEntry> assistFilterEntries, Long periodId, Long[] currencyIds) {
        if (!accountBookInfo.isIsendinit()) {
            return ReciprocalInitUtils.genNullBalance();
        }
        String selector = "account,currency,assgrp,beginfor,beginlocal";
        QueryParam balParam = new QueryParam();
        balParam.setAssGrpIds(null);
        balParam.setSumAssgrp(true);
        balParam.setOnlyLeafAcctBal(true);
        balParam.setCurrencyIds(currencyIds);
        QFilter accountFilter = new QFilter("id", "=", account.get("id"));
        balParam.setAccountFilter(accountFilter);
        if (assistFilterEntries != null) {
            Triple<MainEntityType, List<QFilter>, List<String>> balanceOrmInfo = FlexUtils.buildDynamicORMAssistOnBalance(assistFilterEntries, "gl_balance", false);
            balParam.setBalEntityType((MainEntityType)balanceOrmInfo.getLeft());
            ArrayList customF = balParam.getCustomFilter();
            if (customF == null) {
                customF = new ArrayList(4);
            }
            customF.addAll((Collection)balanceOrmInfo.getMiddle());
            balParam.setCustomFilter(customF);
        }
        long curPeriodAccountTableId = AccountRefUtils.getCurPeriodAccountTableId((long)accountBookInfo.getOrgId(), (long)accountBookInfo.getBookTypeId(), (long)periodId);
        DataSet balanceDs = BalanceQueryExecutor.getInstance().getBalance(selector, new Long[]{accountBookInfo.getOrgId()}, accountBookInfo.getBookTypeId(), curPeriodAccountTableId, periodId.longValue(), periodId.longValue(), balParam);
        return balanceDs;
    }

    public static DataSet getDynamicOrmDataSet(AccountBookInfo accountBookInfo, DynamicObject account, Long periodId, List<String> accheckFlexField, String entityName) {
        DataSet dataSet;
        long tick = System.currentTimeMillis();
        String forField = "amountfor";
        String localField = "amountlocal";
        if ("gl_balance".equals(entityName)) {
            forField = "beginfor";
            localField = "beginlocal";
            dataSet = ReciprocalInitUtils.getBalanceNoAccheck(accountBookInfo, account, periodId, accheckFlexField);
        } else {
            dataSet = ReciprocalInitUtils.queryReciprocalInitDataSet(accountBookInfo, account, accheckFlexField);
        }
        ArrayList<String> groupByField = new ArrayList<String>(accheckFlexField.size() + 2);
        groupByField.add("account");
        groupByField.add("currency");
        groupByField.addAll(accheckFlexField);
        ArrayList<String> orderByField = new ArrayList<String>(accheckFlexField.size() + 1);
        orderByField.add("currency");
        orderByField.addAll(accheckFlexField);
        ArrayList<String> selectField = new ArrayList<String>(accheckFlexField.size() + 4);
        selectField.add("account");
        selectField.add("currency");
        selectField.add(forField);
        selectField.add(localField);
        selectField.addAll(accheckFlexField);
        dataSet = dataSet.groupBy(groupByField.toArray(new String[0])).sum(forField).sum(localField).finish();
        dataSet = dataSet.orderBy(orderByField.toArray(new String[0]));
        dataSet = dataSet.select(selectField.toArray(new String[0]));
        logger.info("endreciprocalinit getDynamicOrmDataSet of {} cost:{}ms", (Object)entityName, (Object)(System.currentTimeMillis() - tick));
        return dataSet;
    }

    public static DataSet getBalanceNoAccheck(AccountBookInfo accountBookInfo, DynamicObject account, Long periodId, List<String> accheckFlexField) {
        String selector = "account,currency,beginfor,beginlocal";
        QueryParam balParam = new QueryParam();
        balParam.setAssGrpIds(null);
        balParam.setSumAssgrp(true);
        balParam.setOnlyLeafAcctBal(true);
        balParam.setCurrencyIds(null);
        QFilter accountFilter = new QFilter("id", "=", account.get("id"));
        balParam.setAccountFilter(accountFilter);
        Triple<MainEntityType, List<QFilter>, List<String>> entityTriple = FlexUtils.buildDynamicORMAssistOnBalance(accheckFlexField, "gl_balance", true);
        balParam.setBalEntityType((MainEntityType)entityTriple.getLeft());
        ArrayList customFiter = new ArrayList(accheckFlexField.size());
        customFiter.addAll((Collection)entityTriple.getMiddle());
        balParam.setCustomFilter(customFiter);
        DataSet ds = BalanceQueryExecutor.getInstance().getBalance(selector + "," + Joiner.on((String)",").join((Iterable)entityTriple.getRight()), new Long[]{accountBookInfo.getOrgId()}, accountBookInfo.getBookTypeId(), accountBookInfo.getAccountTableId(), periodId.longValue(), periodId.longValue(), balParam);
        return ds;
    }

    public static DataSet queryReciprocalInitDataSet(AccountBookInfo accountBookInfo, DynamicObject account, List<String> accheckFlexField) {
        ORM orm = ORM.create();
        Triple<MainEntityType, List<QFilter>, List<String>> entityTriple = FlexUtils.buildDynamicORMAssistOnBalance(accheckFlexField, "gl_initacccurrent", true);
        orm.setDataEntityType("gl_initacccurrent", (IDataEntityType)entityTriple.getLeft());
        QFilter orgFilter = new QFilter("org", "=", (Object)accountBookInfo.getOrgId());
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)accountBookInfo.getBookTypeId());
        QFilter acctFilter = new QFilter("account.masterid", "=", (Object)account.getLong("masterid"));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3 + accheckFlexField.size());
        filters.add(orgFilter);
        filters.add(bookTypeFilter);
        filters.add(acctFilter);
        filters.addAll((Collection)entityTriple.getMiddle());
        String selectFields = "account.masterid account, currency, assgrp, amountfor, amountlocal," + Joiner.on((String)",").join((Iterable)entityTriple.getRight());
        DataSet ds = orm.queryDataSet(ReportUtils.class.getName() + "/", "gl_initacccurrent", selectFields, filters.toArray(new QFilter[0]));
        return ds;
    }

    private static DataSet genNullBalance() {
        RowMeta meta = RowMetaFactory.createRowMeta((String[])new String[]{"account", "currency", "assgrp", "beginfor", "beginlocal"}, (DataType[])new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType});
        DataSetBuilder builder = Algo.create((String)"ReciprocalInitUtils.genNullBalance").createDataSetBuilder(meta);
        return builder.build();
    }

    public static List<DynamicObject> buildReciprocalRecordFromInit(DynamicObject account, AccountBookInfo accountBookInfo, QFilter orgFilter, QFilter bookTypeFilter, Long acctTblId, DynamicObject period) {
        QFilter acctFilter = new QFilter("account.masterid", "=", (Object)account.getLong("masterid"));
        QFilter recordIsNullFilter = new QFilter("reciprocalrecord", "=", (Object)0L);
        String selectFields = "account, currency, assgrp, amountfor, amountlocal, bizdate, deadlinedate, bizbillno, description, reciprocalrecord";
        DynamicObject[] reciprocalInitArray = BusinessDataServiceHelper.load((String)"gl_initacccurrent", (String)selectFields, (QFilter[])new QFilter[]{acctFilter, orgFilter, bookTypeFilter, recordIsNullFilter}, null, (int)5000);
        ArrayList<DynamicObject> reciprocalRecordList = new ArrayList<DynamicObject>(reciprocalInitArray.length);
        long[] recordIds = DB.genGlobalLongIds((int)reciprocalInitArray.length);
        Date modifyDate = TimeServiceHelper.now();
        for (int i = 0; i < reciprocalInitArray.length; ++i) {
            DynamicObject reciprocalInit = reciprocalInitArray[i];
            long recordId = recordIds[i];
            DynamicObject reciprocalRecord = ReciprocalInitUtils.initReciprocalRecord(accountBookInfo, acctTblId);
            reciprocalRecord.set("id", (Object)recordId);
            DynamicObject acct = reciprocalInit.getDynamicObject("account");
            reciprocalRecord.set("account", acct == null ? null : Long.valueOf(acct.getLong("masterid")));
            reciprocalRecord.set("assgrp", (Object)reciprocalInit.getLong(ReciprocalInitField.id_("assgrp")));
            reciprocalRecord.set("amountfor", (Object)reciprocalInit.getBigDecimal("amountfor"));
            reciprocalRecord.set("amountbalfor", (Object)reciprocalInit.getBigDecimal("amountfor"));
            reciprocalRecord.set("amount", (Object)reciprocalInit.getBigDecimal("amountlocal"));
            reciprocalRecord.set("amountbal", (Object)reciprocalInit.getBigDecimal("amountlocal"));
            reciprocalRecord.set("currency", (Object)reciprocalInit.getLong(ReciprocalInitField.id_("currency")));
            reciprocalRecord.set("bizdate", (Object)reciprocalInit.getDate("bizdate"));
            reciprocalRecord.set("expiredate", (Object)reciprocalInit.getDate("deadlinedate"));
            reciprocalRecord.set("biznum", (Object)reciprocalInit.getString("bizbillno"));
            reciprocalRecord.set("description", (Object)reciprocalInit.getString("description"));
            reciprocalRecord.set("status", (Object)"0");
            reciprocalRecord.set("sourcetype", (Object)"0");
            reciprocalRecord.set("modifytime", (Object)modifyDate);
            reciprocalRecord.set("createtime", (Object)modifyDate);
            reciprocalRecord.set("effectivedate", (Object)BalanceTransferUtils.getInitBeginDate());
            reciprocalRecord.set("uneffectivedate", (Object)BalanceTransferUtils.getEndDate());
            reciprocalRecord.set("masterid", (Object)recordId);
            reciprocalRecord.set("bookeddate", (Object)period.getDate("begindate"));
            reciprocalRecord.set("period", (Object)period.getDate("id"));
            reciprocalRecordList.add(reciprocalRecord);
            reciprocalInit.set("reciprocalrecord", (Object)recordId);
        }
        SaveServiceHelper.save((DynamicObject[])reciprocalInitArray);
        return reciprocalRecordList;
    }

    public static DynamicObject[] updateReciprocalRecordFromInit(QFilter idFilter, DynamicObject period) {
        String selectFields = "account, currency, assgrp, amountfor, amountlocal, bizdate, deadlinedate, bizbillno, description, reciprocalrecord";
        DynamicObject[] reciprocalInitArray = BusinessDataServiceHelper.load((String)"gl_initacccurrent", (String)selectFields, (QFilter[])idFilter.toArray());
        if (reciprocalInitArray == null || reciprocalInitArray.length == 0) {
            return null;
        }
        HashMap<Long, DynamicObject> reciprocalInitMap = new HashMap<Long, DynamicObject>(reciprocalInitArray.length);
        for (int i = 0; i < reciprocalInitArray.length; ++i) {
            DynamicObject reciprocalInit = reciprocalInitArray[i];
            Long recordId = reciprocalInit.getLong(ReciprocalInitField.id_("reciprocalrecord"));
            reciprocalInitMap.put(recordId, reciprocalInit);
        }
        QFilter recordIdFilter = new QFilter("id", "in", reciprocalInitMap.keySet());
        selectFields = "account,assgrp,currency,amountfor,amountbalfor,amount,amountbal,bizdate,expiredate,biznum,description,modifytime,bookeddate,period";
        DynamicObject[] reciprocalRecordArray = BusinessDataServiceHelper.load((String)"gl_acccurrent", (String)selectFields, (QFilter[])recordIdFilter.toArray());
        Date modifyDate = TimeServiceHelper.now();
        for (int i = 0; i < reciprocalRecordArray.length; ++i) {
            DynamicObject reciprocalRecord;
            Long recordId = (reciprocalRecord = reciprocalRecordArray[i]).getLong("id");
            DynamicObject reciprocalInit = (DynamicObject)reciprocalInitMap.get(recordId);
            DynamicObject acct = reciprocalInit.getDynamicObject("account");
            reciprocalRecord.set("account", acct == null ? null : Long.valueOf(acct.getLong("masterid")));
            reciprocalRecord.set("assgrp", (Object)reciprocalInit.getLong(ReciprocalInitField.id_("assgrp")));
            reciprocalRecord.set("currency", (Object)reciprocalInit.getLong(ReciprocalInitField.id_("currency")));
            reciprocalRecord.set("amountfor", (Object)reciprocalInit.getBigDecimal("amountfor"));
            reciprocalRecord.set("amountbalfor", (Object)reciprocalInit.getBigDecimal("amountfor"));
            reciprocalRecord.set("amount", (Object)reciprocalInit.getBigDecimal("amountlocal"));
            reciprocalRecord.set("amountbal", (Object)reciprocalInit.getBigDecimal("amountlocal"));
            reciprocalRecord.set("bizdate", (Object)reciprocalInit.getDate("bizdate"));
            reciprocalRecord.set("expiredate", (Object)reciprocalInit.getDate("deadlinedate"));
            reciprocalRecord.set("biznum", (Object)reciprocalInit.getString("bizbillno"));
            reciprocalRecord.set("description", (Object)reciprocalInit.getString("description"));
            reciprocalRecord.set("modifytime", (Object)modifyDate);
            reciprocalRecord.set("bookeddate", (Object)period.getDate("begindate"));
            reciprocalRecord.set("period", (Object)period.getDate("id"));
        }
        return reciprocalRecordArray;
    }

    private static DynamicObject initReciprocalRecord(AccountBookInfo accountBookInfo, Long acctTblId) {
        DynamicObject reciprocalRecord = BusinessDataServiceHelper.newDynamicObject((String)"gl_acccurrent");
        reciprocalRecord.set(ReciprocalInitField.id_("org"), (Object)accountBookInfo.getOrgId());
        reciprocalRecord.set(ReciprocalInitField.id_("booktype"), (Object)accountBookInfo.getBookTypeId());
        reciprocalRecord.set(ReciprocalInitField.id_("accounttable"), (Object)acctTblId);
        reciprocalRecord.set("localcurrency_id", (Object)accountBookInfo.getBaseCurrencyId());
        return reciprocalRecord;
    }

    public static Map<Long, String> analyzeAssgrpNameById(Set<Long> assgrpIdSet) {
        if (assgrpIdSet == null || assgrpIdSet.size() == 0) {
            return null;
        }
        HashMap assistTypeValueMap = new HashMap();
        HashMap entityQFilterMap = new HashMap();
        DataSet resultDs = ReciprocalInitUtils.queryResultDs(assgrpIdSet);
        Object object = null;
        try {
            if (resultDs != null) {
                for (Row row : resultDs) {
                    Long assgrpId = row.getLong("hg");
                    String assEntity = row.getString("valuesource");
                    Long assval = row.getLong("assval");
                    if (assEntity == null) continue;
                    String string = assEntity = "bos_assistantdatagroup".equals(assEntity) ? "bos_assistantdata_detail" : assEntity;
                    if (entityQFilterMap.containsKey(assEntity)) {
                        ((Set)entityQFilterMap.get(assEntity)).add(assval);
                    } else {
                        HashSet<Long> assvalSet = new HashSet<Long>();
                        assvalSet.add(assval);
                        entityQFilterMap.put(assEntity, assvalSet);
                    }
                    String asstypeName = row.getString("name");
                    AssistTypeValue atv = new AssistTypeValue(assEntity, assval, asstypeName);
                    if (assistTypeValueMap.containsKey(assgrpId)) {
                        ((List)assistTypeValueMap.get(assgrpId)).add(atv);
                        continue;
                    }
                    ArrayList<AssistTypeValue> atvList = new ArrayList<AssistTypeValue>();
                    atvList.add(atv);
                    assistTypeValueMap.put(assgrpId, atvList);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (resultDs != null) {
                if (object != null) {
                    try {
                        resultDs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    resultDs.close();
                }
            }
        }
        HashMap resultMap = new HashMap(entityQFilterMap.size());
        for (Map.Entry entry : entityQFilterMap.entrySet()) {
            Set assvalSet = (Set)entry.getValue();
            HashMap<Long, String> entityResult = new HashMap<Long, String>();
            QFilter idFilter = new QFilter("id", "in", (Object)assvalSet);
            BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)((String)entry.getKey()));
            String name = entityType.getNameProperty();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ReciprocalInitUtil.analyzeAssgrpNameById", (String)((String)entry.getKey()), (String)("id," + name), (QFilter[])idFilter.toArray(), null);){
                if (ds != null) {
                    for (Row row : ds) {
                        entityResult.put(row.getLong("id"), row.getString(name));
                    }
                }
            }
            resultMap.put(entry.getKey(), entityResult);
        }
        HashMap<Long, String> assistNameMap = new HashMap<Long, String>();
        for (Long assgrpId : assgrpIdSet) {
            List atvList = (List)assistTypeValueMap.get(assgrpId);
            if (atvList == null || atvList.size() == 0) {
                if (assgrpId != 0L) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"ID\u4e3a\u201c%s\u201d\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"ReciprocalInitUtils_0", (String)"fi-gl-common", (Object[])new Object[0]), assgrpId));
                }
                assistNameMap.put(assgrpId, null);
                continue;
            }
            ArrayList<String> assValNameList = new ArrayList<String>();
            for (AssistTypeValue atv : atvList) {
                String assvalName = (String)((Map)resultMap.get(atv.getAssEntity())).get(atv.getAssval());
                atv.setAssvalName(assvalName);
                if (atv.getAssvalName() == null) continue;
                assValNameList.add(atv.toString());
            }
            assistNameMap.put(assgrpId, String.join((CharSequence)",", assValNameList));
        }
        return assistNameMap;
    }

    private static DataSet queryResultDs(Set<Long> assgrpIdSet) {
        String selectFields = "hg, asstype, assval";
        QFilter idFilter = new QFilter("hg", "in", assgrpIdSet);
        DataSet glAssistDs = QueryServiceHelper.queryDataSet((String)(ReciprocalInitUtils.class.getName() + "queryResultDs_gl"), (String)"gl_assist_bd", (String)selectFields, (QFilter[])idFilter.toArray(), null);
        String asstacttypeSelectFields = "flexfield, name, valuesource";
        DataSet asstypeDs = QueryServiceHelper.queryDataSet((String)(ReciprocalInitUtils.class.getName() + "queryResultDs_bd"), (String)"bd_asstacttype", (String)asstacttypeSelectFields, null, null);
        DataSet resultDs = glAssistDs.join(asstypeDs, JoinType.LEFT).on("asstype", "flexfield").select(new String[]{"hg", "asstype", "assval"}, new String[]{"name", "valuesource"}).finish();
        return resultDs;
    }

    public static Map<Long, String> getCurrencyName(Set<Long> currencyIdSet) {
        if (currencyIdSet == null || currencyIdSet.size() == 0) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "in", currencyIdSet);
        HashMap<Long, String> currencyIdNameMap = new HashMap<Long, String>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(ReciprocalInitUtils.class.getName() + "getCurrencyName"), (String)"bd_currency", (String)"id, name", (QFilter[])idFilter.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    String name = row.getString("name");
                    Long id = row.getLong("id");
                    currencyIdNameMap.put(id, name);
                }
            }
        }
        return currencyIdNameMap;
    }

    public static void addReciprocalAccountF7Filter(List<QFilter> lstFilters, Long orgId, Long accountTblId, boolean needBaseDataFilter) {
        lstFilters.add(new QFilter("accounttable", "=", (Object)accountTblId));
        if (needBaseDataFilter) {
            QFilter qids = AccountUtils.getAccountDataFilter((long)orgId, (long)accountTblId);
            lstFilters.add(qids);
        }
        lstFilters.add(new QFilter("isleaf", "=", (Object)true));
        lstFilters.add(new QFilter("accheck", "=", (Object)true));
    }

    public static DataSet queryIsEndInitReciprocalInit(boolean needEndInit, Long orgId, Long bookTypeId, Long accountTblId) {
        DataSet ds = ReciprocalInitUtils.queryAllEndInitReciprocalInit(orgId, bookTypeId, accountTblId);
        ds = needEndInit ? ds.filter("isendinit = null or isendinit = false") : ds.filter("isendinit = true");
        return ds;
    }

    public static DataSet queryAllEndInitReciprocalInit(Long orgId, Long bookTypeId, Long accountTblId) {
        DataSet initDs = ReciprocalInitUtils.getAccountReciprocalInitDs(orgId, accountTblId);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("booktype", "=", (Object)bookTypeId));
        DataSet isEndInitDs = QueryServiceHelper.queryDataSet((String)"ReciprocalInitUtil.queryIsEndInitReciprocalInit", (String)"gl_reci_init_state", (String)"account.masterid account, endinitperiod, isendinit,booktype", (QFilter[])filter.toArray(), null);
        DataSet ds = initDs.join(isEndInitDs, JoinType.LEFT).on("account", "account").select(new String[]{"id", "account"}, new String[]{"endinitperiod", "isendinit", "booktype"}).finish();
        ds = ds.join(QueryServiceHelper.queryDataSet((String)"ReciprocalInitUtil.queryIsEndInitReciprocalInit", (String)"bd_period", (String)"id periodid,begindate", null, null), JoinType.LEFT).on("endinitperiod", "periodid").select(new String[]{"id", "account", "endinitperiod", "isendinit", "booktype"}, new String[]{"begindate"}).finish();
        return ds;
    }

    private static DataSet getAccountReciprocalInitDs(Long orgId, Long accountTblId) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
        ReciprocalInitUtils.addReciprocalAccountF7Filter(lstFilters, orgId, accountTblId, true);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"ReciprocalInitUtil.getAccountReciprocalInitDs", (String)"bd_accountview", (String)"id,masterid account", (QFilter[])lstFilters.toArray(new QFilter[0]), (String)"number");
        return ds;
    }
}

