/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.fi.gl.enums.writeoff.WriteOffField;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalContext;
import kd.fi.gl.reciprocal.ReciprocalScheme;

public class ReciprocalRecord
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8208623489881848017L;
    private Long id;
    private Long masterId;
    private Long org;
    private Long bookType;
    private Long period;
    private Long accountTable;
    private Long account;
    private Long accountPkId;
    private Long assgrp;
    private transient Map<String, Object> assgrpVals;
    private Long currency;
    private BigDecimal amountFor;
    private BigDecimal amountBalFor;
    private Long localCurrency;
    private BigDecimal amount;
    private BigDecimal amountBal;
    private Date bizDate;
    private Date expireDate;
    private String bizNum;
    private String description;
    private Long voucherId;
    private Long vchEntryId;
    private String status;
    private String sourceType;
    private Date modifyTime;
    private String entryType = null;
    private String baseFieldKey;
    private String baseKey;
    private String groupByKey;
    private String curUnitName;
    private static final int NUMBER_OF_COMPARE = 3;
    private Long creatorId;
    private Long writeOffPerson;
    private String entryDc;
    private Date effectiveDate;
    private Date uneffectiveDate;
    private Date bookeddate;
    private Long recordid;
    private Date forWriteOffDate;
    private Date localWriteOffDate;
    private BigDecimal leavingAmount;
    private BigDecimal leavingAmountFor;

    public Long getId() {
        return this.id;
    }

    public void setId(Long lId) {
        this.id = lId;
    }

    public Long getMasterId() {
        return this.masterId;
    }

    public void setMasterId(Long masterId) {
        this.masterId = masterId;
    }

    public Long getOrg() {
        return this.org;
    }

    public void setOrg(Long lOrg) {
        this.org = lOrg;
    }

    public Long getBookType() {
        return this.bookType;
    }

    public void setBookType(Long lBookType) {
        this.bookType = lBookType;
    }

    public Long getPeriod() {
        return this.period;
    }

    public void setPeriod(Long lPeriod) {
        this.period = lPeriod;
    }

    public Long getAccountTable() {
        return this.accountTable;
    }

    public void setAccountTable(Long lAccountTable) {
        this.accountTable = lAccountTable;
    }

    public Long getAccount() {
        return this.account;
    }

    public void setAccount(Long lAccount) {
        this.account = lAccount;
    }

    public Long getAccountPkId() {
        return this.accountPkId;
    }

    public void setAccountPkId(Long lAccountPkId) {
        this.accountPkId = lAccountPkId;
    }

    public Long getAssgrp() {
        return this.assgrp;
    }

    public void setAssgrp(Long lAssgrp) {
        this.assgrp = lAssgrp;
    }

    public Map<String, Object> getAssgrpVals() {
        return this.assgrpVals;
    }

    public String getAssgrpValStr() {
        if (Objects.isNull(this.assgrpVals)) {
            return JSON.toJSONString(new HashMap(0));
        }
        return JSON.toJSONString(this.assgrpVals);
    }

    public List<WriteOffField> getAssgrpItem() {
        return new ArrayList<WriteOffField>(0);
    }

    public void setAssgrpVals(Map<String, Object> lAssgrpVals) {
        this.assgrpVals = lAssgrpVals;
    }

    public Long getCurrency() {
        return this.currency;
    }

    public void setCurrency(Long lCurrency) {
        this.currency = lCurrency;
    }

    public BigDecimal getAmountFor() {
        return this.amountFor;
    }

    public void setAmountFor(BigDecimal lAmountFor) {
        this.amountFor = lAmountFor;
    }

    public BigDecimal getAmountBalFor() {
        return this.amountBalFor;
    }

    public void setAmountBalFor(BigDecimal lAmountBalFor) {
        this.amountBalFor = lAmountBalFor;
    }

    public Long getLocalCurrency() {
        return this.localCurrency;
    }

    public void setLocalCurrency(Long lLocalCurrency) {
        this.localCurrency = lLocalCurrency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal lAmount) {
        this.amount = lAmount;
    }

    public BigDecimal getAmountBal() {
        return this.amountBal;
    }

    public void setAmountBal(BigDecimal lAmountBal) {
        this.amountBal = lAmountBal;
    }

    public Date getBizDate() {
        return this.bizDate;
    }

    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(Date dExpireDate) {
        this.expireDate = dExpireDate;
    }

    public String getBizNum() {
        return this.bizNum;
    }

    public void setBizNum(String sBizNum) {
        this.bizNum = sBizNum;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String sDescription) {
        this.description = sDescription;
    }

    public Long getVoucherId() {
        return this.voucherId;
    }

    public void setVoucherId(Long lVoucherId) {
        this.voucherId = lVoucherId;
    }

    public Long getVchEntryId() {
        return this.vchEntryId;
    }

    public void setVchEntryId(Long lVchEntryId) {
        this.vchEntryId = lVchEntryId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String strStatus) {
        this.status = strStatus;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String strSourceType) {
        this.sourceType = strSourceType;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date dModifyTime) {
        this.modifyTime = dModifyTime;
    }

    public String getBaseFieldKey() {
        return this.baseFieldKey;
    }

    public void setBaseFieldKey(String baseFieldKey) {
        this.baseFieldKey = baseFieldKey;
    }

    public String getCurUnitName() {
        return this.curUnitName;
    }

    public void setCurUnitName(String curUnitName) {
        this.curUnitName = curUnitName;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getUneffectiveDate() {
        return this.uneffectiveDate;
    }

    public void setUneffectiveDate(Date uneffectiveDate) {
        this.uneffectiveDate = uneffectiveDate;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public Long getWriteOffPerson() {
        return this.writeOffPerson;
    }

    public void setWriteOffPerson(Long writeOffPerson) {
        this.writeOffPerson = writeOffPerson;
    }

    public String getEntryDc() {
        return this.entryDc;
    }

    public void setEntryDc(String entryDc) {
        this.entryDc = entryDc;
    }

    public Date getBookeddate() {
        return this.bookeddate;
    }

    public void setBookeddate(Date bookeddate) {
        this.bookeddate = bookeddate;
    }

    public Boolean getBuyerFor() {
        if (this.amountFor.compareTo(BigDecimal.ZERO) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getBuyerLocal() {
        if (this.amount.compareTo(BigDecimal.ZERO) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean compareTo(ReciprocalRecord record, boolean isContainAmt, ReciprocalScheme scheme) {
        if ((isContainAmt || scheme.isEquaCanVerfi()) && this.amountBalFor.abs().compareTo(record.amountBalFor.abs()) != 0) {
            return Boolean.FALSE;
        }
        if (!scheme.isVerifiDiffBusiNo() && !this.bizNum.equals(record.bizNum)) {
            return Boolean.FALSE;
        }
        if (this.getAmountBalFor().compareTo(BigDecimal.ZERO) == 0 && record.getAmountBal().compareTo(BigDecimal.ZERO) == 0 || this.getAmountBal().compareTo(BigDecimal.ZERO) == 0 && record.getAmountBalFor().compareTo(BigDecimal.ZERO) == 0) {
            return Boolean.FALSE;
        }
        if (this.getId().equals(record.getId()) || !this.getBaseKey().equals(record.getBaseKey())) {
            return Boolean.FALSE;
        }
        if (RcpWriteOffUtils.isZeroByMultiply(this.getAmountBalFor(), record.getAmountBalFor()) && RcpWriteOffUtils.isSameDc(this.getAmountBal(), record.getAmountBal()).booleanValue() || RcpWriteOffUtils.isZeroByMultiply(this.getAmountBal(), record.getAmountBal()) && RcpWriteOffUtils.isSameDc(this.getAmountBalFor(), record.getAmountBalFor()).booleanValue()) {
            return Boolean.FALSE;
        }
        if (RcpWriteOffUtils.isZero(record.getAmountBalFor().multiply(this.getAmountBalFor())) && RcpWriteOffUtils.isZero(record.getAmountBal().multiply(this.getAmountBal()))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Integer compareToByInt(ReciprocalRecord record, ReciprocalScheme scheme) {
        int rst;
        String oppKey;
        Integer comparRst = 0;
        String key = this.getBaseKey();
        if (key.compareTo(oppKey = record.getBaseKey()) > 0) {
            comparRst = comparRst + 5;
        } else if (key.compareTo(oppKey) < 0) {
            comparRst = comparRst - 5;
        }
        comparRst = !scheme.isVerifiDiffBusiNo() ? ((rst = this.compareByAmount(record)) == 0 ? Integer.valueOf(comparRst + this.compareByBiznum(record)) : Integer.valueOf(comparRst + rst)) : Integer.valueOf(comparRst + this.compareByAmount(record));
        return comparRst;
    }

    public String groupByKey(ReciprocalContext context, boolean isContainAmt) {
        String ctxUnitName = context.getCurUnit();
        if (this.groupByKey != null && ctxUnitName.equals(this.curUnitName)) {
            return this.groupByKey;
        }
        ReciprocalScheme scheme = context.getScheme();
        String key = this.getBaseFieldKey(scheme);
        if (!ctxUnitName.equals(this.curUnitName)) {
            this.curUnitName = ctxUnitName;
            if (isContainAmt || scheme.isEquaCanVerfi()) {
                key = key + "-" + this.amountBal.abs();
            }
        }
        this.groupByKey = key;
        return this.groupByKey;
    }

    public String getBaseKey() {
        if (this.baseKey == null) {
            this.baseKey = this.account + "-" + this.assgrp + "-" + this.currency;
        }
        return this.baseKey;
    }

    private String getBaseFieldKey(ReciprocalScheme scheme) {
        if (this.baseFieldKey == null) {
            this.baseFieldKey = this.getBaseKey();
            if (!scheme.isVerifiDiffBusiNo()) {
                this.baseFieldKey = this.baseFieldKey + "-" + this.bizNum;
            }
        }
        return this.baseFieldKey;
    }

    public String entryType() {
        if (this.entryType == null) {
            if (this.amountFor.compareTo(BigDecimal.ZERO) >= 0) {
                return "0";
            }
            return "1";
        }
        return this.entryType;
    }

    public String localEntryType() {
        if (this.entryType == null) {
            if (this.amount.compareTo(BigDecimal.ZERO) >= 0) {
                return "0";
            }
            return "1";
        }
        return this.entryType;
    }

    public String recordType() {
        if (this.amountBalFor.compareTo(BigDecimal.ZERO) > 0 || this.amountBalFor.compareTo(BigDecimal.ZERO) == 0 && this.amountBal.compareTo(BigDecimal.ZERO) > 0) {
            return "0";
        }
        return "1";
    }

    public void substractBalFor(BigDecimal writeOffAmtFor) {
        this.amountBalFor = "0".equals(this.entryType()) ? this.amountBalFor.subtract(writeOffAmtFor) : this.amountBalFor.add(writeOffAmtFor);
    }

    public void substractBalLocal(BigDecimal writeOffAmt) {
        this.amountBal = "0".equals(this.localEntryType()) ? this.amountBal.subtract(writeOffAmt) : this.amountBal.add(writeOffAmt);
    }

    public void addBalFor(BigDecimal writeOffAmtFor) {
        this.amountBalFor = "0".equals(this.entryType()) ? this.amountBalFor.add(writeOffAmtFor) : this.amountBalFor.subtract(writeOffAmtFor);
    }

    public void addBalLocal(BigDecimal writeOffAmt) {
        this.amountBal = "0".equals(this.localEntryType()) ? this.amountBal.add(writeOffAmt) : this.amountBal.subtract(writeOffAmt);
    }

    private int compareByAmount(ReciprocalRecord record) {
        BigDecimal oppAmt;
        BigDecimal amt = this.amountBalFor.abs();
        if (amt.compareTo(oppAmt = record.amountBalFor.abs()) > 0) {
            return 1;
        }
        if (amt.compareTo(oppAmt) < 0) {
            return -1;
        }
        return 0;
    }

    private int compareByBiznum(ReciprocalRecord record) {
        if (this.bizNum.compareTo(record.getBizNum()) > 0) {
            return 1;
        }
        if (this.bizNum.compareTo(record.getBizNum()) < 0) {
            return -1;
        }
        return 0;
    }

    public Long getRecordid() {
        return this.recordid;
    }

    public void setRecordid(Long recordid) {
        this.recordid = recordid;
    }

    public Date getForWriteOffDate() {
        return this.forWriteOffDate;
    }

    public void setForWriteOffDate(Date forwriteoffdate) {
        this.forWriteOffDate = forwriteoffdate;
    }

    public Date getLocalWriteOffDate() {
        return this.localWriteOffDate;
    }

    public void setLocalWriteOffDate(Date localWriteOffDate) {
        this.localWriteOffDate = localWriteOffDate;
    }

    public BigDecimal getLeavingAmount() {
        return this.leavingAmount;
    }

    public void setLeavingAmount(BigDecimal leavingAmount) {
        this.leavingAmount = leavingAmount;
    }

    public BigDecimal getLeavingAmountFor() {
        return this.leavingAmountFor;
    }

    public void setLeavingAmountFor(BigDecimal leavingAmountFor) {
        this.leavingAmountFor = leavingAmountFor;
    }

    protected ReciprocalRecord clone() {
        try {
            return (ReciprocalRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "ReciprocalRecord{id=" + this.id + ", masterId=" + this.masterId + ", org=" + this.org + ", bookType=" + this.bookType + ", period=" + this.period + ", accountTable=" + this.accountTable + ", account=" + this.account + ", accountPkId=" + this.accountPkId + ", assgrp=" + this.assgrp + ", assgrpVals=" + this.assgrpVals + ", currency=" + this.currency + ", amountFor=" + this.amountFor + ", amountBalFor=" + this.amountBalFor + ", localCurrency=" + this.localCurrency + ", amount=" + this.amount + ", amountBal=" + this.amountBal + ", bizDate=" + this.bizDate + ", expireDate=" + this.expireDate + ", bizNum='" + this.bizNum + '\'' + ", description='" + this.description + '\'' + ", voucherId=" + this.voucherId + ", vchEntryId=" + this.vchEntryId + ", status='" + this.status + '\'' + ", sourceType='" + this.sourceType + '\'' + ", modifyTime=" + this.modifyTime + ", entryType='" + this.entryType + '\'' + ", baseFieldKey='" + this.baseFieldKey + '\'' + ", baseKey='" + this.baseKey + '\'' + ", groupByKey='" + this.groupByKey + '\'' + ", curUnitName='" + this.curUnitName + '\'' + ", creatorId=" + this.creatorId + ", writeOffPerson=" + this.writeOffPerson + ", entryDc='" + this.entryDc + '\'' + ", effectiveDate=" + this.effectiveDate + ", uneffectiveDate=" + this.uneffectiveDate + ", bookeddate=" + this.bookeddate + ", recordid=" + this.recordid + ", forWriteOffDate=" + this.forWriteOffDate + ", localWriteOffDate=" + this.localWriteOffDate + ", leavingAmount=" + this.leavingAmount + ", leavingAmountFor=" + this.leavingAmountFor + '}';
    }
}

