/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.flex.FlexService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.assign.OpLogHelper;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.bd.rate.RateType;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.balcal.AcccurrentVersionBalCal;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.business.service.PeriodService;
import kd.fi.gl.business.service.reciprocal.UnAcccurrentUpdateUtil;
import kd.fi.gl.business.vo.reciprocal.AccountGroup;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.common.Task;
import kd.fi.gl.enums.WriteOffMode;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.interfaces.service.voucher.IVoucherQueryService;
import kd.fi.gl.reciprocal.FlexSaveService;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalContext;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.reciprocal.ReciprocalLog;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.SpecialPermItemHelper;
import kd.fi.gl.util.SubsiDiaryHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ReciprocalUtils {
    private static final String UPDATE_ACCCURRENT_SQL = "UPDATE T_GL_ACCCURRENT SET FAMOUNTBAL=?, FAMOUNTBALFOR=?, FSTATUS=?, FMODIFYTIME=?, FWRITEOFFPERSONID=? WHERE FMASTERID=?";
    private static final String MASTERID = "masterid";
    private static final String T_GL_ACCCURRENT = "T_GL_ACCCURRENT";
    private static final String STATUS_NOT_WRITEOFF = "0";
    private static final String BIZNUM = "biznum";
    private static final String SOURCETYPE = "sourcetype";
    private static final String DESCRIPTION = "description";
    private static final int INIT_RECORD_CAPACITY = 8;
    private static final String ID = "id";
    private static final int LEVEL_ONE = 1;
    private static final int LEVEL_TWO = 2;
    private static final int LEVEL_THREE = 3;
    private static final int LEVEL_FOUR = 4;
    private static final String CURRENCY_BASEDATAID = "currency.fbasedataid";
    private static final String WRITEOFFENTRY = "writeoffentry";
    private static final String BUYERENTRY = "buyerentry";
    private static final String VOUCHERID = "voucherid";
    private static final String VOUCHERENTRY = "voucherentry";
    private static final String MODIFYTIME = "modifytime";
    private static final String CREATETIME = "createtime";
    private static final String BIZDATE = "bizdate";
    private static final String AMOUNTBAL = "amountbal";
    private static final String AMOUNT = "amount";
    private static final String AMOUNTBALFOR = "amountbalfor";
    private static final String WRITEOFFDATE = "writeoffdate";
    private static final String LOCALCURRENCY = "localcurrency";
    private static final String AMOUNTFOR = "amountfor";
    private static final String RECIPROCAL_LOG = "gl_reciprocal_log";
    private static final String RECIPROCAL_SCHEME = "gl_reciprocal_scheme";
    private static final String EXPIREDATE = "expiredate";
    private static final String ORG = "org";
    private static final String BOOKTYPE = "booktype";
    private static final String PERIOD = "period";
    private static final String ACCOUNT = "account";
    private static final String ASSGRP = "assgrp";
    private static final String CURRENCY = "currency";
    private static final String BUSINESSNUM = "businessnum";
    private static final String STATUS = "status";
    private static final String ENTYRDC = "entrydc";
    private static final String ACCOUNTTABLE = "accounttable";
    private static final String BD_ACCOUNTTABLEREF = "bd_accounttableref";
    private static final String CREATOR = "creator";
    private static final String EDESCRIPTION = "edescription";
    private static final String BOOKEDDATE = "bookeddate";
    private static final String ACCCURRENTFIELD = "id,voucherid,bizdate,voucherentry,status";
    private static final String SELECTFIELDS = "id, masterid, org.id org, booktype.id booktype,accounttable.id accounttable, period.id period,account.id account, assgrp.id assgrp,currency.id currency,amountfor,amountbalfor,localcurrency,amount,amountbal,biznum,voucherid,voucherentry vchentryid,sourcetype,modifytime,status, effectivedate, uneffectivedate";
    private static final Log logger = LogFactory.getLog(ReciprocalUtils.class);
    private static final String DELACCCSQL = "delete from t_gl_acccurrent where fstatus = '0' and  fvoucherid in(%s)";
    private static final String select_fileds = "id,number,name,useorg,account,currency,verifiorder,verifidiffbusino,reverordersamedire,equalamountpriority,noverifibusinoempty,moneyequacanverfi,excluunpostvoucher,enable,voucherfilterjson,writeoffmode";
    private static final String ENDINITPERIOD = "endinitperiod";
    private static final String ISENDINIT = "isendinit";

    public static ReciprocalRecord buildReciprocalRecord(DynamicObject entryRow, Long orgId, Long bookType, Long period, Date bizDate, Long acctTable, Long localCurrency, Long voucherid, String sourceType, Long creatorId) {
        ReciprocalRecord record = new ReciprocalRecord();
        record.setOrg(orgId);
        record.setBookType(bookType);
        record.setPeriod(period);
        record.setAccountTable(acctTable);
        record.setCreatorId(creatorId);
        record.setAccount(entryRow.getLong("account.masterid"));
        record.setAccountPkId(entryRow.getLong("account.id"));
        record.setAssgrp(entryRow.getLong("assgrp.id"));
        String assgrpVal = entryRow.getString("assgrp.value");
        if (kd.bos.util.StringUtils.isNotEmpty((String)assgrpVal)) {
            record.setAssgrpVals((Map<String, Object>)JSONObject.parseObject((String)assgrpVal));
        }
        record.setCurrency(entryRow.getLong("currency.id"));
        record.setLocalCurrency(localCurrency);
        int accountDC = Integer.parseInt(entryRow.getString("account.dc"));
        BigDecimal debit = entryRow.getBigDecimal("debitori");
        BigDecimal credit = entryRow.getBigDecimal("creditori");
        BigDecimal debitlocal = entryRow.getBigDecimal("debitlocal");
        BigDecimal creditlocal = entryRow.getBigDecimal("creditlocal");
        int entryDC = Integer.parseInt(entryRow.getString(ENTYRDC));
        BigDecimal amount = entryDC == 1 ? debit : credit;
        BigDecimal amountlocal = entryDC == 1 ? debitlocal : creditlocal;
        amountlocal = amountlocal.multiply(BigDecimal.valueOf(accountDC)).multiply(BigDecimal.valueOf(entryDC));
        amount = amount.multiply(BigDecimal.valueOf(accountDC)).multiply(BigDecimal.valueOf(entryDC));
        record.setAmountFor(amount);
        record.setAmountBalFor(amount);
        record.setAmount(amountlocal);
        record.setAmountBal(amountlocal);
        record.setBizDate(bizDate);
        record.setExpireDate(entryRow.getDate(EXPIREDATE));
        record.setBizNum(entryRow.getString(BUSINESSNUM));
        record.setDescription(entryRow.getString(EDESCRIPTION));
        record.setVoucherId(voucherid);
        record.setVchEntryId(entryRow.getLong(ID));
        record.setSourceType(sourceType);
        record.setEntryDc(entryRow.getString(ENTYRDC));
        return record;
    }

    public static void batchSaveReciprocalRecordsEndInit(Long org, Long bookType, Long period, Long localCurrency, Long acctTable, Long accountid, DynamicObject reciprocalInitState) {
        long tick = System.currentTimeMillis();
        List<QFilter> lstFilters = ReciprocalUtils.buildFilter(reciprocalInitState, org, bookType, period, accountid);
        List pkIds = VoucherQueryUtils.queryPrimaryKeys((QFilter[])lstFilters.toArray(new QFilter[0]), null, (int)-1);
        logger.info("endreciprocalinit VoucherQueryUtils_queryPrimaryKeys cost:{}ms", (Object)(System.currentTimeMillis() - tick));
        ArrayList<Long> voucherIds = new ArrayList<Long>(pkIds.size());
        int splitSize = 1000;
        for (Object pkId : pkIds) {
            voucherIds.add((Long)pkId);
            if (voucherIds.size() < splitSize) continue;
            ReciprocalUtils.saveReciprocalRecordEndInitOnce(localCurrency, acctTable, lstFilters, voucherIds);
            voucherIds.clear();
        }
        ReciprocalUtils.saveReciprocalRecordEndInitOnce(localCurrency, acctTable, lstFilters, voucherIds);
    }

    public static List<QFilter> buildFilter(DynamicObject reciInitState, long org, long bookType, long period, long accountid) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
        lstFilters.add(new QFilter(ORG, "=", (Object)org));
        lstFilters.add(new QFilter(BOOKTYPE, "=", (Object)bookType));
        lstFilters.add(new QFilter(PERIOD, ">=", (Object)period));
        lstFilters.add(new QFilter("entries.account.masterid", "=", (Object)accountid));
        HashSet<String> status = new HashSet<String>();
        status.add("B");
        status.add("C");
        lstFilters.add(new QFilter("billstatus", "in", status));
        if (reciInitState != null) {
            lstFilters.add(new QFilter(MODIFYTIME, ">=", (Object)reciInitState.getDate("modifydate")));
        }
        return lstFilters;
    }

    public static int saveReciprocalRecordEndInitOnce(Long localCurrency, Long acctTable, Collection<QFilter> lstFilters, List<Long> voucherIds) {
        int voucherEntryCount = 0;
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            ReciprocalUtils.lockVoucher(voucherIds);
            ArrayList<QFilter> batchFilters = new ArrayList<QFilter>(lstFilters);
            batchFilters.add(new QFilter(ID, "in", voucherIds));
            String selectFields = "id,org.id org, booktype.id booktype, period.id period,bizDate,bookeddate,isreverse,sourcetype, entries.id entryid, entries.account.masterid account, entries.account.id actpkid, entries.assgrp.id assgrp, entries.assgrp.value assgrpVal, entries.currency.id currency, entries.account.dc accountdc, entries.debitori debitori,entries.creditori creditori, entries.debitlocal debitlocal, entries.creditlocal creditlocal,entries.entrydc entrydc, entries.businessnum businessnum,entries.edescription edescription, entries.expiredate expiredate,creator";
            HashSet<Long> vchId = new HashSet<Long>(1000);
            HashSet<Long> vchEntryId = new HashSet<Long>();
            HashSet<ReciprocalRecord> lstRecords = new HashSet<ReciprocalRecord>();
            int splitSize = 1000;
            try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.batchBuildReciprocalRecords", (String)"gl_voucher", (String)selectFields, (QFilter[])batchFilters.toArray(new QFilter[0]), null);){
                while (dSet.hasNext()) {
                    ++voucherEntryCount;
                    Row entryRow = dSet.next();
                    ReciprocalRecord record = ReciprocalUtils.buildRecord(entryRow, acctTable, localCurrency);
                    vchId.add(entryRow.getLong(ID));
                    vchEntryId.add(entryRow.getLong("entryid"));
                    lstRecords.add(record);
                    if (vchEntryId.size() < splitSize) continue;
                    Set<Long> existsVchentryIds = ReciprocalUtils.queryExistsVchentryIds(vchId, vchEntryId);
                    ReciprocalUtils.saveReciprocalRecord(lstRecords, existsVchentryIds);
                    vchEntryId.clear();
                    lstRecords.clear();
                }
            }
            if (vchEntryId.size() > 0) {
                Set<Long> existsVchentryIds = ReciprocalUtils.queryExistsVchentryIds(vchId, vchEntryId);
                ReciprocalUtils.saveReciprocalRecord(lstRecords, existsVchentryIds);
            }
            int n = voucherEntryCount;
            return n;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f80\u6765\u521d\u59cb\u5316\u589e\u91cf\u65b0\u589e\u5f80\u6765\u8d26\u51fa\u9519\uff1a%s\u3002", (String)"ReciprocalUtils_0", (String)"fi-gl-common", (Object[])new Object[0]), GLUtil.printError(e)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static ReciprocalRecord buildRecord(Row entryRow, long acctTable, long localCurrency) {
        ReciprocalRecord record = new ReciprocalRecord();
        record.setOrg(entryRow.getLong(ORG));
        record.setBookType(entryRow.getLong(BOOKTYPE));
        record.setPeriod(entryRow.getLong(PERIOD));
        record.setAccountTable(acctTable);
        record.setAccount(entryRow.getLong(ACCOUNT));
        record.setAccountPkId(entryRow.getLong("actpkid"));
        record.setAssgrp(entryRow.getLong(ASSGRP));
        String assgrpVal = entryRow.getString("assgrpVal");
        if (kd.bos.util.StringUtils.isNotEmpty((String)assgrpVal)) {
            record.setAssgrpVals((Map<String, Object>)JSONObject.parseObject((String)assgrpVal));
        }
        record.setCurrency(entryRow.getLong(CURRENCY));
        record.setLocalCurrency(localCurrency);
        int accountDC = Integer.parseInt(entryRow.getString("accountdc"));
        BigDecimal debit = entryRow.getBigDecimal("debitori");
        BigDecimal credit = entryRow.getBigDecimal("creditori");
        BigDecimal debitlocal = entryRow.getBigDecimal("debitlocal");
        BigDecimal creditlocal = entryRow.getBigDecimal("creditlocal");
        int entryDC = Integer.parseInt(entryRow.getString(ENTYRDC));
        BigDecimal amount = entryDC == 1 ? debit : credit;
        BigDecimal amountlocal = entryDC == 1 ? debitlocal : creditlocal;
        amountlocal = amountlocal.multiply(BigDecimal.valueOf(accountDC)).multiply(BigDecimal.valueOf(entryDC));
        amount = amount.multiply(BigDecimal.valueOf(accountDC)).multiply(BigDecimal.valueOf(entryDC));
        record.setAmountFor(amount);
        record.setAmountBalFor(amount);
        record.setAmount(amountlocal);
        record.setAmountBal(amountlocal);
        record.setBizDate(entryRow.getDate("bizDate"));
        record.setExpireDate(entryRow.getDate(EXPIREDATE));
        record.setBizNum(entryRow.getString(BUSINESSNUM));
        record.setDescription(entryRow.getString(EDESCRIPTION));
        record.setVoucherId(entryRow.getLong(ID));
        long entryId = entryRow.getLong("entryid");
        record.setVchEntryId(entryId);
        record.setSourceType(ReciprocalUtils.getSourceType(entryRow));
        record.setCreatorId(entryRow.getLong(CREATOR));
        record.setEntryDc(entryRow.getString(ENTYRDC));
        record.setBookeddate(entryRow.getDate(BOOKEDDATE));
        return record;
    }

    private static Map<Long, Map<String, Long>> queryReciprocalAssgrp(Set<ReciprocalRecord> records, Map<Long, List<String>> acctAndFieldMap) {
        HashMap<Long, Map<String, Long>> accIdAndAssValAndIdMap = new HashMap<Long, Map<String, Long>>(8);
        HashMap<Long, List<FlexEntireData>> accIdAndFlexEntireDataMap = new HashMap<Long, List<FlexEntireData>>(8);
        HashMap<Long, Map<String, String>> accIdAndOldAndNewValMap = new HashMap<Long, Map<String, String>>(8);
        for (ReciprocalRecord reciprocalRecord : records) {
            ReciprocalUtils.addRecordAssgrpToMap(acctAndFieldMap, accIdAndAssValAndIdMap, accIdAndFlexEntireDataMap, accIdAndOldAndNewValMap, reciprocalRecord);
        }
        for (Map.Entry entry : accIdAndFlexEntireDataMap.entrySet()) {
            Long accountId = (Long)entry.getKey();
            Map assValAndIdMap = accIdAndAssValAndIdMap.computeIfAbsent(accountId, m -> new HashMap(8));
            Map oldValAndNewValMap = (Map)accIdAndOldAndNewValMap.get(accountId);
            List flexEntireDatas = (List)entry.getValue();
            Map<String, Long> map = ReciprocalUtils.saveNewAssgrpVal(flexEntireDatas);
            if (map == null || oldValAndNewValMap == null) continue;
            ReciprocalUtils.addValAndIdMap(assValAndIdMap, oldValAndNewValMap, map);
        }
        return accIdAndAssValAndIdMap;
    }

    private static void addValAndIdMap(Map<String, Long> valAndIdMap, Map<String, String> oldAndNewValMap, Map<String, Long> map) {
        for (Map.Entry<String, String> entry : oldAndNewValMap.entrySet()) {
            String oriVal = entry.getKey();
            String newVal = entry.getValue();
            Long id = map.get(newVal);
            if (id == null) continue;
            valAndIdMap.put(oriVal, id);
        }
    }

    private static void addRecordAssgrpToMap(Map<Long, List<String>> acctAndFieldMap, Map<Long, Map<String, Long>> accIdAndAssValAndIdMap, Map<Long, List<FlexEntireData>> accIdAndFlexEntireDataMap, Map<Long, Map<String, String>> accIdAndOldAndNewValMap, ReciprocalRecord record) {
        Long lAssgrpId = record.getAssgrp();
        Map<String, Object> valueMap = record.getAssgrpVals();
        Long lAcctId = record.getAccountPkId();
        List<String> lstAssgrps = acctAndFieldMap.get(lAcctId);
        if (lstAssgrps == null || valueMap == null) {
            return;
        }
        if (valueMap.size() == lstAssgrps.size()) {
            Map assValAndIdMap = accIdAndAssValAndIdMap.computeIfAbsent(lAcctId, m -> new HashMap());
            assValAndIdMap.put(valueMap.toString(), lAssgrpId);
            accIdAndAssValAndIdMap.put(lAcctId, assValAndIdMap);
        } else {
            Map<String, Object> newValueMap = ReciprocalUtils.createValueMap(valueMap, lstAssgrps);
            FlexEntireData flexEntireData = ReciprocalUtils.buildFlexEntireData(newValueMap);
            Map oldAssValAndIdMap = accIdAndOldAndNewValMap.computeIfAbsent(lAcctId, m -> new HashMap(8));
            oldAssValAndIdMap.put(valueMap.toString(), flexEntireData.concatFlexData());
            accIdAndOldAndNewValMap.put(lAcctId, oldAssValAndIdMap);
            List flexEntireDatas = accIdAndFlexEntireDataMap.computeIfAbsent(lAcctId, f -> new ArrayList(8));
            flexEntireDatas.add(flexEntireData);
            accIdAndFlexEntireDataMap.put(lAcctId, flexEntireDatas);
        }
    }

    private static Map<String, Object> createValueMap(Map<String, Object> valueMap, List<String> lstAssgrps) {
        JSONObject newValueMap = new JSONObject();
        for (String assgrpField : lstAssgrps) {
            Object value = valueMap.get(assgrpField);
            if (value == null) continue;
            newValueMap.put(assgrpField, value);
        }
        return newValueMap;
    }

    public static Map<Long, List<String>> queryAccountAndAssgrpMap(Collection<Long> lstAcctIds, Map<Long, Tuple<Date, Date>> acctAndAcctRefDateMap) {
        Map accounts = BusinessDataServiceHelper.loadFromCache((Object[])lstAcctIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        HashMap<Long, List<String>> map = new HashMap<Long, List<String>>(lstAcctIds.size());
        for (DynamicObject account : accounts.values()) {
            Long id = account.getLong(ID);
            DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
            ArrayList<String> lstFields = new ArrayList<String>();
            for (DynamicObject assistRow : assistEntry) {
                Boolean enaccheck = assistRow.getBoolean("enaccheck");
                if (!enaccheck.booleanValue()) continue;
                String fieldName = assistRow.getString("asstactitem.flexfield");
                lstFields.add(fieldName);
            }
            map.put(id, lstFields);
            Date startDate = account.getDate("startdate");
            Date endDate = account.getDate("enddate");
            acctAndAcctRefDateMap.put(id, (Tuple<Date, Date>)new Tuple((Object)startDate, (Object)endDate));
        }
        return map;
    }

    public static Map<Long, List<String>> acctIdToFlexFields(Collection<Long> lstAcctIds) {
        Map<DynamicObject, List<String>> acctToAssgrpFlexFied = ReciprocalUtils.queryAccountAndAssgrpMap(lstAcctIds);
        HashMap<Long, List<String>> map = new HashMap<Long, List<String>>(lstAcctIds.size());
        acctToAssgrpFlexFied.forEach((account, v) -> {
            Long id = account.getLong(ID);
            map.put(id, (List<String>)v);
        });
        return map;
    }

    public static Map<DynamicObject, List<String>> queryAccountAndAssgrpMap(Collection<Long> lstAcctIds) {
        Map accounts = BusinessDataServiceHelper.loadFromCache((Object[])lstAcctIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        HashMap<DynamicObject, List<String>> map = new HashMap<DynamicObject, List<String>>(lstAcctIds.size());
        for (DynamicObject account : accounts.values()) {
            DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
            ArrayList<String> lstFields = new ArrayList<String>();
            for (DynamicObject assistRow : assistEntry) {
                Boolean enaccheck = assistRow.getBoolean("enaccheck");
                if (!enaccheck.booleanValue()) continue;
                String fieldName = assistRow.getString("asstactitem.flexfield");
                lstFields.add(fieldName);
            }
            map.put(account, lstFields);
        }
        return map;
    }

    public static void saveReciprocalRecord(Set<ReciprocalRecord> records, Set<Long> existsVchentryIds) {
        Date modifyDate = TimeServiceHelper.now();
        HashSet<Long> lstAcctIds = new HashSet<Long>();
        records.forEach(p -> lstAcctIds.add(p.getAccountPkId()));
        HashMap<Long, Tuple<Date, Date>> acctAndAcctRefDateMap = new HashMap<Long, Tuple<Date, Date>>(8);
        Map<Long, List<String>> acctAndAssgrpMap = ReciprocalUtils.queryAccountAndAssgrpMap(lstAcctIds, acctAndAcctRefDateMap);
        Map<Long, Map<String, Long>> assgrpValAndIdMap = ReciprocalUtils.queryReciprocalAssgrp(records, acctAndAssgrpMap);
        ArrayList<ReciprocalRecord> newReciprocalRecords = new ArrayList<ReciprocalRecord>(8);
        int size = 999;
        for (ReciprocalRecord record : records) {
            Long entryId = record.getVchEntryId();
            if (existsVchentryIds.contains(entryId)) continue;
            newReciprocalRecords.add(record);
        }
        if (!newReciprocalRecords.isEmpty()) {
            ArrayList<DynamicObject> newData = new ArrayList<DynamicObject>(1024);
            MainEntityType recordType = EntityMetadataCache.getDataEntityType((String)"gl_acccurrent");
            long[] newRecordIds = DB.genLongIds((String)T_GL_ACCCURRENT, (int)newReciprocalRecords.size());
            for (int i = 0; i < newReciprocalRecords.size(); ++i) {
                ReciprocalRecord record = (ReciprocalRecord)newReciprocalRecords.get(i);
                DynamicObject saveObj = new DynamicObject((DynamicObjectType)recordType);
                long newRecordId = newRecordIds[i];
                saveObj.set(ID, (Object)newRecordId);
                saveObj.set(MASTERID, (Object)newRecordId);
                ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(8);
                saveObjs.add(saveObj);
                ReciprocalUtils.createSingleRecord(modifyDate, assgrpValAndIdMap, acctAndAcctRefDateMap, record, saveObjs, true);
                newData.add(saveObj);
                if (newData.size() < size) continue;
                ReciprocalUtils.persistentTODb(newData);
                newData.clear();
            }
            if (!newData.isEmpty()) {
                ReciprocalUtils.persistentTODb(newData);
                newData.clear();
            }
        }
    }

    public static void saveReciprocalRecord(Set<ReciprocalRecord> records) {
        Date modifyDate = TimeServiceHelper.now();
        HashSet<Long> lstAcctIds = new HashSet<Long>(32);
        records.forEach(p -> lstAcctIds.add(p.getAccountPkId()));
        HashMap<Long, Tuple<Date, Date>> acctAndAcctRefDateMap = new HashMap<Long, Tuple<Date, Date>>(8);
        Map<Long, List<String>> acctAndAssgrpMap = ReciprocalUtils.queryAccountAndAssgrpMap(lstAcctIds, acctAndAcctRefDateMap);
        Map<Long, Map<String, Long>> assgrpValAndIdMap = ReciprocalUtils.queryReciprocalAssgrp(records, acctAndAssgrpMap);
        ArrayList<ReciprocalRecord> newReciprocalRecords = new ArrayList<ReciprocalRecord>(records);
        int size = 999;
        ArrayList<DynamicObject> newData = new ArrayList<DynamicObject>(1024);
        MainEntityType recordType = EntityMetadataCache.getDataEntityType((String)"gl_acccurrent");
        long[] newRecordIds = DB.genLongIds((String)T_GL_ACCCURRENT, (int)newReciprocalRecords.size());
        Map<Pair<Long, Long>, Long> assgrpMap = ReciprocalUtils.getAssgrpMap();
        for (int i = 0; i < newReciprocalRecords.size(); ++i) {
            ReciprocalRecord record = (ReciprocalRecord)newReciprocalRecords.get(i);
            DynamicObject saveObj = new DynamicObject((DynamicObjectType)recordType);
            long newRecordId = newRecordIds[i];
            saveObj.set(ID, (Object)newRecordId);
            saveObj.set(MASTERID, (Object)newRecordId);
            ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(8);
            saveObjs.add(saveObj);
            ReciprocalUtils.createSingleRecord(modifyDate, assgrpValAndIdMap, acctAndAcctRefDateMap, record, saveObjs, true);
            newData.add(saveObj);
            assgrpMap.put((Pair<Long, Long>)Pair.of((Object)record.getAccount(), (Object)record.getAssgrp()), saveObj.getLong(ASSGRP));
            if (newData.size() < size) continue;
            ReciprocalUtils.storeAcccurrent(newData);
            newData.clear();
        }
        ReciprocalUtils.setAssgrpMap(assgrpMap);
        if (!newData.isEmpty()) {
            ReciprocalUtils.storeAcccurrent(newData);
            newData.clear();
        }
    }

    private static void storeAcccurrent(List<DynamicObject> lstSaveDatas) {
        ReciprocalUtils.saveAcccurrent(lstSaveDatas);
    }

    private static void persistentTODb(List<DynamicObject> lstSaveDatas) {
        try (TXHandle tx = TX.requiresNew((String)"kd.fi.gl.reciprocal.ReciprocalUtils.persistentTODb");){
            try {
                ReciprocalUtils.saveAcccurrent(lstSaveDatas);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void saveAcccurrent(List<DynamicObject> lstSaveDatas) {
        SaveServiceHelper.save((DynamicObject[])lstSaveDatas.toArray(new DynamicObject[0]));
    }

    public static void preciseWriteOff(Long orgId, Long bookTypeId, Long accountTable, List<Long> acctMasterIds, List<Long> acctIds, Set<Long> accCurIds) {
        String acctMasterIdsStr = SerializationUtils.serializeToBase64(acctMasterIds);
        String acctIdsStr = SerializationUtils.serializeToBase64(acctIds);
        String reciIdsStr = SerializationUtils.serializeToBase64(accCurIds);
        OperateOption option = OperateOption.create();
        option.setVariableValue(ORG, orgId.toString());
        option.setVariableValue(BOOKTYPE, bookTypeId.toString());
        option.setVariableValue(ACCOUNTTABLE, accountTable.toString());
        option.setVariableValue("autoByPage", "1");
        option.setVariableValue("accountmater", acctMasterIdsStr);
        option.setVariableValue(ACCOUNT, acctIdsStr);
        option.setVariableValue("reciIds", reciIdsStr);
        option.setVariableValue("manualWriteoff", "true");
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gl_reci_autowriteoff");
        Task writeOffTask = new Task(() -> OperationServiceHelper.executeOperate((String)"reciprocal_writeoff", (String)"gl_reci_autowriteoff", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)option));
        GLThreadService.ayncPageLoadingTask(ReciprocalUtils.class.getName(), writeOffTask);
    }

    private static void createSingleRecord(Date modifyDate, Map<Long, Map<String, Long>> assgrpValAndIdMap, Map<Long, Tuple<Date, Date>> acctAndAcctRefDateMap, ReciprocalRecord record, List<DynamicObject> saveObjs, boolean isCreateNew) {
        for (DynamicObject saveObj : saveObjs) {
            Tuple<Date, Date> dateTpl;
            String status;
            String string = status = saveObj.getString(STATUS) == null ? STATUS_NOT_WRITEOFF : saveObj.getString(STATUS);
            if (STATUS_NOT_WRITEOFF.equals(status)) {
                saveObj.set(ORG, (Object)record.getOrg());
                saveObj.set(BOOKTYPE, (Object)record.getBookType());
                saveObj.set(PERIOD, (Object)record.getPeriod());
                if (saveObj.getLong(ID) == saveObj.getLong(MASTERID)) {
                    Long tmpId;
                    Map<String, Long> assValAndIdMap;
                    saveObj.set(ACCOUNTTABLE, (Object)record.getAccountTable());
                    saveObj.set(ACCOUNT, (Object)record.getAccount());
                    Long newAssgrpId = 0L;
                    Map<String, Object> assgrpVal = record.getAssgrpVals();
                    if (assgrpVal != null && (assValAndIdMap = assgrpValAndIdMap.get(record.getAccountPkId())) != null && (tmpId = assValAndIdMap.get(assgrpVal.toString())) != null) {
                        newAssgrpId = tmpId;
                    }
                    saveObj.set(ASSGRP, (Object)newAssgrpId);
                }
                saveObj.set(CURRENCY, (Object)record.getCurrency());
                saveObj.set(AMOUNTFOR, (Object)record.getAmountFor());
                saveObj.set(AMOUNTBALFOR, (Object)record.getAmountBalFor());
                saveObj.set(LOCALCURRENCY, (Object)record.getLocalCurrency());
                saveObj.set(AMOUNT, (Object)record.getAmount());
                saveObj.set(AMOUNTBAL, (Object)record.getAmountBal());
                saveObj.set(BIZDATE, (Object)record.getBizDate());
                saveObj.set(EXPIREDATE, (Object)record.getExpireDate());
                saveObj.set(BIZNUM, (Object)record.getBizNum());
                saveObj.set(DESCRIPTION, (Object)record.getDescription());
                saveObj.set(VOUCHERENTRY, (Object)record.getVchEntryId());
                saveObj.set(VOUCHERID, (Object)record.getVoucherId());
                saveObj.set(STATUS, (Object)status);
                saveObj.set(SOURCETYPE, (Object)record.getSourceType());
                saveObj.set(MODIFYTIME, (Object)modifyDate);
                saveObj.set(CREATETIME, (Object)modifyDate);
                saveObj.set(CREATOR, (Object)record.getCreatorId());
                saveObj.set(ENTYRDC, (Object)record.getEntryDc());
                saveObj.set(BOOKEDDATE, (Object)record.getBookeddate());
            } else {
                saveObj.set(PERIOD, (Object)record.getPeriod());
                saveObj.set(BIZDATE, (Object)record.getBizDate());
                saveObj.set(EXPIREDATE, (Object)record.getExpireDate());
                saveObj.set(DESCRIPTION, (Object)record.getDescription());
                saveObj.set(MODIFYTIME, (Object)modifyDate);
                saveObj.set(BOOKEDDATE, (Object)record.getBookeddate());
            }
            if (!isCreateNew || saveObj.getLong(ID) != saveObj.getLong(MASTERID) || (dateTpl = acctAndAcctRefDateMap.get(record.getAccountPkId())) == null) continue;
            saveObj.set("effectivedate", (Object)BalanceTransferUtils.getInitBeginDate());
            saveObj.set("uneffectivedate", (Object)BalanceTransferUtils.getEndDate());
        }
    }

    private static Set<Long> queryExistsVchentryIds(Set<Long> vchId, Set<Long> lstEntryId) {
        QFilter vchIdFilter = new QFilter(VOUCHERID, "in", vchId);
        QFilter vchentryFilter = new QFilter(VOUCHERENTRY, "in", lstEntryId);
        HashSet<Long> accVchentryIds = new HashSet<Long>(16);
        try (DataSet reciDs = QueryServiceHelper.queryDataSet((String)ReciprocalUtils.class.getName(), (String)"gl_acccurrent", (String)VOUCHERENTRY, (QFilter[])new QFilter[]{vchIdFilter, vchentryFilter}, null);){
            for (Row row : reciDs) {
                accVchentryIds.add(row.getLong(VOUCHERENTRY));
            }
        }
        return accVchentryIds;
    }

    public static ReciprocalRecord queryOneRecordById(Long id, Map<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroup) {
        HashSet<Long> ids = new HashSet<Long>(1);
        ids.add(id);
        Map<Long, ReciprocalRecord> map = ReciprocalUtils.queryRecordsById(ids, acctGroup);
        return map.isEmpty() ? null : map.values().iterator().next();
    }

    private static Map<Long, ReciprocalRecord> queryRecordsById(Set<Long> ids, Map<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMap) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
        lstFilters.add(new QFilter(ID, "in", ids));
        HashMap<Long, ReciprocalRecord> records = new HashMap<Long, ReciprocalRecord>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.queryOneRecord", (String)"gl_acccurrent", (String)SELECTFIELDS, (QFilter[])lstFilters.toArray(new QFilter[0]), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                ReciprocalRecord record = ReciprocalUtils.getRecord(row);
                records.put(record.getId(), record);
                AccountGroup acctGroup = AccountGroup.of(record.getOrg(), record.getBookType(), record.getAccountTable(), record.getAccount(), record.getCurrency());
                if (!Objects.nonNull(acctGroupMap)) continue;
                Pair pair = acctGroupMap.get(acctGroup);
                if (Objects.isNull(pair)) {
                    pair = Pair.of((Object)Sets.newHashSet((Object[])new Long[]{record.getAssgrp()}), (Object)Sets.newHashSet());
                    acctGroupMap.put(acctGroup, (Pair<Set<Long>, Set<Long>>)pair);
                    continue;
                }
                ((Set)pair.getLeft()).add(record.getAssgrp());
            }
        }
        return records;
    }

    public static Map<Long, ReciprocalRecord> queryRecords(Collection<QFilter> customFilters, String orderByString, int rowSize) {
        HashMap<Long, ReciprocalRecord> map = new HashMap<Long, ReciprocalRecord>();
        if (customFilters == null || customFilters.isEmpty()) {
            return map;
        }
        ArrayList<QFilter> lstAllFilters = new ArrayList<QFilter>();
        lstAllFilters.addAll(customFilters);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.queryRecords", (String)"gl_acccurrent", (String)SELECTFIELDS, (QFilter[])lstAllFilters.toArray(new QFilter[0]), (String)orderByString);){
            while (ds.hasNext()) {
                Row row = ds.next();
                ReciprocalRecord record = ReciprocalUtils.getRecord(row);
                map.put(record.getId(), record);
                if (--rowSize != 0) continue;
                break;
            }
        }
        return map;
    }

    public static Map<Long, ReciprocalRecord> queryRecords(Collection<QFilter> customFilters) {
        return ReciprocalUtils.queryRecords(customFilters, null, -1);
    }

    private static ReciprocalRecord getRecord(Row row) {
        ReciprocalRecord record = new ReciprocalRecord();
        record.setId(row.getLong(ID));
        record.setOrg(row.getLong(ORG));
        record.setAccountTable(row.getLong(ACCOUNTTABLE));
        record.setBookType(row.getLong(BOOKTYPE));
        record.setPeriod(row.getLong(PERIOD));
        record.setAccount(row.getLong(ACCOUNT));
        record.setAssgrp(row.getLong(ASSGRP));
        record.setCurrency(row.getLong(CURRENCY));
        record.setAmountFor(row.getBigDecimal(AMOUNTFOR));
        record.setAmountBalFor(row.getBigDecimal(AMOUNTBALFOR));
        record.setLocalCurrency(row.getLong(LOCALCURRENCY));
        record.setAmount(row.getBigDecimal(AMOUNT));
        record.setAmountBal(row.getBigDecimal(AMOUNTBAL));
        record.setBizNum(row.getString(BIZNUM));
        record.setVoucherId(row.getLong(VOUCHERID));
        record.setVchEntryId(row.getLong("vchentryid"));
        String key = row.getString(SOURCETYPE);
        record.setSourceType(key);
        record.setModifyTime(row.getDate(MODIFYTIME));
        record.setStatus(row.getString(STATUS));
        record.setMasterId(row.getLong(MASTERID));
        record.setEffectiveDate(row.getDate("effectivedate"));
        record.setUneffectiveDate(row.getDate("uneffectivedate"));
        return record;
    }

    public static Map<Long, List<ReciprocalLog>> queryOppReciprocalLog(ReciprocalRecord record) {
        Long masterId = record.getMasterId();
        HashSet<Long> acctRefIds = new HashSet<Long>(8);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.queryOppReciprocalLog", (String)"gl_acccurrent", (String)ID, (QFilter[])new QFilter[]{new QFilter(MASTERID, "=", (Object)masterId)}, (String)"effectivedate");){
            for (Row row : dSet) {
                acctRefIds.add(row.getLong(ID));
            }
        }
        String selectFields = "id, buyerentry, writeoffentry, amountfor, amount, writeoffdate,writer";
        HashMap<Long, List<ReciprocalLog>> map = new HashMap<Long, List<ReciprocalLog>>();
        DataSet buyerDs = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.queryOppReciprocalLog", (String)RECIPROCAL_LOG, (String)selectFields, (QFilter[])new QFilter[]{new QFilter(BUYERENTRY, "in", acctRefIds)}, null);
        DataSet writeOffDs = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.queryOppReciprocalLog", (String)RECIPROCAL_LOG, (String)selectFields, (QFilter[])new QFilter[]{new QFilter(WRITEOFFENTRY, "in", acctRefIds)}, null);
        DataSet ds = buyerDs.union(writeOffDs);
        while (ds.hasNext()) {
            Row row = ds.next();
            ReciprocalLog rcpLog = new ReciprocalLog();
            rcpLog.setId(row.getLong(ID));
            rcpLog.setAmount(row.getBigDecimal(AMOUNT));
            rcpLog.setAmountFor(row.getBigDecimal(AMOUNTFOR));
            rcpLog.setBuyerEntryId(row.getLong(BUYERENTRY));
            rcpLog.setWriteOffEntryId(row.getLong(WRITEOFFENTRY));
            rcpLog.setWriteOffDate(row.getDate(WRITEOFFDATE));
            rcpLog.setWriter(row.getLong("writer"));
            if (!record.getId().equals(row.getLong(WRITEOFFENTRY))) {
                map.computeIfAbsent(row.getLong(WRITEOFFENTRY), v -> new ArrayList(2)).add(rcpLog);
                continue;
            }
            map.computeIfAbsent(row.getLong(BUYERENTRY), v -> new ArrayList(2)).add(rcpLog);
        }
        return map;
    }

    public static String doUnWriteOff(ReciprocalRecord srcRecord, Map<Long, ReciprocalRecord> tgtRecords) {
        ArrayList<Long> vchids = new ArrayList<Long>(tgtRecords.size() + 1);
        HashSet<Long> recordIds = new HashSet<Long>(tgtRecords.size() + 1);
        Long srcRecordId = srcRecord.getId();
        recordIds.add(srcRecordId);
        vchids.add(srcRecord.getVoucherId());
        for (ReciprocalRecord record : tgtRecords.values()) {
            recordIds.add(record.getId());
            vchids.add(record.getVoucherId());
        }
        ArrayList<String> operationMsgs = new ArrayList<String>();
        HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMap = new HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>>(1);
        try (TXHandle handler = TX.requiresNew();){
            try {
                ReciprocalUtils.lockVoucher(vchids);
                Map<Long, ReciprocalRecord> recordMap = ReciprocalUtils.queryRecordsById(recordIds, acctGroupMap);
                UnAcccurrentUpdateUtil.ongoingCalculateAccount(acctGroupMap);
                srcRecord = recordMap.remove(srcRecordId);
                tgtRecords = recordMap;
                if (srcRecord == null || tgtRecords.isEmpty()) {
                    operationMsgs.add(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6838\u9500\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"ReciprocalUtils_1", (String)"fi-gl-common", (Object[])new Object[0]));
                } else {
                    Map<Long, List<ReciprocalLog>> map = ReciprocalUtils.queryOppReciprocalLog(srcRecord);
                    List<Long> logIds = ReciprocalUtils.doUnWriteOffLogic(srcRecord, tgtRecords, map);
                    String logMsg = ReciprocalUtils.delReciprocalLog(logIds);
                    operationMsgs.add(logMsg);
                    HashMap<Long, ReciprocalRecord> records = new HashMap<Long, ReciprocalRecord>();
                    records.put(srcRecord.getId(), srcRecord);
                    records.putAll(tgtRecords);
                    String recordMsg = ReciprocalUtils.reWriteReciprocalRecord(records, false);
                    operationMsgs.add(recordMsg);
                }
            }
            catch (Exception e) {
                handler.markRollback();
                logger.error(e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        UnAcccurrentUpdateUtil.asyncCalAndDeleteStatus(acctGroupMap);
        return String.join((CharSequence)",", operationMsgs.toArray(new String[0]));
    }

    public static String doUnWriteOff(List<Long> logIdList) {
        List logIdsPartition = Lists.partition(logIdList, (int)2000);
        ArrayList<String> operationMsgs = new ArrayList<String>(8);
        HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMap = new HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>>(1);
        for (List logIds : logIdsPartition) {
            List<ReciprocalLog> logs = ReciprocalUtils.queryLogInfo(logIds);
            HashSet<Long> entryIds = new HashSet<Long>(logs.size() * 2);
            for (ReciprocalLog log : logs) {
                entryIds.add(log.getBuyerEntryId());
                entryIds.add(log.getWriteOffEntryId());
            }
            HashSet vchIds = new HashSet();
            Map<Long, ReciprocalRecord> recordMap = ReciprocalUtils.queryRecordsById(entryIds, acctGroupMap);
            UnAcccurrentUpdateUtil.ongoingCalculateAccount(acctGroupMap);
            recordMap.values().forEach(p -> vchIds.add(p.getVoucherId()));
            TXHandle handler = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    ReciprocalUtils.lockVoucher(new ArrayList<Long>(vchIds));
                    recordMap = ReciprocalUtils.queryRecordsById(entryIds, acctGroupMap);
                    logs = ReciprocalUtils.queryLogInfo(logIds);
                    ArrayList<Long> delLogIds = new ArrayList<Long>();
                    ReciprocalUtils.unWriteOffRecord(logs, recordMap, operationMsgs, delLogIds);
                    String logMsg = ReciprocalUtils.delReciprocalLog(delLogIds);
                    operationMsgs.add(logMsg);
                    String recordMsg = ReciprocalUtils.reWriteReciprocalRecord(recordMap, false);
                    operationMsgs.add(recordMsg);
                }
                catch (Exception e) {
                    handler.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (handler == null) continue;
                if (throwable != null) {
                    try {
                        handler.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                handler.close();
            }
        }
        UnAcccurrentUpdateUtil.asyncCalAndDeleteStatus(acctGroupMap);
        return String.join((CharSequence)",", operationMsgs.toArray(new String[0]));
    }

    private static void unWriteOffRecord(List<ReciprocalLog> logs, Map<Long, ReciprocalRecord> recordMap, List<String> operationMsgs, List<Long> delLogIds) {
        Map<Long, String> billnoMap = ReciprocalUtils.queryVchBillNoMap(recordMap);
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(8);
        for (ReciprocalLog log : logs) {
            ReciprocalRecord srcRecord = recordMap.get(log.getBuyerEntryId());
            ReciprocalRecord tgtRecord = recordMap.get(log.getWriteOffEntryId());
            if (srcRecord == null || tgtRecord == null) {
                operationMsgs.add(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6838\u9500\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"ReciprocalUtils_1", (String)"fi-gl-common", (Object[])new Object[0]));
                continue;
            }
            ReciprocalUtils.unWriteOffRecordAmount(log, srcRecord, tgtRecord);
            delLogIds.add(log.getId());
            appLogInfos.add(ReciprocalUtils.getAppLogInfo(billnoMap, log, srcRecord, tgtRecord));
        }
        new OpLogHelper().addBatchOperateLog(appLogInfos);
    }

    private static List<ReciprocalLog> queryLogInfo(List<Long> logIds) {
        ArrayList<ReciprocalLog> logs = new ArrayList<ReciprocalLog>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.doUnWriteOff", (String)RECIPROCAL_LOG, (String)"id,buyerentry,writeoffentry,amount,amountfor", (QFilter[])new QFilter[]{new QFilter(ID, "in", logIds)}, (String)"id desc");){
            while (dSet.hasNext()) {
                Row row = dSet.next();
                ReciprocalLog log = new ReciprocalLog();
                log.setId(row.getLong(ID));
                log.setBuyerEntryId(row.getLong(BUYERENTRY));
                log.setWriteOffEntryId(row.getLong(WRITEOFFENTRY));
                log.setAmount(row.getBigDecimal(AMOUNT));
                log.setAmountFor(row.getBigDecimal(AMOUNTFOR));
                logs.add(log);
            }
        }
        return logs;
    }

    private static List<Long> doUnWriteOffLogic(ReciprocalRecord srcRecord, Map<Long, ReciprocalRecord> tgtRecords, Map<Long, List<ReciprocalLog>> map) {
        Map<Long, String> billnoMap = ReciprocalUtils.queryVchBillNoMap(srcRecord, tgtRecords);
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(8);
        ArrayList<Long> lstLogs = new ArrayList<Long>(tgtRecords.size());
        for (ReciprocalRecord targetRecord : tgtRecords.values()) {
            List<ReciprocalLog> logs = map.get(targetRecord.getId());
            if (logs == null || logs.isEmpty()) continue;
            for (ReciprocalLog log : logs) {
                ReciprocalUtils.unWriteOffRecordAmount(log, srcRecord, targetRecord);
                lstLogs.add(log.getId());
                appLogInfos.add(ReciprocalUtils.getAppLogInfo(billnoMap, log, srcRecord, targetRecord));
            }
        }
        new OpLogHelper().addBatchOperateLog(appLogInfos);
        return lstLogs;
    }

    private static void unWriteOffRecordAmount(ReciprocalLog log, ReciprocalRecord srcRecord, ReciprocalRecord targetRecord) {
        BigDecimal writeOffAmt = log.getAmount();
        BigDecimal writeOffAmtFor = log.getAmountFor();
        srcRecord.addBalLocal(writeOffAmt);
        srcRecord.addBalFor(writeOffAmtFor);
        targetRecord.addBalLocal(writeOffAmt);
        targetRecord.addBalFor(writeOffAmtFor);
        if (srcRecord.getAmountBalFor().compareTo(srcRecord.getAmountFor()) == 0 && srcRecord.getAmountBal().compareTo(srcRecord.getAmount()) == 0) {
            srcRecord.setStatus(STATUS_NOT_WRITEOFF);
        } else {
            srcRecord.setStatus("1");
        }
        if (targetRecord.getAmountBalFor().compareTo(targetRecord.getAmountFor()) == 0 && targetRecord.getAmountBal().compareTo(targetRecord.getAmount()) == 0) {
            targetRecord.setStatus(STATUS_NOT_WRITEOFF);
        } else {
            targetRecord.setStatus("1");
        }
    }

    private static String delReciprocalLog(Collection<Long> logIds) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)RECIPROCAL_LOG, (Object[])logIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            return ResManager.loadKDString((String)"\u6838\u9500\u65e5\u5fd7\u5220\u9664\u6210\u529f\u3002", (String)"ReciprocalUtils_2", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"\u5220\u9664\u6838\u9500\u65e5\u5fd7\u5931\u8d25\uff1a%s\u3002", (String)"ReciprocalUtils_3", (String)"fi-gl-common", (Object[])new Object[0]), result.getMessage());
    }

    public static String doWriteOff(List<Long> vchids, Map<Long, Long> recordAndOppRecordMap) {
        HashSet<Long> recordIds = new HashSet<Long>(recordAndOppRecordMap.size() * 2);
        for (Map.Entry<Long, Long> entry : recordAndOppRecordMap.entrySet()) {
            recordIds.add(entry.getKey());
            recordIds.add(entry.getValue());
        }
        ArrayList<String> operationMsgs = new ArrayList<String>();
        HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMap = new HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>>(1);
        try (TXHandle handler = TX.required();){
            try {
                Map<Long, ReciprocalRecord> reWriteRecords;
                ReciprocalUtils.lockVoucher(vchids);
                Map<Long, ReciprocalRecord> recordMap = ReciprocalUtils.queryRecordsById(recordIds, acctGroupMap);
                UnAcccurrentUpdateUtil.ongoingCalculateAccount(acctGroupMap);
                ReciprocalContext context = new ReciprocalContext();
                for (Map.Entry<Long, Long> entry : recordAndOppRecordMap.entrySet()) {
                    ReciprocalRecord tgtRecord;
                    ReciprocalRecord srcRecord = recordMap.get(entry.getKey());
                    if (!ReciprocalUtils.checkRecordValidate(srcRecord, tgtRecord = recordMap.get(entry.getValue()), operationMsgs).booleanValue()) continue;
                    RcpWriteOffUtils.generateWriteOffLog(srcRecord, tgtRecord, context, Boolean.FALSE);
                }
                List<ReciprocalLog> saveLogs = context.getReciprocalLogs();
                if (!saveLogs.isEmpty()) {
                    String logMsg = ReciprocalUtils.saveReciprocalLog(saveLogs);
                    operationMsgs.add(logMsg);
                }
                if (!(reWriteRecords = context.getSuccessRecords().stream().collect(Collectors.toMap(ReciprocalRecord::getId, x -> x, (oldVal, newVal) -> newVal))).isEmpty()) {
                    String recordMsg = ReciprocalUtils.reWriteReciprocalRecord(reWriteRecords, true);
                    operationMsgs.add(recordMsg);
                }
            }
            catch (Exception e) {
                handler.markRollback();
                throw e;
            }
        }
        UnAcccurrentUpdateUtil.asyncCalAndDeleteStatus(acctGroupMap);
        return String.join((CharSequence)",", operationMsgs.toArray(new String[0]));
    }

    private static Boolean checkRecordValidate(ReciprocalRecord srcRecord, ReciprocalRecord tgtRecord, List<String> operationMsgs) {
        if (srcRecord == null || tgtRecord == null) {
            return Boolean.FALSE;
        }
        if (srcRecord.getId().equals(tgtRecord.getId())) {
            return Boolean.FALSE;
        }
        if ("2".equals(srcRecord.getStatus()) || "2".equals(tgtRecord.getStatus())) {
            operationMsgs.add(String.format(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55%1$s\uff0c%2$s\u5df2\u5b58\u5728\u5b8c\u5168\u6838\u9500\uff0c\u4e0d\u5141\u8bb8\u6838\u9500\u3002", (String)"ReciprocalUtils_4", (String)"fi-gl-common", (Object[])new Object[0]), srcRecord.getId(), tgtRecord.getId()));
            return Boolean.FALSE;
        }
        if (!(srcRecord.getAccount().equals(tgtRecord.getAccount()) && srcRecord.getAssgrp().equals(tgtRecord.getAssgrp()) && srcRecord.getCurrency().equals(tgtRecord.getCurrency()) && srcRecord.getBizNum().equals(tgtRecord.getBizNum()))) {
            operationMsgs.add(String.format(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55%1$s\uff0c%2$s\u79d1\u76ee\u3001\u5e01\u79cd\u3001\u6838\u7b97\u7ef4\u5ea6\u3001\u4e1a\u52a1\u7f16\u53f7\u5b58\u5728\u4e0d\u76f8\u540c\uff0c\u4e0d\u5141\u8bb8\u6838\u9500\u3002", (String)"ReciprocalUtils_6", (String)"fi-gl-common", (Object[])new Object[0]), srcRecord.getId(), tgtRecord.getId()));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static void lockVoucher(List<Long> vchids) {
        GLUtil.lockVouchers(vchids);
    }

    protected static ReciprocalLog buildReciprocalLog(ReciprocalRecord buyerRecord, ReciprocalRecord writeOffRecord, BigDecimal writeOffAmount, BigDecimal writeOffAmountFor) {
        ReciprocalLog rcpLog = new ReciprocalLog();
        rcpLog.setOrg(buyerRecord.getOrg());
        rcpLog.setBookType(buyerRecord.getBookType());
        rcpLog.setPeriod(buyerRecord.getPeriod());
        rcpLog.setWriteOffDate(TimeServiceHelper.now());
        rcpLog.setAcctTable(buyerRecord.getAccountTable());
        rcpLog.setAccount(buyerRecord.getAccount());
        rcpLog.setAssgrp(buyerRecord.getAssgrp());
        rcpLog.setCurrency(buyerRecord.getCurrency());
        rcpLog.setLocalCurrency(buyerRecord.getLocalCurrency());
        rcpLog.setAmount(writeOffAmount);
        rcpLog.setAmountFor(writeOffAmountFor);
        rcpLog.setBuyerEntryId(buyerRecord.getId());
        rcpLog.setWriteOffEntryId(writeOffRecord.getId());
        rcpLog.setWriter(ContextUtil.getUserId());
        return rcpLog;
    }

    private static String saveReciprocalLog(List<ReciprocalLog> logs) {
        MainEntityType logType = EntityMetadataCache.getDataEntityType((String)RECIPROCAL_LOG);
        ArrayList<DynamicObject> lstSaveDatas = new ArrayList<DynamicObject>(logs.size());
        for (ReciprocalLog log : logs) {
            DynamicObject saveObj = (DynamicObject)logType.createInstance();
            saveObj.set(ORG, (Object)log.getOrg());
            saveObj.set(BOOKTYPE, (Object)log.getBookType());
            saveObj.set(PERIOD, (Object)log.getPeriod());
            saveObj.set(WRITEOFFDATE, (Object)log.getWriteOffDate());
            saveObj.set(ACCOUNTTABLE, (Object)log.getAcctTable());
            saveObj.set(ACCOUNT, (Object)log.getAccount());
            saveObj.set(ASSGRP, (Object)log.getAssgrp());
            saveObj.set(CURRENCY, (Object)log.getCurrency());
            saveObj.set(AMOUNTFOR, (Object)log.getAmountFor());
            saveObj.set(LOCALCURRENCY, (Object)log.getLocalCurrency());
            saveObj.set(AMOUNT, (Object)log.getAmount());
            saveObj.set(BUYERENTRY, (Object)log.getBuyerEntryId());
            saveObj.set(WRITEOFFENTRY, (Object)log.getWriteOffEntryId());
            saveObj.set("writer", (Object)log.getWriter());
            saveObj.set("writeofftype", (Object)STATUS_NOT_WRITEOFF);
            lstSaveDatas.add(saveObj);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)RECIPROCAL_LOG, (DynamicObject[])lstSaveDatas.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            return ResManager.loadKDString((String)"\u6838\u9500\u65e5\u5fd7\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReciprocalUtils_8", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"\u6838\u9500\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25\uff1a%s\u3002", (String)"ReciprocalUtils_9", (String)"fi-gl-common", (Object[])new Object[0]), result.getMessage());
    }

    private static String reWriteReciprocalRecord(Map<Long, ReciprocalRecord> records, boolean isWriteOff) {
        Date modifyDate = TimeServiceHelper.now();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(8);
        Long zeroId = 0L;
        for (ReciprocalRecord record : records.values()) {
            if (record.getMasterId().equals(zeroId)) continue;
            updateParams.add(new Object[]{record.getAmountBal(), record.getAmountBalFor(), record.getStatus(), modifyDate, isWriteOff ? ContextUtil.getUserId() : 0L, record.getMasterId()});
        }
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)new DBRoute("gl"), (String)UPDATE_ACCCURRENT_SQL, updateParams);
        }
        return ResManager.loadKDString((String)"\u5f80\u6765\u8d26\u8bb0\u5f55\u53cd\u5199\u6210\u529f\u3002", (String)"ReciprocalUtils_10", (String)"fi-gl-common", (Object[])new Object[0]);
    }

    public static Map<String, Long> saveNewAssgrpVal(List<FlexEntireData> flexEntireDatas) {
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        return FlexSaveService.batchSaveFlexData(mainEntity, flexEntireDatas);
    }

    public static FlexEntireData buildFlexEntireData(Map<String, Object> flexFieldValueMap) {
        Map<String, Integer> map = ReciprocalUtils.getFlexIndexCache();
        FlexEntireData flexEntireData = new FlexEntireData();
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>();
        for (Map.Entry<String, Object> entry : flexFieldValueMap.entrySet()) {
            String flexField = entry.getKey();
            Object value = entry.getValue();
            FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData);
            if (value instanceof String) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
            } else {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
            }
            if (Objects.nonNull(map.get(flexField))) {
                flexData.setIndex(map.get(flexField).intValue());
            }
            flexData.setPropId(flexField);
            flexData.setValue(value);
            if (value == null) continue;
            flexDatas.add(flexData);
        }
        flexEntireData.setFlexDatas(flexDatas);
        return flexEntireData;
    }

    private static Map<String, Integer> getFlexIndexCache() {
        HashMap<String, Integer> map = (HashMap<String, Integer>)ThreadCache.get((Object)"flexproperty-index");
        if (map == null) {
            map = new HashMap<String, Integer>(50);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.reciprocal.ReciprocalUtils.getFlexIndexCache", (String)"bd_asstacttype", (String)"flexfield,index", null, null);
            for (Row row : ds) {
                map.put(row.getString("flexfield"), row.getInteger("index"));
            }
            ThreadCache.put((Object)"flexproperty-index", map);
        }
        return map;
    }

    public static Long rebuildAssgrpId(Map<String, Object> flexFieldValueMap) {
        Map<String, Integer> map = ReciprocalUtils.getFlexIndexCache();
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>();
        FlexEntireData flexEntireData = new FlexEntireData();
        for (Map.Entry<String, Object> entry : flexFieldValueMap.entrySet()) {
            String flexField = entry.getKey();
            Object value = entry.getValue();
            FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData);
            if (value instanceof Long || value instanceof Integer) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
            } else if (value instanceof String) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
            }
            if (Objects.nonNull(map.get(flexField))) {
                flexData.setIndex(map.get(flexField).intValue());
            }
            flexData.setPropId(flexField);
            flexData.setValue(value);
            if (value == null) continue;
            flexDatas.add(flexData);
        }
        flexEntireData.setFlexDatas(flexDatas);
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        return FlexService.saveFlexData((MainEntityType)mainEntity, (FlexEntireData)flexEntireData);
    }

    public static List<ReciprocalScheme> loadRcpSchemes(FilterInfo filterInfo) {
        ArrayList<Long> accountids;
        Long currencyId;
        Long actTableId;
        long orgId;
        block18: {
            orgId = 0L;
            QFilter pOrgF = (QFilter)filterInfo.getCommFilter().get("parentOrg");
            if (pOrgF != null) {
                String s = pOrgF.getValue().toString();
                orgId = Long.parseLong(s);
            }
            actTableId = filterInfo.getLong(ACCOUNTTABLE);
            currencyId = 0L;
            String curStr = filterInfo.getString(CURRENCY);
            if (!"allcurrency".equals(curStr) && !"basecurrency".equals(curStr)) {
                currencyId = Long.valueOf(curStr);
            }
            accountids = new ArrayList<Long>();
            FilterItemInfo itemInfo = filterInfo.getFilterItem(ACCOUNT);
            if (itemInfo == null) break block18;
            List value = (List)itemInfo.getValue();
            if (value != null) {
                for (DynamicObject dyn : value) {
                    accountids.add(dyn.getLong(MASTERID));
                }
            } else {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter(ACCOUNTTABLE, "=", (Object)actTableId));
                filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
                filters.add(new QFilter("accheck", "=", (Object)"1"));
                try (DataSet dSet = QueryServiceHelper.queryDataSet((String)ReciprocalUtils.class.getName(), (String)"bd_accountview", (String)MASTERID, (QFilter[])filters.toArray(new QFilter[0]), null);){
                    while (dSet.hasNext()) {
                        accountids.add(dSet.next().getLong(MASTERID));
                    }
                }
            }
        }
        return ReciprocalUtils.loadRcpSchemes(orgId, actTableId, accountids, currencyId);
    }

    public static List<ReciprocalScheme> loadRcpSchemes(Long orgId, Long acctTableId, Iterable<Long> accountids, Long currencyId) {
        HashMap<Long, ReciprocalScheme> schemes = new HashMap<Long, ReciprocalScheme>();
        DynamicObjectCollection schemeCollection = ReciprocalUtils.getScheDynamicObjects(orgId, acctTableId);
        for (Long account : accountids) {
            ReciprocalScheme curScheme = ReciprocalUtils.loadReciScheme(account, currencyId, schemeCollection);
            if (curScheme == null) continue;
            ReciprocalScheme scheme = (ReciprocalScheme)schemes.get(curScheme.getId());
            if (scheme == null) {
                scheme = curScheme;
                schemes.put(scheme.getId(), scheme);
            }
            scheme.setOrg(orgId);
            if (account != 0L && !scheme.getAccountList().contains(account)) {
                scheme.getAccountList().add(account);
            }
            if (currencyId == 0L || scheme.getCurrencyList().contains(currencyId)) continue;
            scheme.getCurrencyList().add(currencyId);
        }
        ArrayList<ReciprocalScheme> schemesList = new ArrayList<ReciprocalScheme>(schemes.size());
        for (ReciprocalScheme scheme : schemes.values()) {
            schemesList.add(scheme);
        }
        return schemesList;
    }

    private static DynamicObjectCollection getScheDynamicObjects(Long orgId, Long acctTableId) {
        String selectFields = "id,number,name,useorg org,writeoffmode,verifiorder,reverordersamedire,verifidiffbusino,noverifibusinoempty,moneyequacanverfi,excluunpostvoucher, account.fbasedataid.masterid account, currency.fbasedataid currency,voucherfilterjson,equalamountpriority";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)RECIPROCAL_SCHEME, (Long)orgId);
        if (orgFilter != null) {
            filters.add(orgFilter);
        }
        filters.add(new QFilter(ACCOUNTTABLE, "=", (Object)acctTableId));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(ReciprocalUtils.getWriteOffWayFilter("2"));
        DynamicObjectCollection schemeCollection = QueryServiceHelper.query((String)RECIPROCAL_SCHEME, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        return schemeCollection;
    }

    public static ReciprocalScheme loadRcpScheme(Long orgId, Long acctTableId, Long accountid, Long currencyId) {
        ReciprocalScheme rstScheme = null;
        String selectFields = "id,number,name,useorg org,verifiorder,reverordersamedire,equalamountpriority,verifidiffbusino,noverifibusinoempty,moneyequacanverfi,excluunpostvoucher, account.fbasedataid.masterid account, currency.fbasedataid currency,voucherfilterjson,writeoffmode";
        List<QFilter> filters = ReciprocalUtils.getSchemeFilter(orgId, acctTableId, accountid, currencyId);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.loadRcpScheme", (String)RECIPROCAL_SCHEME, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            int matchLevel = 0;
            while (dSet.hasNext()) {
                long currency;
                Row row = dSet.next();
                long account = row.getLong(ACCOUNT);
                Integer level = ReciprocalUtils.getSchemePriorityLevel(account, currency = row.getLong(CURRENCY).longValue());
                if (level <= matchLevel) continue;
                rstScheme = ReciprocalUtils.buildScheme(row);
                matchLevel = level;
            }
        }
        return rstScheme;
    }

    public static ReciprocalScheme loadReciScheme(Long accountid, Long currencyId, DynamicObjectCollection schemeCollection) {
        ReciprocalScheme rstScheme = null;
        int matchLevel = 0;
        for (DynamicObject schDynamicObj : schemeCollection) {
            Integer level;
            long account = schDynamicObj.getLong(ACCOUNT);
            long currency = schDynamicObj.getLong(CURRENCY);
            boolean flag = false;
            if (account != 0L && account == accountid && currency != 0L && (currency == currencyId || currencyId == 0L)) {
                flag = true;
            } else if (account != 0L && account == accountid && currency == 0L) {
                flag = true;
            } else if (account == 0L && currency != 0L && (currency == currencyId || currencyId == 0L)) {
                flag = true;
            } else if (account == 0L && currency == 0L) {
                flag = true;
            }
            if (!flag || (level = ReciprocalUtils.getSchemePriorityLevel(account, currency)) <= matchLevel) continue;
            rstScheme = ReciprocalUtils.buildSchemeByDynamicObject(schDynamicObj);
            matchLevel = level;
        }
        return rstScheme;
    }

    private static Integer getSchemePriorityLevel(long account, long currency) {
        Integer level = 0;
        if (account > 0L && currency > 0L) {
            level = 4;
        } else if (account > 0L && currency == 0L) {
            level = 3;
        } else if (account == 0L && currency > 0L) {
            level = 2;
        } else if (account == 0L && currency == 0L) {
            level = 1;
        }
        return level;
    }

    private static List<QFilter> getSchemeFilter(Long orgId, Long acctTableId, Long accountid, Long currencyId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)RECIPROCAL_SCHEME, (Long)orgId);
        if (orgFilter != null) {
            filters.add(orgFilter);
        }
        filters.add(new QFilter(ACCOUNTTABLE, "=", (Object)acctTableId));
        if (accountid != 0L) {
            filters.add(new QFilter("account.fbasedataid.masterid", "=", (Object)accountid).or(new QFilter("account.fbasedataid", "is null", null)));
        } else {
            filters.add(new QFilter("account.fbasedataid", "is null", null));
        }
        if (currencyId != 0L) {
            filters.add(new QFilter(CURRENCY_BASEDATAID, "=", (Object)currencyId).or(new QFilter(CURRENCY_BASEDATAID, "is null", null)));
        } else {
            filters.add(new QFilter(CURRENCY_BASEDATAID, "is null", null));
        }
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(ReciprocalUtils.getWriteOffWayFilter("1"));
        return filters;
    }

    public static DynamicObject[] querySchemes(long orgId, long acctTableId, List<Long> accountMasterIdList, List<Long> currencyIdList, String writeOffWay) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        qFilterList.add(BaseDataServiceHelper.getBaseDataFilter((String)RECIPROCAL_SCHEME, (Long)orgId));
        qFilterList.add(new QFilter(ACCOUNTTABLE, "=", (Object)acctTableId));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        if (accountMasterIdList != null && !accountMasterIdList.isEmpty()) {
            qFilterList.add(new QFilter("account.fbasedataid.masterid", "in", accountMasterIdList).or(new QFilter("account.fbasedataid", "is null", null)));
        } else {
            qFilterList.add(new QFilter("account.fbasedataid", "is null", null));
        }
        if (currencyIdList != null && !currencyIdList.isEmpty()) {
            qFilterList.add(new QFilter(CURRENCY_BASEDATAID, "in", currencyIdList).or(new QFilter(CURRENCY_BASEDATAID, "is null", null)));
        } else if (currencyIdList != null && currencyIdList.isEmpty()) {
            qFilterList.add(new QFilter(CURRENCY_BASEDATAID, "is null", null));
        }
        if ("1".equals(writeOffWay)) {
            qFilterList.add(ReciprocalUtils.getWriteOffWayFilter("1"));
        } else if ("2".equals(writeOffWay)) {
            qFilterList.add(ReciprocalUtils.getWriteOffWayFilter("2"));
        }
        return BusinessDataServiceHelper.load((String)RECIPROCAL_SCHEME, (String)select_fileds, (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    public static QFilter getWriteOffWayFilter(String writeoffWay) {
        if (!"1".equals(writeoffWay) && !"2".equals(writeoffWay)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9002\u7528\u6838\u9500\u65b9\u5f0f\u6709\u8bef\u3002", (String)"ReciprocalUtils_17", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        ArrayList<String> writeOffWayTypes = new ArrayList<String>(2);
        writeOffWayTypes.add(writeoffWay);
        writeOffWayTypes.add(STATUS_NOT_WRITEOFF);
        return new QFilter("writeoffway", "in", writeOffWayTypes);
    }

    private static ReciprocalScheme buildScheme(Row row) {
        ReciprocalScheme scheme = new ReciprocalScheme();
        scheme.setId(row.getLong(ID));
        scheme.setNumber(row.getString("number"));
        scheme.setOrg(row.getLong(ORG));
        scheme.setAccountList(new ArrayList<Long>());
        scheme.setCurrencyList(new ArrayList<Long>());
        scheme.setWriteOffMode(row.getString("writeoffmode"));
        if (scheme.getWriteOffMode() == WriteOffMode.ORDER) {
            scheme.setVerifiOrder(row.getString("verifiorder"));
            scheme.setReverOrderSameDire(row.getBoolean("reverordersamedire"));
            scheme.setEqualamountpriority(row.getBoolean("equalamountpriority"));
            scheme.setVerifiDiffBusiNo(row.getBoolean("verifidiffbusino"));
            scheme.setNoVerifiBusiNoEmpty(row.getBoolean("noverifibusinoempty"));
            scheme.setEquaCanVerfi(row.getBoolean("moneyequacanverfi"));
            scheme.setExculdeUnPostVoucher(row.getBoolean("excluunpostvoucher"));
            scheme.setVoucherFilterJson(row.getString("voucherfilterjson"));
        }
        return scheme;
    }

    private static ReciprocalScheme buildSchemeByDynamicObject(DynamicObject row) {
        ReciprocalScheme scheme = new ReciprocalScheme();
        scheme.setId(row.getLong(ID));
        scheme.setNumber(row.getString("number"));
        scheme.setOrg(row.getLong(ORG));
        scheme.setAccountList(new ArrayList<Long>(8));
        scheme.setCurrencyList(new ArrayList<Long>(8));
        scheme.setWriteOffMode(row.getString("writeoffmode"));
        if (scheme.getWriteOffMode() == WriteOffMode.ORDER) {
            scheme.setVerifiOrder(row.getString("verifiorder"));
            scheme.setReverOrderSameDire(row.getBoolean("reverordersamedire"));
            scheme.setVerifiDiffBusiNo(row.getBoolean("verifidiffbusino"));
            scheme.setNoVerifiBusiNoEmpty(row.getBoolean("noverifibusinoempty"));
            scheme.setEquaCanVerfi(row.getBoolean("moneyequacanverfi"));
            scheme.setExculdeUnPostVoucher(row.getBoolean("excluunpostvoucher"));
            scheme.setVoucherFilterJson(row.getString("voucherfilterjson"));
            scheme.setEqualamountpriority(row.getBoolean("equalamountpriority"));
        }
        return scheme;
    }

    public static Set<Long> queryEndInitOrgs(Set<Long> orgs, Long bookType, Set<Long> accountids) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(ORG, "in", orgs));
        filters.add(new QFilter(BOOKTYPE, "=", (Object)bookType));
        filters.add(new QFilter(ISENDINIT, "=", (Object)"1"));
        filters.add(new QFilter("account.masterid", "in", accountids));
        HashSet<Long> orgSet = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"ReciprocalInitUtil.queryIsEndInitReciprocalInit", (String)"gl_reci_init_state", (String)ORG, (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (dSet.hasNext()) {
                Row row = dSet.next();
                orgSet.add(row.getLong(ORG));
            }
        }
        return orgSet;
    }

    public static QFilter queryEndInitActFilter(Set<Long> orgs, Long bookType) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(ORG, "in", orgs));
        filters.add(new QFilter(BOOKTYPE, "=", (Object)bookType));
        filters.add(new QFilter(ISENDINIT, "=", (Object)"1"));
        HashSet<Long> masterIds = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"ReciprocalInitUtil.queryIsEndInitReciprocalInit", (String)"gl_reci_init_state", (String)"account.masterid masterid", (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (dSet.hasNext()) {
                Row row = dSet.next();
                masterIds.add(row.getLong(MASTERID));
            }
        }
        return new QFilter(MASTERID, "in", masterIds);
    }

    public static List<QFilter> getAccAccountFilter(Long orgId, Long bookTypeId, Long accountTableId) {
        Row row;
        Object object;
        Object dSet;
        Object acctId3;
        Serializable preParentId;
        ArrayList<QFilter> acctFilters = new ArrayList<QFilter>(8);
        ReciprocalInitUtils.addReciprocalAccountF7Filter(acctFilters, orgId, accountTableId, true);
        HashSet<Object> acctIds = new HashSet<Object>(8);
        QFilter oldAcctFilter = null;
        HashMap<String, Long> masterAndIdMap = new HashMap<String, Long>(8);
        HashMap<Long, Set> parentAndIdMap = new HashMap<Long, Set>(8);
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys(orgId, (long)bookTypeId);
        if (Objects.isNull(accountBookInfo)) {
            return acctFilters;
        }
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBookInfo.getCurPeriodId(), (String)"bd_period");
        if (period == null) {
            return acctFilters;
        }
        Date curPeriodDate = period.getDate("enddate");
        try (DataSet dSet2 = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.getAccAccountFilter", (String)"bd_accountview", (String)"id,masterid,startdate,enddate,parent,createtime", (QFilter[])acctFilters.toArray(new QFilter[0]), (String)"parent,createtime");){
            preParentId = Long.valueOf(0L);
            Date initBeginDate = BalanceTransferUtils.getInitBeginDate();
            for (Row row2 : dSet2) {
                Long masterId = row2.getLong(MASTERID);
                Long acctId2 = row2.getLong(ID);
                Date startDate = row2.getDate("startdate");
                Long parentId = row2.getLong("parent");
                if (startDate == null) continue;
                if (startDate.compareTo(initBeginDate) == 0) {
                    acctIds.add(acctId2);
                } else if (masterId.compareTo(acctId2) == 0) {
                    if (parentId.compareTo(0L) == 0) {
                        acctIds.add(acctId2);
                    } else if (((Long)preParentId).compareTo(parentId) == 0) {
                        acctIds.add(acctId2);
                    } else {
                        Set accts = parentAndIdMap.computeIfAbsent(parentId, k -> new HashSet(8));
                        accts.add(acctId2);
                    }
                } else {
                    Date endDate = row2.getDate("enddate");
                    if (startDate.compareTo(curPeriodDate) <= 0 && endDate.compareTo(curPeriodDate) >= 0) {
                        QFilter tmpFilter = new QFilter(MASTERID, "=", (Object)masterId).and(new QFilter("enddate", "=", (Object)startDate));
                        oldAcctFilter = oldAcctFilter == null ? tmpFilter : oldAcctFilter.or(tmpFilter);
                        masterAndIdMap.put(masterId + "-" + startDate, acctId2);
                        acctIds.add(acctId2);
                    }
                }
                preParentId = parentId;
            }
        }
        if (oldAcctFilter != null) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            filters.add(oldAcctFilter);
            DataSet dSet3 = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)"accheck,masterid,enddate", filters);
            preParentId = null;
            try {
                for (Row row3 : dSet3) {
                    if (row3.getBoolean("accheck").booleanValue() || (acctId3 = (Long)masterAndIdMap.get(row3.get(MASTERID) + "-" + row3.get("enddate"))) == null) continue;
                    acctIds.add(acctId3);
                }
            }
            catch (Throwable initBeginDate) {
                preParentId = initBeginDate;
                throw initBeginDate;
            }
            finally {
                if (dSet3 != null) {
                    if (preParentId != null) {
                        try {
                            dSet3.close();
                        }
                        catch (Throwable initBeginDate) {
                            ((Throwable)preParentId).addSuppressed(initBeginDate);
                        }
                    } else {
                        dSet3.close();
                    }
                }
            }
        }
        if (!parentAndIdMap.isEmpty()) {
            QFilter parentFilter = new QFilter(ID, "in", parentAndIdMap.keySet());
            QFilter isAccFilter = new QFilter("accheck", "=", (Object)false);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            filters.add(parentFilter);
            filters.add(isAccFilter);
            dSet = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)ID, filters);
            object = null;
            try {
                acctId3 = dSet.iterator();
                while (acctId3.hasNext()) {
                    row = (Row)acctId3.next();
                    Long pAcctId = row.getLong(ID);
                    Set cAcctIds = (Set)parentAndIdMap.get(pAcctId);
                    if (cAcctIds == null) continue;
                    acctIds.addAll(cAcctIds);
                }
            }
            catch (Throwable acctId3) {
                object = acctId3;
                throw acctId3;
            }
            finally {
                if (dSet != null) {
                    if (object != null) {
                        try {
                            dSet.close();
                        }
                        catch (Throwable acctId3) {
                            ((Throwable)object).addSuppressed(acctId3);
                        }
                    } else {
                        dSet.close();
                    }
                }
            }
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)BD_ACCOUNTTABLEREF, (Long)orgId);
        HashMap<Long, Long> oldAcctAndNewAcctMap = new HashMap<Long, Long>(8);
        DataSet dSet4 = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.getAccAccountFilter", (String)BD_ACCOUNTTABLEREF, (String)"mappingentry.oldaccount.masterid oldaccount, mappingentry.newaccount newaccount", (QFilter[])new QFilter[]{new QFilter("mappingentry.newaccount", "in", acctIds), baseDataFilter}, null);
        dSet = null;
        try {
            for (Row row2 : dSet4) {
                oldAcctAndNewAcctMap.put(row2.getLong("oldaccount"), row2.getLong("newaccount"));
            }
        }
        catch (Throwable throwable) {
            dSet = throwable;
            throw throwable;
        }
        finally {
            if (dSet4 != null) {
                if (dSet != null) {
                    try {
                        dSet4.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)dSet).addSuppressed(throwable);
                    }
                } else {
                    dSet4.close();
                }
            }
        }
        QFilter filter = new QFilter("account.masterid", "in", oldAcctAndNewAcctMap.keySet());
        filter.and(new QFilter(BOOKTYPE, "=", (Object)bookTypeId));
        filter.and(new QFilter(ORG, "=", (Object)orgId));
        dSet = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.getAccAccountFilter", (String)"gl_reci_init_state", (String)"account.masterid account", (QFilter[])new QFilter[]{filter}, null);
        object = null;
        try {
            Iterator iterator = dSet.iterator();
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                Long newAcct = (Long)oldAcctAndNewAcctMap.get(row.getLong(ACCOUNT));
                if (newAcct == null) continue;
                acctIds.remove(newAcct);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dSet != null) {
                if (object != null) {
                    try {
                        dSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dSet.close();
                }
            }
        }
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(8);
        lstFilters.add(new QFilter(ACCOUNTTABLE, "=", (Object)accountTableId));
        lstFilters.add(new QFilter("startdate", "<=", (Object)curPeriodDate));
        lstFilters.add(new QFilter("enddate", ">=", (Object)curPeriodDate));
        lstFilters.add(new QFilter(ID, "in", acctIds));
        return lstFilters;
    }

    public static boolean isEndInit(long orgId, long bookTypeId, long periodId) {
        long curPeriodAccountTableId = AccSysUtil.getCurPeriodAccountTableId(orgId, bookTypeId, periodId);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(ID, "=", periodId);
        DynamicObject periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)String.join((CharSequence)",", "begindate", "enddate"), (QFilter[])qfBuilder.toArray());
        if (Objects.isNull(periodDO)) {
            throw new GLException(GLErrorCode.common, String.format(ResManager.loadKDString((String)"ID\u201c%s\u201d\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5df2\u88ab\u5220\u9664\u3002", (String)"ReciprocalUtils_11", (String)"fi-gl-common", (Object[])new Object[0]), periodId));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("accheck", "=", (Object)true));
        if (Objects.isNull(periodDO.getDate("begindate"))) {
            filters.add(new QFilter("enddate", ">=", (Object)GLUtil.getInitBeginDate()));
        } else {
            filters.add(new QFilter("enddate", ">=", (Object)periodDO.getDate("begindate")));
        }
        if (Objects.isNull(periodDO.getDate("enddate"))) {
            filters.add(new QFilter("startdate", "<=", (Object)GLUtil.getEndDate()));
        } else {
            filters.add(new QFilter("startdate", "<=", (Object)periodDO.getDate("enddate")));
        }
        filters.add(new QFilter("enable", "=", (Object)"1"));
        try (DataSet accountDataSet = AccountUtils.queryAccountDataSet((long)orgId, (long)curPeriodAccountTableId, (String)MASTERID, filters, null);){
            HashSet<Long> acAccountIds = new HashSet<Long>(10);
            for (Row row : accountDataSet) {
                acAccountIds.add(row.getLong(MASTERID));
            }
            if (CollectionUtils.isEmpty(acAccountIds)) {
                boolean bl = true;
                return bl;
            }
            qfBuilder.clear();
            qfBuilder.add(ORG, "=", orgId);
            qfBuilder.add(BOOKTYPE, "=", bookTypeId);
            qfBuilder.add("account.masterid", "in", acAccountIds);
            try (DataSet reciprotalInitStates = QueryServiceHelper.queryDataSet((String)ReciprocalUtils.class.getName(), (String)"gl_reci_init_state", (String)String.join((CharSequence)",", "account.masterid", ISENDINIT, ENDINITPERIOD), (QFilter[])qfBuilder.toArray(), null);){
                for (Row row : reciprotalInitStates) {
                    long endInitPeriod = row.getLong(ENDINITPERIOD);
                    if (!row.getBoolean(ISENDINIT).booleanValue() && endInitPeriod <= periodId || endInitPeriod >= periodId) {
                        boolean bl = false;
                        return bl;
                    }
                    acAccountIds.remove(row.getLong("account.masterid"));
                }
            }
            if (CollectionUtils.isEmpty(acAccountIds)) {
                boolean bl = true;
                return bl;
            }
            qfBuilder.clear();
            qfBuilder.add(ORG, "=", orgId);
            qfBuilder.add(BOOKTYPE, "=", bookTypeId);
            qfBuilder.add(ACCOUNT, "in", acAccountIds);
            qfBuilder.add(PERIOD, "<=", periodId);
            qfBuilder.add(PERIOD, ">=", periodId / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L);
            boolean bl = !QueryServiceHelper.exists((String)"gl_balance", (QFilter[])qfBuilder.toArray());
            return bl;
        }
    }

    public static String checkSpecialPerm(boolean isWrite) {
        DynamicObject permCon = isWrite ? SpecialPermItemHelper.getInstance().getActivePermController("1ZXGXDQW=R57", "id,operationrule") : SpecialPermItemHelper.getInstance().getActivePermController("1ZXHPDFDC/4C", "id,operationrule");
        if (permCon != null) {
            return permCon.getString("operationrule");
        }
        return null;
    }

    public static QFilter getSpecialPermFilter(String ruleId, ITimeService timeService, IUserService userService) {
        DynamicObject rule = SpecialPermItemHelper.getInstance().getActivePermRuleController(ruleId);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rule.getString("rule"), FilterCondition.class);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"gl_acccurrent");
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition);
        filterBuilder.setTimeService(timeService);
        filterBuilder.setUserService(userService);
        filterBuilder.buildFilter();
        QFilter qFilter = filterBuilder.getQFilter();
        qFilter.or(VOUCHERID, "=", (Object)0);
        return qFilter;
    }

    public static boolean checkPermForUnWriteOff(Long recordId, ITimeService timeService, IUserService userService) {
        QFilter qFilter1;
        QFilter qFilter;
        DynamicObject[] dyn;
        String ruleId;
        boolean result = true;
        DynamicObject permCon = SpecialPermItemHelper.getInstance().getActivePermController("1ZCUN6OZ1TWD", "id,operationrule");
        if (permCon != null && kd.bos.util.StringUtils.isNotEmpty((String)(ruleId = permCon.getString("operationrule"))) && (dyn = BusinessDataServiceHelper.load((String)RECIPROCAL_LOG, (String)ID, (QFilter[])new QFilter[]{qFilter = ReciprocalUtils.getSpecialPermFilter(ruleId, timeService, userService), qFilter1 = new QFilter(BUYERENTRY, "=", (Object)recordId).or(WRITEOFFENTRY, "=", (Object)recordId)})).length == 0) {
            result = false;
        }
        return result;
    }

    public static void processReciprocalRecord(Set<Long> voucherIds) {
        if (voucherIds == null || voucherIds.isEmpty()) {
            return;
        }
        Date modifyDate = TimeServiceHelper.now();
        HashSet<ReciprocalRecord> newReciRecordList = new HashSet<ReciprocalRecord>(32);
        HashMap<String, Map<Long, List<Long>>> bookAndAcctMap = new HashMap<String, Map<Long, List<Long>>>(voucherIds.size());
        String VCHFIELD = "id,bizdate,period.id,entries.expiredate,modifytime,sourcetype,isreverse,booktype,booktype.id,localcur,creator,creator.id,bookeddate,entries.currency.id currency,entries.account.dc,entries.debitori debitori,entries.creditori creditori,entries.debitlocal debitlocal,entries.creditlocal creditlocal,entries.entrydc entrydc,entries.businessnum businessnum,org,org.id,suppstatus,entries.id,entries.account,entries.account.accounttable accounttable,entries.account.id,entries.account.masterid masterid, entries.account.accheck accheck,entries.assgrp,entries.assgrp.id,entries.assgrp.value,entries.edescription edescription";
        DataSet vchdataSet = GLServiceFactory.getService(IVoucherQueryService.class).queryByIds(voucherIds, new QFilter("entries.account.accheck", "=", (Object)"1").toArray(), VCHFIELD, ID);
        Map<Long, List<DynamicObject>> writeoffedReciMap = ReciprocalUtils.queryWriteoffedReciMap(voucherIds);
        ReciprocalUtils.deleteNotWriteoffRecord(voucherIds);
        Map<String, DynamicObject> reciInitMap = ReciprocalUtils.getReciInitMap(vchdataSet.copy());
        ArrayList<DynamicObject> lstSaveDatas = new ArrayList<DynamicObject>(32);
        for (Row row : vchdataSet) {
            long periodId = row.getLong("period.id");
            long orgId = row.getLong("org.id");
            long bookTypeId = row.getLong("booktype.id");
            long acctTableId = AccSysUtil.getCurPeriodAccountTableId(orgId, bookTypeId, periodId);
            if (writeoffedReciMap.containsKey(row.getLong("entries.id"))) {
                ReciprocalUtils.buildWriteoffedReci(writeoffedReciMap, lstSaveDatas, row, modifyDate);
            } else {
                Long acctMasterId = row.getLong(MASTERID);
                String key = orgId + "-" + bookTypeId + "-" + acctMasterId;
                if (reciInitMap.containsKey(key)) {
                    DynamicObject reciInit = reciInitMap.get(key);
                    long initPeriod = reciInit.getLong(ENDINITPERIOD);
                    boolean isEndInit = reciInit.getBoolean(ISENDINIT);
                    if (isEndInit && periodId >= initPeriod) {
                        ReciprocalRecord rc = ReciprocalUtils.buildReciprocalRecord(row, orgId, bookTypeId, acctTableId);
                        newReciRecordList.add(rc);
                        if (newReciRecordList.size() > 10000) {
                            ReciprocalUtils.saveReciprocalRecord(newReciRecordList);
                            newReciRecordList.clear();
                        }
                    } else if (isEndInit && periodId < initPeriod) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u7ed3\u675f\u5f80\u6765\u521d\u59cb\u5316\u671f\u95f4\u5927\u4e8e\u51ed\u8bc1\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u51ed\u8bc1\u3002", (String)"ReciprocalUtils_16", (String)"fi-gl-common", (Object[])new Object[0]));
                    }
                }
            }
            ReciprocalUtils.putAcctMap(bookAndAcctMap, periodId, orgId, bookTypeId, acctTableId, row.getLong(MASTERID));
        }
        vchdataSet.close();
        if (!lstSaveDatas.isEmpty()) {
            ReciprocalUtils.storeAcccurrent(lstSaveDatas);
            lstSaveDatas.clear();
        }
        if (!newReciRecordList.isEmpty()) {
            ReciprocalUtils.saveReciprocalRecord(newReciRecordList);
        }
        if (!bookAndAcctMap.isEmpty()) {
            AcccurrentVersionBalCal bal = new AcccurrentVersionBalCal();
            bal.updateBal(bookAndAcctMap, false);
        }
    }

    private static String getSourceType(Row row) {
        if (row.getBoolean("isreverse").booleanValue()) {
            return "1";
        }
        if ("4".equals(row.getString(SOURCETYPE))) {
            return "3";
        }
        return STATUS_NOT_WRITEOFF;
    }

    private static void buildWriteoffedReci(Map<Long, List<DynamicObject>> writeoffedReciMap, List<DynamicObject> lstSaveDatas, Row voucher, Date modifyDate) {
        Long vchEntryId = voucher.getLong("entries.id");
        List<DynamicObject> saveObjs = writeoffedReciMap.get(vchEntryId);
        for (DynamicObject saveObj : saveObjs) {
            saveObj.set(PERIOD, (Object)voucher.getLong("period.id"));
            saveObj.set(BIZDATE, (Object)voucher.getDate(BIZDATE));
            saveObj.set(EXPIREDATE, (Object)voucher.getDate("entries.expiredate"));
            saveObj.set(DESCRIPTION, (Object)voucher.getString(EDESCRIPTION));
            saveObj.set(MODIFYTIME, (Object)modifyDate);
            saveObj.set(BOOKEDDATE, (Object)voucher.getDate(BOOKEDDATE));
        }
        lstSaveDatas.addAll(saveObjs);
        if (lstSaveDatas.size() >= 999) {
            ReciprocalUtils.saveAcccurrent(lstSaveDatas);
            lstSaveDatas.clear();
        }
    }

    private static ReciprocalRecord buildReciprocalRecord(Row row, long orgId, long bookTypeId, long acctTableId) {
        ReciprocalRecord record = new ReciprocalRecord();
        record.setOrg(orgId);
        record.setBookType(bookTypeId);
        record.setPeriod(row.getLong("period.id"));
        record.setAccountTable(acctTableId);
        record.setCreatorId(row.getLong("creator.id"));
        record.setAccount(row.getLong(MASTERID));
        record.setAccountPkId(row.getLong("entries.account.id"));
        record.setAssgrp(row.getLong("entries.assgrp.id"));
        String assgrpVal = row.getString("entries.assgrp.value");
        if (kd.bos.util.StringUtils.isNotEmpty((String)assgrpVal)) {
            record.setAssgrpVals((Map<String, Object>)JSONObject.parseObject((String)assgrpVal));
        }
        record.setCurrency(row.getLong(CURRENCY));
        record.setLocalCurrency(row.getLong("localcur"));
        int accountDC = Integer.parseInt(row.getString("entries.account.dc"));
        BigDecimal debit = row.getBigDecimal("debitori");
        BigDecimal credit = row.getBigDecimal("creditori");
        BigDecimal debitlocal = row.getBigDecimal("debitlocal");
        BigDecimal creditlocal = row.getBigDecimal("creditlocal");
        int entryDC = Integer.parseInt(row.getString(ENTYRDC));
        BigDecimal amount = entryDC == 1 ? debit : credit;
        BigDecimal amountlocal = entryDC == 1 ? debitlocal : creditlocal;
        amountlocal = amountlocal.multiply(BigDecimal.valueOf(accountDC)).multiply(BigDecimal.valueOf(entryDC));
        amount = amount.multiply(BigDecimal.valueOf(accountDC)).multiply(BigDecimal.valueOf(entryDC));
        record.setAmountFor(amount);
        record.setAmountBalFor(amount);
        record.setAmount(amountlocal);
        record.setAmountBal(amountlocal);
        record.setBizDate(row.getDate(BIZDATE));
        record.setExpireDate(row.getDate("entries.expiredate"));
        record.setBizNum(row.getString(BUSINESSNUM));
        record.setDescription(row.getString(EDESCRIPTION));
        record.setVoucherId(row.getLong(ID));
        record.setVchEntryId(row.getLong("entries.id"));
        record.setSourceType(ReciprocalUtils.getSourceType(row));
        record.setEntryDc(row.getString(ENTYRDC));
        record.setBookeddate(row.getDate(BOOKEDDATE));
        return record;
    }

    private static Map<String, DynamicObject> getReciInitMap(DataSet vchDataSet) {
        HashSet<Long> orgIds = new HashSet<Long>(32);
        HashSet<Long> bookTypeIds = new HashSet<Long>(32);
        HashMap<String, DynamicObject> reciInitMap = new HashMap<String, DynamicObject>(8);
        HashSet<Long> acctMasterIds = new HashSet<Long>(8);
        DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.reciEndInit);
        DynamicObjectCollection reciInitObj = QueryServiceHelper.query((String)"gl_reci_init_state", (String)"org,booktype,account.masterid,endinitperiod,isendinit", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)0L), null});
        for (Row vch : vchDataSet) {
            Long orgId = vch.getLong("org.id");
            orgIds.add(orgId);
            Long bookTypeId = vch.getLong("booktype.id");
            bookTypeIds.add(bookTypeId);
            if (!vch.getBoolean("accheck").booleanValue()) continue;
            Long acctMastreId = vch.getLong(MASTERID);
            acctMasterIds.add(acctMastreId);
            try {
                String cacheValue = cache.get(ReciprocalUtils.getAccountBookKey(orgId, bookTypeId));
                if (!Objects.nonNull(cacheValue)) continue;
                Map acctMstIdMapPeriod = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
                String acctMstIdStr = String.valueOf(acctMastreId);
                if (!Objects.nonNull(acctMstIdMapPeriod) || !Objects.nonNull(acctMstIdMapPeriod.get(acctMstIdStr))) continue;
                String key = orgId + "-" + bookTypeId + "-" + acctMastreId;
                DynamicObject obj = (DynamicObject)reciInitObj.getDynamicObjectType().createInstance();
                obj.set(ORG, (Object)orgId);
                obj.set(BOOKTYPE, (Object)bookTypeId);
                obj.set("account.masterid", (Object)acctMastreId);
                obj.set(ISENDINIT, (Object)Boolean.TRUE);
                obj.set(ENDINITPERIOD, acctMstIdMapPeriod.get(acctMstIdStr));
                reciInitMap.put(key, obj);
            }
            catch (RuntimeException e) {
                logger.error((Throwable)e);
                throw new KDBizException((Throwable)e, GLErrorCode.SYS_ERR, new Object[0]);
            }
        }
        if (!acctMasterIds.isEmpty()) {
            QFilter orgFilter = new QFilter(ORG, "in", orgIds);
            QFilter bookTypeFilter = new QFilter(BOOKTYPE, "in", bookTypeIds);
            QFilter reciInitFilter = new QFilter("account.masterid", "in", acctMasterIds);
            DynamicObjectCollection reciInitObjs = QueryServiceHelper.query((String)"gl_reci_init_state", (String)"org,booktype,account.masterid,endinitperiod,isendinit", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, reciInitFilter});
            for (DynamicObject obj : reciInitObjs) {
                String key = obj.getLong(ORG) + "-" + obj.getLong(BOOKTYPE) + "-" + obj.getLong("account.masterid");
                reciInitMap.put(key, obj);
            }
        }
        return reciInitMap;
    }

    private static void deleteNotWriteoffRecord(Set<Long> voucherIds) {
        ArrayList<Long> voucherIdList = new ArrayList<Long>(voucherIds);
        List vchIdList = Lists.partition(voucherIdList, (int)999);
        for (List vchIds : vchIdList) {
            String idsStr = StringUtils.join((Object[])vchIds.toArray(), (String)",");
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)String.format(DELACCCSQL, idsStr));
        }
    }

    private static Map<Long, List<DynamicObject>> queryWriteoffedReciMap(Set<Long> voucherIds) {
        HashMap<Long, List<DynamicObject>> writeoffedReciMap = new HashMap<Long, List<DynamicObject>>();
        ArrayList<QFilter> reciFilters = new ArrayList<QFilter>(2);
        QFilter vchFilter = new QFilter(VOUCHERID, "in", voucherIds);
        QFilter statusFilter = new QFilter(STATUS, "!=", (Object)STATUS_NOT_WRITEOFF);
        reciFilters.add(vchFilter);
        reciFilters.add(statusFilter);
        ArrayList<Long> acctIds = new ArrayList<Long>(16);
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet reciDs = QueryServiceHelper.queryDataSet((String)"ReciprocalVchTask.run.queryReciprocalVchentry", (String)"gl_acccurrent", (String)ACCCURRENTFIELD, (QFilter[])reciFilters.toArray(new QFilter[0]), null);){
            for (Row row : reciDs) {
                acctIds.add(row.getLong(ID));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        if (!acctIds.isEmpty()) {
            DynamicObject[] col;
            for (DynamicObject obj : col = BusinessDataServiceHelper.load((Object[])acctIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"gl_acccurrent"))) {
                long vchEnryId = obj.getLong(VOUCHERENTRY);
                List records = writeoffedReciMap.computeIfAbsent(vchEnryId, k -> new ArrayList(8));
                records.add(obj);
            }
        }
        return writeoffedReciMap;
    }

    private static void putAcctMap(Map<String, Map<Long, List<Long>>> bookAndAcctMap, long periodId, long orgId, long bookTypeId, long acctTableId, long acctMasterId) {
        String key = BalanceTransferUtils.getBalTranferKey(orgId, bookTypeId, acctTableId);
        if (bookAndAcctMap.containsKey(key)) {
            Map<Long, List<Long>> map = bookAndAcctMap.get(key);
            List tmpAcctIds = map.computeIfAbsent(periodId, k -> new ArrayList(8));
            tmpAcctIds.add(acctMasterId);
        } else {
            Map map = bookAndAcctMap.computeIfAbsent(key, k -> new HashMap());
            ArrayList<Long> tmpAcctIds = new ArrayList<Long>(10);
            tmpAcctIds.add(acctMasterId);
            map.put(periodId, tmpAcctIds);
        }
    }

    public static void getUpdateWriterByLog(Long recordId, Long writerId, List<Object[]> params) {
        Long writeOffPerson;
        QFilter qFilter = new QFilter(ID, "=", (Object)recordId);
        DynamicObject result = QueryServiceHelper.queryOne((String)"gl_acccurrent", (String)"id,writeoffperson", (QFilter[])new QFilter[]{qFilter});
        if (result != null && !writerId.equals(writeOffPerson = Long.valueOf(result.getLong("writeoffperson")))) {
            params.add(new Object[]{writerId, recordId});
        }
    }

    public static void updateWriteoffPersonByLog(List<Object[]> params) {
        if (!CollectionUtils.isEmpty(params)) {
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)"update t_gl_acccurrent set fwriteoffpersonid = ? where fid = ? ", params);
        }
    }

    public static void delAcccBeforePeroid(Long orgId, Long bookTypeId, Long acctMasterId, Long periodId) {
        if (orgId == null || bookTypeId == null || acctMasterId == null || periodId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5f80\u6765\u7ed3\u675f\u521d\u59cb\u5316\u671f\u95f4\u4e4b\u524d\u5f80\u6765\u8d26\u8bb0\u5f55\u5931\u8d25\u3002", (String)"ReciprocalInitEndInitPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        List<Long> periodIds = PeriodService.getAvailablePeriodIds(orgId, bookTypeId, periodId, acctMasterId);
        for (Long pid : periodIds) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("delete from t_gl_acccurrent where ", new Object[0]);
            sqlBuilder.append(" forgid = ?", new Object[]{orgId});
            sqlBuilder.append(" and fbooktypeid = ?", new Object[]{bookTypeId});
            sqlBuilder.append(" and faccountid = ?", new Object[]{acctMasterId});
            sqlBuilder.append(" and fperiodid = ? ", new Object[]{pid});
            ReciprocalUtils.executeSqlDelete(sqlBuilder);
        }
    }

    private static void executeSqlDelete(SqlBuilder sqlBuilder) {
        try (TXHandle tx = TX.requiresNew((String)"delAcccBeforePeroid");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static Map<String, Set<Object>> getPropValues(DynamicObject assgrp, DynamicObject acct) {
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)acct.getLong(ID), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
        DynamicObjectCollection assistEntry = account.getDynamicObjectCollection("checkitementry");
        ArrayList<String> lstFields = new ArrayList<String>(8);
        for (DynamicObject assistRow : assistEntry) {
            if (!assistRow.getBoolean("enaccheck")) continue;
            String fieldName = assistRow.getString("asstactitem.flexfield");
            lstFields.add(fieldName);
        }
        String flexValue = assgrp.getString("value");
        Map valueMap = (Map)SerializationUtils.fromJsonString((String)flexValue, Map.class);
        HashMap flexFieldToValue = new HashMap(8);
        for (String lstField : lstFields) {
            Object value = valueMap.get(lstField);
            if (value == null) continue;
            flexFieldToValue.put(lstField, value);
        }
        HashMap<String, Set<Object>> propValues = new HashMap<String, Set<Object>>(8);
        for (String propName : lstFields) {
            Object value = flexFieldToValue.get(propName);
            if (null != value) {
                propValues.computeIfAbsent(propName, v -> new HashSet(1)).add(value);
                continue;
            }
            propValues.computeIfAbsent(propName, v -> new HashSet(1));
        }
        return propValues;
    }

    public static boolean needClearBizNumRecord(ChangeData data, IDataModel m) {
        int index = data.getRowIndex();
        DynamicObject currentEntryRow = m.getEntryRowEntity("entries", index);
        String currentBusinessNum = currentEntryRow.getString(BUSINESSNUM);
        if (kd.bos.util.StringUtils.isBlank((String)currentBusinessNum)) {
            return false;
        }
        if (data.getOldValue() == null || data.getNewValue() == null) {
            return false;
        }
        long oldId = ((DynamicObject)data.getOldValue()).getLong(ID);
        long newId = ((DynamicObject)data.getNewValue()).getLong(ID);
        if (oldId == 0L || newId == 0L) {
            return false;
        }
        DynamicObject currentRowAccount = currentEntryRow.getDynamicObject(ACCOUNT);
        boolean accheck = currentRowAccount.getBoolean("accheck");
        long accountId = currentRowAccount.getLong(ID);
        if (!accheck) {
            return false;
        }
        DynamicObject accountDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview");
        DynamicObjectCollection col = accountDyn.getDynamicObjectCollection("checkitementry");
        ArrayList<String> accheckFlexFields = new ArrayList<String>(6);
        for (DynamicObject obj : col) {
            DynamicObject asstactitem;
            if (!obj.getBoolean("enaccheck") || (asstactitem = (DynamicObject)obj.get("asstactitem")) == null) continue;
            accheckFlexFields.add(asstactitem.getString("flexfield"));
        }
        String oldFlexValue = ((DynamicObject)data.getOldValue()).getString("value");
        Map oldFlexMap = (Map)SerializationUtils.fromJsonString((String)oldFlexValue, Map.class);
        String newFlexValue = ((DynamicObject)data.getNewValue()).getString("value");
        Map newFlexMap = (Map)SerializationUtils.fromJsonString((String)newFlexValue, Map.class);
        if (!accheckFlexFields.isEmpty()) {
            for (String flexField : accheckFlexFields) {
                if (oldFlexMap.get(flexField) != null && newFlexMap.get(flexField) != null && oldFlexMap.get(flexField).equals(newFlexMap.get(flexField))) continue;
                return true;
            }
        }
        return false;
    }

    public static FlexEntireData getflexValueMap(DynamicObject acccurrent, DynamicObject vchEntryAssgrp, Long vchEntryAccount, DynamicObject vchEntryRefAcccu) {
        String accheckFlexValue = acccurrent.getString("assgrpvalue");
        FlexValueJson accheckFlexValueJson = new FlexValueJson(accheckFlexValue);
        Map<String, Object> flexValueMap = accheckFlexValueJson.getValueMap();
        if (vchEntryAssgrp != null) {
            String entryFlexValue = vchEntryAssgrp.getString("value");
            FlexValueJson entryFlexValueJson = new FlexValueJson(entryFlexValue);
            Map<String, Object> entryFlexValueMap = entryFlexValueJson.getValueMap();
            flexValueMap.putAll(entryFlexValueMap);
        }
        if (vchEntryRefAcccu != null) {
            long vchEntryAcctIdRefAcccu = vchEntryRefAcccu.getLong("accountid");
            boolean isVersionAccount = vchEntryAccount != vchEntryAcctIdRefAcccu;
            List vchEntryAsstactitems = null;
            if (isVersionAccount) {
                DynamicObject vchEntryAccountObj = BusinessDataServiceHelper.loadSingleFromCache((Object)vchEntryAccount, (String)"bd_accountview", (String)"id,checkitementry.id,checkitementry.asstactitem");
                DynamicObjectCollection checkitementry = vchEntryAccountObj.getDynamicObjectCollection("checkitementry");
                vchEntryAsstactitems = checkitementry.stream().map(c -> c.getString("asstactitem.flexfield")).collect(Collectors.toList());
            }
            String entryRefAcccuFlexValue = vchEntryRefAcccu.getString("assgrpvalue");
            FlexValueJson entryRefAcccuFlexValueJson = new FlexValueJson(entryRefAcccuFlexValue);
            Map<String, Object> entryRefAcccuFlexValueMap = entryRefAcccuFlexValueJson.getValueMap();
            for (Map.Entry<String, Object> entry : entryRefAcccuFlexValueMap.entrySet()) {
                String vchEntryFlex = entry.getKey();
                if (vchEntryAsstactitems != null && !vchEntryAsstactitems.contains(vchEntryFlex)) continue;
                flexValueMap.computeIfAbsent(vchEntryFlex, k -> entry.getValue());
            }
        }
        return ReciprocalUtils.buildFlexEntireData(flexValueMap);
    }

    public static Collection<FlexUtils.AssistFilterEntry> buildAssistFilterInfo(FilterInfo reportFilter, Object obj) {
        HashMap<String, Set> propValues = new HashMap<String, Set>(8);
        List<String> props = reportFilter.getFlexFilterItems().stream().map(FilterItemInfo::getPropName).collect(Collectors.toList());
        if (SubsiDiaryHelper.isExport(reportFilter)) {
            for (FilterItemInfo itemInfo : reportFilter.getFlexFilterItems()) {
                String assType = itemInfo.getPropName();
                HashSet valSet = (HashSet)itemInfo.getValue();
                if (valSet.isEmpty()) {
                    propValues.computeIfAbsent(assType, v -> new HashSet());
                    continue;
                }
                propValues.computeIfAbsent(assType, v -> new HashSet(1)).addAll(valSet);
            }
        } else {
            for (FilterItemInfo itemInfo : reportFilter.getFlexFilterItems()) {
                String assType = itemInfo.getPropName();
                if (!((DynamicObject)obj).containsProperty(assType)) continue;
                DynamicObject valueDyn = ((DynamicObject)obj).getDynamicObject(assType);
                propValues.computeIfAbsent(assType, v -> new HashSet(1)).add(valueDyn.get(ID));
            }
        }
        if (props.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Map<String, FlexProperty> propInfos = FlexUtils.batchGetFlexProperty(props.toArray(new String[0]));
        return props.stream().map(k -> new FlexUtils.AssistFilterEntry((String)k, propValues.get(k) == null ? new HashSet(0) : (Set)propValues.get(k), (FlexProperty)propInfos.get(k))).collect(Collectors.toList());
    }

    public static Collection<FlexUtils.AssistFilterEntry> buildAssistFilterInfo(Map<String, Set<Object>> propValues) {
        Set<String> props = propValues.keySet();
        if (props.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Map<String, FlexProperty> propInfos = FlexUtils.batchGetFlexProperty(props.toArray(new String[0]));
        ArrayList<FlexUtils.AssistFilterEntry> result = new ArrayList<FlexUtils.AssistFilterEntry>(2);
        for (Map.Entry<String, Set<Object>> entry : propValues.entrySet()) {
            FlexProperty flexProperty = propInfos.get(entry.getKey());
            HashSet<Object> vals = new HashSet<Object>(8);
            vals.addAll((Collection)entry.getValue());
            FlexUtils.AssistFilterEntry assistFilterEntry = new FlexUtils.AssistFilterEntry(entry.getKey(), vals, flexProperty);
            result.add(assistFilterEntry);
        }
        return result;
    }

    public static Set<Long> getAllLeafAccount(Set<Long> accountId) {
        HashSet<Long> masterIds = new HashSet<Long>();
        HashSet<Long> pmIds = new HashSet<Long>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)(ReciprocalUtils.class.getName() + ".account"), (String)"bd_accountview", (String)"id, masterid,isleaf", (QFilter[])new QFilter[]{new QFilter("parent.masterid", "in", accountId)}, null);){
            for (Row row : dSet) {
                Long masterId = row.getLong(MASTERID);
                Boolean isLeaf = row.getBoolean("isleaf");
                if (isLeaf.booleanValue()) {
                    masterIds.add(masterId);
                    continue;
                }
                pmIds.add(masterId);
            }
        }
        if (!pmIds.isEmpty()) {
            masterIds.addAll(ReciprocalUtils.getAllLeafAccount(pmIds));
        }
        return masterIds;
    }

    public static Set<Long> getAllLeafAccount(Long accountId, long acctTableId) {
        HashSet<Long> masterIds = new HashSet<Long>();
        QFilter facctId = new QFilter(ID, "=", (Object)accountId);
        QFilter facctTable = new QFilter(ACCOUNTTABLE, "=", (Object)acctTableId);
        DynamicObject dynAcct = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"longnumber", (QFilter[])new QFilter[]{facctId, facctTable});
        if (Objects.isNull(dynAcct)) {
            return masterIds;
        }
        QFilter filter = new QFilter("longnumber", "ftlike", (Object)(dynAcct.getString("longnumber") + "_"));
        filter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        filter.and(facctTable);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ReciprocalUtils.class.getName() + "#getAllLeafAccount"), (String)"bd_accountview", (String)MASTERID, (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                masterIds.add(row.getLong(MASTERID));
            }
        }
        return masterIds;
    }

    public static Set<Long> getAllLeafAccount(Long orgId, Long acctMasterId, long acctTableId, Date date) {
        QFilter acctFilter = new QFilter(MASTERID, "=", (Object)acctMasterId);
        if (Objects.isNull(date)) {
            acctFilter.and(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
        } else {
            acctFilter.and(new QFilter("startdate", "<=", (Object)date));
            acctFilter.and(new QFilter("enddate", ">", (Object)date));
        }
        QFilter filter = null;
        try (DataSet dataSet = AccountUtils.queryAccountDataSet((long)orgId, (long)acctTableId, (String)"longnumber", Collections.singletonList(acctFilter));){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                filter = new QFilter("longnumber", "ftlike", (Object)(next.getString("longnumber") + "_"));
            }
        }
        HashSet<Long> masterIds = new HashSet<Long>();
        if (Objects.isNull(filter)) {
            return masterIds;
        }
        filter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        try (DataSet dataSet = AccountUtils.queryAccountDataSet((long)orgId, (long)acctTableId, (String)"masterid,longnumber", Collections.singletonList(filter));){
            for (Row row : dataSet) {
                masterIds.add(row.getLong(MASTERID));
            }
        }
        return masterIds;
    }

    public static boolean existsWriteOffRecord(IDataModel model, int row) {
        DynamicObject entryRow = model.getEntryRowEntity("entries", row);
        long entryId = 0L;
        DynamicObject account = entryRow.getDynamicObject(ACCOUNT);
        if (account != null && account.getBoolean("accheck")) {
            entryId = entryRow.getLong(ID);
        }
        if (entryId != 0L) {
            QFilter entryIdFilter = new QFilter(VOUCHERENTRY, "=", (Object)entryId);
            QFilter statusFilter = new QFilter(STATUS, "!=", (Object)STATUS_NOT_WRITEOFF);
            return QueryServiceHelper.exists((String)"gl_acccurrent", (QFilter[])new QFilter[]{entryIdFilter, statusFilter});
        }
        return false;
    }

    public static String getAccountBookKey(Object orgId, Object bookTypeId) {
        return "CurrentAcctEndInit-" + orgId + "-" + bookTypeId;
    }

    public static int getAmountSignType(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            return 1;
        }
        if (amount.compareTo(BigDecimal.ZERO) < 0) {
            return -1;
        }
        return 0;
    }

    private static Map<Long, String> queryVchBillNoMap(Map<Long, ReciprocalRecord> recordMap) {
        HashMap<Long, String> billnoMap = new HashMap<Long, String>(16);
        HashSet vchIdSet = new HashSet(8);
        recordMap.values().forEach(p -> vchIdSet.add(p.getVoucherId()));
        ArrayList vchIds = new ArrayList(vchIdSet);
        List vchIdlists = Lists.partition(vchIds, (int)999);
        for (List vchIdlist : vchIdlists) {
            QFilter vchFilter = new QFilter(ID, "in", (Object)vchIdlist);
            DataSet voucherDt = VoucherQueryUtils.queryDataSet((String)"id,billno", (QFilter[])new QFilter[]{vchFilter}, null, (int)-1);
            Throwable throwable = null;
            try {
                voucherDt.forEach(vch -> billnoMap.put(vch.getLong(ID), vch.getString("billno")));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (voucherDt == null) continue;
                if (throwable != null) {
                    try {
                        voucherDt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                voucherDt.close();
            }
        }
        return billnoMap;
    }

    private static Map<Long, String> queryVchBillNoMap(ReciprocalRecord srcRecord, Map<Long, ReciprocalRecord> tgtRecords) {
        HashMap<Long, String> billnoMap = new HashMap<Long, String>(16);
        HashSet<Long> vchIdSet = new HashSet<Long>(8);
        vchIdSet.add(srcRecord.getVoucherId());
        tgtRecords.values().forEach(r -> vchIdSet.add(r.getVoucherId()));
        ArrayList vchIds = new ArrayList(vchIdSet);
        List vchIdlists = Lists.partition(vchIds, (int)999);
        for (List vchIdlist : vchIdlists) {
            QFilter vchFilter = new QFilter(ID, "in", (Object)vchIdlist);
            DataSet voucherDt = VoucherQueryUtils.queryDataSet((String)"id,billno", (QFilter[])new QFilter[]{vchFilter}, null, (int)-1);
            Throwable throwable = null;
            try {
                voucherDt.forEach(vch -> billnoMap.put(vch.getLong(ID), vch.getString("billno")));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (voucherDt == null) continue;
                if (throwable != null) {
                    try {
                        voucherDt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                voucherDt.close();
            }
        }
        return billnoMap;
    }

    private static AppLogInfo getAppLogInfo(Map<Long, String> billnoMap, ReciprocalLog log, ReciprocalRecord srcRecord, ReciprocalRecord tgtRecord) {
        String initOpDesc = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8bb0\u5f55", (String)"ReciprocalUtils_15", (String)"fi-gl-common", (Object[])new Object[0]);
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53cd\u6838\u9500", "ReciprocalUtils_13", "fi-gl-common");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6302\u8d26\u51ed\u8bc1\u53f7\uff1a%1$s\uff0c\u5bf9\u5e94\u6838\u9500\u51ed\u8bc1\u53f7\uff1a%2$s\uff0c\u53cd\u6838\u9500\u91d1\u989d%3$s\u3002", "ReciprocalUtils_14", "fi-gl-common");
        OpLogAppInfo info = new OpLogAppInfo();
        info.setBizAppID(appId);
        info.setBizObjID(RECIPROCAL_LOG);
        info.setOpTime(TimeServiceHelper.now());
        info.setKeyWord("antiWriteOff");
        info.setOpName("antiWriteOff", opNameBridge);
        info.setOpDesc(opDescBridge, new String[]{billnoMap.get(srcRecord.getVoucherId()) == null ? initOpDesc : billnoMap.get(srcRecord.getVoucherId()), billnoMap.get(tgtRecord.getVoucherId()) == null ? initOpDesc : billnoMap.get(tgtRecord.getVoucherId()), log.getAmountFor().toString()});
        return info;
    }

    public static Map<Long, DynamicObject> getAcccurrentMap(ListSelectedRowCollection rows) {
        HashSet acccuIds = new HashSet(6);
        rows.forEach(row -> acccuIds.add(row.getPrimaryKeyValue()));
        QFilter acccuIdsFilter = new QFilter(ID, "in", acccuIds);
        DynamicObjectCollection acccuDyns = QueryServiceHelper.query((String)"gl_acccurrent", (String)"id, currency, currency.amtprecision amtprecision, assgrp.value assgrpvalue, amountbalfor, amountbal, biznum, voucherentry, voucherid, entrydc, amount", (QFilter[])new QFilter[]{acccuIdsFilter});
        return acccuDyns.stream().collect(Collectors.toMap(x -> x.getLong(ID), x -> x, (oldVal, newVal) -> newVal));
    }

    public static Map<Long, DynamicObject> getVchEntryMap(Map<Long, DynamicObject> acccurrentMap) {
        HashSet voucherIds = new HashSet(6);
        HashSet vchentryIds = new HashSet(6);
        acccurrentMap.entrySet().forEach(x -> {
            voucherIds.add(((DynamicObject)x.getValue()).getLong(VOUCHERID));
            vchentryIds.add(((DynamicObject)x.getValue()).getLong(VOUCHERENTRY));
        });
        ArrayList<QFilter> voucherFilters = new ArrayList<QFilter>(2);
        voucherFilters.add(new QFilter("entries.id", "in", vchentryIds));
        voucherFilters.add(new QFilter(ID, "in", voucherIds));
        DynamicObjectCollection vchEntryDyns = QueryServiceHelper.query((String)"gl_voucher", (String)"entries.id id,entries.account.id accountid, entries.assgrp.value assgrpvalue", (QFilter[])voucherFilters.toArray(new QFilter[0]));
        return vchEntryDyns.stream().collect(Collectors.toMap(x -> x.getLong(ID), x -> x, (oldVal, newVal) -> newVal));
    }

    public static void updateAcccurrentAmount(IDataModel m, int curIndex, DynamicObject acccurrent, RateType rateType, Map<Long, ExchangeRate> exchangeRateMap) {
        int accountDC = ((DynamicObject)m.getValue(ACCOUNT, curIndex)).getInt("dc");
        String entryDCStr = acccurrent.getString(ENTYRDC).trim();
        if (kd.bos.util.StringUtils.isEmpty((String)entryDCStr)) {
            BigDecimal amount = acccurrent.getBigDecimal(AMOUNT);
            entryDCStr = BigDecimal.ZERO.compareTo(amount) > 0 ? String.valueOf(accountDC * -1) : String.valueOf(accountDC);
        }
        int entryDC = Integer.parseInt(entryDCStr);
        BigDecimal amountBal = acccurrent.getBigDecimal(AMOUNTBAL);
        BigDecimal amountbalfor = acccurrent.getBigDecimal(AMOUNTBALFOR);
        BigDecimal debitBal = BigDecimal.ZERO;
        BigDecimal creditBal = BigDecimal.ZERO;
        BigDecimal debitori = BigDecimal.ZERO;
        BigDecimal creditori = BigDecimal.ZERO;
        BigDecimal accountDcBigDecimal = new BigDecimal(accountDC);
        BigDecimal entryDcBigDecimal = new BigDecimal(entryDC);
        BigDecimal creditOrDebitAmountBal = amountBal.multiply(accountDcBigDecimal).multiply(entryDcBigDecimal);
        BigDecimal creditOrDebitAmountFor = amountbalfor.multiply(accountDcBigDecimal).multiply(entryDcBigDecimal);
        if (entryDC == 1) {
            creditBal = creditOrDebitAmountBal;
            creditori = creditOrDebitAmountFor;
        } else {
            debitBal = creditOrDebitAmountBal;
            debitori = creditOrDebitAmountFor;
        }
        m.setValue("debitlocal", (Object)debitBal, curIndex);
        m.setValue("creditlocal", (Object)creditBal, curIndex);
        m.setValue("debitori", (Object)debitori, curIndex);
        m.setValue("creditori", (Object)creditori, curIndex);
        m.setValue("oriamount", (Object)amountbalfor.abs(), curIndex);
        if (amountBal.compareTo(BigDecimal.ZERO) != 0 && amountbalfor.compareTo(BigDecimal.ZERO) != 0) {
            long currencyId = acccurrent.getLong(CURRENCY);
            ExchangeRate exchangeRate = exchangeRateMap.get(currencyId);
            int precision = exchangeRate == null ? 8 : exchangeRate.getPrecision();
            IRateCalculator rateCalculator = rateType.getRateCalculator();
            BigDecimal localRate = rateCalculator.calRate(amountbalfor, amountBal, precision);
            m.setValue("localrate", (Object)localRate.stripTrailingZeros(), curIndex);
        } else {
            m.setValue("localrate", (Object)"", curIndex);
        }
    }

    public static List<Long> getAssgrpIds(ListSelectedRowCollection rows, IDataModel m, Map<Long, DynamicObject> acccurrentMap, Map<Long, DynamicObject> voucherEntryMap) {
        int curIndex = m.getEntryCurrentRowIndex("entries");
        Long vchEntryAccount = ((DynamicObject)m.getValue(ACCOUNT, curIndex)).getLong(ID);
        ArrayList<FlexEntireData> flexEntireDatas = new ArrayList<FlexEntireData>(8);
        for (int i = 0; i < rows.size(); ++i) {
            ListSelectedRow seldata = rows.get(i);
            Object id = seldata.getPrimaryKeyValue();
            DynamicObject acccurrent = acccurrentMap.get(id);
            Long vchentryId = acccurrent.getLong(VOUCHERENTRY);
            DynamicObject vchEntryRefAcccu = null;
            if (vchentryId != 0L && (vchEntryRefAcccu = voucherEntryMap.get(vchentryId)) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5f80\u6765\u8d26\u7b2c%s\u884c\uff0c\u5bf9\u5e94\u7684\u51ed\u8bc1\u4e0d\u5b58\u5728\u3002", (String)"VoucherEdit_77", (String)"fi-gl-formplugin", (Object[])new Object[]{i + 1}));
            }
            DynamicObject vchEntryAssgrp = (DynamicObject)m.getValue(ASSGRP, curIndex);
            FlexEntireData flexEntireData = ReciprocalUtils.getflexValueMap(acccurrent, vchEntryAssgrp, vchEntryAccount, vchEntryRefAcccu);
            flexEntireDatas.add(flexEntireData);
        }
        return FlexUtils.batchSaveFlexData(flexEntireDatas);
    }

    public static DataSet getFilterVoucherDt(ReciprocalScheme scheme) {
        DataSet filterVoucherDt = null;
        QFilter vchFromPageQFilter = scheme.getVchQFilterFromPage();
        if (CollectionUtils.isEmpty(scheme.getReciprocalIdList()) && vchFromPageQFilter != null) {
            ArrayList<QFilter> vchFilters = new ArrayList<QFilter>(8);
            vchFilters.add(new QFilter(ORG, "=", (Object)scheme.getOrg()));
            vchFilters.add(new QFilter(BOOKTYPE, "=", (Object)scheme.getBookType()));
            vchFilters.add(new QFilter(PERIOD, ">=", (Object)scheme.getStartPeriod()));
            vchFilters.add(new QFilter(PERIOD, "<=", (Object)scheme.getEndPeriod()));
            List<Long> accountListFromPage = scheme.getAccountListFromPage();
            if (CollectionUtils.isEmpty(accountListFromPage)) {
                vchFilters.add(new QFilter("entries.account.masterid", "in", accountListFromPage));
            }
            vchFilters.add(vchFromPageQFilter);
            filterVoucherDt = VoucherQueryUtils.queryDataSet((String)"id fvoucherid, entries.id vchentryid", (QFilter[])vchFilters.toArray(new QFilter[0]), null, (int)-1);
        }
        return filterVoucherDt;
    }

    public static Map<Pair<Long, Long>, Long> getAssgrpMap() {
        HashMap assgrpMap = (HashMap)ThreadCache.get((Object)ThreadCacheKey.buildAcctAssgrpToAccAssgrpKey());
        if (Objects.isNull(assgrpMap)) {
            assgrpMap = new HashMap(1);
        }
        return assgrpMap;
    }

    public static void setAssgrpMap(Map<Pair<Long, Long>, Long> assgrpMap) {
        ThreadCache.put((Object)ThreadCacheKey.buildAcctAssgrpToAccAssgrpKey(), assgrpMap);
    }
}

