/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import java.util.ArrayList;
import java.util.List;
import kd.fi.gl.reciprocal.AbstractReciprocalLogicUnit;
import kd.fi.gl.reciprocal.AmtEqlWriteOffLogicUnit;
import kd.fi.gl.reciprocal.AmtNoEqlWriteOffLogicUnit;
import kd.fi.gl.reciprocal.NegativeVoucherWriteOffLogicUnit;
import kd.fi.gl.reciprocal.RcpTask;
import kd.fi.gl.reciprocal.ReciprocalContext;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.VchAgainstWriteOffLogicUnit;

public class SingleReciprocalEngine
implements Runnable {
    protected ReciprocalContext context;

    public SingleReciprocalEngine(ReciprocalScheme scheme, RcpTask task) {
        this.context = new ReciprocalContext(scheme, false);
        this.context.setCurTask(task);
    }

    public SingleReciprocalEngine(ReciprocalScheme scheme, RcpTask task, boolean bIsSimulate) {
        this.context = new ReciprocalContext(scheme, bIsSimulate);
        this.context.setCurTask(task);
    }

    @Override
    public void run() {
        List<AbstractReciprocalLogicUnit> lstLogicUnits = this.createLogicUnits();
        for (AbstractReciprocalLogicUnit logicUnit : lstLogicUnits) {
            logicUnit.doAction(this.context);
        }
    }

    private List<AbstractReciprocalLogicUnit> createLogicUnits() {
        ReciprocalScheme scheme = this.context.getScheme();
        ArrayList<AbstractReciprocalLogicUnit> lstLogicUnits = new ArrayList<AbstractReciprocalLogicUnit>();
        lstLogicUnits.add(new VchAgainstWriteOffLogicUnit());
        lstLogicUnits.add(new NegativeVoucherWriteOffLogicUnit());
        lstLogicUnits.add(new AmtEqlWriteOffLogicUnit());
        if (!scheme.isEquaCanVerfi()) {
            lstLogicUnits.add(new AmtNoEqlWriteOffLogicUnit());
        }
        return lstLogicUnits;
    }
}

