/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.reciprocal.datarepair.service.AbstractDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;

public class NoVchEntryCheckAndRepairUnit
extends AbstractDataCheckAndRepairService {
    @Override
    public String repairSelected(String checkType, List<Long> selectedIds) {
        if (CollectionUtils.isEmpty(selectedIds)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u884c", (String)"ReciprocalDataCheckAndRepairPlugin_7", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        return this.noVchEntryRecordRepair(checkType, selectedIds);
    }

    @Override
    public String repairByCondition(ReportQueryParam queryParam) {
        ArrayList<Long> acccurrentIds = new ArrayList<Long>(32);
        DataSet accDataSet = this.queryCheckDataSet(queryParam);
        for (Row row : accDataSet) {
            acccurrentIds.add(row.getLong("id"));
        }
        if (acccurrentIds.isEmpty()) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u4e0b\u65e0\u9700\u4fee\u590d\u6570\u636e\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_2", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        String checkType = (String)queryParam.getFilter().getValue("checktype");
        return this.noVchEntryRecordRepair(checkType, acccurrentIds);
    }

    @Override
    public DataSet queryCheckDataSet(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Long orgId = filterInfo.getLong("org");
        Long bookTypeId = filterInfo.getLong("booktype");
        if (orgId != null && orgId != 0L && (bookTypeId == null || bookTypeId == 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        return ReciprocalDataRepairUtil.queryNoVchEntryRecordByOrgId(orgId, bookTypeId);
    }

    @Override
    public List<AbstractReportColumn> getColums(List<AbstractReportColumn> columns) {
        return ReciprocalDataRepairUtil.getAccurrentColums(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String noVchEntryRecordRepair(String checkType, List<Long> recordIds) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(16);
        lstFilters.add(new QFilter("id", "in", recordIds));
        DataSet reciprocalDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"id as acctid,voucherentry,voucherid,period,status", (QFilter[])lstFilters.toArray(new QFilter[0]), null);
        ArrayList<Long> vchEntryIds = new ArrayList<Long>(16);
        ArrayList<Long> voucherIdList = new ArrayList<Long>(16);
        for (Row record : reciprocalDataSet.copy()) {
            Long voucherId;
            Long voucherentry = record.getLong("voucherentry");
            if (voucherentry != null) {
                vchEntryIds.add(voucherentry);
            }
            if ((voucherId = record.getLong("voucherid")) == null) continue;
            voucherIdList.add(voucherId);
        }
        String idString = StringUtils.join((Object[])recordIds.toArray(), (String)",");
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(" acct.fid acctid,acct.fstatus status").append(" from t_gl_acccurrent acct left join t_gl_voucherentry ve on  acct.FVCHENTRYID = ve.FENTRYID where 1 = 1 ");
        sb.append(" and acct.FVCHENTRYID != 0  and acct.FPERIODID != 0 and acct.FVOUCHERID != 0  and ve.FENTRYID is null ");
        sb.append(" and acct.fid in( ");
        sb.append(idString);
        sb.append(" )");
        DataSet resultDt = DB.queryDataSet((String)"NoVchEntryCheckAndRepairUnit_noVchEntryRecordRepair", (DBRoute)DBRoute.of((String)"gl"), (String)sb.toString());
        ArrayList<Long> resultReciIds = new ArrayList<Long>(16);
        ArrayList<Long> writeOffedIds = new ArrayList<Long>(16);
        for (Row row : resultDt) {
            Long acctid = row.getLong("acctid");
            resultReciIds.add(acctid);
            if ("0".equals(row.getString("status"))) continue;
            writeOffedIds.add(acctid);
        }
        if (!resultReciIds.containsAll(recordIds)) {
            return ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_3", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        Date now = new Date();
        String tableName = "";
        String logMessage = "";
        String status = "1";
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                ReciprocalDataRepairUtil.doUnWriteOffByAcctIds(writeOffedIds);
                QFilter delFilter = new QFilter("id", "in", resultReciIds);
                DeleteServiceHelper.delete((String)"gl_acccurrent", (QFilter[])new QFilter[]{delFilter});
            }
            catch (Exception e) {
                txHandle.markRollback();
                logMessage = e.getMessage();
                status = "0";
                throw e;
            }
        }
        finally {
            ReciprocalDataRepairUtil.reciDataRepairLog(checkType, now, tableName, logMessage, status);
        }
        return "";
    }
}

