/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.reciprocal.datarepair.service.AbstractDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;
import kd.fi.gl.util.GLUtil;

public class ReciAccountTableVersionUnit
extends AbstractDataCheckAndRepairService {
    private static final String UPDATE_ACCCURRENT_SQL = "update t_gl_acccurrent set fentrydc =?, fcreatorid =?, fwriteoffpersonid =?, fbookeddate =? WHERE fmasterid =? and fid !=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String repairSelected(String checkType, List<Long> recordIds) {
        if (CollectionUtils.isEmpty(recordIds)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u884c", (String)"ReciprocalDataCheckAndRepairPlugin_7", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        ArrayList<QFilter> versionFilters = new ArrayList<QFilter>(1);
        versionFilters.add(new QFilter("id", "in", recordIds));
        HashSet masterIds = new HashSet(recordIds.size());
        try (DataSet versionDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"masterid", (QFilter[])versionFilters.toArray(new QFilter[0]), null);){
            versionDataSet.forEach(v -> masterIds.add(v.getLong("masterid")));
        }
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(2);
        lstFilters.add(new QFilter("masterid", "in", masterIds));
        lstFilters.add(new QFilter("effectivedate", "=", (Object)GLUtil.getInitBeginDate()));
        DataSet reciprocalDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"masterid, entrydc, creator, writeoffperson, bookeddate", (QFilter[])lstFilters.toArray(new QFilter[0]), null);
        Date now = new Date();
        String tableName = "";
        String logMessage = "";
        String status = "1";
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>(recordIds.size());
                for (Row row : reciprocalDataSet) {
                    updateParams.add(new Object[]{row.get("entrydc"), row.get("creator"), row.get("writeoffperson"), row.get("bookeddate"), row.get("masterid"), row.get("masterid")});
                    if (updateParams.size() <= 999) continue;
                    DB.executeBatch((DBRoute)new DBRoute("fi"), (String)UPDATE_ACCCURRENT_SQL, updateParams);
                    updateParams.clear();
                }
                if (!updateParams.isEmpty()) {
                    DB.executeBatch((DBRoute)new DBRoute("fi"), (String)UPDATE_ACCCURRENT_SQL, updateParams);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                logMessage = e.getMessage();
                status = "0";
                throw e;
            }
        }
        finally {
            ReciprocalDataRepairUtil.reciDataRepairLog(checkType, now, tableName, logMessage, status);
        }
        return "";
    }

    @Override
    public String repairByCondition(ReportQueryParam param) {
        DataSet dataSet = this.queryCheckDataSet(param);
        ArrayList<Long> recordIds = new ArrayList<Long>(8);
        for (Row row : dataSet) {
            recordIds.add(row.getLong("id"));
        }
        String checkType = (String)param.getFilter().getValue("checktype");
        return this.repairSelected(checkType, recordIds);
    }

    @Override
    public DataSet queryCheckDataSet(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        Long orgId = filterInfo.getLong("org");
        Long bookTypeId = filterInfo.getLong("booktype");
        if (orgId != null && orgId != 0L && (bookTypeId == null || bookTypeId == 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        SqlBuilder querySql = new SqlBuilder();
        querySql.append(" select  acct.fid id, acct.forgid org, acct.fbooktypeid booktype, acct.fperiodid period, acct.facctableid accounttable, acct.faccountid account, acct.fassgrpid assgrp, acct.fcurrencyid currency,acct.famountfor amountfor, acct.famountbalfor amountbalfor, acct.flocalcurrencyid localcurrency, acct.famount amount, acct.famountbal amountbal, acct.fbizdate bizdate, acct.fexpiredate expiredate, acct.fbiznum biznum, acct.fdescription description, acct.fstatus status, acct.fvchentryid voucherentry, acct.fsourcetype sourcetype, acct.fvoucherid voucherid from t_gl_acccurrent acct where acct.fbookeddate is null", new Object[0]);
        querySql.append(" and feffectivedate != ? ", new Object[]{GLUtil.getInitBeginDate()});
        if (orgId != null && orgId != 0L) {
            querySql.append(" and acct.forgid = ?", new Object[]{orgId});
            querySql.append(" and acct.fbooktypeid = ?", new Object[]{bookTypeId});
        }
        DataSet queryDataSet = DB.queryDataSet((String)"ReciAccountTableVersionUnit_queryCheckDataSet", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)querySql);
        return queryDataSet;
    }

    @Override
    public List<AbstractReportColumn> getColums(List<AbstractReportColumn> columns) {
        return ReciprocalDataRepairUtil.getAccurrentColums(columns);
    }
}

