/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.enums.ReciprocalDataRepairEnum;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.datarepair.service.IDataCheckAndRepairService;

public class ReciprocalDataRepairUtil {
    public static final String DBACCURRENTFIELD = " acct.fid id, acct.forgid org, acct.fbooktypeid booktype, acct.fperiodid period, acct.facctableid accounttable, acct.faccountid account, acct.fassgrpid assgrp, acct.fcurrencyid currency,acct.famountfor amountfor, acct.famountbalfor amountbalfor, acct.flocalcurrencyid localcurrency, acct.famount amount, acct.famountbal amountbal, acct.fbizdate bizdate, acct.fexpiredate expiredate, acct.fbiznum biznum, acct.fdescription description, acct.fstatus status, acct.fvchentryid voucherentry, acct.fsourcetype sourcetype, acct.fvoucherid voucherid";
    public static final String ACCURRENTFIELD = " id, org, booktype, period, accounttable, account, assgrp, currency, amountfor, amountbalfor, localcurrency, amount, amountbal, bizdate, expiredate, biznum, description, status, voucherid, sourcetype,voucherentry ";
    private static final String COLKEY_CUR = "fcurrencyid";

    public static IDataCheckAndRepairService getDataCheckAndRepairService(String checkType) {
        if (StringUtils.isEmpty((CharSequence)checkType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u68c0\u67e5\u7c7b\u578b", (String)"ReciprocalDataRepairUtil_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        ReciprocalDataRepairEnum repairEnum = ReciprocalDataRepairEnum.getDataRepairEnumByCode(checkType);
        if (repairEnum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u68c0\u67e5\u7c7b\u578b", (String)"ReciprocalDataRepairUtil_5", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        IDataCheckAndRepairService checkAndRepairService = repairEnum.getRepairObj();
        if (checkAndRepairService == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5904\u7406\u5355\u5143\u4e0d\u5b58\u5728", (String)"ReciprocalDataRepairUtil_6", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        return checkAndRepairService;
    }

    public static List<Long> getAllOrgPkList() {
        LinkedHashSet<Long> orgSet = new LinkedHashSet<Long>();
        Map<Long, Set<Long>> viewOrgMap = ReciprocalDataRepairUtil.getMainViewOrgMap();
        for (Set<Long> orgs : viewOrgMap.values()) {
            orgSet.addAll(orgs);
        }
        return new ArrayList<Long>(orgSet);
    }

    private static Map<Long, Set<Long>> getMainViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = ReciprocalDataRepairUtil.getViewOrgBTMapHelper(true);
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    private static Map<Long, Map<Long, List<Long>>> getViewOrgBTMapHelper(boolean isMainView) {
        HashMap<Long, Map<Long, List<Long>>> result = new HashMap<Long, Map<Long, List<Long>>>(32);
        QFilter[] bookQF = new QFilter[]{new QFilter("isbizunit", "=", (Object)"1")};
        QFilter[] viewQF = new QFilter[]{new QFilter("ismainview", "=", (Object)isMainView)};
        try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getBook"), (String)"gl_accountbook", (String)"bookstype,org,accountingsys", (QFilter[])bookQF, null);
             DataSet viewDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getView"), (String)"bd_accountingsysviewsch", (String)"id,accountingsys", (QFilter[])viewQF, null);
             DataSet finish = bookDataSet.join(viewDataSet, JoinType.INNER).on("accountingsys", "accountingsys").select(new String[]{"bookstype", "org"}, new String[]{"id"}).finish();){
            for (Row row : finish) {
                Map orgBookTypeMap;
                long mainView = row.getLong("id");
                long org = row.getLong("org");
                long bookType = row.getLong("bookstype");
                if (result.containsKey(mainView)) {
                    List<Long> bookTypeList;
                    orgBookTypeMap = (Map)result.get(mainView);
                    if (orgBookTypeMap.containsKey(org)) {
                        bookTypeList = (List)orgBookTypeMap.get(org);
                        bookTypeList.add(bookType);
                        orgBookTypeMap.put(org, bookTypeList);
                        result.put(mainView, orgBookTypeMap);
                        continue;
                    }
                    bookTypeList = new ArrayList<Long>();
                    bookTypeList.add(bookType);
                    orgBookTypeMap.put(org, bookTypeList);
                    result.put(mainView, orgBookTypeMap);
                    continue;
                }
                orgBookTypeMap = new HashMap();
                ArrayList<Long> bookTypes = new ArrayList<Long>();
                bookTypes.add(bookType);
                orgBookTypeMap.put(org, bookTypes);
                result.put(mainView, orgBookTypeMap);
            }
        }
        return result;
    }

    public static DataSet queryNoVchEntryRecordByOrgId(Long orgId, Long bookTypeId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(DBACCURRENTFIELD).append(" from t_gl_acccurrent acct left join t_gl_voucherentry ve on acct.fvoucherid = ve.fid and acct.fvchentryid = ve.fentryid where 1 = 1");
        if (orgId != null && orgId != 0L) {
            sb.append(" and acct.forgid = ").append(orgId);
        }
        if (bookTypeId != null && bookTypeId != 0L) {
            sb.append(" and acct.fbooktypeid = ").append(bookTypeId);
        }
        sb.append(" and  acct.fvchentryid != 0 and acct.fperiodid != 0 and acct.fvoucherid != 0 and fentryid is null");
        return DB.queryDataSet((String)"ReciprocalDataRepairUtil_queryNoVchEntryRecordByOrgId", (DBRoute)DBRoute.of((String)"gl"), (String)sb.toString());
    }

    public static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add(field.getName());
        }
        return list;
    }

    public static boolean checkListDiffrent(List<String> firstList, List<String> secondList) {
        firstList.sort(Comparator.comparing(String::hashCode));
        secondList.sort(Comparator.comparing(String::hashCode));
        return firstList.toString().equals(secondList.toString());
    }

    public static ReportColumn createColumn(LocaleString caption, String fieldKey, String fieldType, Boolean hyperLink) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        if ("amount".equals(fieldType)) {
            column.setCurrencyField(COLKEY_CUR);
        }
        column.setHyperlink(hyperLink.booleanValue());
        return column;
    }

    public static void doUnWriteOffByAcctIds(List<Long> writeOffedIds) {
        QFilter[] logFilters = new QFilter[]{new QFilter("buyerentry", "in", writeOffedIds).or(new QFilter("writeoffentry", "in", writeOffedIds))};
        ArrayList<Long> reciLogIds = new ArrayList<Long>(16);
        try (DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"gl_ReciprocalDataCheckAndRepairPlugin_querylog", (String)"gl_reciprocal_log", (String)"id", (QFilter[])logFilters, null);){
            for (Row row : logDataSet) {
                reciLogIds.add(row.getLong("id"));
            }
        }
        if (!reciLogIds.isEmpty()) {
            ReciprocalUtils.doUnWriteOff(reciLogIds);
        }
    }

    public static void reciDataRepairLog(String checkType, Date now, String tableName, String logMessage, String status) {
        DynamicObject reciDataRepairLog = BusinessDataServiceHelper.newDynamicObject((String)"gl_reci_datarepair_log");
        reciDataRepairLog.set("checktype", (Object)checkType);
        reciDataRepairLog.set("backuptable", (Object)tableName);
        reciDataRepairLog.set("modeltype", (Object)"1");
        reciDataRepairLog.set("status", (Object)status);
        reciDataRepairLog.set("message", (Object)(logMessage.isEmpty() ? "success" : logMessage));
        reciDataRepairLog.set("operateuser", (Object)RequestContext.get().getCurrUserId());
        reciDataRepairLog.set("operatetime", (Object)now);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reciDataRepairLog});
    }

    public static List<AbstractReportColumn> getAccurrentColums(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> customColumns = new ArrayList<AbstractReportColumn>(8);
        LocaleString orgName = new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"NoAcccurrentUnit_0", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn orgColumn = ReciprocalDataRepairUtil.createColumn(orgName, "org", "basedata", Boolean.FALSE);
        orgColumn.setEntityId("bos_org");
        orgColumn.setDisplayProp("name");
        customColumns.add((AbstractReportColumn)orgColumn);
        LocaleString periodName = new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4", (String)"NoAcccurrentUnit_1", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn periodColumn = ReciprocalDataRepairUtil.createColumn(periodName, "period", "basedata", Boolean.FALSE);
        periodColumn.setEntityId("bd_period");
        customColumns.add((AbstractReportColumn)periodColumn);
        customColumns.addAll(columns);
        LocaleString currencyName = new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ReciprocalLogErrorUnit_2", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn currencyColumn = ReciprocalDataRepairUtil.createColumn(currencyName, "currency", "basedata", Boolean.FALSE);
        currencyColumn.setEntityId("bd_currency");
        currencyColumn.setDisplayProp("name");
        customColumns.add((AbstractReportColumn)currencyColumn);
        LocaleString amountforName = new LocaleString(ResManager.loadKDString((String)"\u6302\u8d26\u91d1\u989d", (String)"ReciprocalDataRepairUtil_0", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn amountforColumn = ReciprocalDataRepairUtil.createColumn(amountforName, "amountfor", "amount", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)amountforColumn);
        LocaleString amountbalforName = new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u91d1\u989d", (String)"ReciprocalDataRepairUtil_1", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn amountbalforColumn = ReciprocalDataRepairUtil.createColumn(amountbalforName, "amountbalfor", "amount", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)amountbalforColumn);
        LocaleString biznumName = new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u53f7", (String)"ReciprocalDataRepairUtil_2", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn biznumColumn = ReciprocalDataRepairUtil.createColumn(biznumName, "biznum", "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)biznumColumn);
        LocaleString descName = new LocaleString(ResManager.loadKDString((String)"\u6458\u8981", (String)"NoAcccurrentUnit_7", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn descColumn = ReciprocalDataRepairUtil.createColumn(descName, "description", "text", Boolean.FALSE);
        descColumn.setDisplayProp("number");
        customColumns.add((AbstractReportColumn)descColumn);
        LocaleString idName = new LocaleString(ResManager.loadKDString((String)"\u5f80\u6765\u8d26\u8bb0\u5f55id", (String)"ReciprocalDataRepairUtil_3", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn idColumn = ReciprocalDataRepairUtil.createColumn(idName, "id", "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)idColumn);
        return customColumns;
    }
}

