/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.simulate;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.business.service.reciprocal.baldeduct.result.AgingSumarryResult;
import kd.fi.gl.business.vo.reciprocal.AccountFlexVO;
import kd.fi.gl.business.vo.reciprocal.AgeRangeVO;
import kd.fi.gl.enums.writeoff.WriteOffField;
import kd.fi.gl.reciprocal.RcpTask;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.simulate.SimulateRecord;
import kd.fi.gl.reciprocal.simulate.SingleReciprocalSimulateEngine;
import kd.fi.gl.reciprocal.simulate.balance.vo.AssistVO;
import kd.fi.gl.util.GLUtil;

public class ReciprocalSimulateEngine {
    private static final String ACCOUNTTABLE = "accounttable";
    private static final String SELECT_FIELDS = "id, account, assgrp, currency, sourcetype, amount, status, masterid";
    private static final String SELECT_LOG_FIELDS = "buyerentry,writeoffentry,amountfor,amount";
    private static final int INIT_FILTER_CAPACITY = 8;
    private static final String MASTERID = "masterid";
    private static final String STATUS = "status";
    private static final String ID = "id";
    private static final String ASOPID = "id as opid";
    private static final String OPID = "opid";
    private static final String AMOUNT = "amount";
    private static final String AMOUNTFOR = "amountfor";
    private static final String BUYERENTRY = "buyerentry";
    private static final String WRITEOFFENTRY = "writeoffentry";
    private static final String WRITEOFFDATE = "writeoffdate";
    private static final String ORG = "org";
    private static final String BOOKTYPE = "booktype";
    private static final String PERIOD = "period";
    private static final String ACCOUNT = "account";
    private static final String CURRENCY = "currency";
    private static final String VOUCHERID = "voucherid";
    private static final String ASSGRP = "assgrp";
    private static final String SOURCETYPE = "sourcetype";
    private static final String BIZNUM = "biznum";
    private static final String BOOKEDDATE = "bookeddate";
    private static final int BATCH_COUNT = 1000;
    private List<ReciprocalScheme> schemes;
    private List<WriteOffField> groupFields = new ArrayList<WriteOffField>(0);
    private List<WriteOffField> sumFields = new ArrayList<WriteOffField>(0);
    private List<String> flexFiels = new ArrayList<String>(0);
    private static Log logger = LogFactory.getLog(ReciprocalSimulateEngine.class);

    public ReciprocalSimulateEngine(List<ReciprocalScheme> schemelist) {
        this.schemes = schemelist;
        this.flexFiels = new ArrayList<String>(schemelist.get(0).getAssistVOMap().keySet());
    }

    public ReciprocalSimulateEngine(List<ReciprocalScheme> schemelist, List<WriteOffField> groupFields, List<WriteOffField> sumFields, List<String> flexFiels) {
        this(schemelist);
        this.groupFields = groupFields;
        this.sumFields = sumFields;
        this.flexFiels = flexFiels;
    }

    public DataSet run() {
        Queue<Future<List<ReciprocalRecord>>> taskQueue = this.getFutures();
        ArrayList<WriteOffField> fields = new ArrayList<WriteOffField>(this.groupFields.size() + this.sumFields.size());
        fields.addAll(this.groupFields);
        fields.addAll(this.sumFields);
        int fieldLen = fields.size() + this.flexFiels.size();
        ArrayList<String> buildFields = new ArrayList<String>(fieldLen);
        ArrayList<DataType> buildDt = new ArrayList<DataType>(fieldLen);
        if (fields.size() == 0 || this.flexFiels.size() == 0) {
            fields.addAll(RcpWriteOffUtils.writeoffAllField());
            fieldLen = fields.size() + this.flexFiels.size();
        }
        for (WriteOffField field : fields) {
            buildFields.add(field.getFiled());
            buildDt.add(field.getType());
        }
        for (String flexFiel : this.flexFiels) {
            buildFields.add(flexFiel);
            buildDt.add((DataType)DataType.LongType);
        }
        DataSetBuilder dataSetBuilder = RcpWriteOffUtils.buildWriteOffDs(buildFields, buildDt);
        HashSet<Long> existSet = new HashSet<Long>(32);
        int count = 0;
        while (!taskQueue.isEmpty()) {
            try {
                List<ReciprocalRecord> records = taskQueue.poll().get();
                existSet.clear();
                if (records == null) continue;
                Map<String, AssistVO> assistVOMap = this.schemes.get(0).getAssistVOMap();
                for (ReciprocalRecord record : records) {
                    if ("2".equals(record.getStatus()) && BigDecimal.ZERO.compareTo(record.getAmountBal()) == 0 || existSet.contains(record.getId())) continue;
                    existSet.add(record.getId());
                    ++count;
                    Object[] params = new Object[fieldLen];
                    for (int i = 0; i < fields.size(); ++i) {
                        params[i] = WriteOffField.CURRENCYID == fields.get(i) ? (this.schemes.get(0).isSynCurrency() ? record.getLocalCurrency() : record.getCurrency()) : ((WriteOffField)((Object)fields.get(i))).getFunction().apply(record);
                    }
                    boolean isMatch = true;
                    for (int i = fields.size(); i < fieldLen; ++i) {
                        Object assVal;
                        String flexField = this.flexFiels.get(i - fields.size());
                        if (Objects.isNull(record.getAssgrpVals())) {
                            isMatch = false;
                            break;
                        }
                        Object object = assVal = record.getAssgrpVals().get(flexField) == null ? null : record.getAssgrpVals().get(flexField);
                        if (assistVOMap.size() <= 0) continue;
                        AssistVO assistVO = assistVOMap.get(flexField);
                        if (Objects.isNull(assistVO) || Objects.nonNull(assistVO.getAssValue()) && assistVO.getAssValue().size() > 0 && !assistVO.getAssValue().contains(assVal)) {
                            isMatch = false;
                            break;
                        }
                        params[i] = assVal;
                    }
                    if (!isMatch) continue;
                    dataSetBuilder.append(params);
                }
            }
            catch (Exception e) {
                logger.error("failed to do reciprocal simulate on :" + e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        logger.info("=====reciprocalAging_ReciprocalSimulateEngine_run_rstRecords_size:{}=====", (Object)count);
        DataSet build = dataSetBuilder.build();
        if (this.groupFields.size() > 0) {
            List<String> groupList = this.groupFields.stream().map(WriteOffField::getFiled).collect(Collectors.toList());
            groupList.addAll(this.flexFiels);
            GroupbyDataSet groupbyDataSet = build.groupBy(groupList.toArray(new String[groupList.size()]));
            for (WriteOffField field : this.sumFields) {
                groupbyDataSet.sum(field.getFiled());
            }
            return groupbyDataSet.finish();
        }
        return build;
    }

    public DataSet orderWriteOff() {
        Queue<Future<List<ReciprocalRecord>>> taskQueue = this.getFutures();
        HashSet<Long> existSet = new HashSet<Long>(32);
        ReciprocalScheme scheme = this.schemes.get(0);
        Map<String, AssistVO> assistVOMap = scheme.getAssistVOMap();
        ArrayList<AccountFlexVO> acctFlexVOs = new ArrayList<AccountFlexVO>(assistVOMap.size());
        assistVOMap.forEach((k, v) -> acctFlexVOs.add(new AccountFlexVO((String)k, v.getAssValue())));
        List<AgeRangeVO> ageRangeVOS = AgeRangeVO.convert(scheme.getOverDueRangeMap(), scheme.getUnDueRangeMap());
        AgingSumarryResult agingResult = new AgingSumarryResult(ageRangeVOS, acctFlexVOs, scheme.isShowByExpireDate(), scheme.getExpiredate(), scheme.isSynCurrency());
        while (!taskQueue.isEmpty()) {
            try {
                List<ReciprocalRecord> records = taskQueue.poll().get();
                DebugTrace.action(() -> logger.info("ReciprocalSimulateEngine#orderWriteOff:{}", (Object)records));
                existSet.clear();
                if (records == null) continue;
                for (ReciprocalRecord record : records) {
                    if ("2".equals(record.getStatus()) && BigDecimal.ZERO.compareTo(record.getAmountBal()) == 0 || existSet.contains(record.getId())) continue;
                    existSet.add(record.getId());
                    agingResult.add(record);
                }
            }
            catch (Exception e) {
                logger.error("failed to do reciprocal simulate on :" + e.getMessage(), (Throwable)e);
                throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        }
        return agingResult.getAgingResult();
    }

    protected Queue<Future<List<ReciprocalRecord>>> getFutures() {
        ArrayDeque<Future<List<ReciprocalRecord>>> taskQueue = new ArrayDeque<Future<List<ReciprocalRecord>>>(10);
        for (ReciprocalScheme comScheme : this.schemes) {
            Set<Long> childOrgs = comScheme.getChildOrgs();
            DynamicObject bookDatePeriod = GLUtil.getPeriodByDate(comScheme.getBookedDate(), comScheme.getPeriodType());
            if (bookDatePeriod != null) {
                comScheme.setBookedDatePeriod(bookDatePeriod.getLong(ID));
            }
            for (Long org : childOrgs) {
                AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(org, (long)comScheme.getBookType());
                if (Objects.isNull(bookInfo)) continue;
                ReciprocalScheme scheme = comScheme.clone();
                scheme.setOrg(org);
                scheme.setVerifiDiffBusiNo(true);
                scheme.setNoVerifiBusiNoEmpty(false);
                scheme.setEquaCanVerfi(false);
                scheme.setExculdeUnPostVoucher(false);
                HashMap<Long, SimulateRecord> writeOffAndWOAmountMap = new HashMap<Long, SimulateRecord>();
                HashMap<Long, SimulateRecord> buyerAndWOAmountMap = new HashMap<Long, SimulateRecord>();
                this.returnWOAmount(scheme, writeOffAndWOAmountMap, buyerAndWOAmountMap);
                List<RcpTask> tasks = this.splitLoadRecordIds(scheme, writeOffAndWOAmountMap, buyerAndWOAmountMap);
                if (DebugTrace.enable()) {
                    logger.info("=====reciprocalAging_ReciprocalSimulateEngine_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_tasks:{}=====", new Object[]{scheme.getNumber(), scheme.getOrg(), JSON.toJSONString(tasks)});
                }
                for (RcpTask task : tasks) {
                    if (DebugTrace.enable()) {
                        String taskId = task.getTaskId();
                        Set<Long> entryIds = task.getEntryIds("-1");
                        logger.info("=====reciprocalAging_taskId:{}_ReciprocalSimulateEngine_run_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_tasksEntryIds:{}=====", new Object[]{taskId, scheme.getNumber(), scheme.getOrg(), entryIds == null ? Integer.valueOf(0) : JSON.toJSONString(entryIds)});
                    }
                    scheme.setSimulateMap(task.getRecordAndWOAmountMap());
                    ReciprocalScheme snapshotScheme = scheme.clone();
                    Future future = ThreadService.submit((Callable)new SingleReciprocalSimulateEngine(snapshotScheme, task), (TaskType)TaskType.GL_ACCCURRENT_SIMULATE_WRITEOFF);
                    taskQueue.add(future);
                }
            }
        }
        logger.info("generate_tasks count {}", (Object)taskQueue.size());
        return taskQueue;
    }

    protected List<RcpTask> splitLoadRecordIds(ReciprocalScheme scheme, Map<Long, SimulateRecord> writeOffAndWOAmountMap, Map<Long, SimulateRecord> buyerAndWOAmountMap) {
        ArrayList<RcpTask> tasks = new ArrayList<RcpTask>(16);
        HashMap<Long, SimulateRecord> recordAndWOAmountMap = new HashMap<Long, SimulateRecord>(8);
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(scheme.getOrg(), (long)scheme.getBookType());
        if (Objects.isNull(bookInfo)) {
            return tasks;
        }
        List<QFilter> lstFilters = this.getFilters(scheme, true);
        String orderFields = this.getOrderString(scheme);
        try (DataSet dsRst = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)SELECT_FIELDS, (QFilter[])lstFilters.toArray(new QFilter[0]), (String)orderFields);){
            String currentKey = "";
            RcpTask task = new RcpTask();
            task.setRecordAndWOAmountMap(recordAndWOAmountMap);
            int iCount = 0;
            for (Row row : dsRst) {
                SimulateRecord simulateRecord;
                Long id = row.getLong(ID);
                String key = row.get(ACCOUNT) + "-" + row.get(ASSGRP) + "-" + row.get(CURRENCY);
                String srcType = row.getString(SOURCETYPE);
                if (currentKey.equals(key)) {
                    task.addEntryId(srcType, id);
                } else {
                    currentKey = key;
                    if (iCount >= 1000) {
                        iCount = 0;
                        tasks.add(task);
                        task = new RcpTask();
                        recordAndWOAmountMap = new HashMap(8);
                        task.setRecordAndWOAmountMap(recordAndWOAmountMap);
                    }
                    task.addEntryId(srcType, id);
                    task.addAccount((Long)row.get(ACCOUNT));
                    task.addAssgrp((Long)row.get(ASSGRP));
                }
                ++iCount;
                if ("0".equals(row.getString(STATUS))) continue;
                Long masterId = row.getLong(MASTERID);
                if (row.getBigDecimal(AMOUNT).compareTo(BigDecimal.ZERO) > 0) {
                    task.addSrcEntryId(masterId);
                    simulateRecord = buyerAndWOAmountMap.get(id);
                    if (simulateRecord == null) continue;
                    recordAndWOAmountMap.put(masterId, simulateRecord);
                    continue;
                }
                task.addTgtEntryId(masterId);
                simulateRecord = writeOffAndWOAmountMap.get(id);
                if (simulateRecord == null) continue;
                recordAndWOAmountMap.put(masterId, simulateRecord);
            }
            if (iCount > 0) {
                tasks.add(task);
            }
        }
        return tasks;
    }

    protected List<QFilter> getFilters(ReciprocalScheme scheme, boolean isBeforeBookedDate) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(8);
        lstFilters.add(new QFilter(ORG, "=", (Object)scheme.getOrg()));
        lstFilters.add(new QFilter(BOOKTYPE, "=", (Object)scheme.getBookType()));
        lstFilters.add(new QFilter(ACCOUNTTABLE, "=", (Object)scheme.getAccountTableId()));
        if (scheme.getAccountList().size() > 0) {
            lstFilters.add(new QFilter(ACCOUNT, "in", scheme.getAccountList()));
        }
        if (scheme.getCurrencyList().size() > 0) {
            lstFilters.add(new QFilter(CURRENCY, "in", scheme.getCurrencyList()));
        }
        if (isBeforeBookedDate) {
            ArrayList<Long> periodIds = new ArrayList<Long>(16);
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(scheme.getOrg(), (long)scheme.getBookType());
            periodIds.addAll(this.getPeriodIds(bookInfo.getPeriodTypeId(), scheme.getBookedDatePeriod()));
            periodIds.add(0L);
            lstFilters.add(new QFilter(BOOKEDDATE, "<=", (Object)scheme.getBookedDate()));
            lstFilters.add(new QFilter(PERIOD, "in", periodIds));
        } else {
            lstFilters.add(new QFilter(BOOKEDDATE, ">", (Object)scheme.getBookedDate()));
            lstFilters.add(new QFilter(STATUS, "!=", (Object)Character.valueOf('0')));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(scheme.getBookedDate());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date effecitveDate = calendar.getTime();
        lstFilters.add(new QFilter("uneffectivedate", ">=", (Object)effecitveDate));
        lstFilters.add(new QFilter("effectivedate", "<=", (Object)effecitveDate));
        return lstFilters;
    }

    protected List<Long> getPeriodIds(Long periodtype, Long endPeriod) {
        ArrayList<QFilter> periodFilters = new ArrayList<QFilter>(16);
        QFilter periodTypeFilter = new QFilter("periodtype.id", "=", (Object)periodtype);
        periodFilters.add(periodTypeFilter);
        if (endPeriod != null) {
            QFilter endPeriodFilter = new QFilter(ID, "<=", (Object)endPeriod);
            periodFilters.add(endPeriodFilter);
        }
        Map periodDynMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)ID, (QFilter[])periodFilters.toArray(new QFilter[0]));
        ArrayList<Long> periodList = new ArrayList<Long>(16);
        for (DynamicObject entry : periodDynMap.values()) {
            periodList.add(entry.getLong(ID));
        }
        return periodList;
    }

    protected String getOrderString(ReciprocalScheme scheme) {
        StringBuilder orderFields = new StringBuilder();
        orderFields.append("org, booktype, account, assgrp, currency, sourcetype");
        if ("0".equals(scheme.getVerifiOrder())) {
            orderFields.append(",bizdate, biznum");
        } else {
            orderFields.append(",biznum, bizdate");
        }
        orderFields.append(",createtime,id");
        return orderFields.toString();
    }

    protected List<QFilter> getLogFilters(ReciprocalScheme scheme) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(8);
        lstFilters.add(new QFilter(ORG, "=", (Object)scheme.getOrg()));
        lstFilters.add(new QFilter(BOOKTYPE, "=", (Object)scheme.getBookType()));
        lstFilters.add(new QFilter(BOOKTYPE, "=", (Object)scheme.getBookType()));
        if (scheme.getAccountList().size() > 0) {
            lstFilters.add(new QFilter(ACCOUNT, "in", scheme.getAccountList()));
        }
        if (scheme.getCurrencyList().size() > 0) {
            lstFilters.add(new QFilter(CURRENCY, "in", scheme.getCurrencyList()));
        }
        return lstFilters;
    }

    public void returnWOAmount(ReciprocalScheme scheme, Map<Long, SimulateRecord> writeOffAndWOAmountMap, Map<Long, SimulateRecord> buyerAndWOAmountMap) {
        SimulateRecord sr;
        BigDecimal amount;
        BigDecimal amountfor;
        Long acctId;
        Row row;
        DataSet logDt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_reciprocal_log", (String)SELECT_LOG_FIELDS, (QFilter[])this.getLogFilters(scheme).toArray(new QFilter[0]), null);
        String[] logDtField = GLUtil.getDataSetCols(logDt).toArray(new String[0]);
        List<QFilter> acctFilters = this.getFilters(scheme, false);
        DataSet acctDt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)ID, (QFilter[])acctFilters.toArray(new QFilter[0]), null);
        String[] acctDtField = GLUtil.getDataSetCols(acctDt).toArray(new String[0]);
        try (DataSet writeOffEntryDt = logDt.copy().join(acctDt.copy(), JoinType.INNER).on(BUYERENTRY, ID).select(logDtField, acctDtField).finish().groupBy(new String[]{WRITEOFFENTRY}).sum(AMOUNT).sum(AMOUNTFOR).finish();){
            while (writeOffEntryDt.hasNext()) {
                row = writeOffEntryDt.next();
                acctId = row.getLong(WRITEOFFENTRY);
                amountfor = row.getBigDecimal(AMOUNTFOR);
                amount = row.getBigDecimal(AMOUNT);
                sr = writeOffAndWOAmountMap.get(acctId);
                if (sr == null) {
                    sr = new SimulateRecord();
                    writeOffAndWOAmountMap.put(acctId, sr);
                }
                sr.addAmountFor(amountfor);
                sr.addAmount(amount);
            }
        }
        var10_10 = null;
        try (DataSet buyerEntryDt = logDt.join(acctDt, JoinType.INNER).on(WRITEOFFENTRY, ID).select(logDtField, acctDtField).finish().groupBy(new String[]{BUYERENTRY}).sum(AMOUNT).sum(AMOUNTFOR).finish();){
            while (buyerEntryDt.hasNext()) {
                row = buyerEntryDt.next();
                acctId = row.getLong(BUYERENTRY);
                amountfor = row.getBigDecimal(AMOUNTFOR);
                amount = row.getBigDecimal(AMOUNT);
                sr = buyerAndWOAmountMap.get(acctId);
                if (sr == null) {
                    sr = new SimulateRecord();
                    buyerAndWOAmountMap.put(acctId, sr);
                }
                sr.addAmountFor(amountfor);
                sr.addAmount(amount);
            }
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
    }
}

