/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.report.CurType;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.RateVO;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.vo.RateBean;
import org.apache.commons.lang3.StringUtils;

public class QueryParamRpt
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String entityId;
    private List<Long> orgs;
    private long porg;
    protected Set<Long> childOrg;
    protected Map<Long, Long> orgCurMap;
    protected Map<Long, Long> orgStartPeriodMap;
    protected static String orgGrpField = "orgid";
    private long bookType;
    private long periodType;
    private long startPeriod;
    private long endPeriod;
    private int searchType = 1;
    private Date startDate;
    private Date endDate;
    private long accountTable;
    private List<Long> accountList;
    private Set<Long> masterIdSet;
    Set<Long> filterAccIds;
    private Map<Long, Boolean> acctContainsgrpMap = new HashMap<Long, Boolean>(8);
    private int accountLevel;
    private long currency;
    private List<Tuple2<String, Set<Long>>> comAssistValsList = new ArrayList<Tuple2<String, Set<Long>>>(16);
    private List<Tuple2<String, String>> comAssistEntityList = new ArrayList<Tuple2<String, String>>(16);
    private List<String> comAssistList = new ArrayList<String>(8);
    protected long curLocal;
    private String mulcur;
    private long curRpt;
    private Map<Long, RateBean> rateMap;
    protected CurType curType;
    private boolean showRpt;
    private boolean isSynCurrency;
    private boolean isAllCurrency;
    private boolean showQty;
    private boolean showSumQty;
    private boolean showLeafAccount;
    private boolean showAssist;
    private boolean noZeroAmount;
    private boolean noZeroBalance;
    private boolean noZeroYearBal;
    private boolean noZeroSumAmount;
    protected boolean showOrg;
    private String showTreeOrg;
    private Long orgViewId;
    private boolean isSubstractPL;
    private boolean isShowDataByDC;
    private boolean isShowAllAccount = true;
    protected OrgType orgType;
    private boolean isShowDailySum;
    private boolean isShowOpAccount;
    private boolean isExportAll;
    private boolean isShowPrice;
    private boolean isShowAccountFullName;
    private boolean onlyShowDetailData;
    private boolean hideUnused;
    private String openType = "Default";
    private boolean isAllEmptyAssgrp;
    private LinkedList<Set<Object>> filterAssistValList;
    private boolean isShowPeriod;
    private boolean isShowComassist;
    private Map<String, Object> customParam = new HashMap<String, Object>();
    private FilterInfo filterInfo;

    public QueryParamRpt() {
    }

    public QueryParamRpt(FilterInfo filterInfo, String entityId) {
        List value;
        FilterItemInfo itemInfo;
        this.entityId = entityId;
        this.filterInfo = filterInfo;
        if (filterInfo.containProp("orgs")) {
            DynamicObjectCollection dyns = filterInfo.getDynamicObjectCollection("orgs");
            this.orgs = dyns.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        } else {
            this.orgs = new ArrayList<Long>();
            this.orgs.add(filterInfo.getLong("org"));
        }
        this.bookType = filterInfo.getLong("booktype");
        this.periodType = filterInfo.getLong("periodtype");
        if (filterInfo.containProp("searchtype") && "2".equals(filterInfo.getString("searchtype"))) {
            this.searchType = 2;
            this.startDate = filterInfo.getDate("datebegin");
            this.endDate = filterInfo.getDate("dateend");
        }
        this.startPeriod = filterInfo.getLong("startperiod");
        this.endPeriod = filterInfo.getLong("endperiod");
        this.accountTable = filterInfo.getLong("accounttable");
        QFilter pOrgF = (QFilter)filterInfo.getCommFilter().get("parentOrg");
        if (pOrgF != null) {
            String s = pOrgF.getValue().toString();
            this.porg = Long.parseLong(s);
        }
        if ((itemInfo = filterInfo.getFilterItem("account")) != null && (value = (List)itemInfo.getValue()) != null) {
            this.accountList = new ArrayList<Long>(value.size());
            this.masterIdSet = new HashSet<Long>(value.size());
            HashSet<String> numberSet = new HashSet<String>(value.size());
            for (DynamicObject dyn : value) {
                numberSet.add(dyn.getString("number"));
            }
            QFilter numberFilter = new QFilter("number", "in", numberSet);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
            filters.add(numberFilter);
            try (DataSet dataSet = AccountUtils.queryAccountDataSet((long)this.porg, (long)this.accountTable, (String)"id,masterid", filters);){
                for (Row row : dataSet) {
                    this.accountList.add(row.getLong("id"));
                    this.masterIdSet.add(row.getLong("masterid"));
                }
            }
        }
        this.accountLevel = filterInfo.getInt("accountlevel");
        String curStr = filterInfo.getString("currency");
        if ("basecurrency".equals(curStr)) {
            this.isSynCurrency = true;
            this.curType = CurType.BASE;
        } else if ("allcurrency".equals(curStr)) {
            this.isAllCurrency = true;
            this.curType = CurType.ALL;
        } else {
            this.currency = Long.parseLong(curStr);
        }
        this.mulcur = filterInfo.getString("mulcur");
        this.showRpt = filterInfo.getBoolean("showrpt");
        if (this.showRpt) {
            this.curRpt = filterInfo.getLong("currencyrpt");
            QFilter rateMapFilter = (QFilter)filterInfo.getCommFilter().get("rateMap");
            this.rateMap = (Map)rateMapFilter.getValue();
        }
        this.showSumQty = filterInfo.getBoolean("showsumqty");
        this.showQty = this.showSumQty || filterInfo.getBoolean("showqty");
        this.showLeafAccount = filterInfo.getBoolean("showleafaccount");
        this.showAssist = filterInfo.getBoolean("showassist");
        this.noZeroAmount = filterInfo.getBoolean("nodisplayforzero");
        this.noZeroBalance = filterInfo.getBoolean("balancezero");
        this.noZeroYearBal = filterInfo.getBoolean("yearbalzero");
        this.noZeroSumAmount = filterInfo.getBoolean("nodisplayforzeroamount");
        this.showOrg = filterInfo.getBoolean("showorg");
        this.isSubstractPL = filterInfo.getBoolean("issubstractpl");
        this.isShowDailySum = filterInfo.getBoolean("showdailysum");
        this.isShowOpAccount = filterInfo.getBoolean("showopaccount");
        this.hideUnused = filterInfo.getBoolean("hideunused");
        Boolean showDc = (Boolean)GLUtil.getSystemParam("showbyaccountdc", this.porg);
        this.isShowDataByDC = showDc == null ? false : showDc;
        Boolean showPrice = (Boolean)GLUtil.getSystemParam("p_showprice", this.porg);
        this.isShowPrice = showPrice == null ? false : showPrice;
        Boolean showAccountFullName = (Boolean)GLUtil.getSystemParam("showfullname", this.porg);
        this.isShowAccountFullName = showAccountFullName == null ? false : showAccountFullName;
        this.orgType = OrgType.ENTITY;
        this.showTreeOrg = filterInfo.getString("showtreeorg");
        if (StringUtils.isEmpty((CharSequence)this.showTreeOrg) && Objects.equals(entityId, "gl_rpt_accountbalance")) {
            this.showTreeOrg = "0";
        }
        this.orgViewId = 10L;
        if (Objects.nonNull(filterInfo.getDynamicObject("orgview"))) {
            this.orgViewId = filterInfo.getDynamicObject("orgview").getLong("id");
        }
        this.isShowPeriod = filterInfo.getBoolean("showperiod");
        this.isShowComassist = filterInfo.getBoolean("showcomassist");
        this.initBook(filterInfo);
        this.setComassist(filterInfo);
    }

    private void setComassist(FilterInfo filterInfo) {
        DynamicObject acctTableDyn = filterInfo.getDynamicObject("accounttable");
        if (acctTableDyn == null) {
            return;
        }
        DynamicObjectCollection accTableColl = acctTableDyn.getDynamicObjectCollection("comassistentry");
        ArrayList<Object[]> entityList = new ArrayList<Object[]>(8);
        int index = 1;
        for (DynamicObject row : accTableColl) {
            String valType = row.getString("valuesourcetype");
            if (valType == null) {
                entityList.add(null);
                continue;
            }
            String entityId = null;
            ILocaleString locaName = row.getLocaleString("comassistname");
            if (AssistValueType.isAssistData(valType)) {
                entityId = "bos_assistantdata_detail";
            } else if (row.getDynamicObject("valuesource") != null) {
                DynamicObject valTypeObj = row.getDynamicObject("valuesource");
                entityId = valTypeObj.getString("number");
            }
            String fieldKey = "comassist" + index;
            if (filterInfo.containProp(fieldKey)) {
                DynamicObjectCollection coll = filterInfo.getDynamicObjectCollection(fieldKey);
                String fieldKeyId = this.comAssist_Suffix(fieldKey);
                if (coll != null) {
                    Set ids = coll.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                    this.comAssistValsList.add((Tuple2<String, Set<Long>>)new Tuple2((Object)fieldKey, ids));
                } else {
                    this.comAssistValsList.add((Tuple2<String, Set<Long>>)new Tuple2((Object)fieldKey, new HashSet(8)));
                }
                this.comAssistEntityList.add((Tuple2<String, String>)new Tuple2((Object)fieldKeyId, (Object)entityId));
                this.comAssistList.add(fieldKeyId);
                entityList.add(new Object[]{fieldKeyId, entityId, locaName});
            }
            ++index;
        }
        if (!filterInfo.getBoolean("showcomassist")) {
            this.customParam.put("ComAssistEntityListStr", null);
            this.comAssistEntityList.clear();
            this.comAssistList.clear();
            return;
        }
        String entityStr = SerializationUtils.toJsonString(entityList);
        this.customParam.put("ComAssistEntityListStr", entityStr);
    }

    private String comAssist_Suffix(String comAssist) {
        return comAssist + "id";
    }

    private void initBook(FilterInfo filterInfo) {
        this.initBookRef(filterInfo);
    }

    public int getSearchType() {
        return this.searchType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public QueryParamRpt(FilterInfo filterInfo) {
        this(filterInfo, "");
    }

    protected void initBookRef(FilterInfo filterInfo) {
        HashSet<Long> orgSet = new HashSet<Long>(this.orgs);
        List<AccountBookInfo> books = AccSysUtil.getBookFromAccSys(orgSet, this.bookType);
        if (books.size() == 0) {
            return;
        }
        AccountBookInfo dyn = books.get(0);
        this.curLocal = MulCurReportUtil.getMulCurrency(this.mulcur, this.orgs.get(0), this.bookType, dyn.getBaseCurrencyId());
        if (this.curType == null) {
            this.curType = this.curLocal == this.currency ? CurType.NATIVE : CurType.FOREIGN;
        }
        long orgId = dyn.getOrgId();
        this.childOrg = new HashSet<Long>();
        this.childOrg.add(orgId);
        this.orgCurMap = new HashMap<Long, Long>();
        this.orgCurMap.put(orgId, this.curLocal);
        this.orgStartPeriodMap = new HashMap<Long, Long>();
        this.orgStartPeriodMap.put(orgId, dyn.getStartPeriodId());
    }

    public DataSet addCurRptField(DataSet ds) {
        if (!this.isShowRpt()) {
            throw new BOSException(new Exception(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u62a5\u544a\u5e01\u5b57\u6bb5\uff0c\u9700\u5148\u663e\u793a\u62a5\u544a\u5e01\u3002", (String)"QueryParamRpt_0", (String)"fi-gl-common", (Object[])new Object[0])));
        }
        DataSet orgCurRateSet = this.getOrgCurRateDS();
        List<String> cols = GLUtil.getDataSetCols(ds);
        DataSet finish = ds.join(orgCurRateSet, JoinType.LEFT).on(orgGrpField, orgGrpField).select(cols.toArray(new String[0]), new String[]{"exrate", "ratetype"}).finish();
        for (String col : cols) {
            if (!col.toLowerCase(Locale.ENGLISH).endsWith("local")) continue;
            String exp = "case when ratetype then " + col + "*exrate else " + col + "/exrate end";
            finish = finish.addField(exp, col.replace("local", "rpt"));
        }
        return finish;
    }

    public DataSet getOrgCurRateDS() {
        String[] fieldNames = new String[]{orgGrpField, "currencylocalid", "exrate", "ratetype"};
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.BigDecimalType, DateType.BooleanType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        DataSetBuilder builder = Algo.create((String)(this.getClass().getName() + "addCurRptField")).createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Long> entry : this.getOrgCurMap().entrySet()) {
            RateBean rate = this.getRateMap().get(entry.getValue());
            builder.append(new Object[]{entry.getKey(), entry.getValue(), rate.getRateVal(), rate.isDirect()});
        }
        return builder.build();
    }

    public Map<Long, RateVO> getOrgCurRateMap() {
        if (null == this.getRateMap()) {
            return Collections.EMPTY_MAP;
        }
        return this.getOrgCurMap().entrySet().stream().collect(Collectors.toMap(e -> (Long)e.getKey(), e -> {
            long currencyId = (Long)e.getValue();
            RateBean rate = this.getRateMap().get(currencyId);
            return new RateVO(currencyId, rate.isDirect(), rate.getRateVal());
        }));
    }

    public Map<Long, RateBean> getOrgRateMap() {
        HashMap<Long, RateBean> orgRateMap = new HashMap<Long, RateBean>();
        if (this.isShowRpt()) {
            Map<Long, RateBean> rateMap = this.getRateMap();
            Map<Long, Long> orgCurMap = this.getOrgCurMap();
            for (Map.Entry<Long, Long> entry : orgCurMap.entrySet()) {
                orgRateMap.put(entry.getKey(), rateMap.get(entry.getValue()));
            }
        }
        return orgRateMap;
    }

    public boolean isShowAllAccount() {
        return this.isShowAllAccount;
    }

    public void setShowAllAccount(boolean showAllAccount) {
        this.isShowAllAccount = showAllAccount;
    }

    public boolean isShowDataByDC() {
        return this.isShowDataByDC;
    }

    public boolean isShowAccountFullName() {
        return this.isShowAccountFullName;
    }

    public long getPorg() {
        return this.porg;
    }

    public List<Long> getOrgs() {
        return this.orgs;
    }

    public List<Long> getAllEntityOrgs() {
        return this.orgs;
    }

    public OrgType getOrgType() {
        return this.orgType;
    }

    public void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }

    public long getBookType() {
        return this.bookType;
    }

    public long getPeriodType() {
        return this.periodType;
    }

    public long getStartPeriod() {
        return this.startPeriod;
    }

    public long getEndPeriod() {
        return this.endPeriod;
    }

    public long getAccountTable() {
        return this.accountTable;
    }

    public List<Long> getAccountList() {
        return this.accountList;
    }

    public Set<Long> getMasterIdSet() {
        return this.masterIdSet;
    }

    public int getAccountLevel() {
        return this.accountLevel;
    }

    public long getCurrency() {
        return this.currency;
    }

    public long getCurLocal() {
        return this.curLocal;
    }

    public void setCurLocal(long curLocal) {
        this.curLocal = curLocal;
    }

    public String getMulCur() {
        return this.mulcur;
    }

    public long getCurRpt() {
        return this.curRpt;
    }

    public Map<Long, RateBean> getRateMap() {
        return this.rateMap;
    }

    public boolean isSynCurrency() {
        return this.isSynCurrency;
    }

    public boolean isAllCurrency() {
        return this.isAllCurrency;
    }

    public boolean isShowRpt() {
        return this.showRpt;
    }

    public boolean isShowQty() {
        return this.showQty;
    }

    public boolean isShowSumQty() {
        return this.showSumQty;
    }

    public boolean isShowLeafAccount() {
        return this.showLeafAccount;
    }

    public boolean isNoZeroAmount() {
        return this.noZeroAmount;
    }

    public boolean isNoZeroSumAmount() {
        return this.noZeroSumAmount;
    }

    public boolean isShowAssist() {
        return this.showAssist;
    }

    public boolean isNoZeroBalance() {
        return this.noZeroBalance;
    }

    public boolean isNoZeroYearBal() {
        return this.noZeroYearBal;
    }

    public boolean isShowOrg() {
        return this.showOrg;
    }

    public CurType getCurType() {
        return this.curType;
    }

    public void setStartPeriod(long startPeriod) {
        this.startPeriod = startPeriod;
    }

    public void setEndPeriod(long endPeriod) {
        this.endPeriod = endPeriod;
    }

    public boolean isSubstractPL() {
        return this.isSubstractPL;
    }

    public void setSubstractPL(boolean substractPL) {
        this.isSubstractPL = substractPL;
    }

    public void setNoZeroAmount(boolean noZeroAmount) {
        this.noZeroAmount = noZeroAmount;
    }

    public void setNoZeroBalance(boolean noZeroBalance) {
        this.noZeroBalance = noZeroBalance;
    }

    public Object getCustomParam(String key) {
        return this.customParam.get(key);
    }

    public void setCustomParam(String key, Object value) {
        this.customParam.put(key, value);
    }

    public static List<QFilter[]> splitQFilter(QFilter[] filters, String propertyName, int splitSize) {
        ArrayList<QFilter[]> result;
        block11: {
            int valueLen;
            int len;
            Object[] values;
            block10: {
                result = new ArrayList<QFilter[]>();
                values = null;
                for (QFilter qf : filters) {
                    if (!qf.getProperty().equals(propertyName)) continue;
                    values = ((Set)qf.getValue()).toArray();
                    break;
                }
                if (values == null) {
                    result.add(filters);
                    return result;
                }
                len = filters.length;
                valueLen = values.length;
                if (splitSize >= 0 && valueLen >= splitSize) break block10;
                if (valueLen <= 0) break block11;
                for (int i = 0; i < valueLen; ++i) {
                    QFilter[] qfs = new QFilter[len];
                    for (int j = 0; j < len; ++j) {
                        QFilter qf = filters[j];
                        qfs[j] = qf.getProperty().equals(propertyName) ? new QFilter(propertyName, "in", (Object)new Object[]{values[i]}) : qf;
                    }
                    result.add(qfs);
                }
                break block11;
            }
            int qfSize = valueLen / splitSize;
            for (int i = 0; i < splitSize; ++i) {
                QFilter[] qfs = new QFilter[len];
                for (int j = 0; j < len; ++j) {
                    QFilter qf = filters[j];
                    if (qf.getProperty().equals(propertyName)) {
                        if (i < splitSize - 1) {
                            Object[] qfv = new Object[qfSize];
                            for (int s = 0; s < qfSize; ++s) {
                                qfv[s] = values[i * qfSize + s];
                            }
                            qfs[j] = new QFilter(propertyName, "in", (Object)qfv);
                            continue;
                        }
                        int lastSize = valueLen - (splitSize - 1) * qfSize;
                        Object[] qfv = new Object[lastSize];
                        for (int s = 0; s < lastSize; ++s) {
                            qfv[s] = values[i * qfSize + s];
                        }
                        qfs[j] = new QFilter(propertyName, "in", (Object)qfv);
                        continue;
                    }
                    qfs[j] = qf;
                }
                result.add(qfs);
            }
        }
        return result;
    }

    public void setOrgs(List<Long> orgs) {
        this.orgs = orgs;
    }

    public void setPorg(long porg) {
        this.porg = porg;
    }

    public void setBookType(long bookType) {
        this.bookType = bookType;
    }

    public void setPeriodType(long periodType) {
        this.periodType = periodType;
    }

    public void setAccountTable(long accountTable) {
        this.accountTable = accountTable;
    }

    public void setAccountList(List<Long> accountList) {
        this.accountList = accountList;
    }

    public void setAccountLevel(int accountLevel) {
        this.accountLevel = accountLevel;
    }

    public void setCurrency(long currency) {
        this.currency = currency;
    }

    public Boolean isShowComAssistSum() {
        return this.filterInfo.getBoolean("showsumcomassist");
    }

    public List<String> getCommonAssistsForGroup() {
        return ComAssistTable.get(this.getAccountTable()).getComAssistForGroup(this.isShowComAssistSum()).stream().map(commonAssist -> commonAssist.key).collect(Collectors.toList());
    }

    public List<CommonAssist> getCommonAssists() {
        return ComAssistTable.get(this.getAccountTable()).getCommonAssists();
    }

    public List<QFilter> getComAssistFiltersForBal() {
        return ComAssistTableService.getComAssistFilters(ComAssistTable.get(this.getAccountTable()), this.getOrgs(), this.filterInfo, key -> key, "masterid");
    }

    public List<QFilter> getComAssistFiltersForBill(Function<String, String> propGetter) {
        return ComAssistTableService.getComAssistFilters(ComAssistTable.get(this.getAccountTable()), this.getOrgs(), this.filterInfo, propGetter, "id");
    }

    public List<String> getCommonAssistKeys() {
        return this.comAssistValsList.stream().map(comassit -> (String)comassit.t1).collect(Collectors.toList());
    }

    public List<Tuple2<String, Set<Long>>> getComAssistValsList() {
        return this.comAssistValsList;
    }

    public void setComAssistValsList(List<Tuple2<String, Set<Long>>> comAssistValsList) {
        this.comAssistValsList = comAssistValsList;
    }

    public List<Tuple2<String, String>> getComAssistEntityList() {
        return this.comAssistEntityList;
    }

    public void setComAssistEntityList(List<Tuple2<String, String>> comAssistFieldList) {
        this.comAssistEntityList = comAssistFieldList;
    }

    public List<String> getComAssistList() {
        return this.comAssistList;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setShowAssist(boolean showAssist) {
        this.showAssist = showAssist;
    }

    public void setShowLeafAccount(boolean showLeafAccount) {
        this.showLeafAccount = showLeafAccount;
    }

    public void setShowOrg(boolean showOrg) {
        this.showOrg = showOrg;
    }

    public boolean isQueryCurrency() {
        return this.curType == CurType.ALL || this.curType == CurType.FOREIGN;
    }

    public boolean isShowCurrency() {
        return this.curType == CurType.ALL;
    }

    public DataSet addCurLocal(String orgField, DataSet ds) {
        return ds.addField("" + this.curLocal, "currencylocalid");
    }

    public DataSet addCurOri(DataSet ds) {
        return ds.addField("" + this.currency, "currency");
    }

    public Set<Long> getChildOrg() {
        return Collections.unmodifiableSet(this.childOrg == null ? new HashSet() : this.childOrg);
    }

    public Map<Long, Long> getOrgCurMap() {
        return this.orgCurMap;
    }

    public boolean isShowDailySum() {
        return this.isShowDailySum;
    }

    public boolean isShowOpAccount() {
        return this.isShowOpAccount;
    }

    public void setMasterIdSet(Set<Long> masterIdSet) {
        this.masterIdSet = masterIdSet;
    }

    public boolean isExportAll() {
        return this.isExportAll;
    }

    public void setExportAll(boolean exportAll) {
        this.isExportAll = exportAll;
    }

    public boolean isShowPrice() {
        return this.isShowPrice;
    }

    public void setShowPrice(boolean showPrice) {
        this.isShowPrice = showPrice;
    }

    public boolean isOnlyShowDetailData() {
        return this.onlyShowDetailData;
    }

    public void setOnlyShowDetailData(boolean onlyShowDetailData) {
        this.onlyShowDetailData = onlyShowDetailData;
    }

    public boolean isHideUnused() {
        return this.hideUnused;
    }

    public boolean isShowOrgTree() {
        return this.showTreeOrg == null ? false : Objects.equals(this.showTreeOrg, "1");
    }

    public String getShowOrgTree() {
        return this.showTreeOrg;
    }

    public Long getOrgViewId() {
        return this.orgViewId;
    }

    public void setOrgViewId(Long orgViewId) {
        this.orgViewId = orgViewId;
    }

    public boolean isHyperClick() {
        return Objects.equals(this.openType, "HyperClick");
    }

    public void setOpenType(String openType) {
        this.openType = openType;
    }

    public void setAllEmptyAssgrp(boolean allEmptyAssgrp) {
        this.isAllEmptyAssgrp = allEmptyAssgrp;
    }

    public boolean isAllEmptyAssgrp() {
        return this.isAllEmptyAssgrp;
    }

    public LinkedList<Set<Object>> getFilterAssistValList() {
        return this.filterAssistValList;
    }

    public void setFilterAssistValList(LinkedList<Set<Object>> filterAssistValList) {
        this.filterAssistValList = filterAssistValList;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Map<Long, Boolean> getAcctContainsgrpMap() {
        return this.acctContainsgrpMap;
    }

    public void setAcctContainsgrpMap(Map<Long, Boolean> acctContainsgrpMap) {
        this.acctContainsgrpMap = acctContainsgrpMap;
    }

    public Set<Long> getFilterAccIds() {
        return this.filterAccIds;
    }

    public void setFilterAccIds(Set<Long> filterAccIds) {
        this.filterAccIds = filterAccIds;
    }

    public boolean isShowPeriod() {
        return this.isShowPeriod;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public boolean isShowComassist() {
        return this.isShowComassist;
    }

    public void setShowComassist(boolean showComassist) {
        this.isShowComassist = showComassist;
    }

    public String getLocaleCurType() {
        return this.getFilterInfo().getString("mulcur");
    }
}

