/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.bd.model.Context;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.ShowByAccountDCParam;
import kd.fi.gl.report.subsidiary.AssistBalanceQuery;
import kd.fi.gl.report.subsidiary.SubsidiaryRow;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class ReportUtils {
    private static final String ASSGRP = "assgrp";
    private static final String ASSIST_BD_SELECTFIELDS = "hg assisthg,asstype,assval val";
    public static final String CURRENCY_TYPE_ALL = "allcurrency";
    public static final String CURRENCY_TYPE_BASE = "basecurrency";
    public static final String CURRENCY_TYPE_RPT = "reportcurrency";
    private static final String TYPE_TXT = "type_txt";
    private static final String TYPE_BASE_STRING = "type_base_str";
    private static final String TYPE_BASE_LONG = "type_base_long";
    private static final String ASSIST_DB = "gl_assist_bd";
    private static final String ASSIST_TXT = "gl_assist_txt";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private static final String ACCT_DC_CACHE = "reportutil-acctdc";

    public static Set<Long> getAccIdsByFlexFields(List<Long> orgIDs, long accountTableId, Set<String> flexFields, long endPeriod) {
        DynamicObjectCollection acttypeColl = QueryServiceHelper.query((String)ASSIST_TYPE, (String)"id,flexfield", (QFilter[])new QFilter("flexfield", "in", flexFields).toArray());
        HashMap<String, Long> typeMap = new HashMap<String, Long>();
        for (DynamicObject acttype : acttypeColl) {
            typeMap.put(acttype.getString("flexfield"), acttype.getLong("id"));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid,a.fmasterid from T_BD_Account a ");
        StringBuffer where = new StringBuffer();
        where.append(" WHERE a.faccounttableid = ? ");
        String useRangeF = " and (fctrlstrategy = '5' AND fstatus = 'C' OR (a.fid in (select fdataid from T_BD_Account_U where fuseorgid in (%s)))) ";
        if (!orgIDs.isEmpty()) {
            where.append(String.format(useRangeF, orgIDs.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
        where.append(" and a.fenddate >= ? ");
        where.append(" and a.fstartdate <= ? ");
        ArrayList<Comparable<Long>> sp = new ArrayList<Comparable<Long>>(flexFields.size());
        sp.add(Long.valueOf(accountTableId));
        DynamicObject endperiod = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriod, (String)"bd_period");
        sp.add(endperiod.getDate("enddate"));
        sp.add(endperiod.getDate("enddate"));
        HashSet<Long> accIds = new HashSet<Long>();
        HashSet<Long> accmasterIds = new HashSet<Long>();
        int i = 1;
        for (String string : flexFields) {
            sql.append(" INNER JOIN T_BD_AccountAsstActItem a").append(i).append(" ON a.fid=a").append(i).append(".fid");
            where.append(" and a").append(i).append(".fasstactitemid = ? ");
            sp.add((Comparable<Long>)typeMap.get(string));
            ++i;
        }
        Throwable throwable = null;
        try (DataSet dataSet = DB.queryDataSet((String)"queryAccIdsByFlexFields", (DBRoute)DBRoute.of((String)"gl"), (String)sql.append(where).toString(), (Object[])sp.toArray());){
            for (Row row : dataSet) {
                accIds.add(row.getLong("fid"));
                accmasterIds.add(row.getLong("fmasterid"));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        filters.add(new QFilter("masterid", "in", accmasterIds));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAccIdsByFlexFields2", (String)"bd_accountview", (String)"id", (QFilter[])filters.toArray(new QFilter[0]), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                accIds.add(row.getLong("id"));
            }
        }
        catch (Throwable throwable4) {
            object = throwable4;
            throw throwable4;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable5) {
                        ((Throwable)object).addSuppressed(throwable5);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return accIds;
    }

    public static Set<Long> getAccIdsByFlexFieldsForBalance(List<Long> orgIDs, long accountTableId, Set<String> flexFields, long endPeriod) {
        DynamicObjectCollection acttypeColl = QueryServiceHelper.query((String)ASSIST_TYPE, (String)"id,flexfield", (QFilter[])new QFilter("flexfield", "in", flexFields).toArray());
        HashMap<String, Long> typeMap = new HashMap<String, Long>();
        for (DynamicObject acttype : acttypeColl) {
            typeMap.put(acttype.getString("flexfield"), acttype.getLong("id"));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid,a.fmasterid from T_BD_Account a ");
        StringBuffer where = new StringBuffer();
        where.append(" WHERE a.faccounttableid = ?  and a.fisleaf = '1' ");
        String useRangeF = " and (fctrlstrategy = '5' AND fstatus = 'C' OR (a.fid in (select fdataid from T_BD_Account_U where fuseorgid in (%s)))) ";
        if (!orgIDs.isEmpty()) {
            where.append(String.format(useRangeF, orgIDs.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
        where.append(" and a.fenddate >= ? ");
        where.append(" and a.fstartdate <= ? ");
        ArrayList<Comparable<Long>> sp = new ArrayList<Comparable<Long>>(flexFields.size());
        sp.add(Long.valueOf(accountTableId));
        DynamicObject endperiod = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriod, (String)"bd_period");
        sp.add(endperiod.getDate("enddate"));
        sp.add(endperiod.getDate("enddate"));
        HashSet<Long> accIds = new HashSet<Long>();
        int i = 1;
        for (String s : flexFields) {
            sql.append(" INNER JOIN T_BD_AccountAsstActItem a").append(i).append(" ON a.fid=a").append(i).append(".fid");
            where.append(" and a").append(i).append(".fasstactitemid = ? ");
            sp.add((Comparable<Long>)typeMap.get(s));
            ++i;
        }
        try (DataSet dataSet = DB.queryDataSet((String)"queryAccIdsByFlexFields", (DBRoute)DBRoute.of((String)"gl"), (String)sql.append(where).toString(), (Object[])sp.toArray());){
            for (Row row : dataSet) {
                accIds.add(row.getLong("fid"));
            }
        }
        return accIds;
    }

    public static Set<Long> getAccIdsByFlexFields(long accountTableId, Set<String> flexFields) {
        DynamicObjectCollection acttypeColl = QueryServiceHelper.query((String)ASSIST_TYPE, (String)"id,flexfield", (QFilter[])new QFilter("flexfield", "in", flexFields).toArray());
        HashMap<String, Long> typeMap = new HashMap<String, Long>();
        for (DynamicObject acttype : acttypeColl) {
            typeMap.put(acttype.getString("flexfield"), acttype.getLong("id"));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid from T_BD_Account a ");
        StringBuffer where = new StringBuffer();
        where.append(" WHERE a.faccounttableid = ? ");
        ArrayList<Long> sp = new ArrayList<Long>(flexFields.size());
        sp.add(accountTableId);
        HashSet<Long> accIds = new HashSet<Long>();
        int i = 1;
        for (String s : flexFields) {
            sql.append(" INNER JOIN T_BD_AccountAsstActItem a").append(i).append(" ON a.fid=a").append(i).append(".fid");
            where.append(" and a").append(i).append(".fasstactitemid = ? ");
            sp.add((Long)typeMap.get(s));
            ++i;
        }
        try (DataSet dataSet = DB.queryDataSet((String)"queryAccIdsByFlexFields", (DBRoute)DBRoute.of((String)"gl"), (String)sql.append(where).toString(), (Object[])sp.toArray());){
            while (dataSet.hasNext()) {
                accIds.add(dataSet.next().getLong("fid"));
            }
        }
        return accIds;
    }

    public static Set<Long> getAllLeafAcctMIDByNumber(Set<String> numbers, Long acctTableID, Long orgID, QFilter extF) {
        HashSet<Long> ids = new HashSet<Long>(100);
        QFilter acctTableF = new QFilter("accounttable", "=", (Object)acctTableID);
        Optional.ofNullable(extF).ifPresent(arg_0 -> ((QFilter)acctTableF).and(arg_0));
        QFilter useRangeF = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgID);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ReportUtils.class.getSimpleName() + "getAllLeafAcctMIDByNumber"), (String)"bd_accountview", (String)"longnumber, masterid", (QFilter[])new QFilter[]{acctTableF, useRangeF}, null);
        for (Row row : dataSet) {
            String[] split;
            String longnumber = row.getString("longnumber");
            for (String s : split = longnumber.split("_")) {
                if (!numbers.contains(s)) continue;
                ids.add(row.getLong("masterid"));
            }
        }
        return ids;
    }

    public static Set<Object> getAllIdAndMasterid(String baseDataEntityId, Set<Object> idSet) {
        HashSet<Object> rs = new HashSet<Object>();
        if (idSet.isEmpty()) {
            return rs;
        }
        HashSet<Object> pSet = new HashSet<Object>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"gl.report", (String)baseDataEntityId, (String)"id, masterid", (QFilter[])new QFilter("id", "in", idSet).toArray(), null);){
            for (Row row : ds) {
                pSet.add(row.getLong("id"));
                pSet.add(row.getLong("masterid"));
                rs.add(row.getLong("id"));
                rs.add(row.getLong("masterid"));
            }
        }
        if (!pSet.isEmpty()) {
            rs.addAll(ReportUtils.getAllLeafIdAndMasteridSet(pSet));
        }
        return rs;
    }

    private static Set<Object> getAllLeafIdAndMasteridSet(Set<Object> idSet) {
        HashSet<Object> rs = new HashSet<Object>();
        HashSet<Object> pSet = new HashSet<Object>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"gl.report", (String)"bd_accountview", (String)"id, masterid", (QFilter[])new QFilter("parent", "in", idSet).toArray(), null);){
            for (Row row : ds) {
                rs.add(row.getLong("id"));
                rs.add(row.getLong("masterid"));
                pSet.add(row.getLong("id"));
                pSet.add(row.getLong("masterid"));
            }
        }
        if (!pSet.isEmpty()) {
            rs.addAll(ReportUtils.getAllLeafIdAndMasteridSet(pSet));
        }
        return rs;
    }

    public static Set<Object> getAllMasterIdSet(String baseDataEntityId, Set<Object> idSet) {
        HashSet<Object> masterIdSet = new HashSet<Object>();
        if (idSet.isEmpty()) {
            return masterIdSet;
        }
        HashSet<Object> pSet = new HashSet<Object>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"gl.report", (String)baseDataEntityId, (String)"id, masterid", (QFilter[])new QFilter("id", "in", idSet).toArray(), null);){
            for (Row row : ds) {
                pSet.add(row.getLong("id"));
                masterIdSet.add(row.getLong("masterid"));
            }
        }
        ds = QueryServiceHelper.queryDataSet((String)"gl.report.masterid", (String)"bd_accountview", (String)"id", (QFilter[])new QFilter("masterid", "in", masterIdSet).toArray(), null);
        var5_5 = null;
        try {
            for (Row d : ds) {
                pSet.add(d.getLong("id"));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var5_5 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (!pSet.isEmpty()) {
            masterIdSet.addAll(ReportUtils.getAllLeafMasterIdSet(pSet));
        }
        return masterIdSet;
    }

    private static Set<Object> getAllLeafMasterIdSet(Set<Object> idSet) {
        HashSet<Object> masterIdSet = new HashSet<Object>();
        HashSet<Object> pSet = new HashSet<Object>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"gl.report", (String)"bd_accountview", (String)"id, masterid", (QFilter[])new QFilter("parent", "in", idSet).toArray(), null);){
            for (Row row : ds) {
                masterIdSet.add(row.getLong("masterid"));
                pSet.add(row.getLong("id"));
            }
        }
        if (!pSet.isEmpty()) {
            masterIdSet.addAll(ReportUtils.getAllLeafMasterIdSet(pSet));
        }
        return masterIdSet;
    }

    public static Set<Object> getAllIdSet(String baseDataEntityId, Set<Object> idSet) {
        HashSet<Object> accIdSet = new HashSet<Object>();
        if (idSet.isEmpty()) {
            return accIdSet;
        }
        HashSet<Object> pSet = new HashSet<Object>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"gl.report", (String)"bd_accountview", (String)"id, masterid, isleaf", (QFilter[])new QFilter("id", "in", idSet).toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                accIdSet.add(row.getLong("masterid"));
                if (row.getBoolean("isleaf").booleanValue()) {
                    accIdSet.add(row.getLong("id"));
                    continue;
                }
                pSet.add(row.getLong("id"));
            }
            if (!pSet.isEmpty()) {
                accIdSet.addAll(ReportUtils.getAllLeafIdSet(pSet));
            }
        }
        return accIdSet;
    }

    private static Set<Object> getAllLeafIdSet(Set<Object> idSet) {
        HashSet<Object> accIdSet = new HashSet<Object>();
        HashSet<Object> pSet = new HashSet<Object>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"gl.report", (String)"bd_accountview", (String)"id, masterid, isleaf", (QFilter[])new QFilter("parent", "in", pSet).toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                accIdSet.add(row.getLong("masterid"));
                if (row.getBoolean("isleaf").booleanValue()) {
                    accIdSet.add(row.getLong("id"));
                    continue;
                }
                pSet.add(row.getLong("id"));
            }
        }
        if (!pSet.isEmpty()) {
            accIdSet.addAll(ReportUtils.getAllLeafIdSet(pSet));
        }
        return accIdSet;
    }

    public static DataSet gainSumSetHelper(DataSet ds, Field[] oldFields) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> newCols = ReportUtils.getDataSetCols(ds);
        for (Field field : oldFields) {
            String name = field.getName().toLowerCase();
            if (newCols.contains(name)) {
                list.add(name);
                continue;
            }
            DataType dataType = field.getDataType();
            if (dataType instanceof LongType) {
                list.add("0L " + name);
                continue;
            }
            if (dataType instanceof IntegerType) {
                list.add("0 " + name);
                continue;
            }
            if (dataType instanceof BigDecimalType) {
                list.add("0.0 " + name);
                continue;
            }
            if (dataType instanceof StringType) {
                list.add("'' " + name);
                continue;
            }
            if (dataType instanceof BooleanType) {
                list.add("false " + name);
                continue;
            }
            if (!(dataType instanceof NullType)) continue;
            list.add("null " + name);
        }
        ds = ds.select(list.toArray(new String[0]));
        return ds;
    }

    public static List<String> getDataSetCols(DataSet ds) {
        ArrayList<String> list = new ArrayList<String>(16);
        if (ds != null) {
            Field[] fields;
            RowMeta rowMeta = ds.getRowMeta();
            for (Field field : fields = rowMeta.getFields()) {
                list.add(field.getName().toLowerCase());
            }
        }
        return list;
    }

    public static List<String> getSetField(DataSet dataSet) {
        ArrayList<String> list = new ArrayList<String>(16);
        if (dataSet != null) {
            RowMeta meta = dataSet.getRowMeta();
            int count = meta.getFieldCount();
            for (int i = 0; i < count; ++i) {
                String alias = meta.getFieldAlias(i);
                list.add(alias);
            }
        }
        return list;
    }

    public static void showRowDataByActDC(ShowByAccountDCParam param, DynamicObjectCollection rowData) {
        ReportUtils.showRowDataByActDC(param, rowData, false);
    }

    public static void showRowDataByActDC(ShowByAccountDCParam param, DynamicObjectCollection rowData, boolean byNegate) {
        Boolean bIsShowByAccountDC = ReportUtils.getShowByActDCSysParam(param.getOrg());
        Map<Long, String> actAndDCMap = ReportUtils.getActAndDCMap(param.getOrg(), param.getAccountTable());
        String accountField = param.getAccountField();
        List<String> amountTypes = param.getAmountTypes();
        List<Tuple<String, String>> debitAndCreditFields = param.getDebitAndCreditFields();
        List<Tuple<String, String>> balAndDCFields = param.getBalAndDCFields();
        if (rowData == null || rowData.isEmpty()) {
            return;
        }
        if (param.isMergeDebitAndCreditCol().booleanValue()) {
            if (bIsShowByAccountDC.booleanValue()) {
                return;
            }
            for (DynamicObject row : rowData) {
                for (Tuple<String, String> balAndDCField : balAndDCFields) {
                    ReportUtils.setBalAndDC((String)balAndDCField.item1, (String)balAndDCField.item2, amountTypes, row, param.getQtyField(), byNegate);
                }
            }
        } else {
            for (DynamicObject row : rowData) {
                DynamicObject acct = row.getDynamicObject(accountField);
                if (acct == null) continue;
                Long masterid = acct.getLong("masterid");
                String accountDC = actAndDCMap.get(masterid);
                if (accountDC == null) {
                    accountDC = acct.getString("dc");
                }
                for (Tuple<String, String> debitAndCreditField : debitAndCreditFields) {
                    ReportUtils.mergeDebitCreditValue((String)debitAndCreditField.item1, (String)debitAndCreditField.item2, amountTypes, row, accountDC, bIsShowByAccountDC);
                }
            }
        }
    }

    public static void showRowDataByActDC(ShowByAccountDCParam param, List<Object[]> rowData, Map<String, Integer> fieldMap) {
        Boolean bIsShowByAccountDC = ReportUtils.getShowByActDCSysParam(param.getOrg());
        Map<Long, String> actAndDCMap = ReportUtils.getActAndDCMap(param.getOrg(), param.getAccountTable());
        Map<Long, String> allActAndDCMap = ReportUtils.getAllActAndDCMap(param.getAccountTable());
        String accountField = param.getAccountField();
        List<String> amountTypes = param.getAmountTypes();
        List<Tuple<String, String>> debitAndCreditFields = param.getDebitAndCreditFields();
        List<Tuple<String, String>> balAndDCFields = param.getBalAndDCFields();
        if (rowData == null || rowData.isEmpty()) {
            return;
        }
        for (Object[] row : rowData) {
            Long masterid = (Long)row[Integer.parseInt(accountField)];
            String accountDC = actAndDCMap.get(masterid);
            if (accountDC == null && (accountDC = allActAndDCMap.get(masterid)) == null) continue;
            for (Tuple<String, String> debitAndCreditField : debitAndCreditFields) {
                ReportUtils.mergeDebitCreditValue((String)debitAndCreditField.item1, (String)debitAndCreditField.item2, amountTypes, row, fieldMap, accountDC, bIsShowByAccountDC);
            }
            for (Tuple<String, String> balAndDCField : balAndDCFields) {
                ReportUtils.showBalValueByDC((String)balAndDCField.item1, (String)balAndDCField.item2, amountTypes, bIsShowByAccountDC, row, fieldMap, accountDC);
            }
        }
    }

    private static void setBalAndDC(String balField, String dcField, List<String> amountTypes, DynamicObject row, List<String> qtyField, boolean byNegate) {
        Object balDC;
        boolean directionChange = false;
        if (byNegate) {
            Optional<BigDecimal> checkAmt;
            balDC = row.getString(dcField);
            if (!"0".equals(balDC) && (checkAmt = amountTypes.stream().map(type -> row.getBigDecimal(balField + type)).filter(amt -> amt != null && amt.signum() != 0).findFirst()).isPresent() && checkAmt.get().signum() < 0) {
                directionChange = true;
                amountTypes.stream().map(type -> balField + type).forEach(field -> row.set(field, (Object)row.getBigDecimal(field).negate()));
            }
        } else {
            for (String type2 : amountTypes) {
                BigDecimal balAmount = row.getBigDecimal(balField + type2);
                if (balAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                row.set(balField + type2, (Object)balAmount.abs());
                directionChange = true;
            }
        }
        if (directionChange) {
            balDC = row.getString(dcField);
            if (ResManager.loadKDString((String)"\u501f", (String)"ReportUtils_0", (String)"fi-gl-common", (Object[])new Object[0]).equals(balDC)) {
                row.set(dcField, (Object)ResManager.loadKDString((String)"\u8d37", (String)"ReportUtils_1", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            if (ResManager.loadKDString((String)"\u8d37", (String)"ReportUtils_1", (String)"fi-gl-common", (Object[])new Object[0]).equals(balDC)) {
                row.set(dcField, (Object)ResManager.loadKDString((String)"\u501f", (String)"ReportUtils_0", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            if ("1".equals(balDC)) {
                row.set(dcField, (Object)"-1");
                qtyField.forEach(x -> row.set(x, (Object)row.getBigDecimal(x).negate()));
            }
            if ("-1".equals(balDC)) {
                row.set(dcField, (Object)"1");
                qtyField.forEach(x -> row.set(x, (Object)row.getBigDecimal(x).negate()));
            }
        }
    }

    private static void showBalValueByDC(String balField, String dcField, List<String> amountTypes, Boolean bIsShowByAccountDC, Object[] row, Map<String, Integer> fieldMap, String accountDC) {
        if (bIsShowByAccountDC.booleanValue()) {
            return;
        }
        boolean directionChange = false;
        for (String type : amountTypes) {
            Integer balIndex = fieldMap.get(balField + type);
            BigDecimal balAmount = ReportUtils.bigD(row[balIndex]);
            if (balAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
            row[balIndex.intValue()] = balAmount.abs();
            directionChange = true;
        }
        if (directionChange) {
            Integer dcIndex = fieldMap.get(dcField);
            if ("1".equals(accountDC)) {
                row[dcIndex.intValue()] = Character.valueOf('\u8d37');
            }
            if ("-1".equals(accountDC)) {
                row[dcIndex.intValue()] = Character.valueOf('\u501f');
            }
        }
    }

    private static void mergeDebitCreditValue(String debit, String credit, List<String> amountTypes, DynamicObject obj, String accountDC, Boolean bIsShowByAccountDC) {
        for (String type : amountTypes) {
            BigDecimal creditAmt;
            if (bIsShowByAccountDC.booleanValue()) {
                if (accountDC.equals("1")) {
                    if (obj.getBigDecimal(credit + type).compareTo(BigDecimal.ZERO) == 0) continue;
                    obj.set(debit + type, (Object)obj.getBigDecimal(debit + type).subtract(obj.getBigDecimal(credit + type)));
                    obj.set(credit + type, (Object)BigDecimal.ZERO);
                    continue;
                }
                if (obj.getBigDecimal(debit + type).compareTo(BigDecimal.ZERO) == 0) continue;
                obj.set(credit + type, (Object)obj.getBigDecimal(credit + type).subtract(obj.getBigDecimal(debit + type)));
                obj.set(debit + type, (Object)BigDecimal.ZERO);
                continue;
            }
            BigDecimal debitAmt = obj.getBigDecimal(debit + type);
            BigDecimal diffAmt = debitAmt.subtract(creditAmt = obj.getBigDecimal(credit + type));
            if (diffAmt.compareTo(BigDecimal.ZERO) > 0) {
                obj.set(debit + type, (Object)diffAmt);
                obj.set(credit + type, (Object)BigDecimal.ZERO);
                continue;
            }
            obj.set(credit + type, (Object)creditAmt.subtract(debitAmt));
            obj.set(debit + type, (Object)BigDecimal.ZERO);
        }
    }

    public static Object subtract(Object val1, Object val2) {
        if (val1 == null) {
            if (val2 == null) {
                return null;
            }
            if (val2 instanceof BigDecimal) {
                return ((BigDecimal)val2).negate();
            }
            if (val2 instanceof Integer) {
                return -((Integer)val2).intValue();
            }
            if (val2 instanceof Double || val2 instanceof Float || val2 instanceof Long) {
                return new BigDecimal(val2.toString()).negate();
            }
            throw new KDBizException("value type not support2");
        }
        if (val2 == null) {
            return val1;
        }
        if (val1 instanceof BigDecimal) {
            return ((BigDecimal)val1).subtract((BigDecimal)val2);
        }
        if (val1 instanceof Integer) {
            return (Integer)val1 - (Integer)val2;
        }
        if (val1 instanceof Double || val1 instanceof Float || val1 instanceof Long) {
            return new BigDecimal(val1.toString()).subtract(new BigDecimal(val2.toString()));
        }
        throw new KDBizException("value type not support3");
    }

    private static void mergeDebitCreditValue(String debit, String credit, List<String> amountTypes, Object[] obj, Map<String, Integer> fieldMap, String accountDC, Boolean bIsShowByAccountDC) {
        for (String type : amountTypes) {
            BigDecimal creditAmt;
            Integer creditIndex = fieldMap.get(credit + type);
            Integer debitIndex = fieldMap.get(debit + type);
            if (bIsShowByAccountDC.booleanValue()) {
                if (accountDC.equals("1")) {
                    if (ReportUtils.bigD(obj[creditIndex]).compareTo(BigDecimal.ZERO) == 0) continue;
                    obj[debitIndex.intValue()] = ReportUtils.subtract(obj[debitIndex], obj[creditIndex]);
                    obj[creditIndex.intValue()] = BigDecimal.ZERO;
                    continue;
                }
                if (ReportUtils.bigD(obj[debitIndex]).compareTo(BigDecimal.ZERO) == 0) continue;
                obj[creditIndex.intValue()] = ReportUtils.subtract(obj[creditIndex], obj[debitIndex]);
                obj[debitIndex.intValue()] = BigDecimal.ZERO;
                continue;
            }
            BigDecimal debitAmt = ReportUtils.bigD(obj[debitIndex]);
            BigDecimal diffAmt = debitAmt.subtract(creditAmt = ReportUtils.bigD(obj[creditIndex]));
            if (diffAmt.compareTo(BigDecimal.ZERO) > 0) {
                obj[debitIndex.intValue()] = diffAmt;
                obj[creditIndex.intValue()] = BigDecimal.ZERO;
                continue;
            }
            obj[creditIndex.intValue()] = creditAmt.subtract(debitAmt);
            obj[debitIndex.intValue()] = BigDecimal.ZERO;
        }
    }

    private static BigDecimal bigD(Object o) {
        return o == null ? BigDecimal.ZERO : (BigDecimal)o;
    }

    private static Map<Long, String> getAllActAndDCMap(Long accountTable) {
        HashMap<Long, String> actAndDCMap = new HashMap<Long, String>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accounttable", "=", (Object)accountTable));
        filters.add(new QFilter("id", "=", (Object)"masterid", true));
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"ReportUtils.showRowDataByActDC", (String)"bd_accountview", (String)"masterid,dc", (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : dSet) {
                actAndDCMap.put(row.getLong("masterid"), row.getString("dc"));
            }
        }
        return actAndDCMap;
    }

    public static Map<Long, String> getActAndDCMap(Long defaultOrg, Long accountTableId) {
        if (null != ThreadCache.get((Object)ACCT_DC_CACHE)) {
            String key = defaultOrg + "-" + accountTableId;
            Map map = (Map)ThreadCache.get((Object)ACCT_DC_CACHE);
            if (map.get(key) != null) {
                return (Map)map.get(key);
            }
            Map<Long, String> actAndDCMap = ReportUtils.getAcctDc(defaultOrg, accountTableId);
            map.put(key, actAndDCMap);
            return actAndDCMap;
        }
        String key = defaultOrg + "-" + accountTableId;
        HashMap<String, Map<Long, String>> map = new HashMap<String, Map<Long, String>>(8);
        Map<Long, String> actAndDCMap = ReportUtils.getAcctDc(defaultOrg, accountTableId);
        map.put(key, actAndDCMap);
        ThreadCache.put((Object)ACCT_DC_CACHE, map);
        return actAndDCMap;
    }

    private static Map<Long, String> getAcctDc(Long defaultOrg, Long accountTableId) {
        HashMap<Long, String> actAndDCMap = new HashMap<Long, String>();
        try (DataSet dSet = AccountUtils.queryAccountDataSet((long)defaultOrg, (long)accountTableId, (String)"masterid,dc", null);){
            for (Row row : dSet) {
                actAndDCMap.put(row.getLong("masterid"), row.getString("dc"));
            }
        }
        return actAndDCMap;
    }

    public static Boolean getShowByActDCSysParam(Long curOrgId) {
        AppParam param = new AppParam("83bfebc8000017ac", "10", curOrgId, Long.valueOf(0L));
        Boolean bIsShowByAccountDC = (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"showbyaccountdc");
        bIsShowByAccountDC = bIsShowByAccountDC == null ? Boolean.FALSE : bIsShowByAccountDC;
        return bIsShowByAccountDC;
    }

    public static DataSet getAccountInfos(Long orgId, Long accountTableId, Date endDate) {
        return ReportUtils.getAccountInfos(orgId, accountTableId, endDate, null);
    }

    public static DataSet getAccountInfos(Long orgId, Long accountTableId, Date endDate, Set<Long> masterIdSet) {
        String accountNameField = GLUtil.getAcctNameBySysParam(orgId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter fstartDate = new QFilter("startdate", "<=", (Object)endDate);
        QFilter fendDate = new QFilter("enddate", ">=", (Object)endDate);
        qFilters.add(fstartDate);
        qFilters.add(fendDate);
        if (!CollectionUtils.isEmpty(masterIdSet)) {
            qFilters.add(new QFilter("masterid", "in", masterIdSet));
        }
        return AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)String.format("masterid, id account, dc, %s name, number", accountNameField), qFilters);
    }

    public static DataSet getAccountInfos(Long orgId, Set<Long> accountMasterIdSet, Date endDate) {
        String accountNameField = GLUtil.getAcctNameBySysParam(orgId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("startdate", "<=", (Object)endDate));
        qFilters.add(new QFilter("enddate", ">=", (Object)endDate));
        qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
        qFilters.add(new QFilter("masterid", "in", accountMasterIdSet));
        return QueryServiceHelper.queryDataSet((String)"ReportUtil.getAccountInfos", (String)"bd_accountview", (String)String.format("masterid, id account, dc, %s name, number", accountNameField), (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }

    public static Map<Long, DynamicObject> getAccountInfos(Long orgId, Long accountTableId, String accountNameField, Date endDate) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter atF = new QFilter("accounttable", "=", (Object)accountTableId);
        qFilters.add(atF);
        HashMap<Long, DynamicObject> masterIdAndNameMap = new HashMap<Long, DynamicObject>();
        QFilter fstartDate = new QFilter("startdate", "<=", (Object)endDate);
        QFilter fendDate = new QFilter("enddate", ">=", (Object)endDate);
        qFilters.add(fstartDate);
        qFilters.add(fendDate);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountview", (String)("masterid,number," + accountNameField + " name,dc"), (QFilter[])qFilters.toArray(new QFilter[0]));
        for (DynamicObject obj : coll) {
            masterIdAndNameMap.put(obj.getLong("masterid"), obj);
        }
        return masterIdAndNameMap;
    }

    private static Map<String, Tuple2<String, Set<Object>>> buildAssistMap(FilterInfo filter) {
        LinkedHashMap<String, Tuple2<String, Set<Object>>> assistMap = new LinkedHashMap<String, Tuple2<String, Set<Object>>>(32);
        List items = filter.getFlexFilterItems();
        for (FilterItemInfo filterItemInfo : items) {
            String propName = filterItemInfo.getPropName();
            String entityId = ReportUtils.fillAssistTypeName(propName);
            HashSet value = (HashSet)filterItemInfo.getValue();
            if (entityId == null) {
                assistMap.put(propName, (Tuple2<String, Set<Object>>)new Tuple2((Object)TYPE_TXT, (Object)value));
                continue;
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (dataEntityType.getPrimaryKey() instanceof VarcharProp) {
                assistMap.put(propName, (Tuple2<String, Set<Object>>)new Tuple2((Object)TYPE_BASE_STRING, (Object)value));
                continue;
            }
            assistMap.put(propName, (Tuple2<String, Set<Object>>)new Tuple2((Object)TYPE_BASE_LONG, (Object)value));
        }
        return assistMap;
    }

    private static String fillAssistTypeName(String propName) {
        QFilter qFilter = new QFilter("flexfield", "=", (Object)propName);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)ASSIST_TYPE, (String)"name,valuesource,valuetype", (QFilter[])new QFilter[]{qFilter});
        String valType = queryOne.getString("valuetype");
        String entityId = null;
        switch (valType) {
            case "1": {
                entityId = queryOne.getString("valuesource");
                break;
            }
            case "2": {
                entityId = "bos_assistantdata_detail";
            }
        }
        return entityId;
    }

    public static List<Long> getVerAcctTable(long orgId, long bookTypeId, long periodTypeId, Date endDate) {
        QFilter forg = new QFilter("org", "=", (Object)orgId);
        QFilter fbt = new QFilter("booktype", "=", (Object)bookTypeId);
        DynamicObjectCollection reCol = QueryServiceHelper.query((String)"gl_book_version", (String)"oldaccttab,accounttable,enableperiod", (QFilter[])new QFilter[]{forg, fbt}, (String)"enableperiod desc");
        ArrayList<Long> acctTableIds = new ArrayList<Long>(2);
        if (!reCol.isEmpty()) {
            QFilter fbegin = new QFilter("begindate", "<=", (Object)endDate);
            QFilter fend = new QFilter("enddate", ">=", (Object)endDate);
            QFilter ftype = new QFilter("periodtype", "=", (Object)periodTypeId);
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fbegin, fend, ftype}, (String)"id desc", (int)1);
            long periodId = ((DynamicObject)col.get(0)).getLong("id");
            if (reCol.size() == 1) {
                DynamicObject obj = (DynamicObject)reCol.get(0);
                if (periodId > obj.getLong("enableperiod")) {
                    acctTableIds.add(obj.getLong("accounttable"));
                } else if (periodId == obj.getLong("enableperiod")) {
                    acctTableIds.add(obj.getLong("accounttable"));
                    acctTableIds.add(obj.getLong("oldaccttab"));
                } else {
                    acctTableIds.add(obj.getLong("oldaccttab"));
                }
            } else {
                int size = col.size();
                int i = 0;
                for (DynamicObject rec : reCol) {
                    ++i;
                    if (periodId > rec.getLong("enableperiod")) {
                        acctTableIds.add(rec.getLong("accounttable"));
                    } else if (periodId == rec.getLong("enableperiod")) {
                        acctTableIds.add(rec.getLong("accounttable"));
                        acctTableIds.add(rec.getLong("oldaccttab"));
                    }
                    if (size != i) continue;
                    acctTableIds.add(rec.getLong("oldaccttab"));
                }
            }
        } else {
            QFilter fbts = new QFilter("bookstype", "=", (Object)bookTypeId);
            DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{forg, fbts});
            if (book != null) {
                acctTableIds.add(book.getLong("accounttable"));
            }
        }
        return acctTableIds;
    }

    public static String isOverAcctVer(Date begin, Date end, long periodTypeId, long orgId, long bookTypeId) {
        return ReportUtils.isOverAcctVer(begin, end, periodTypeId, Collections.singletonList(orgId), bookTypeId);
    }

    public static String isOverAcctVer(Date begin, Date end, long periodTypeId, List<Long> orgIds, long bookTypeId) {
        Tuple<String, String> acctVerTuple = ReportUtils.overAcctVer(begin, end, periodTypeId, orgIds, bookTypeId);
        if (Objects.nonNull(acctVerTuple)) {
            return (String)acctVerTuple.item1;
        }
        return null;
    }

    public static Tuple<String, String> overAcctVer(Date begin, Date end, long periodTypeId, List<Long> orgIds, long bookTypeId) {
        QFilter fbegin = new QFilter("begindate", "<=", (Object)begin);
        QFilter fend = new QFilter("enddate", ">=", (Object)begin);
        QFilter ftype = new QFilter("periodtype", "=", (Object)periodTypeId);
        DynamicObject startP = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,periodyear", (QFilter[])new QFilter[]{fbegin, fend, ftype});
        if (startP == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6b63\u786e\u7684\u65e5\u671f\u3002", (String)"ReportUtils_3", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        fbegin = new QFilter("begindate", "<=", (Object)end);
        fend = new QFilter("enddate", ">=", (Object)end);
        DynamicObjectCollection pCol = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear", (QFilter[])new QFilter[]{fbegin, fend, ftype}, (String)"id desc", (int)1);
        DynamicObject endP = null;
        if (pCol.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReportUtils_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        endP = (DynamicObject)pCol.get(0);
        long endPId = endP.getLong("id");
        QFilter forg = new QFilter("org", "in", orgIds);
        QFilter fbt = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter fs = null;
        QFilter fe = null;
        long startPId = startP.getLong("id");
        if (startPId == endPId) {
            fs = new QFilter("enableperiod", ">", (Object)startPId);
            fe = new QFilter("enableperiod", "<", (Object)endPId);
        } else {
            fs = new QFilter("enableperiod", ">=", (Object)startPId);
            fe = new QFilter("enableperiod", "<=", (Object)endPId);
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_book_version", (String)"enableperiod.name, org.name", (QFilter[])new QFilter[]{fs, fe, forg, fbt}, (String)"enableperiod desc", (int)1);
        if (col != null && !col.isEmpty()) {
            String periodName = ((DynamicObject)col.get(0)).getString("enableperiod.name");
            String orgName = ((DynamicObject)col.get(0)).getString("org.name");
            return new Tuple((Object)periodName, (Object)orgName);
        }
        return null;
    }

    public static List<QFilter> tableHeadFilter2QFilters(List<FilterItemInfo> tableHeadFilters, Map<String, Tuple<String, Class<?>>> map) {
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>(tableHeadFilters.size());
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        tableHeadFilters.forEach(filterItemInfo -> {
            String propName = filterItemInfo.getPropName();
            if (!map.containsKey(propName)) {
                return;
            }
            String comparator = filterItemInfo.getCompareType();
            String sourceName = (String)((Tuple)map.get((Object)propName)).item1;
            Class type = (Class)((Tuple)map.get((Object)propName)).item2;
            Object value = null;
            switch (type.getSimpleName()) {
                case "String": {
                    if (filterItemInfo.getValue() instanceof List) {
                        value = filterItemInfo.getValue();
                        break;
                    }
                    value = filterItemInfo.getString();
                    if (comparator.equalsIgnoreCase("in")) {
                        comparator = "=";
                        break;
                    }
                    if (comparator.equals("LIKE")) {
                        value = String.format("%%%s%%", value);
                        break;
                    }
                    if (comparator.equals("lIKE")) {
                        value = String.format("%s%%", value);
                        break;
                    }
                    if (comparator.equals("like")) {
                        value = String.format("%%%s", value);
                        break;
                    }
                    if (comparator.equalsIgnoreCase("isnull")) {
                        comparator = "=";
                        break;
                    }
                    if (!comparator.equalsIgnoreCase("notisnull")) break;
                    comparator = "!=";
                    break;
                }
                case "Integer": {
                    value = filterItemInfo.getInt();
                    break;
                }
                case "BigDecimal": {
                    value = filterItemInfo.getBigDecimal();
                    break;
                }
                case "Long": {
                    value = filterItemInfo.getLong();
                    break;
                }
                default: {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u89e3\u6790\u8be5\u7c7b\u578b\uff1a%s\u3002", (String)"ReportUtils_2", (String)"fi-gl-common", (Object[])new Object[0]), type.getSimpleName()));
                }
            }
            resultFilter.add(new QFilter(sourceName, comparator, value));
        });
        return resultFilter;
    }

    public static DataSet queryVoucherByAssistGrp(FilterInfo filterInfo, QFilter[] additionalFilters, String selectedFields, String orderBys, int limit) {
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_voucher", (IDataEntityType)ReportUtils.buildEnhanceAssistgrpEntity(filterInfo, "gl_voucher"));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.addAll(Arrays.asList(additionalFilters));
        Tuple<List<QFilter>, List<String>> assgrpTuple = ReportUtils.buildVoucherAssGrpFilter(filterInfo, "gl_voucher");
        filters.addAll((Collection)assgrpTuple.item1);
        ArrayList<String> fieldsList = new ArrayList<String>(16);
        fieldsList.addAll((Collection)assgrpTuple.item2);
        fieldsList.add(selectedFields);
        return orm.queryDataSet(ReportUtils.class.getName() + "/", "gl_voucher", Joiner.on((String)",").join(fieldsList), filters.toArray(new QFilter[0]), orderBys, limit);
    }

    public static MainEntityType buildEnhanceAssistgrpEntity(FilterInfo filterInfo, String entity) {
        Map<String, Set> flexField2SelectedValues = filterInfo.getFlexFilterItems().stream().collect(Collectors.toMap(FilterItemInfo::getPropName, filterItemInfo -> (Set)filterItemInfo.getValue()));
        Map<String, AssistBalanceQuery.CustomFlexProperty> flexField2Property = FlexUtils.batchGetFlexProperty(flexField2SelectedValues.keySet().toArray(new String[0])).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new AssistBalanceQuery.CustomFlexProperty((FlexProperty)entry.getValue())));
        try {
            MainEntityType mainEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)entity).clone();
            EntityType entriesType = null;
            if ("gl_voucher".equals(entity)) {
                entriesType = (EntityType)mainEntity.getAllEntities().get("entries");
            }
            for (AssistBalanceQuery.CustomFlexProperty flexProperty : flexField2Property.values()) {
                BasedataProp flexProp = new BasedataProp();
                flexProp.setAlias("fassgrpid");
                flexProp.setName(flexProperty.getCustomPropKey());
                String flexPropEntity = AssistValueType.isManualTxt(flexProperty.property.getValueType()) ? ASSIST_TXT : ASSIST_DB;
                DynamicObjectType clonedFlexType = (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)flexPropEntity).clone();
                ((LongProp)clonedFlexType.getProperties().get((Object)"id")).setAlias("fid");
                flexProp.setComplexType((IDataEntityType)clonedFlexType);
                if (null != entriesType) {
                    entriesType.addProperty((DynamicProperty)flexProp);
                    continue;
                }
                mainEntity.addProperty((DynamicProperty)flexProp);
            }
            return mainEntity;
        }
        catch (CloneNotSupportedException e) {
            LogFactory.getLog(ReportUtils.class).error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static Tuple<List<QFilter>, List<String>> buildVoucherAssGrpFilter(FilterInfo filterInfo, String entity) {
        ArrayList<QFilter> assistGrpFilters = new ArrayList<QFilter>(8);
        ArrayList<String> selectedFields = new ArrayList<String>(8);
        Map<String, Tuple2<String, Set<Object>>> assistMap = ReportUtils.buildAssistMap(filterInfo);
        int index = 0;
        String assgrp_ = "assgrp_";
        if ("gl_voucher".equals(entity)) {
            assgrp_ = "entries.assgrp_";
        }
        for (Map.Entry<String, Tuple2<String, Set<Object>>> entry : assistMap.entrySet()) {
            String flexfield = entry.getKey();
            Tuple2<String, Set<Object>> tuple2 = entry.getValue();
            Set objSet = (Set)tuple2.t2;
            if (objSet != null && objSet.size() > 0) {
                QFilter fflex = new QFilter(assgrp_ + flexfield + ".asstype", "=", (Object)flexfield);
                QFilter fvalue = new QFilter(assgrp_ + flexfield + ".assval", "in", (Object)objSet);
                assistGrpFilters.add(fflex);
                assistGrpFilters.add(fvalue);
            } else {
                assistGrpFilters.add(QFilter.join((String)(assgrp_ + flexfield), (String)(assgrp_ + flexfield + ".hg"), (QFilter)new QFilter(assgrp_ + flexfield + ".asstype", "=", (Object)flexfield), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)false));
            }
            selectedFields.add(String.format("%s%s.assval %s", assgrp_, flexfield, flexfield));
            ++index;
        }
        return Tuple.create(assistGrpFilters, selectedFields);
    }

    public static Boolean checkIfDetailOutOfLimit(ReportQueryParam queryParam) {
        try {
            CachedDataSet batchByDS = queryParam.byBatchInfo().getBatchBy();
            if (batchByDS != null) {
                String queryID = batchByDS.getCacheId() + "#queryID";
                DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.report);
                Boolean isDetailOutOfLimit = Optional.ofNullable(distributeCache.get(queryID)).map(contextJson -> new Context((Map)JsonObjectAdapter.fromJson((String)contextJson).getSource())).map(context1 -> (Boolean)Optional.ofNullable(context1.query("TotalCalculateReportPlugin.isTotalCalculateWithDetailDS")).orElse(Boolean.TRUE)).orElse(Boolean.TRUE) == false;
                return isDetailOutOfLimit;
            }
        }
        catch (Exception e) {
            LogFactory.getLog(ReportUtils.class).warn((Throwable)e);
        }
        return false;
    }

    public static Map<Long, DynamicObject> getVoucherInfo(List<ReportFieldSettingVo> displayFields, DynamicObjectCollection rowData) {
        HashMap<Long, DynamicObject> vchMap = new HashMap<Long, DynamicObject>(rowData.size());
        if (displayFields.isEmpty()) {
            return vchMap;
        }
        ArrayList<Long> vchIds = new ArrayList<Long>(200);
        ArrayList<Long> vchEntryIds = new ArrayList<Long>(200);
        for (DynamicObject row : rowData) {
            if (row.getLong("voucherid") == 0L) continue;
            vchIds.add(row.getLong("voucherid"));
            vchEntryIds.add(row.getLong("fentryid"));
        }
        return ReportUtils.getVoucherInfo(displayFields, vchIds, vchEntryIds);
    }

    public static Map<Long, DynamicObject> getVoucherInfoMap(List<ReportFieldSettingVo> cusVoucherFields, List<SubsidiaryRow> dataList) {
        Map<Long, DynamicObject> voucherInfoMap = new HashMap<Long, DynamicObject>(dataList.size());
        if (!CollectionUtils.isEmpty(dataList) && !CollectionUtils.isEmpty(cusVoucherFields)) {
            ArrayList<Long> vchIds = new ArrayList<Long>(dataList.size());
            ArrayList<Long> vchEntryIds = new ArrayList<Long>(dataList.size());
            dataList.stream().forEach(x -> {
                vchIds.add(x.getVoucherId());
                vchEntryIds.add(x.getVoucherEntryId());
            });
            voucherInfoMap = ReportUtils.getVoucherInfo(cusVoucherFields, vchIds, vchEntryIds);
        }
        return voucherInfoMap;
    }

    public static Map<Long, DynamicObject> getVoucherInfo(List<ReportFieldSettingVo> displayFields, List<Long> vchIds, List<Long> vchEntryIds) {
        Map<Long, DynamicObject> vchMap = new HashMap<Long, DynamicObject>(vchEntryIds.size());
        if (displayFields.isEmpty()) {
            return vchMap;
        }
        StringBuilder selectFieldBuilder = new StringBuilder();
        for (ReportFieldSettingVo vo : displayFields) {
            selectFieldBuilder.append(vo.getFieldMark()).append(",");
        }
        if (selectFieldBuilder.length() > 1 && !vchIds.isEmpty()) {
            selectFieldBuilder.append("id,entries.id");
            String selectFields = selectFieldBuilder.toString();
            QFilter filter = new QFilter("id", "in", vchIds).and(new QFilter("entries.id", "in", vchEntryIds));
            DynamicObjectCollection voucherObj = QueryServiceHelper.query((String)"gl_voucher", (String)selectFields, (QFilter[])filter.toArray());
            vchMap = voucherObj.stream().collect(Collectors.toMap(x -> x.getLong("entries.id"), x -> x));
        }
        return vchMap;
    }

    public static Set<Long> getSelectedLeafChildMids(FilterInfo filterInfo, List<Long> orgs, long acctTableId, Date endDate) {
        boolean selectLargeNum;
        DynamicObjectCollection selectAccts = filterInfo.getDynamicObjectCollection("account");
        HashSet selectedLongNums = new HashSet(128);
        QFilter numFilter = null;
        if (!CollectionUtils.isEmpty((Collection)selectAccts)) {
            selectAccts.stream().map(dyo -> dyo.getString("longnumber")).forEach(selectedLongNums::add);
        }
        boolean bl = selectLargeNum = selectedLongNums.size() > 20;
        if (selectedLongNums.size() > 0 && !selectLargeNum) {
            numFilter = QFilter.of((String)selectedLongNums.stream().map(num -> "longnumber like '" + num + "%' ").collect(Collectors.joining(" or ")), (Object[])new Object[0]);
        }
        HashSet<Long> leafChildMid = new HashSet<Long>(selectedLongNums.size());
        kd.fi.gl.util.AccountUtils.getAccountDataSet(orgs, acctTableId, endDate, true, numFilter, "masterid", "longnumber").forEach(acct -> {
            Long mid = acct.getLong("masterid");
            if (selectLargeNum) {
                String longNum = acct.getString("longnumber");
                boolean isChildNum = selectedLongNums.stream().anyMatch(longNum::startsWith);
                if (isChildNum) {
                    leafChildMid.add(mid);
                }
            } else {
                leafChildMid.add(mid);
            }
        });
        return leafChildMid;
    }

    public static Set<Long> getAccIdSetByFlexFields(MulOrgQPRpt qParam, ReportQueryParam reportQueryParam) {
        HashSet<Long> accIdSet;
        if (qParam.getAccountList() != null) {
            accIdSet = new HashSet<Long>(qParam.getAccountList());
        } else {
            Set<String> assistProps = FlexUtils.buildAssistFilterInfo(reportQueryParam).stream().map(FlexUtils.AssistFilterEntry::getProperty).collect(Collectors.toSet());
            DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)qParam.getEndPeriod()).toArray());
            QFilter atFilter = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
            atFilter.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
            atFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)qParam.getPorg()));
            Set<Long> ids = ReportUtils.getAccIdsByFlexFields(qParam.getAccountTable(), assistProps);
            QFilter fid = new QFilter("id", "in", ids);
            accIdSet = new HashSet(ids.size());
            HashSet<Long> masterIdSet = new HashSet<Long>(ids.size());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getAccIds", (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{atFilter, fid}, null);){
                for (Row row : ds) {
                    accIdSet.add(row.getLong("id"));
                    masterIdSet.add(row.getLong("masterid"));
                }
            }
            qParam.setMasterIdSet(masterIdSet);
            qParam.setAccountList(new ArrayList<Long>(accIdSet));
        }
        return accIdSet;
    }

    protected static List<ComboItem> getCurrencyItems(boolean hasBaseCurrency, boolean hasAllCurrency) {
        ArrayList<ComboItem> currColl = new ArrayList<ComboItem>();
        if (hasBaseCurrency) {
            ComboItem baseCur = new ComboItem();
            baseCur.setValue(CURRENCY_TYPE_BASE);
            baseCur.setCaption(ReportUtils.getBaseCurrency());
            currColl.add(baseCur);
        }
        if (hasAllCurrency) {
            ComboItem allCur = new ComboItem();
            allCur.setValue(CURRENCY_TYPE_ALL);
            allCur.setCaption(ReportUtils.getAllCurrency());
            currColl.add(allCur);
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_currency", (String)"id, name", null);
        for (DynamicObject obj : coll) {
            ComboItem item = new ComboItem();
            item.setValue(obj.getString("id"));
            item.setCaption(new LocaleString(obj.getString("name")));
            currColl.add(item);
        }
        return currColl;
    }

    private static LocaleString getBaseCurrency() {
        return new LocaleString(ResManager.loadKDString((String)"\u7efc\u5408\u672c\u4f4d\u5e01", (String)"ReportUtils_5", (String)"fi-gl-common", (Object[])new Object[0]));
    }

    protected static LocaleString getAllCurrency() {
        return new LocaleString(ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"ReportUtils_6", (String)"fi-gl-common", (Object[])new Object[0]));
    }
}

