/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export.convert;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Row;
import kd.bos.entity.report.ReportQueryParam;
import kd.fi.bd.model.Context;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.subsidiary.SubsidiaryAccount;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryRow;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SubsiDiaryHelper;

public class AuxPeriodBeginConverter
implements IDatasetRowTypeConverter<SubsidiaryRow> {
    @Override
    public SubsidiaryRow convertTo(Context context, Row row) {
        return null;
    }

    @Override
    public SubsidiaryRow convertTo(ReportQueryParam param, Row row) {
        Map orgCurLocalMap = (Map)param.getCustomParam().get("orgCurLocalMap");
        QueryParamRpt qpRpt = (QueryParamRpt)param.getCustomParam().get("queryParamRpt");
        Map acctMID2IDMap = (Map)param.getCustomParam().get("acctMID2IDMap");
        List flexFieldNames = (List)param.getCustomParam().get("flexFieldNames");
        Map periodMap = (Map)param.getCustomParam().get("periodMap");
        String beginVoucherDesc = (String)param.getCustomParam().get("beginVoucherDesc");
        ArrayList<Object> groupKeys = new ArrayList<Object>(16);
        SubsidiaryRow subsidiaryRow = new SubsidiaryRow();
        subsidiaryRow.setRowtype("1");
        Long orgId = row.getLong("org");
        subsidiaryRow.setOrgId(orgId);
        groupKeys.add(orgId);
        Tuple[] flexTuple = new Tuple[flexFieldNames.size()];
        for (int i = 0; i < flexFieldNames.size(); ++i) {
            flexTuple[i] = Tuple.create(flexFieldNames.get(i), row.get((String)flexFieldNames.get(i)));
            groupKeys.add(row.get((String)flexFieldNames.get(i)));
        }
        subsidiaryRow.setFlexTuple(flexTuple);
        Long acctMid = row.getLong("account");
        SubsidiaryAccount account = (SubsidiaryAccount)acctMID2IDMap.get(acctMid);
        if (Objects.isNull(account)) {
            SubsiDiaryHelper.addAcctMID2IDMap(param, row, acctMID2IDMap, qpRpt);
            account = (SubsidiaryAccount)acctMID2IDMap.get(acctMid);
        }
        subsidiaryRow.setAccountId(account.getId());
        subsidiaryRow.setAccountMasterId(acctMid);
        subsidiaryRow.setAccountNumber(account.getNumber());
        subsidiaryRow.setAccountName(account.getName());
        groupKeys.add(account.getNumber());
        subsidiaryRow.setAccountDc(account.getDc());
        Long startPeriod = row.getLong("period");
        Long endPeriod = row.getLong("endperiod");
        subsidiaryRow.setEndLocal(this.getEndBalance(row, "endlocal", qpRpt, startPeriod, endPeriod));
        subsidiaryRow.setYearDebitLocal(this.getYearBalance(row, "yeardebitlocal", qpRpt, startPeriod, endPeriod));
        subsidiaryRow.setYearCreditLocal(this.getYearBalance(row, "yearcreditlocal", qpRpt, startPeriod, endPeriod));
        subsidiaryRow.setBaseCurrency((Long)orgCurLocalMap.get(orgId));
        if (qpRpt.isQueryCurrency()) {
            Long currency = row.getLong("currency");
            subsidiaryRow.setCurrencyId(currency);
            groupKeys.add(currency);
            subsidiaryRow.setEndFor(this.getEndBalance(row, "endfor", qpRpt, startPeriod, endPeriod));
            subsidiaryRow.setYearDebitFor(this.getYearBalance(row, "yeardebitfor", qpRpt, startPeriod, endPeriod));
            subsidiaryRow.setYearCreditFor(this.getYearBalance(row, "yearcreditfor", qpRpt, startPeriod, endPeriod));
        }
        if (qpRpt.isNoZeroAmount()) {
            subsidiaryRow.setCount(this.getCount(row, qpRpt));
        }
        subsidiaryRow.setPeriodId(0L);
        subsidiaryRow.setPeriodYear(((SubsidiaryPeriod)periodMap.get(qpRpt.getStartPeriod())).getPeriodyear());
        subsidiaryRow.setVoucherDesc(beginVoucherDesc);
        subsidiaryRow.setGroupKey(Joiner.on((String)"_").useForNull("_").join(groupKeys));
        return subsidiaryRow;
    }

    private BigDecimal getYearBalance(Row row, String yearBalanceKey, QueryParamRpt qpRpt, Long startPeriod, Long endPeriod) {
        BigDecimal tempBalance = BigDecimal.ZERO;
        BigDecimal tempYearBalance = BigDecimal.ZERO;
        if (startPeriod.longValue() == qpRpt.getStartPeriod()) {
            tempBalance = row.getBigDecimal(yearBalanceKey.replace("year", ""));
        }
        long yearFlag = qpRpt.getStartPeriod() / GLUtil.YEAR_PERIOD_L * GLUtil.YEAR_PERIOD_L;
        if (endPeriod > qpRpt.getStartPeriod() && startPeriod <= qpRpt.getStartPeriod() && startPeriod > yearFlag) {
            tempYearBalance = row.getBigDecimal(yearBalanceKey);
        }
        return tempYearBalance.subtract(tempBalance);
    }

    private BigDecimal getEndBalance(Row row, String balanceKey, QueryParamRpt qpRpt, Long startPeriod, Long endPeriod) {
        if (startPeriod.longValue() == qpRpt.getStartPeriod()) {
            return row.getBigDecimal(balanceKey.replace("end", "begin"));
        }
        if (startPeriod < qpRpt.getStartPeriod() && endPeriod > qpRpt.getStartPeriod()) {
            return row.getBigDecimal(balanceKey);
        }
        return BigDecimal.ZERO;
    }

    private Long getCount(Row row, QueryParamRpt qpRpt) {
        if (qpRpt.getStartPeriod() <= row.getLong("period") && row.getLong("period") <= qpRpt.getEndPeriod()) {
            return row.getLong("count");
        }
        return 0L;
    }
}

