/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.taxreport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.taxreport.AbstractTaxReportDataHandler;
import kd.fi.gl.util.TaxReportFormHelper;
import kd.fi.gl.util.TaxReportParam;

public class IncomeDataHandler
extends AbstractTaxReportDataHandler {
    @Override
    protected DynamicObjectCollection getParentBalSheet(TaxReportParam param) {
        return TaxReportFormHelper.getIncomeEdit(Collections.singleton(param.getParentOrg()), param.getAccTableId(), param.getType(), new QFilter("booktype", "=", (Object)param.getBookTypeId()).toArray());
    }

    @Override
    protected DynamicObjectCollection getChildBalSheet(Long childOrg, TaxReportParam param) {
        return TaxReportFormHelper.getIncomeEdit(Collections.singleton(childOrg), param.getAccTableId(), param.getType(), new QFilter("booktype", "=", (Object)param.getBookTypeId()).toArray());
    }

    @Override
    protected List<List<BigDecimal>> collectChildOrgBal(Long childOrg, TaxReportParam param) {
        return TaxReportFormHelper.collectBal(Collections.singletonList(childOrg), Collections.singleton(childOrg), param.getOrgViewId(), param.getBookTypeId(), param.getAccTableId(), param.getPeriodTypeId(), param.getPeriodId(), param.getType(), param.getEntityType(), param.getAmtprecision(), false);
    }

    @Override
    protected DynamicObjectCollection getSheetExps(TaxReportParam param) {
        Set<Long> orgIds = Collections.singleton(param.getParentOrg());
        return TaxReportFormHelper.getIncomeExps(orgIds, param.getAccTableId(), param.getBookTypeId(), param.getType());
    }

    @Override
    protected void handleSingleOrgRowAmt(Map<Long, Tuple<String, BigDecimal[]>> itemAndAmtMap, DynamicObjectCollection childBalSheet, List<List<BigDecimal>> resultList, TaxReportParam param) {
        for (int i = 0; i < childBalSheet.size(); ++i) {
            DynamicObject childBal = (DynamicObject)childBalSheet.get(i);
            List<BigDecimal> balVals = resultList.get(i);
            Long masterId = childBal.getLong("projectmasterid");
            BigDecimal[] amtVals = (BigDecimal[])itemAndAmtMap.get((Object)masterId).item2;
            if (amtVals == null) continue;
            amtVals[0] = amtVals[0].add(balVals.get(0));
            amtVals[1] = amtVals[1].add(balVals.get(1));
        }
    }

    @Override
    protected Map<String, List<BigDecimal>> transToMap(Map<Long, Tuple<String, BigDecimal[]>> itemAndAmtMap, List<Long> rowAndItemMap, TaxReportParam param) {
        LinkedHashMap<String, List<BigDecimal>> resultMap = new LinkedHashMap<String, List<BigDecimal>>(itemAndAmtMap.size());
        for (Long item : rowAndItemMap) {
            ArrayList<BigDecimal> singleRow = new ArrayList<BigDecimal>(4);
            BigDecimal[] amt = (BigDecimal[])itemAndAmtMap.get((Object)item).item2;
            if (amt != null) {
                singleRow.add(amt[0]);
                singleRow.add(amt[1]);
            } else {
                singleRow.add(BigDecimal.ZERO);
                singleRow.add(BigDecimal.ZERO);
            }
            resultMap.put((String)itemAndAmtMap.get((Object)item).item1, (List<BigDecimal>)singleRow);
        }
        return resultMap;
    }
}

