/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.fi.gl.tools.IAssistIdFinder;
import kd.fi.gl.tools.dao.AssistReplaceVO;
import kd.fi.gl.tools.dao.ReplaceRecordDAO;

public class DuplicateAssistIdFinder
implements IAssistIdFinder {
    private static final int BATCH_1000 = 1000;

    @Override
    public void prepareReplaceAssistIds() {
        ArrayList<AssistReplaceVO> voBuffer = new ArrayList<AssistReplaceVO>(1000);
        try (DataSet ds = DB.queryDataSet((String)"queryDuplicatedAssistIds", (DBRoute)DBRoute.of((String)"fi"), (String)"select fvalue, fid from t_gl_assist order by fvalue, fid asc");){
            String preValue = "";
            ArrayList<Long> duplicateIds = new ArrayList<Long>(2);
            while (ds.hasNext()) {
                Row row = ds.next();
                String curValue = row.getString("fvalue");
                Long id = row.getLong("fid");
                if (!curValue.equals(preValue)) {
                    if (duplicateIds.size() > 1) {
                        voBuffer.addAll(DuplicateAssistIdFinder.buildReplaceVOs(duplicateIds));
                        if (voBuffer.size() > 1000) {
                            ReplaceRecordDAO.insert(voBuffer);
                            voBuffer.clear();
                        }
                    }
                    duplicateIds.clear();
                    preValue = curValue;
                }
                duplicateIds.add(id);
            }
            if (duplicateIds.size() > 1) {
                voBuffer.addAll(DuplicateAssistIdFinder.buildReplaceVOs(duplicateIds));
            }
        }
        if (!voBuffer.isEmpty()) {
            ReplaceRecordDAO.insert(voBuffer);
            voBuffer.clear();
        }
    }

    protected static List<AssistReplaceVO> buildReplaceVOs(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (ids.size() == 1) {
            throw new KDBizException("logic error");
        }
        long replaceId = ids.get(0);
        ArrayList<AssistReplaceVO> vos = new ArrayList<AssistReplaceVO>(ids.size() - 1);
        for (int i = 1; i < ids.size(); ++i) {
            vos.add(new AssistReplaceVO(ids.get(i), replaceId));
        }
        return vos;
    }
}

