/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.flex.FlexFilterUtil;
import kd.bos.ext.fi.gl.flexplugin.FilterInfo;
import kd.bos.ext.fi.gl.flexplugin.SourceType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.flex.FlexValue;
import kd.fi.gl.flex.FlexValueEntry;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.FlexUtils;

public class AssgrpDefValUtil {
    public static Object getAssgrpDefVal(Long orgid, Long bookTypeId, Long accounttableid, Long userid, Long accountID, Long selectedCurrency) {
        return AssgrpDefValUtil.getAssgrpDefVal(orgid, bookTypeId, accounttableid, userid, accountID, selectedCurrency, Collections.emptyMap());
    }

    public static Tuple<Object, Map<String, Object>> getAssgrpDefValTuple(Long orgid, Long accounttableid, Long userid, Long accountid, Long selectedCurrency, Map<String, Object> customValues) {
        if (accountid != null && accountid > 0L) {
            Set<String> flexfields = AssgrpDefValUtil.getFlexFields(accountid);
            HashMap<String, Object> oldValues = new HashMap<String, Object>();
            customValues.entrySet().stream().filter(x -> flexfields.contains(x.getKey())).forEach(entry -> oldValues.put((String)entry.getKey(), entry.getValue()));
            flexfields.removeAll(oldValues.keySet());
            Map<String, Object> valMap = AssgrpDefValUtil.getAssgrpDefMap(flexfields, orgid, accounttableid, userid, accountid, selectedCurrency);
            return AssgrpDefValUtil.getAssgrpValTuple(valMap, accountid, flexfields, selectedCurrency, oldValues);
        }
        return null;
    }

    public static Object getAssgrpDefVal(Long orgid, Long bookTypeId, Long accounttableid, Long userid, Long accountid, Long selectedCurrency, Map<String, Object> customValues) {
        if (accountid != null && accountid > 0L) {
            Set<String> flexfields = AssgrpDefValUtil.getFlexFields(accountid);
            HashMap<String, Object> oldValues = new HashMap<String, Object>();
            customValues.entrySet().stream().filter(x -> flexfields.contains(x.getKey())).forEach(entry -> oldValues.put((String)entry.getKey(), entry.getValue()));
            flexfields.removeAll(oldValues.keySet());
            Map<String, Object> valMap = AssgrpDefValUtil.getAssgrpDefMap(flexfields, orgid, accounttableid, userid, accountid, selectedCurrency);
            return AssgrpDefValUtil.getAssgrpVal(orgid, bookTypeId, valMap, accountid, flexfields, selectedCurrency, oldValues);
        }
        return null;
    }

    private static Tuple<Object, Map<String, Object>> getAssgrpValTuple(Map<String, Object> valMap, Long accountid, Set<String> flexfields, Long currency, Map<String, Object> oldValues) {
        Tuple result = null;
        for (String flexfield : flexfields) {
            Object val = AssgrpDefValUtil.getAssgrpValByFlexfield(valMap, accountid, currency, flexfield);
            if (val == null) continue;
            oldValues.put(flexfield, val);
        }
        if (!oldValues.isEmpty()) {
            result = new Tuple((Object)FlexUtils.saveFlexData(oldValues, Boolean.TRUE), oldValues);
        }
        return result;
    }

    private static Object getAssgrpVal(Long orgId, Long bookTypeId, Map<String, Object> valMap, Long accountid, Set<String> flexfields, Long currency, Map<String, Object> oldValues) {
        Long result = null;
        for (String flexfield : flexfields) {
            Object val = AssgrpDefValUtil.getAssgrpValByFlexfield(valMap, accountid, currency, flexfield);
            if (val == null) continue;
            oldValues.put(flexfield, val);
        }
        if (!oldValues.isEmpty()) {
            FlexValue flexValue = new FlexValue(oldValues);
            flexValue.remove(entry -> AssgrpDefValUtil.removeIllegalFlexEntry(orgId, bookTypeId, currency, entry));
            result = FlexUtils.saveFlexData(flexValue.getFlexToValues(), Boolean.TRUE);
        }
        return result;
    }

    public static boolean removeIllegalFlexEntry(Long orgId, Long bookTypeId, Long currencyId, FlexValueEntry valueEntry) {
        String valueSource = valueEntry.getFlexItem().getEntity();
        if (!valueSource.equals("bd_accountbanks") && !valueSource.equals("am_accountbank")) {
            return false;
        }
        FilterInfo bankFilterInfo = FlexFilterUtil.getBankQFilter((long)orgId, (long)bookTypeId, (String)valueSource, (SourceType)SourceType.bill, Collections.singletonList(currencyId), (List)Collections.EMPTY_LIST);
        QFilter finalFilter = bankFilterInfo.getFilter().and("id", "=", valueEntry.getValue());
        return !QueryServiceHelper.exists((String)valueSource, (QFilter[])new QFilter[]{finalFilter});
    }

    public static Set<String> getFlexFields(long accountid) {
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)accountid, (String)"bd_accountview");
        DynamicObjectCollection col = account.getDynamicObjectCollection("checkitementry");
        HashSet<String> flexfields = new HashSet<String>(col.size());
        for (DynamicObject dyn : col) {
            DynamicObject assgrp = dyn.getDynamicObject("asstactitem");
            if (assgrp == null) continue;
            flexfields.add(assgrp.getString("flexfield"));
        }
        return flexfields;
    }

    public static Map<String, Object> getAssgrpDefMap(Set<String> flexfields, Long orgid, Long accounttableid, Long userid, Long accountid, Long newCurrency) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(flexfields.size());
        if (accountid != null && accountid > 0L && orgid > 0L && accounttableid > 0L && !flexfields.isEmpty()) {
            Long acctMasterID = BusinessDataServiceHelper.loadSingleFromCache((Object)accountid, (String)"bd_accountview", (String)"masterid").getLong("masterid");
            QFilter[] filters = AssgrpDefValUtil.buildFilters(flexfields, orgid, accounttableid, userid, acctMasterID, newCurrency);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.AssgrpDefValUtil.getAssgrpMapWithNewCurrency", (String)"gl_assgrpdefval", (String)"entryentity.account.masterid acctmasterid, entryentity.assgrptype.flexfield flexfield, entryentity.basepk basepk, entryentity.txtval txtval, usertype, entryentity.currency currency", (QFilter[])filters, null);){
                for (Row row : ds) {
                    String userStr = row.getString("usertype");
                    String accountStr = row.getString("acctmasterid");
                    String assgrpStr = row.getString("flexfield");
                    String currency = row.getString("currency");
                    String key = String.join((CharSequence)"_", accountStr, userStr, currency, assgrpStr);
                    Object value = row.get("txtval");
                    if (StringUtils.isBlank((Object)value)) {
                        value = row.getLong("basepk");
                    }
                    valMap.put(key, value);
                }
            }
        }
        return valMap;
    }

    private static QFilter[] buildFilters(Set<String> flexfields, Long orgid, Long accounttableid, Long userid, Long masterAccountID, Long selectedCurrency) {
        QFilter userFilter = new QFilter("usertype", "=", (Object)"1").and(new QFilter("muluser.fbasedataid", "=", (Object)userid)).or(new QFilter("usertype", "=", (Object)"0"));
        QFilter accountFilter = new QFilter("entryentity.account.masterid", "=", (Object)masterAccountID).or(new QFilter("entryentity.account", "=", (Object)0L));
        QFilter assgrpFilter = new QFilter("entryentity.assgrptype.flexfield", "in", flexfields);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter acctTableFilter = new QFilter("accounttable", "=", (Object)accounttableid);
        ArrayList<Long> currencyGroup = new ArrayList<Long>(Collections.singletonList(0L));
        if (selectedCurrency != null && selectedCurrency != 0L) {
            currencyGroup.add(selectedCurrency);
        }
        QFilter currencyFilter = new QFilter("entryentity.currency", "in", (Object)currencyGroup.toArray());
        return new QFilter[]{orgFilter, accountFilter, acctTableFilter, userFilter, accountFilter, assgrpFilter, currencyFilter};
    }

    private static Object getAssgrpValByFlexfield(Map<String, Object> valMap, Long accountid, Long currency, String flexfield) {
        String acctMasterID = BusinessDataServiceHelper.loadSingleFromCache((Object)accountid, (String)"bd_accountview", (String)"masterid").getString("masterid");
        String[] actualValue = new String[]{acctMasterID, "1", currency.toString(), flexfield};
        return AssgrpDefValUtil.findTheHighPriorityAndExistingCombination(3, valMap, actualValue, "");
    }

    private static Object findTheHighPriorityAndExistingCombination(int baseElementNumber, Map<String, Object> valMap, String[] actualValue, String curKey) {
        if (baseElementNumber == 0) {
            return AssgrpDefValUtil.getValueOfTheCombinationIfExisted(valMap, actualValue, curKey);
        }
        Object res = AssgrpDefValUtil.findTheHighPriorityAndExistingCombination(baseElementNumber - 1, valMap, actualValue, curKey + (StringUtils.isBlank((CharSequence)curKey) ? "" : "_") + 1);
        if (res != null) {
            return res;
        }
        res = AssgrpDefValUtil.findTheHighPriorityAndExistingCombination(baseElementNumber - 1, valMap, actualValue, curKey + (StringUtils.isBlank((CharSequence)curKey) ? "" : "_") + 0);
        return res;
    }

    private static Object getValueOfTheCombinationIfExisted(Map<String, Object> valMap, String[] actualValue, String curKey) {
        String[] curKeyArr = curKey.split("_");
        StringBuilder actualKey = new StringBuilder("1".equals(curKeyArr[0]) ? actualValue[0] : "0");
        for (int i = 1; i < curKeyArr.length; ++i) {
            actualKey.append("_").append("1".equals(curKeyArr[i]) ? actualValue[i] : "0");
        }
        return valMap.get(actualKey + "_" + actualValue[actualValue.length - 1]);
    }

    public static Object getAssgrpDefVal(Long orgid, Long accounttableid, Long userid, Long accountid) {
        if (accountid != null && accountid > 0L) {
            Set<String> flexfields = AssgrpDefValUtil.getFlexFields(accountid);
            if (orgid > 0L && accounttableid > 0L && !flexfields.isEmpty()) {
                QFilter userFilter = new QFilter("usertype", "=", (Object)"1").and(new QFilter("muluser.fbasedataid", "=", (Object)userid)).or(new QFilter("usertype", "=", (Object)"0"));
                QFilter accountFilter = new QFilter("entryentity.account", "in", (Object)new long[]{accountid, 0L});
                QFilter assgrpFilter = new QFilter("entryentity.assgrptype.flexfield", "in", flexfields);
                QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgid), new QFilter("accounttable", "=", (Object)accounttableid), userFilter, accountFilter, assgrpFilter};
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.AssgrpDefValUtil.getAssgrpDefVal", (String)"gl_assgrpdefval", (String)"entryentity.account account, entryentity.assgrptype.flexfield flexfield, entryentity.basepk basepk, entryentity.txtval txtval, usertype", (QFilter[])filters, null);){
                    HashMap<String, Object> valMap = new HashMap<String, Object>();
                    for (Row row : ds) {
                        String userStr = row.getString("usertype");
                        String accountStr = row.getString("account");
                        String assgrpStr = row.getString("flexfield");
                        String key = String.join((CharSequence)"_", userStr, accountStr, assgrpStr);
                        Object value = row.get("txtval");
                        if (StringUtils.isBlank((Object)value)) {
                            value = row.getLong("basepk");
                        }
                        valMap.put(key, value);
                    }
                    Object object = AssgrpDefValUtil.getAssgrpVal(valMap, userid, accountid, flexfields);
                    return object;
                }
            }
        }
        return null;
    }

    private static Object getAssgrpVal(Map<String, Object> valMap, Long userid, Long accountid, Set<String> flexfields) {
        Long result = null;
        HashMap<String, Object> flexToVal = new HashMap<String, Object>();
        for (String flexfield : flexfields) {
            Object val = AssgrpDefValUtil.getAssgrpValByFlexfield(valMap, accountid, flexfield);
            if (val == null) continue;
            flexToVal.put(flexfield, val);
        }
        if (!flexToVal.isEmpty()) {
            result = ReciprocalUtils.rebuildAssgrpId(flexToVal);
        }
        return result;
    }

    private static Object getAssgrpValByFlexfield(Map<String, Object> valMap, Long accountid, String flexfield) {
        String key = String.join((CharSequence)"_", "1", accountid.toString(), flexfield);
        Object val = valMap.get(key);
        if (val == null) {
            key = String.join((CharSequence)"_", "0", accountid.toString(), flexfield);
            val = valMap.get(key);
        }
        if (val == null) {
            key = String.join((CharSequence)"_", "1", "0", flexfield);
            val = valMap.get(key);
        }
        if (val == null) {
            key = String.join((CharSequence)"_", "0", "0", flexfield);
            val = valMap.get(key);
        }
        return val;
    }
}

