/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AssgrpDetailF7Handler {
    private IDataModel model;

    public AssgrpDetailF7Handler(IDataModel model) {
        this.model = model;
    }

    public void handleAssgrpDetail(BeforeF7SelectEvent evt) {
        BasedataProp prop = (BasedataProp)evt.getProperty();
        String entity = prop.getBaseEntityId();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entity);
        if (entity.equals("bos_org") || entity.equals("bos_adminorg")) {
            if (this.isSetLeaf(entity)) {
                List<Long> ids = this.getLeafOrgId();
                ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
                list.getListFilterParameter().getQFilters().add(new QFilter("id", "in", ids));
            }
        } else if (mainType.getFields().containsKey("parent") && mainType.getFields().containsKey("isleaf") && StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)mainType.getFields().get("isleaf")).getAlias()) && this.isSetLeaf(entity)) {
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            list.getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
        }
    }

    private boolean isSetLeaf(String entity) {
        DynamicObject acct = (DynamicObject)this.model.getValue("account");
        DynamicObjectCollection checkitementry = acct.getDynamicObjectCollection("checkitementry");
        for (DynamicObject obj : checkitementry) {
            long asstId = obj.getLong("asstactitem_id");
            DynamicObject asst = BusinessDataServiceHelper.loadSingleFromCache((Object)asstId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_asstacttype"));
            DynamicObject values = asst.getDynamicObject("valuesource");
            if (values == null || !entity.equals(values.getString("number"))) continue;
            return obj.getBoolean("isdetail");
        }
        return false;
    }

    private List<Long> getLeafOrgId() {
        ArrayList<Long> ids = new ArrayList<Long>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryLeftOrg", (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("isleaf", "=", (Object)"1")}, null);){
            for (Row r : ds) {
                ids.add(r.getLong("org"));
            }
        }
        return ids;
    }
}

