/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;

public class AttachmentCopyHelper {
    public static void copyFileToBillByPk(String appId, String formId, Object pkId, String attachKey, List<Map<String, Object>> attachments, boolean useSameFile) {
        if (pkId != null) {
            pkId = "" + pkId;
        }
        ArrayList<DynamicObject> attachmentFileList = new ArrayList<DynamicObject>();
        int i = 1;
        for (Map<String, Object> attach : attachments) {
            String newUid = AttachmentCopyHelper.getAttachUid(i);
            String filePath = AttachmentCopyHelper.uploadNewFile(appId, formId, attach, useSameFile);
            if (!StringUtils.isEmpty((CharSequence)filePath)) {
                DynamicObject newAttachment = AttachmentCopyHelper.createAttachmentDyn(attach, filePath);
                newAttachment.set("FNUMBER", (Object)newUid);
                newAttachment.set("FBillType", (Object)formId);
                newAttachment.set("FInterID", pkId);
                newAttachment.set("fattachmentpanel", (Object)attachKey);
                newAttachment.set("fcreatetime", (Object)new Date());
                attachmentFileList.add(newAttachment);
            }
            ++i;
        }
        if (!CollectionUtils.isEmpty(attachmentFileList)) {
            DynamicObject[] attachmentFileArray = new DynamicObject[attachmentFileList.size()];
            attachmentFileList.toArray(attachmentFileArray);
            SaveServiceHelper.save((DynamicObject[])attachmentFileArray);
        }
    }

    private static String uploadNewFile(String appId, String formId, Map<String, Object> attachInfo, boolean useSameFile) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        DynamicObject oldAttachment = BusinessDataServiceHelper.loadSingle((Object)((Long)attachInfo.get("attPkId")), (String)"bos_attachment");
        if (useSameFile) {
            return oldAttachment.getString("FFileId");
        }
        InputStream in = fileService.getInputStream(oldAttachment.getString("FFileId"));
        RequestContext requestContext = RequestContext.get();
        return fileService.upload(new FileItem(String.valueOf(attachInfo.get("name")), FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)appId, (String)formId, (Object)String.valueOf(attachInfo.get("uid")), (String)String.valueOf(attachInfo.get("name"))), in));
    }

    private static DynamicObject createAttachmentDyn(Map<String, Object> attachInfo, String newFileId) {
        Long attPkId = (Long)attachInfo.get("attPkId");
        String fileName = String.valueOf(attachInfo.get("name"));
        Long fileSize = (Long)attachInfo.get("size");
        String fExtName = (String)attachInfo.get("name");
        DynamicObject oldAttachment = BusinessDataServiceHelper.loadSingle((Object)attPkId, (String)"bos_attachment");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
        DynamicObject newAttachment = new DynamicObject((DynamicObjectType)mainType);
        newAttachment.set("id", (Object)ID.genLongId());
        Timestamp lastModified = (Timestamp)attachInfo.get("lastModified");
        if (lastModified != null) {
            newAttachment.set("FModifyTime", (Object)new Date(lastModified.getTime()));
        } else {
            newAttachment.set("FModifyTime", (Object)new Date());
        }
        DynamicObject creator = oldAttachment.getDynamicObject("FCREATEMEN");
        if (creator != null) {
            newAttachment.set("FCREATEMEN", (Object)creator.getLong("id"));
        }
        newAttachment.set("fcreatetime", (Object)new Date((Long)attachInfo.get("createdate")));
        newAttachment.set("FaliasFileName", (Object)fileName);
        newAttachment.set("FAttachmentName", (Object)fileName);
        newAttachment.set("FExtName", (Object)(fExtName != null ? fExtName.substring(fExtName.lastIndexOf(46) + 1) : ""));
        newAttachment.set("FATTACHMENTSIZE", (Object)fileSize);
        newAttachment.set("fdescription", attachInfo.get("description"));
        newAttachment.set("FFileId", (Object)newFileId);
        return newAttachment;
    }

    private static String getAttachUid(int index) {
        return String.format("%s-%s-%s", "rc-upload", new Date().getTime(), index);
    }
}

