/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.logging.LogFactory;
import kd.bos.util.ThreadLocals;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.util.AccountUtils;

public class BudgetPropExtender {
    private static final ThreadLocal<BeforeCreateListColumnsArgs> columnsArgsThreadLocal = ThreadLocals.create();
    private static final String VISIBLE = "visible";
    private static final String ENTRIES_ACCOUNT = "entries.account";
    private static final String ENTRIES_ACCOUNTINGTYPE = "entries.accountingtype";
    private static final String ORG_ID = "org_id";
    private static final String BOOKTYPE_ID = "booktype_id";
    private final DynamicObjectCollection queryCol;
    private final MainEntityType fullEntityType;
    private final PerformanceWatch watcher;
    private DynamicProperty orgProperty;
    private DynamicProperty bookTypeProperty;

    public BudgetPropExtender(DynamicObjectCollection queryCol, MainEntityType fullEntityType) {
        this.queryCol = queryCol;
        this.fullEntityType = fullEntityType;
        this.watcher = new PerformanceWatch(this.getClass(), this.getClass().getName(), true);
    }

    public boolean extend() {
        this.watcher.start("extend");
        boolean result = this.extendInternal();
        this.watcher.stop();
        return result;
    }

    public boolean extendInternal() {
        MainEntityType entityType = (MainEntityType)this.queryCol.getDynamicObjectType();
        if (this.queryCol.isEmpty() || !this.matchProperties(entityType)) {
            return this.fail();
        }
        this.initProperites();
        Table<Long, Long, Boolean> orgBooktypeStatusTable = this.batchLoadBudgetStatus(this.queryCol);
        List<DynamicObject> budgetEnableRows = this.filterBudgetEnableRows(this.queryCol, orgBooktypeStatusTable);
        if (budgetEnableRows.isEmpty()) {
            return this.fail();
        }
        DynamicSimpleProperty accountingTypeProperty = this.buildAccountingTypeProperty(this.fullEntityType);
        entityType.registerSimpleProperty(accountingTypeProperty);
        for (DynamicObject budgetEnableRow : budgetEnableRows) {
            accountingTypeProperty.setValueFast((Object)budgetEnableRow, (Object)BudgetPropExtender.parseAccountingType(budgetEnableRow));
        }
        return true;
    }

    private void initProperites() {
        this.orgProperty = this.queryCol.getDynamicObjectType().getProperty(ORG_ID);
        this.bookTypeProperty = this.queryCol.getDynamicObjectType().getProperty(BOOKTYPE_ID);
    }

    private Table<Long, Long, Boolean> batchLoadBudgetStatus(DynamicObjectCollection queryCol) {
        return (Table)queryCol.stream().map(row -> AccSysUtil.getBookFromAccSys((Long)this.orgProperty.getValueFast(row), (long)((Long)this.bookTypeProperty.getValueFast(row)))).distinct().collect(Collector.of(HashBasedTable::create, (table, book) -> {
            Boolean cfr_ignored_0 = (Boolean)table.put((Object)book.getOrgId(), (Object)book.getBookTypeId(), (Object)book.isBudget());
        }, (t1, t2) -> {
            t1.putAll((Table)t2);
            return t1;
        }, Collector.Characteristics.CONCURRENT));
    }

    private boolean fail() {
        return false;
    }

    private DynamicSimpleProperty buildAccountingTypeProperty(MainEntityType fullEntityType) {
        try {
            DynamicSimpleProperty property = (DynamicSimpleProperty)fullEntityType.findProperty("accountingtype").clone();
            property.setName(ENTRIES_ACCOUNTINGTYPE);
            return property;
        }
        catch (CloneNotSupportedException e) {
            LogFactory.getLog(this.getClass()).error("clone failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean matchProperties(MainEntityType entityType) {
        return entityType.findProperty(ENTRIES_ACCOUNT) != null && entityType.findProperty(ORG_ID) != null && entityType.findProperty(BOOKTYPE_ID) != null;
    }

    private List<DynamicObject> filterBudgetEnableRows(DynamicObjectCollection queryCol, Table<Long, Long, Boolean> bugetEnableTable) {
        DynamicObjectType objectType = ((DynamicObject)queryCol.get(0)).getDynamicObjectType();
        DynamicProperty orgProp = objectType.getProperty(ORG_ID);
        DynamicProperty bookTypeProp = objectType.getProperty(BOOKTYPE_ID);
        return queryCol.stream().filter(row -> (Boolean)bugetEnableTable.get(orgProp.getValueFast(row), bookTypeProp.getValueFast(row))).collect(Collectors.toList());
    }

    private static String parseAccountingType(DynamicObject rowDyn) {
        DynamicObject accountDyn = rowDyn.getDynamicObject(ENTRIES_ACCOUNT);
        return AccountUtils.parseAccountingType(accountDyn);
    }
}

