/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.CashFlowItemHelperNew;

public class CheckCashAccHasCF {
    private static final Log log = LogFactory.getLog(CheckCashAccHasCF.class);

    public static List<String> checkCashAccHasCF(List<Long> orgs, List<Long> periods, boolean isDeal) {
        ArrayList<String> errorVoucherList = new ArrayList<String>(16);
        if (orgs.isEmpty() || periods.isEmpty()) {
            return null;
        }
        List<Long> cashAccountList = CheckCashAccHasCF.getAllCashAccount();
        int size = 0;
        for (long org : orgs) {
            Map<Long, List<Long>> errorVouchers = CheckCashAccHasCF.check(org, periods, cashAccountList);
            if (isDeal) {
                size += CheckCashAccHasCF.dealCashflow(errorVouchers);
                continue;
            }
            for (Map.Entry<Long, List<Long>> entry : errorVouchers.entrySet()) {
                long voucherId = entry.getKey();
                for (Long enytyId : entry.getValue()) {
                    StringBuilder sb = new StringBuilder(3);
                    sb.append(voucherId);
                    sb.append("_");
                    sb.append(enytyId);
                    errorVoucherList.add(sb.toString());
                }
            }
        }
        if (isDeal) {
            errorVoucherList.add(String.valueOf(size));
        }
        return errorVoucherList;
    }

    private static List<Long> getAllCashAccount() {
        ArrayList<Long> cashAccountList = (ArrayList<Long>)ThreadCache.get((Object)"allCashAccount");
        if (cashAccountList == null) {
            cashAccountList = new ArrayList<Long>(36);
            QFilter cashF = new QFilter("iscash", "=", (Object)true);
            cashF.or(new QFilter("isbank", "=", (Object)true));
            cashF.or(new QFilter("iscashequivalent", "=", (Object)true));
            QFilter isleaf = new QFilter("isleaf", "=", (Object)true);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"check", (String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{cashF, isleaf}, (String)"id");){
                for (Row row : ds) {
                    cashAccountList.add(row.getLong("id"));
                }
            }
            ThreadCache.put((Object)"allCashAccount", cashAccountList);
        }
        return cashAccountList;
    }

    private static Map<Long, List<Long>> check(Long org, List<Long> periods, List<Long> cashAccountList) {
        HashMap<Long, List<Long>> errorVouchers = new HashMap<Long, List<Long>>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fid, fentryid from t_gl_voucherentry where forgid = ? ", new Object[]{org});
        sb.appendIn(" and fperiodid ", periods.toArray());
        sb.appendIn(" and faccountid ", cashAccountList.toArray());
        sb.append(" and fmaincfitemid >  ?", new Object[]{0L});
        try (DataSet ds = DB.queryDataSet((String)"CheckCashAccHasCF", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sb);){
            for (Row row : ds) {
                errorVouchers.compute(row.getLong("fid"), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Long>(8);
                    }
                    v.add(row.getLong("fentryid"));
                    return v;
                });
            }
        }
        return errorVouchers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int dealCashflow(Map<Long, List<Long>> errorVouchers) {
        int size = 0;
        HashSet<String> bookIds = new HashSet<String>(16);
        HashSet<Long> vouIds = new HashSet<Long>(10);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> vchParams = new ArrayList<Object[]>(10);
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>(10);
        try {
            for (Map.Entry<Long, List<Long>> entry : errorVouchers.entrySet()) {
                log.info("CheckCashAccHasCF_dealErrorVouchers", entry);
                size += entry.getValue().size();
            }
            CashFlowItemHelperNew.batchCalVoucherStatus(errorVouchers, "1", bookIds, paramList, vchParams, entryParams, vouIds);
            CashFlowItemHelperNew.saveData(paramList, vchParams, entryParams, vouIds);
        }
        catch (Exception e) {
            log.error("CheckCashAccHasCF_error", (Throwable)e);
        }
        finally {
            if (!bookIds.isEmpty()) {
                log.info("CheckCashAccHasCF_calBal", bookIds);
                CashFlowItemHelper.calBal(bookIds);
            }
        }
        return size;
    }
}

