/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.ImmutableSet;
import java.sql.ResultSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.constant.FieldConfig;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.PermissonType;
import org.apache.commons.lang3.ObjectUtils;

public class CommonAssistUtil {
    public static final Set<String> ONLY_BALANCED_FILTER = ImmutableSet.of((Object)"gl_initbalance", (Object)"gl_initcashflow", (Object)"gl_adjustexchangerate", (Object)"gl_transplprogram", (Object)"gl_autotrans", (Object)"gl_voucheramortacheme", (Object[])new String[0]);

    public static boolean isCommonAssistEnabled() {
        return (Boolean)ThreadCache.get((Object)"CommonAssistUtil#isCommonAssistEnabled", () -> (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)"select top 1 fentryid from t_bd_comassistentry", ResultSet::next));
    }

    public static List<String> getComAssistValSource(long orgId, long bookTypeId) {
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(orgId, bookTypeId);
        if (Objects.isNull(bookInfo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"CommonAssistUtil_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        return CommonAssistUtil.getComAssistValSource(bookInfo.getAccountTableId());
    }

    public static List<String> getComAssistValSource(long acctTableId) {
        return ComAssistTable.get(acctTableId).getCommonAssists().stream().map(commonAssist -> commonAssist.valueSource).collect(Collectors.toList());
    }

    public static List<String> getBalanceComassistValueSource(long orgId, long bookTypeId) {
        Optional<ComAssistTable> tableOptional = ComAssistTable.get(orgId, bookTypeId);
        if (tableOptional.isPresent()) {
            return tableOptional.get().getBalancedCommonAssists().stream().map(commonAssist -> commonAssist.valueSource).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String getComAssistEntityName(long orgId, long bookTypeId, String entityId) {
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(orgId, bookTypeId);
        if (bookInfo == null) {
            return "";
        }
        return CommonAssistUtil.getComAssistEntityName(bookInfo.getAccountTableId(), entityId);
    }

    public static String getComAssistEntityName(long accountTableId, String entityId) {
        return ComAssistTable.get(accountTableId).getCommonAssists().stream().filter(commonAssist -> entityId.equals(commonAssist.valueSource)).map(commonAssist -> commonAssist.getLocaleName().toString()).findFirst().orElse("");
    }

    public static boolean hasMasteridProp(String entityId) {
        if ("bos_assistantdata_detail".equals(entityId)) {
            return true;
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty masterid = type.getProperty("masterid");
        return Objects.nonNull(masterid) && Objects.nonNull(masterid.getAlias());
    }

    public static Set<Long> getAccountTableIds(Collection<Long> orgIds, Collection<Long> bookTypeIds, String entityId) {
        QFilterBuilder qFilterBuilder = new QFilterBuilder();
        if (CollectionUtils.isEmpty(orgIds)) {
            orgIds = AccSysUtil.getAcctOrgPkList(entityId, Boolean.FALSE, PermissonType.VIEW);
        }
        qFilterBuilder.addIn("org", orgIds);
        if (CollectionUtils.isNotEmpty(bookTypeIds)) {
            qFilterBuilder.addIn("bookstype", bookTypeIds);
        }
        return QueryServiceHelper.query((String)"gl_accountbook", (String)"accounttable.id", (QFilter[])qFilterBuilder.toArray(new QFilter[0])).stream().map(dyn -> dyn.getLong("accounttable.id")).collect(Collectors.toSet());
    }

    public static boolean existCommonAssist(long orgId, long bookTypeId) {
        Optional<ComAssistTable> tableOpt = ComAssistTable.get(orgId, bookTypeId);
        if (tableOpt.isPresent()) {
            return tableOpt.get().existCommonAssists();
        }
        return false;
    }

    public static boolean existCommonAssist(long accountTableId) {
        return ComAssistTable.get(accountTableId).existCommonAssists();
    }

    @Deprecated
    public static boolean isSameComAssistByTable(Collection<Long> accountTableIds) {
        if (CollectionUtils.isEmpty(accountTableIds) || accountTableIds.size() <= 1) {
            return true;
        }
        List comAssistTableList = accountTableIds.stream().map(ComAssistTable::get).filter(ComAssistTable::existCommonAssists).collect(Collectors.toList());
        if (comAssistTableList.size() <= 1) {
            return true;
        }
        int maxComAssistCount = 0;
        int maxComAssistIndex = 0;
        for (int i = 0; i < comAssistTableList.size(); ++i) {
            if (maxComAssistCount == 0) {
                maxComAssistCount = ((ComAssistTable)comAssistTableList.get(i)).getCommonAssists().size();
                continue;
            }
            if (maxComAssistCount >= ((ComAssistTable)comAssistTableList.get(i)).getCommonAssists().size()) continue;
            maxComAssistCount = ((ComAssistTable)comAssistTableList.get(i)).getCommonAssists().size();
            maxComAssistIndex = i;
        }
        ComAssistTable comAssistTable = (ComAssistTable)comAssistTableList.get(maxComAssistIndex);
        List<CommonAssist> commonAssistList = comAssistTable.getCommonAssists();
        for (ComAssistTable assistTable : comAssistTableList) {
            if (commonAssistList.containsAll(assistTable.getCommonAssists())) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameCommonAssist(Set<Long> orgIds, Set<Long> bookTypeIds) {
        if (CollectionUtils.isEmpty(orgIds) || CollectionUtils.isEmpty(bookTypeIds)) {
            return true;
        }
        Set<ComAssistTable> commonAssistTables = ComAssistTable.getCommonAssistTables(orgIds, bookTypeIds);
        if (commonAssistTables.size() <= 1) {
            return true;
        }
        HashSet<CommonAssist> assists = new HashSet<CommonAssist>(2);
        int maxSize = -1;
        for (ComAssistTable commonAssistTable : commonAssistTables) {
            List<CommonAssist> commonAssists = commonAssistTable.getCommonAssists();
            assists.addAll(commonAssists);
            maxSize = Math.max(commonAssists.size(), maxSize);
            if (assists.size() <= maxSize) continue;
            return false;
        }
        return assists.size() == maxSize;
    }

    public static String getComassistField(int index) {
        return "comassist" + index;
    }

    public static String getAllSelectKeys(String formId) {
        return (String)ThreadCache.get((Object)String.format("CommonAssistUtil#getAllSelectKeys#%s", formId), () -> EntityMetadataCache.getDataEntityType((String)formId).getAllFields().values().stream().filter(property -> property.getName().startsWith("comassist")).map(property -> CommonAssistUtil.getFullPathName(property, true)).collect(Collectors.joining(",")));
    }

    private static String getFullPathName(IDataEntityProperty property, boolean alias) {
        ArrayDeque<String> splitName = new ArrayDeque<String>();
        splitName.push(property.getName());
        for (IDataEntityType entityTypeIter = property.getParent(); entityTypeIter != null; entityTypeIter = entityTypeIter.getParent()) {
            splitName.push(entityTypeIter.getName());
        }
        splitName.poll();
        String fullPath = org.apache.commons.lang3.StringUtils.join(splitName, (String)".");
        return alias && splitName.size() > 1 ? String.format("%s %s", fullPath, property.getName()) : fullPath;
    }

    public static boolean showSpecifyFilter(CommonAssist commonAssist, String formId) {
        return !ONLY_BALANCED_FILTER.contains(formId) || commonAssist.isBalanced;
    }

    public static void loadReference(Collection<DynamicObject> dynamicObjects) {
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return;
        }
        EntityType entityType = (EntityType)dynamicObjects.iterator().next().getDataEntityType();
        Tuple<String, String> orgAndBookTypeTuple = FieldConfig.getOrgAndBookTypeFieldKey(entityType.getName());
        IDataEntityProperty orgProp = entityType.findProperty(GLField.id_((String)orgAndBookTypeTuple.item1));
        IDataEntityProperty bookTypeProp = entityType.findProperty(GLField.id_((String)orgAndBookTypeTuple.item2));
        dynamicObjects.stream().collect(Collectors.groupingBy(billDyn -> ComAssistTable.get((Long)orgProp.getValueFast(billDyn), (Long)bookTypeProp.getValueFast(billDyn)).get().getAcctTableID())).forEach((tableId, dynList) -> BusinessDataReader.loadRefence((Object[])dynList.toArray(new DynamicObject[0]), (IDataEntityType)ComAssistTableService.modifyEntityType(ComAssistTable.get(tableId), entityType)));
    }

    public static List<Long> getCustomFilter(IFormView view, String filterKey, String entity) {
        if (!(view instanceof ListView)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> filterIds = new ArrayList<Long>(4);
        ControlFilters c = ((ListView)view).getControlFilters();
        if (c != null) {
            Map filters = c.getFilters();
            for (Map.Entry filterEntry : filters.entrySet()) {
                filterIds.addAll(CommonAssistUtil.getIdsInControlFilter(view, filterKey, entity, (ControlFilter)filterEntry.getValue()));
            }
        }
        if (CollectionUtils.isEmpty(filterIds)) {
            filterIds.addAll(CommonAssistUtil.getCustomParamValue(filterKey, view));
        }
        return filterIds;
    }

    public static List<Long> getIdsInControlFilter(IFormView view, String filterProp, String filterPropEntity, ControlFilter controlFilter) {
        ArrayList<Long> filterIds = new ArrayList<Long>(4);
        String fieldName = controlFilter.getFieldName();
        String compareType = controlFilter.getCompareType();
        List values = controlFilter.getValue();
        if ((filterProp + ".id").equals(fieldName)) {
            values.forEach(id -> {
                if (ObjectUtils.isNotEmpty((Object)id)) {
                    filterIds.add(Long.parseLong(id.toString()));
                }
            });
        } else if ((filterProp + ".name").equals(fieldName) || (filterProp + ".number").equals(fieldName)) {
            String entityId = ((ListView)view).getListModel().getEntityId();
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityId));
            String flexField = fieldName.split("\\.")[1];
            if (flexField.equals("name") || flexField.equals("number")) {
                filterBuilder.addFilterField(fieldName, compareType, "", "", values, "");
            }
            filterBuilder.buildFilter();
            if (CollectionUtils.isNotEmpty((Collection)filterBuilder.getQFilters())) {
                List qFilters = filterBuilder.getQFilters();
                qFilters.forEach(x -> {
                    x.__setProperty(CommonAssistUtil.convertPropertyToSubProp(x, filterProp));
                    x.getNests(true).forEach(y -> y.getFilter().__setProperty(CommonAssistUtil.convertPropertyToSubProp(y.getFilter(), filterProp)));
                });
                DynamicObjectCollection orgDyns = QueryServiceHelper.query((String)filterPropEntity, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
                if (CollectionUtils.isNotEmpty((Collection)orgDyns)) {
                    for (DynamicObject orgDyn : orgDyns) {
                        filterIds.add(orgDyn.getLong("id"));
                    }
                }
            }
        }
        return filterIds;
    }

    private static String convertPropertyToSubProp(QFilter filter, String mainProp) {
        String property = filter.getProperty();
        if (property.equalsIgnoreCase(mainProp)) {
            return "id";
        }
        return property.substring(property.indexOf(".") + 1);
    }

    public static Set<Long> getCustomParamValue(String key, IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        HashSet<Long> valueIdSet = new HashSet<Long>(8);
        if (customParams.get(key) != null) {
            if (customParams.get(key) instanceof Collection) {
                valueIdSet.addAll(((Collection)customParams.get(key)).stream().mapToLong(value -> Long.parseLong(value.toString())).boxed().collect(Collectors.toSet()));
            } else if (StringUtils.isNotBlank((CharSequence)customParams.get(key).toString())) {
                valueIdSet.add(Long.parseLong(customParams.get(key).toString()));
            } else {
                LinkQueryPkIdCollection pkIdCollection = ((ListShowParameter)view.getFormShowParameter()).getLinkQueryPkIdCollection();
                if (!pkIdCollection.isEmpty()) {
                    String entityId = ((ListView)view).getListModel().getEntityId();
                    QFilter[] filters = new QFilter[]{new QFilter("id", "=", ((LinkQueryPkId)pkIdCollection.get(0)).getPkId())};
                    DataSet rows = QueryServiceHelper.queryDataSet((String)"getCustomParamValue.queryId", (String)entityId, (String)key, (QFilter[])filters, null);
                    rows.forEach(x -> valueIdSet.add(x.getLong(key)));
                }
            }
        }
        return valueIdSet;
    }

    public static void addComassitHyperParam(ReportQueryParam queryParam, FilterInfo filterInfo) {
        Object value = queryParam.getFilter().getValue("accounttable");
        DynamicObjectCollection accTableColl = null;
        if (value instanceof Long) {
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)value, (String)"bd_accounttable", (String)"id,comassistentry.comassistnumber");
            accTableColl = object.getDynamicObjectCollection("comassistentry");
        } else {
            accTableColl = queryParam.getFilter().getDynamicObject("accounttable").getDynamicObjectCollection("comassistentry");
        }
        if (accTableColl.isEmpty()) {
            return;
        }
        for (int i = 1; i <= accTableColl.size(); ++i) {
            FilterItemInfo item = queryParam.getFilter().getFilterItem("comassist" + i);
            if (item == null) continue;
            filterInfo.addFilterItem(item.getPropName(), item.getValue(), item.getCompareType());
        }
        filterInfo.addFilterItem("showcomassist", (Object)queryParam.getFilter().getBoolean("showcomassist"));
    }

    public static void addComassitHyperParam(ReportQueryParam queryParam, DynamicObject rowData, FilterInfo filterInfo) {
        Object value = queryParam.getFilter().getValue("accounttable");
        DynamicObjectCollection accTableColl = null;
        if (value instanceof Long) {
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)value, (String)"bd_accounttable", (String)"id,comassistentry.comassistnumber");
            accTableColl = object.getDynamicObjectCollection("comassistentry");
        } else {
            accTableColl = queryParam.getFilter().getDynamicObject("accounttable").getDynamicObjectCollection("comassistentry");
        }
        if (accTableColl.isEmpty()) {
            return;
        }
        boolean showComassist = queryParam.getFilter().getBoolean("showcomassist");
        for (int i = 1; i <= accTableColl.size(); ++i) {
            if (showComassist) {
                Object val = rowData.get("comassist" + i + "id");
                if (val != null) {
                    filterInfo.addFilterItem("comassist" + i, val);
                    continue;
                }
                FilterItemInfo item = queryParam.getFilter().getFilterItem("comassist" + i);
                if (item == null) continue;
                filterInfo.addFilterItem(item.getPropName(), item.getValue(), item.getCompareType());
                continue;
            }
            FilterItemInfo item = queryParam.getFilter().getFilterItem("comassist" + i);
            if (item == null) continue;
            filterInfo.addFilterItem(item.getPropName(), item.getValue(), item.getCompareType());
        }
        filterInfo.addFilterItem("showcomassist", (Object)showComassist);
    }

    public static List<Long> getOrgCommonFilterColumnValues(IFormView view, String entityOrgField) {
        List<Long> customFilterIds;
        List filterList = ((FilterContainer)view.getControl("filtercontainerap")).getContext().getClientQueryFilterParameter().getQFilters();
        ArrayList<Long> allValues = new ArrayList<Long>(8);
        ArrayList<QFilter> otherFilter = new ArrayList<QFilter>(8);
        for (QFilter filter : filterList) {
            if (filter.getProperty().equals(entityOrgField + ".id") && !(filter.getValue() instanceof QEmptyValue) && ("in".equalsIgnoreCase(filter.getCP()) || "=".equalsIgnoreCase(filter.getCP()))) {
                List<Long> values = CommonAssistUtil.convertFilterValue(filter.getValue());
                if (allValues.isEmpty()) {
                    allValues.addAll(values);
                    continue;
                }
                allValues.retainAll(values);
                continue;
            }
            if (!filter.getProperty().startsWith(entityOrgField)) continue;
            otherFilter.add(filter.__copy(true));
        }
        if (!otherFilter.isEmpty()) {
            otherFilter.forEach(x -> {
                x.__setProperty(CommonAssistUtil.convertPropertyToSubProp(x, entityOrgField));
                x.getNests(true).forEach(y -> y.getFilter().__setProperty(CommonAssistUtil.convertPropertyToSubProp(y.getFilter(), entityOrgField)));
            });
            DynamicObjectCollection orgDyns = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])otherFilter.toArray(new QFilter[0]));
            if (CollectionUtils.isNotEmpty((Collection)orgDyns)) {
                Set orgIdSet = orgDyns.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
                if (allValues.isEmpty()) {
                    allValues.addAll(orgIdSet);
                } else {
                    allValues.retainAll(orgIdSet);
                }
            }
        }
        if (allValues.size() == 0 && (customFilterIds = CommonAssistUtil.getCustomFilter(view, entityOrgField, "bos_org")) != null) {
            allValues.addAll(customFilterIds);
        }
        if (CollectionUtils.isEmpty(allValues) && "org".equals(entityOrgField)) {
            allValues.addAll(CommonAssistUtil.getCustomParamValue("org", view));
        }
        return allValues;
    }

    public static List<Long> getBookTypeCommonFilterColumnValues(IFormView view, String entityBookTypeField) {
        List<Long> customFilterIds;
        List filterList = ((FilterContainer)view.getControl("filtercontainerap")).getContext().getClientQueryFilterParameter().getQFilters();
        ArrayList<Long> allValues = new ArrayList<Long>(8);
        ArrayList<QFilter> otherFilter = new ArrayList<QFilter>(8);
        for (QFilter filter : filterList) {
            if (filter.getProperty().equals(entityBookTypeField + ".id") && !(filter.getValue() instanceof QEmptyValue) && ("in".equalsIgnoreCase(filter.getCP()) || "=".equalsIgnoreCase(filter.getCP()))) {
                List<Long> values = CommonAssistUtil.convertFilterValue(filter.getValue());
                if (allValues.isEmpty()) {
                    allValues.addAll(values);
                    continue;
                }
                allValues.retainAll(values);
                continue;
            }
            if (!filter.getProperty().startsWith(entityBookTypeField)) continue;
            otherFilter.add(filter.__copy(true));
        }
        if (!otherFilter.isEmpty()) {
            otherFilter.forEach(x -> {
                x.__setProperty(CommonAssistUtil.convertPropertyToSubProp(x, entityBookTypeField));
                x.getNests(true).forEach(y -> y.getFilter().__setProperty(CommonAssistUtil.convertPropertyToSubProp(y.getFilter(), entityBookTypeField)));
            });
            DynamicObjectCollection bookTypeDyns = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id", (QFilter[])otherFilter.toArray(new QFilter[0]));
            if (CollectionUtils.isNotEmpty((Collection)bookTypeDyns)) {
                Set bookTypeIdSet = bookTypeDyns.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
                if (allValues.isEmpty()) {
                    allValues.addAll(bookTypeIdSet);
                } else {
                    allValues.retainAll(bookTypeIdSet);
                }
            }
        }
        if (allValues.size() == 0 && (customFilterIds = CommonAssistUtil.getCustomFilter(view, entityBookTypeField, "bd_accountbookstype")) != null) {
            allValues.addAll(customFilterIds);
        }
        if (CollectionUtils.isEmpty(allValues) && "booktype".equals(entityBookTypeField)) {
            allValues.addAll(CommonAssistUtil.getCustomParamValue("booktype", view));
        }
        return allValues;
    }

    private static List<Long> convertFilterValue(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().filter(Objects::nonNull).map(x -> Long.valueOf(x.toString())).collect(Collectors.toList());
        }
        if (value.getClass().isArray()) {
            return Arrays.stream((Object[])value).filter(Objects::nonNull).map(x -> Long.valueOf(x.toString())).collect(Collectors.toList());
        }
        return Collections.singletonList(Long.valueOf(value.toString()));
    }

    public static long getPermParentOrg(List<Long> permOrgs) {
        return AccSysUtil.getParentOrgByChildre(permOrgs, Long.valueOf("10"));
    }

    public static String getAlias(String key) {
        return "f" + key + "id";
    }
}

