/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static Workbook readExcel(String filePath, InputStream in) {
        HSSFWorkbook wb = null;
        if (in == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        try {
            if (".xls".equals(extString)) {
                wb = new HSSFWorkbook(in);
                return wb;
            }
            if (".xlsx".equals(extString)) {
                wb = new XSSFWorkbook(in);
                return wb;
            }
            wb = null;
            return null;
        }
        catch (IOException iOException) {
            return wb;
        }
    }

    public static Object getCellFormatValue(Cell cell) {
        Object cellValue = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case NUMERIC: {
                    cell.setCellType(CellType.STRING);
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case FORMULA: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = cell.getDateCellValue();
                        break;
                    }
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellValue = "";
                    break;
                }
            }
        } else {
            cellValue = "";
        }
        return cellValue;
    }

    public static List<String> getColumnSet(Workbook wb, int page, int column, int startRow, int endRow) {
        Sheet sheet = wb.getSheetAt(page - 1);
        Row row = null;
        ArrayList<String> result = new ArrayList<String>(endRow - startRow + 1);
        String cellData = null;
        if (wb != null) {
            for (int i = startRow - 1; i < endRow; ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                cellData = (String)ExcelUtils.getCellFormatValue(row.getCell(column - 1));
                result.add(cellData);
            }
        }
        return result;
    }

    public static int excelColStrToNum(String column) {
        int num = 0;
        int result = 0;
        int length = column.length();
        for (int i = 0; i < length; ++i) {
            char ch = column.charAt(length - i - 1);
            num = ch - 65 + 1;
            num = (int)((double)num * Math.pow(26.0, i));
            result += num;
        }
        return result;
    }
}

