/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.util.TipsUtils;

public class FinalProcessUtil {
    private static final String IS_LEAF = "isleaf";

    public static List<List<Object>> getCartesianProduct(List<List<Object>> lists) {
        ArrayList<List<Object>> resultLists = new ArrayList<List<Object>>(8);
        for (List<Object> list : lists) {
            ArrayList tempLists = new ArrayList(8);
            if (CollectionUtils.isEmpty(resultLists)) {
                if (CollectionUtils.isEmpty(list)) {
                    tempLists.add(Stream.of(Long.valueOf(0L)).collect(Collectors.toList()));
                } else {
                    for (Object object : list) {
                        tempLists.add(Stream.of(object).collect(Collectors.toList()));
                    }
                }
            } else if (CollectionUtils.isNotEmpty(list)) {
                for (Object object : list) {
                    for (List list2 : resultLists) {
                        tempLists.add(Stream.concat(list2.stream(), Stream.of(object)).collect(Collectors.toList()));
                    }
                }
            } else {
                for (List list3 : resultLists) {
                    tempLists.add(Stream.concat(list3.stream(), Stream.of(Long.valueOf(0L))).collect(Collectors.toList()));
                }
            }
            resultLists = tempLists;
        }
        return resultLists;
    }

    public static boolean isComAssistExistsNoLeaf(ExtendedDataEntity dataEntity) {
        List comAssistPropList = ((MainEntityType)dataEntity.getDataEntity().getDataEntityType()).getAllFields().values().stream().filter(prop -> prop.getName().startsWith("comassist")).collect(Collectors.toList());
        boolean exists = Boolean.FALSE;
        for (IDataEntityProperty comAssistProp : comAssistPropList) {
            String entityId;
            ArrayList<QFilter> filterList;
            Set<Long> comAssistValueIdSet;
            String comAssistKey = comAssistProp.getName();
            if (comAssistProp instanceof MulBasedataProp) {
                if (!((MulBasedataProp)comAssistProp).getComplexType().getProperties().stream().anyMatch(prop -> IS_LEAF.equals(prop.getName())) || !StringUtils.isNotBlank((CharSequence)((IDataEntityProperty)((MulBasedataProp)comAssistProp).getComplexType().getProperties().get((Object)IS_LEAF)).getAlias()) || !CollectionUtils.isNotEmpty(comAssistValueIdSet = FinalProcessUtil.getComAssistValueIds(dataEntity, comAssistKey, Boolean.TRUE))) continue;
                filterList = new ArrayList<QFilter>(8);
                filterList.add(new QFilter("id", "in", comAssistValueIdSet));
                filterList.add(new QFilter(IS_LEAF, "=", (Object)false));
                entityId = ((MulBasedataProp)comAssistProp).getBaseEntityId();
                exists = QueryServiceHelper.exists((String)entityId, (QFilter[])filterList.toArray(new QFilter[0]));
                if (!exists) continue;
                break;
            }
            if (!(comAssistProp instanceof BasedataProp) || !((BasedataProp)comAssistProp).getComplexType().getProperties().stream().anyMatch(prop -> IS_LEAF.equals(prop.getName())) || !StringUtils.isNotBlank((CharSequence)((IDataEntityProperty)((BasedataProp)comAssistProp).getComplexType().getProperties().get((Object)IS_LEAF)).getAlias()) || !CollectionUtils.isNotEmpty(comAssistValueIdSet = FinalProcessUtil.getComAssistValueIds(dataEntity, comAssistKey, Boolean.FALSE))) continue;
            filterList = new ArrayList(8);
            filterList.add(new QFilter("id", "in", comAssistValueIdSet));
            filterList.add(new QFilter(IS_LEAF, "=", (Object)false));
            entityId = ((BasedataProp)comAssistProp).getBaseEntityId();
            exists = QueryServiceHelper.exists((String)entityId, (QFilter[])filterList.toArray(new QFilter[0]));
            if (!exists) continue;
            break;
        }
        return exists;
    }

    public static Set<Long> getComAssistValueIds(ExtendedDataEntity dataEntity, String key, boolean isMulSelect) {
        HashSet<Long> comAssistValIdSet = new HashSet<Long>(8);
        if (!key.startsWith("comassist")) {
            return comAssistValIdSet;
        }
        DynamicObjectCollection entry = null;
        switch (dataEntity.getDataEntity().getDataEntityType().getName()) {
            case "gl_voucheramortacheme": {
                if (key.endsWith("dest")) {
                    entry = (DynamicObjectCollection)dataEntity.getValue("destaccounts");
                } else if (key.endsWith("target")) {
                    entry = (DynamicObjectCollection)dataEntity.getValue("targetaccounts");
                } else {
                    comAssistValIdSet.addAll(FinalProcessUtil.getValueId(dataEntity.getDataEntity(), key, isMulSelect));
                }
                if (entry == null) break;
                for (DynamicObject dynamicObject : entry) {
                    comAssistValIdSet.addAll(FinalProcessUtil.getValueId(dynamicObject, key, isMulSelect));
                }
                break;
            }
            case "gl_autotrans": {
                entry = (DynamicObjectCollection)dataEntity.getValue("autotransentry");
                if (entry == null) break;
                for (DynamicObject dynamicObject : entry) {
                    comAssistValIdSet.addAll(FinalProcessUtil.getValueId(dynamicObject, key, isMulSelect));
                }
                break;
            }
            default: {
                comAssistValIdSet.addAll(FinalProcessUtil.getValueId(dataEntity.getDataEntity(), key, isMulSelect));
            }
        }
        return comAssistValIdSet;
    }

    public static Set<Long> getValueId(DynamicObject dynamicObject, String key, boolean isMulSelect) {
        HashSet<Long> valueIdSet = new HashSet<Long>(8);
        if (isMulSelect) {
            DynamicObjectCollection comAssistDyns = dynamicObject.getDynamicObjectCollection(key);
            comAssistDyns.forEach(comAssistDyn -> valueIdSet.add(comAssistDyn.getLong("fbasedataid_id")));
        } else {
            valueIdSet.add(dynamicObject.getLong(key + "_id"));
        }
        return valueIdSet;
    }

    public static String formatMessage(DynamicObject schemeDyn, String message) {
        DynamicObject orgDyn = schemeDyn.getDynamicObject("org");
        String entityName = schemeDyn.getDataEntityType().getName();
        DynamicObject bookTypeDyn = schemeDyn.getDynamicObject(FinalProcessUtil.getBookKey(entityName));
        return String.format(FinalProcessUtil.formatMessage(orgDyn.getString("name") + " " + orgDyn.getString("number"), bookTypeDyn.getString("name") + " " + bookTypeDyn.getString("number"), schemeDyn.getString(FinalProcessUtil.getBillNoKey(entityName)), message), new Object[0]);
    }

    public static String formatOrgBookMessage(DynamicObject schemeDyn, String message) {
        DynamicObject orgDyn = schemeDyn.getDynamicObject("org");
        DynamicObject bookTypeDyn = schemeDyn.getDynamicObject(FinalProcessUtil.getBookKey(schemeDyn.getDataEntityType().getName()));
        return String.format(FinalProcessUtil.formatMessage(orgDyn.getString("name") + " " + orgDyn.getString("number"), bookTypeDyn.getString("name") + " " + bookTypeDyn.getString("number"), null, message), new Object[0]);
    }

    public static String formatMessage(String orgNum, String bookNum, String schemeNum, String message) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        return schemeNum == null ? String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\uff0c\u8d26\u7c3f%2$s\uff0c%3$s", (String)"FinalProcessingMessage_0", (String)"fi-gl-common", (Object[])new Object[0]), orgNum, bookNum, TipsUtils.safeSuffix(message, MultiLangPunc.fullStop())) : String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\uff0c\u8d26\u7c3f%2$s\u4e0b\u65b9\u6848%3$s\uff0c%4$s", (String)"FinalProcessingMessage_1", (String)"fi-gl-common", (Object[])new Object[0]), orgNum, bookNum, schemeNum, TipsUtils.safeSuffix(message, MultiLangPunc.fullStop()));
    }

    private static String getBillNoKey(String entityName) {
        return "gl_voucheramortacheme".equals(entityName) ? "number" : "billno";
    }

    private static String getBookKey(String entityName) {
        String bookKey = "bookstype";
        if ("gl_voucheramortacheme".equals(entityName)) {
            bookKey = "accountbooks";
        }
        if ("gl_transplprogram".equals(entityName)) {
            bookKey = "book";
        }
        return bookKey;
    }

    public static boolean isExistVoucher(long schemaId) {
        QFilter srcEntityFilter = new QFilter("srcentity", "=", (Object)schemaId);
        return QueryServiceHelper.exists((String)"gl_voucherrelation", (QFilter[])new QFilter[]{srcEntityFilter});
    }

    public static boolean isExistVchAfterCurPeriod(long schemaId, long curPeriodId) {
        QFilter srcEntityFilter = new QFilter("srcentity", "=", (Object)schemaId);
        QFilter periodFilter = new QFilter("period", ">=", (Object)curPeriodId);
        return QueryServiceHelper.exists((String)"gl_voucherrelation", (QFilter[])new QFilter[]{srcEntityFilter, periodFilter});
    }

    public static boolean canGetHgIds(Collection<FinalProcessAssgrp.AssgrpValues> flex2Values) {
        int maxSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"kd.fi.gl.finalprocessing.autotrans.assgrpparsersize", (int)10000);
        if (CollectionUtils.isEmpty(flex2Values)) {
            return true;
        }
        int cartesianProduct = 1;
        for (FinalProcessAssgrp.AssgrpValues flex2Value : flex2Values) {
            int size = flex2Value.getValues().size();
            if (size == 0) continue;
            if (size > maxSize / cartesianProduct) {
                return false;
            }
            cartesianProduct *= size;
        }
        return true;
    }
}

