/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.alibaba.fastjson.JSONObject;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.flex.FlexService;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MasterBaseDataUtils;
import kd.fi.gl.util.SubsiDiaryHelper;
import org.apache.commons.lang3.tuple.Triple;

public class FlexUtils {
    public static final String T_GL_ASSIST = "T_GL_ASSIST";
    public static final String GL = "gl";
    private static final int ASSIST_FLEX_TYPE_ID = 2;
    private static final String ASSIST_DB = "gl_assist_bd";
    private static final String ASSIST_TXT = "gl_assist_txt";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private static final String VASSGRP_ALIAS_PREFIX = "vassgrp_";
    public static final String BOS_FORMMETA = "bos_formmeta";
    public static final String INHERIT_PATH = "inheritpath";
    public static final String BASE_TREE_TPL = "b0d31cea000001ac";
    private static final String PARENTDATA = "import-parent";
    private static final String FLEXPROPERTY = "import-flex";
    public static final List<String> specialEntity = new ArrayList<String>(2);
    public static final Map<String, String> specialEntityMap;
    private static MainEntityType MAIN_ENTITY_TYPE;
    private static final String ASSGRP_ALIAS_PREFIX = "assgrp_";
    private static final String VOUCHER_ASSIST_ORM_PREFIX = "entries.vassgrp_";

    public static boolean isNoneDetailAssgrp(FlexProperty flexProperty) {
        String valuesource = flexProperty.getValueSource();
        if (StringUtils.isEmpty((CharSequence)valuesource)) {
            return false;
        }
        if (specialEntity.contains(valuesource)) {
            return true;
        }
        return FlexUtils.isNormalTreeEntity(valuesource);
    }

    public static boolean isNormalTreeEntity(String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty parent = mainEntityType.getProperty("parent");
        DynamicProperty isleaf = mainEntityType.getProperty("isleaf");
        return FlexUtils.isPropExist(parent) && FlexUtils.isPropExist(isleaf);
    }

    private static boolean isPropExist(DynamicProperty property) {
        return property != null && !StringUtils.isBlank((CharSequence)property.getAlias());
    }

    public static Set<Object> getAllLeafIdSet(Set<Object> idSet, String entityName, boolean isIncludeParent) {
        HashSet<Object> allSet = new HashSet<Object>(64);
        if (isIncludeParent) {
            allSet.addAll(idSet);
        }
        Iterator<Object> idSetIterator = idSet.iterator();
        while (idSetIterator.hasNext()) {
            Object value = idSetIterator.next();
            if (value instanceof Long && (Long)value == 0L) {
                idSetIterator.remove();
                continue;
            }
            if (!(value instanceof Integer) || (Integer)value != 0) continue;
            idSetIterator.remove();
        }
        HashSet<Object> parentSet = new HashSet<Object>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getAllLeafIdSet", (String)entityName, (String)"id, isleaf", (QFilter[])new QFilter("parent", "in", idSet).toArray(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                if (!row.getBoolean("isleaf").booleanValue()) {
                    parentSet.add(row.get("id"));
                    if (!isIncludeParent) continue;
                    allSet.add(row.get("id"));
                    continue;
                }
                allSet.add(row.get("id"));
            }
        }
        if (!parentSet.isEmpty()) {
            allSet.addAll(FlexUtils.getAllLeafIdSet(parentSet, entityName, isIncludeParent));
        }
        return allSet;
    }

    public static long saveFlexData(Map<String, Object> flexFieldToValue) {
        return FlexUtils.saveFlexData(flexFieldToValue, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, FlexProperty> batchGetFlexProperty(String ... flexFields) {
        Set flexFieldSet = Arrays.stream(flexFields).collect(Collectors.toSet());
        Map<String, FlexProperty> flexPropMap = LocalCacheHelper.get(CacheKey.getCacheKey(CacheKeyPrefix.ASSGRP_FLEXFIELD_PROPERTY, new Object[0]), Map.class);
        if (null == flexPropMap) {
            flexPropMap = FlexUtils.loadAllAssistTypeToCache(false);
            return flexPropMap.entrySet().stream().filter(x -> flexFieldSet.contains(x.getKey())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (FlexProperty)x.getValue()));
        }
        if (flexPropMap.keySet().containsAll(flexFieldSet)) return flexPropMap.entrySet().stream().filter(x -> flexFieldSet.contains(x.getKey())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (FlexProperty)x.getValue()));
        Class<FlexUtils> clazz = FlexUtils.class;
        synchronized (FlexUtils.class) {
            flexPropMap = LocalCacheHelper.get(CacheKey.getCacheKey(CacheKeyPrefix.ASSGRP_FLEXFIELD_PROPERTY, new Object[0]), Map.class);
            if (flexPropMap != null && flexPropMap.keySet().containsAll(flexFieldSet)) return flexPropMap.entrySet().stream().filter(x -> flexFieldSet.contains(x.getKey())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (FlexProperty)x.getValue()));
            flexPropMap = FlexUtils.loadAllAssistTypeToCache(true);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return flexPropMap.entrySet().stream().filter(x -> flexFieldSet.contains(x.getKey())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (FlexProperty)x.getValue()));
        }
    }

    private static synchronized Map<String, FlexProperty> loadAllAssistTypeToCache(boolean isForce) {
        Map<String, FlexProperty> flexPropMap;
        if (isForce) {
            List allFlexProperties = FlexEntityMetaUtils.getFlexProperties((int)2);
            flexPropMap = allFlexProperties.stream().collect(Collectors.toMap(x -> x.getFlexField(), x -> x));
            LocalCacheHelper.put(CacheKey.getCacheKey(CacheKeyPrefix.ASSGRP_FLEXFIELD_PROPERTY, new Object[0]), flexPropMap);
        } else {
            flexPropMap = LocalCacheHelper.get(CacheKey.getCacheKey(CacheKeyPrefix.ASSGRP_FLEXFIELD_PROPERTY, new Object[0]), Map.class);
            if (null == flexPropMap) {
                List allFlexProperties = FlexEntityMetaUtils.getFlexProperties((int)2);
                flexPropMap = allFlexProperties.stream().collect(Collectors.toMap(x -> x.getFlexField(), x -> x));
                LocalCacheHelper.put(CacheKey.getCacheKey(CacheKeyPrefix.ASSGRP_FLEXFIELD_PROPERTY, new Object[0]), flexPropMap);
            }
        }
        return flexPropMap;
    }

    public static Map<Long, FlexProperty> batchGetFlexProperty(List<Long> propertyIds) {
        return FlexEntityMetaUtils.getFlexProperty(propertyIds).stream().collect(Collectors.toMap(FlexProperty::getId, x -> x));
    }

    public static Map<Long, String> batchGetFlexFields(List<Long> propertyIds) {
        return FlexUtils.batchGetFlexProperty(propertyIds).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((FlexProperty)x.getValue()).getFlexField()));
    }

    public static Map<String, String> batchGetFlexEntity(String ... flexFields) {
        Map<String, FlexProperty> flexPropertyMap = FlexUtils.batchGetFlexProperty(flexFields);
        return flexPropertyMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((FlexProperty)x.getValue()).getValueSource()));
    }

    public static String getEntity(String flexField) {
        return FlexUtils.batchGetFlexEntity(flexField).getOrDefault(flexField, "");
    }

    public static FlexProperty getFlexProperty(String flexField) {
        return FlexUtils.batchGetFlexProperty(flexField).get(flexField);
    }

    public static List<FlexProperty> getAllFlexType() {
        Map<String, FlexProperty> flexPropMap = LocalCacheHelper.get(CacheKey.getCacheKey(CacheKeyPrefix.ASSGRP_FLEXFIELD_PROPERTY, new Object[0]), Map.class);
        if (null == flexPropMap) {
            flexPropMap = FlexUtils.loadAllAssistTypeToCache(false);
        }
        return new ArrayList<FlexProperty>(flexPropMap.values());
    }

    public static long saveFlexDataByProperty(Map<FlexProperty, Object> flexPropValueMap, boolean isReLoadMasterId) {
        Objects.requireNonNull(flexPropValueMap);
        if (flexPropValueMap.isEmpty()) {
            return 0L;
        }
        return FlexUtils.saveSingleFlexData(FlexUtils.buildFlexEntireDataByProperty(flexPropValueMap, isReLoadMasterId));
    }

    public static FlexEntireData buildFlexEntireDataByProperty(Map<FlexProperty, Object> flexPropValueMap, boolean isReLoadMasterId) {
        ArrayList flexDataList = new ArrayList(flexPropValueMap.size());
        FlexEntireData flexEntireData = new FlexEntireData();
        flexPropValueMap.forEach((flexProperty, value) -> {
            if (null != value) {
                boolean isTxtType = "3".equals(flexProperty.getValueType());
                if (!isTxtType && isReLoadMasterId) {
                    long masterId = MasterBaseDataUtils.reloadMasterId(flexProperty.getValueSource(), value);
                    if (masterId > 0L) {
                        flexDataList.add(FlexUtils.createSinlgeFlexData(flexEntireData, flexProperty, masterId));
                    }
                } else {
                    flexDataList.add(FlexUtils.createSinlgeFlexData(flexEntireData, flexProperty, value));
                }
            }
        });
        flexEntireData.setFlexDatas(flexDataList);
        return flexEntireData;
    }

    public static FlexEntireData buildFlexEntireData(Map<String, Object> flexFieldToValue, boolean isReLoadMasterId) {
        Map<String, FlexProperty> flexPropertyMap = FlexUtils.batchGetFlexProperty(flexFieldToValue.keySet().toArray(new String[0]));
        Map<FlexProperty, Object> flexPropValueMap = flexFieldToValue.entrySet().stream().filter(x -> flexPropertyMap.containsKey(x.getKey())).collect(Collectors.toMap(x -> (FlexProperty)flexPropertyMap.get(x.getKey()), Map.Entry::getValue, (oldVal, newVal) -> newVal));
        return FlexUtils.buildFlexEntireDataByProperty(flexPropValueMap, isReLoadMasterId);
    }

    public static long saveFlexData(Map<String, Object> flexFieldToValue, boolean isReLoadMasterId) {
        Objects.requireNonNull(flexFieldToValue);
        if (flexFieldToValue.isEmpty()) {
            return 0L;
        }
        return FlexUtils.saveSingleFlexData(FlexUtils.buildFlexEntireData(flexFieldToValue, isReLoadMasterId));
    }

    private static MainEntityType getMainEntityType() {
        if (null == MAIN_ENTITY_TYPE) {
            MAIN_ENTITY_TYPE = new MainEntityType();
            MAIN_ENTITY_TYPE.setAlias(T_GL_ASSIST);
            MAIN_ENTITY_TYPE.setDBRouteKey(GL);
        }
        return MAIN_ENTITY_TYPE;
    }

    private static Long saveSingleFlexData(FlexEntireData flexEntireData) {
        return FlexService.saveFlexData((MainEntityType)FlexUtils.getMainEntityType(), (FlexEntireData)flexEntireData);
    }

    public static List<Long> batchSaveFlexData(Map<String, List<Object>> flexFieldToValues, boolean isReLoadMasterId) {
        Objects.requireNonNull(flexFieldToValues);
        if (flexFieldToValues.isEmpty()) {
            return Collections.emptyList();
        }
        FlexEntireData tempFlexEntireData = new FlexEntireData();
        ArrayList flexDataList = new ArrayList(10);
        Iterator<Map.Entry<String, List<Object>>> iterator = flexFieldToValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Object masterIds;
            Map.Entry<String, List<Object>> next = iterator.next();
            String flexField = next.getKey();
            FlexProperty flexProperty = FlexUtils.getFlexProperty(flexField);
            if (null == flexProperty) {
                iterator.remove();
                continue;
            }
            List<Object> values = next.getValue();
            if (values == null || values.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (isReLoadMasterId && !(masterIds = MasterBaseDataUtils.batchGetMasterIds(flexProperty.getValueSource(), values.toArray())).isEmpty()) {
                values = values.stream().map(arg_0 -> FlexUtils.lambda$batchSaveFlexData$14((Map)masterIds, arg_0)).collect(Collectors.toList());
                next.setValue(values);
            }
            if (flexDataList.isEmpty()) {
                masterIds = values.iterator();
                while (masterIds.hasNext()) {
                    Object value = masterIds.next();
                    ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>(values.size());
                    FlexEntireData.FlexData flexData = FlexUtils.createSinlgeFlexData(tempFlexEntireData, flexProperty, value);
                    flexDatas.add(flexData);
                    flexDataList.add(flexDatas);
                }
                continue;
            }
            ArrayList tempFlexDataList = new ArrayList();
            for (Object value : values) {
                for (List list : flexDataList) {
                    FlexEntireData.FlexData flexData = FlexUtils.createSinlgeFlexData(tempFlexEntireData, flexProperty, value);
                    ArrayList<FlexEntireData.FlexData> tempFlexDatas = new ArrayList<FlexEntireData.FlexData>(10);
                    tempFlexDatas.addAll(list);
                    tempFlexDatas.add(flexData);
                    tempFlexDataList.add(tempFlexDatas);
                }
            }
            if (tempFlexDataList.isEmpty()) continue;
            flexDataList.clear();
            flexDataList.addAll(tempFlexDataList);
        }
        return flexDataList.stream().map(x -> {
            FlexEntireData flexEntireData = new FlexEntireData();
            flexEntireData.setFlexDatas(x);
            return FlexUtils.saveSingleFlexData(flexEntireData);
        }).collect(Collectors.toList());
    }

    public static List<Long> batchSaveFlexData(List<FlexEntireData> flexEntireDataList) {
        FlexService.batchSaveFlexData((int)2, flexEntireDataList);
        return BDUtil.extractToList(flexEntireDataList, FlexEntireData::getId);
    }

    public static Map<Map<String, Object>, Long> batchSaveFlexData(Collection<Map<String, Object>> flexMapList, boolean reloadMasterId) {
        Map<Map, FlexEntireData> flexMapEntireDataMap = flexMapList.stream().distinct().collect(Collectors.toMap(flexMap -> flexMap, flexMap -> FlexUtils.buildFlexEntireData(flexMap, reloadMasterId), (o, n) -> o));
        FlexService.batchSaveFlexData((int)2, new ArrayList<FlexEntireData>(flexMapEntireDataMap.values()));
        return flexMapEntireDataMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FlexEntireData)e.getValue()).getId()));
    }

    private static FlexEntireData.FlexData createSinlgeFlexData(FlexEntireData flexEntireData, FlexProperty flexProperty, Object value) {
        FlexEntireData flexEntireData2 = flexEntireData;
        flexEntireData2.getClass();
        FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData2, flexProperty, value);
        FlexEntireData.FlexFieldDataType flexFieldDataType = "3".equals(flexProperty.getValueType()) ? FlexEntireData.FlexFieldDataType.STRING : FlexEntireData.FlexFieldDataType.LONG;
        flexData.setDbType(flexFieldDataType);
        return flexData;
    }

    public static List<AssistFilterEntry> buildAssistFilterInfo(ReportQueryParam reportQueryParam) {
        return (List)ThreadCache.get((Object)reportQueryParam, () -> FlexUtils.loadAssistFilterInfo(reportQueryParam), (boolean)true);
    }

    private static List<AssistFilterEntry> loadAssistFilterInfo(ReportQueryParam reportQueryParam) {
        FilterInfo reportFilter = reportQueryParam.getFilter();
        List props = reportFilter.getFlexFilterItems().stream().map(FilterItemInfo::getPropName).collect(Collectors.toList());
        if (props.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Set> propValues = reportFilter.getFlexFilterItems().stream().collect(Collectors.toMap(FilterItemInfo::getPropName, x -> (Set)x.getValue()));
        Map<String, FlexProperty> propInfos = FlexUtils.batchGetFlexProperty(propValues.keySet().toArray(new String[0]));
        return props.stream().map(k -> new AssistFilterEntry((String)k, (Set)propValues.get(k), (FlexProperty)propInfos.get(k))).collect(Collectors.toList());
    }

    public static Map<String, Triple<String, String, String>> buildFlexValueSourceMap(ReportQueryParam reportQueryParam) {
        HashMap<String, Triple<String, String, String>> flexMap = new HashMap<String, Triple<String, String, String>>(8);
        List<AssistFilterEntry> assistFilterEntries = FlexUtils.loadAssistFilterInfo(reportQueryParam);
        for (AssistFilterEntry assistFilterEntry : assistFilterEntries) {
            FlexProperty flexProperty = assistFilterEntry.getFlexProperty();
            String valType = flexProperty.getValueType();
            String entityId = null;
            switch (valType) {
                case "1": {
                    entityId = flexProperty.getValueSource();
                    break;
                }
                case "2": {
                    entityId = "bos_assistantdata_detail";
                }
            }
            String flexField = flexProperty.getFlexField();
            flexMap.put(flexField, (Triple<String, String, String>)Triple.of((Object)flexField, (Object)flexProperty.getName().getLocaleValue(), (Object)entityId));
        }
        return flexMap;
    }

    public static List<AssistFilterEntry> toAssistFilterEntries(Map<String, Set<Object>> selectValue) {
        Map<String, FlexProperty> flexProperties = FlexUtils.batchGetFlexProperty(selectValue.keySet().toArray(new String[0]));
        return selectValue.entrySet().stream().map(e -> new AssistFilterEntry((String)e.getKey(), (Set)e.getValue(), (FlexProperty)flexProperties.get(e.getKey()))).collect(Collectors.toList());
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnBalance(ReportQueryParam reportQueryParam, String balanceLikeEntity, boolean isUseFlexPropAsAlias) {
        return FlexUtils.buildDynamicORMAssistOnBalance(FlexUtils.buildAssistFilterInfo(reportQueryParam), balanceLikeEntity, isUseFlexPropAsAlias);
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnBalanceWithoutCache(ReportQueryParam reportQueryParam, String balanceLikeEntity, boolean isUseFlexPropAsAlias) {
        return FlexUtils.buildDynamicORMAssistOnBalance(FlexUtils.loadAssistFilterInfo(reportQueryParam), balanceLikeEntity, isUseFlexPropAsAlias);
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnBalanceWithoutCache(Map<String, Set<Object>> flexValueMap, String balanceLikeEntity, boolean isUseFlexPropAsAlias) {
        return FlexUtils.buildDynamicORMAssistOnBalance(FlexUtils.loadAssistFilterInfo(flexValueMap), balanceLikeEntity, isUseFlexPropAsAlias);
    }

    private static List<AssistFilterEntry> loadAssistFilterInfo(Map<String, Set<Object>> propValues) {
        Set<String> props = propValues.keySet();
        if (props.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, FlexProperty> propInfos = FlexUtils.batchGetFlexProperty(props.toArray(new String[0]));
        return props.stream().map(k -> new AssistFilterEntry((String)k, (Set)propValues.get(k), (FlexProperty)propInfos.get(k))).collect(Collectors.toList());
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnBalance(List<String> flexFields, String balanceLikeEntity, boolean isUseFlexPropAsAlias) {
        Map<String, FlexProperty> propInfos = FlexUtils.batchGetFlexProperty(flexFields.toArray(new String[0]));
        Collection assistFilterItems = flexFields.stream().map(k -> new AssistFilterEntry((String)k, (Set<Object>)new HashSet<Object>(0), (FlexProperty)propInfos.get(k))).collect(Collectors.toList());
        return FlexUtils.buildDynamicORMAssistOnBalance(assistFilterItems, balanceLikeEntity, isUseFlexPropAsAlias);
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnBalanceWithZero(Collection<AssistFilterEntry> assistFilterItems, String balanceLikeEntity, boolean isUseFlexPropAsAlias) {
        try {
            MainEntityType balEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)balanceLikeEntity).clone();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(assistFilterItems.size());
            ArrayList<String> selectFields = new ArrayList<String>(assistFilterItems.size());
            int index = 0;
            for (AssistFilterEntry entry : assistFilterItems) {
                ORMHint.JoinHint joinHint;
                DynamicObjectType type = entry.isManualAssist() ? (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSIST_TXT).clone() : (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSIST_DB).clone();
                BasedataProp prop = new BasedataProp();
                prop.setAlias("fassgrpid");
                prop.setName(ASSGRP_ALIAS_PREFIX + entry.getProperty());
                prop.setComplexType((IDataEntityType)type);
                ((LongProp)type.getProperties().get((Object)"id")).setAlias("fid");
                balEntity.addProperty((DynamicProperty)prop);
                String flexField = ASSGRP_ALIAS_PREFIX + entry.getProperty();
                QFilter joinOnFilter = new QFilter(flexField + ".asstype", "=", (Object)entry.getProperty());
                if (entry.isQueryAll()) {
                    joinHint = ORMHint.JoinHint.LEFT;
                } else if (entry.isQueryZero()) {
                    joinHint = ORMHint.JoinHint.LEFT;
                    qFilters.add(QFilter.isNull((String)(flexField + ".assval")));
                } else {
                    joinHint = ORMHint.JoinHint.INNER;
                    joinOnFilter.and(new QFilter(flexField + ".assval", "in", entry.getFilterVals()));
                }
                qFilters.add(QFilter.join((String)flexField, (String)(flexField + ".hg"), (QFilter)joinOnFilter, (ORMHint.JoinHint)joinHint, (boolean)false));
                if (isUseFlexPropAsAlias) {
                    selectFields.add(String.format("%s.assval %s", flexField, entry.getProperty()));
                } else {
                    selectFields.add(String.format("%s.assval assval%s", flexField, index == 0 ? "" : Integer.valueOf(index)));
                }
                ++index;
            }
            return Triple.of((Object)balEntity, qFilters, selectFields);
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException(e);
        }
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnBalance(Collection<AssistFilterEntry> assistFilterItems, String balanceLikeEntity, boolean isUseFlexPropAsAlias) {
        try {
            MainEntityType balEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)balanceLikeEntity).clone();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(assistFilterItems.size());
            ArrayList<String> selectFields = new ArrayList<String>(assistFilterItems.size());
            int index = 0;
            for (AssistFilterEntry entry : assistFilterItems) {
                DynamicObjectType type = entry.isManualAssist() ? (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSIST_TXT).clone() : (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSIST_DB).clone();
                BasedataProp prop = new BasedataProp();
                prop.setAlias("fassgrpid");
                prop.setName(ASSGRP_ALIAS_PREFIX + entry.getProperty());
                prop.setComplexType((IDataEntityType)type);
                ((LongProp)type.getProperties().get((Object)"id")).setAlias("fid");
                balEntity.addProperty((DynamicProperty)prop);
                String flexField = ASSGRP_ALIAS_PREFIX + entry.getProperty();
                if (!entry.getFilterVals().isEmpty()) {
                    qFilters.add(new QFilter(flexField + ".asstype", "=", (Object)entry.getProperty()));
                    qFilters.add(new QFilter(flexField + ".assval", "in", entry.getFilterVals()));
                } else {
                    qFilters.add(QFilter.join((String)flexField, (String)(flexField + ".hg"), (QFilter)new QFilter(flexField + ".asstype", "=", (Object)entry.getProperty()), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)false));
                }
                if (isUseFlexPropAsAlias) {
                    selectFields.add(String.format("%s.assval %s", flexField, entry.getProperty()));
                } else {
                    selectFields.add(String.format("%s.assval assval%s", flexField, index == 0 ? "" : Integer.valueOf(index)));
                }
                ++index;
            }
            return Triple.of((Object)balEntity, qFilters, selectFields);
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException(e);
        }
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnVoucher(ReportQueryParam reportQueryParam) {
        return FlexUtils.buildDynamicORMAssistOnVoucher(reportQueryParam, false);
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnVoucher(ReportQueryParam reportQueryParam, boolean isUseFlexPropAsAlias) {
        List<AssistFilterEntry> assistFilterItems = FlexUtils.loadAssistFilterInfo(reportQueryParam);
        return FlexUtils.buildDynamicORMAssistOnVoucher(assistFilterItems, isUseFlexPropAsAlias);
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnVoucher(Map<String, Set<Object>> flexValueMap) {
        return FlexUtils.buildDynamicORMAssistOnVoucher(flexValueMap, false);
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnVoucher(Map<String, Set<Object>> flexValueMap, boolean isUseFlexPropAsAlias) {
        List<AssistFilterEntry> assistFilterItems = FlexUtils.loadAssistFilterInfo(flexValueMap);
        return FlexUtils.buildDynamicORMAssistOnVoucher(assistFilterItems, isUseFlexPropAsAlias);
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnVoucher(Collection<AssistFilterEntry> assistFilterItems, boolean isUseFlexPropAsAlias) {
        try {
            MainEntityType voucherEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"gl_voucher").clone();
            EntityType entriesType = (EntityType)voucherEntity.getAllEntities().get("entries");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(assistFilterItems.size());
            ArrayList<String> selectFields = new ArrayList<String>(assistFilterItems.size());
            int index = 0;
            for (AssistFilterEntry entry : assistFilterItems) {
                DynamicObjectType type = entry.isManualAssist() ? (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSIST_TXT).clone() : (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSIST_DB).clone();
                BasedataProp prop = new BasedataProp();
                prop.setAlias("fassgrpid");
                prop.setName(VASSGRP_ALIAS_PREFIX + entry.getProperty());
                prop.setComplexType((IDataEntityType)type);
                ((LongProp)type.getProperties().get((Object)"id")).setAlias("fid");
                entriesType.addProperty((DynamicProperty)prop);
                String flexField = VOUCHER_ASSIST_ORM_PREFIX + entry.getProperty();
                if (!entry.getFilterVals().isEmpty()) {
                    qFilters.add(new QFilter(flexField + ".asstype", "=", (Object)entry.getProperty()));
                    qFilters.add(new QFilter(flexField + ".assval", "in", entry.getFilterVals()));
                } else {
                    qFilters.add(QFilter.join((String)flexField, (String)(flexField + ".hg"), (QFilter)new QFilter(flexField + ".asstype", "=", (Object)entry.getProperty()), (ORMHint.JoinHint)ORMHint.JoinHint.LEFT, (boolean)false));
                }
                if (isUseFlexPropAsAlias) {
                    selectFields.add(String.format("%s.assval %s", flexField, entry.getProperty()));
                } else {
                    selectFields.add(String.format("%s.assval assval%s", flexField, index == 0 ? "" : Integer.valueOf(index)));
                }
                ++index;
            }
            return Triple.of((Object)voucherEntity, qFilters, selectFields);
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException(e);
        }
    }

    public static Triple<MainEntityType, List<QFilter>, List<String>> buildDynamicORMAssistOnVoucherWithZero(Collection<AssistFilterEntry> assistFilterItems, boolean isUseFlexPropAsAlias) {
        try {
            MainEntityType voucherEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"gl_voucher").clone();
            EntityType entriesType = (EntityType)voucherEntity.getAllEntities().get("entries");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(assistFilterItems.size());
            ArrayList<String> selectFields = new ArrayList<String>(assistFilterItems.size());
            int index = 0;
            for (AssistFilterEntry entry : assistFilterItems) {
                ORMHint.JoinHint joinHint;
                DynamicObjectType type = entry.isManualAssist() ? (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSIST_TXT).clone() : (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSIST_DB).clone();
                BasedataProp prop = new BasedataProp();
                prop.setAlias("fassgrpid");
                prop.setName(VASSGRP_ALIAS_PREFIX + entry.getProperty());
                prop.setComplexType((IDataEntityType)type);
                ((LongProp)type.getProperties().get((Object)"id")).setAlias("fid");
                entriesType.addProperty((DynamicProperty)prop);
                String flexField = VOUCHER_ASSIST_ORM_PREFIX + entry.getProperty();
                QFilter joinOnFilter = new QFilter(flexField + ".asstype", "=", (Object)entry.getProperty());
                if (entry.isQueryAll()) {
                    joinHint = ORMHint.JoinHint.LEFT;
                } else if (entry.isQueryZero()) {
                    joinHint = ORMHint.JoinHint.LEFT;
                    qFilters.add(QFilter.isNull((String)(flexField + ".assval")));
                } else {
                    joinHint = ORMHint.JoinHint.INNER;
                    joinOnFilter.and(new QFilter(flexField + ".assval", "in", entry.getFilterVals()));
                }
                qFilters.add(QFilter.join((String)flexField, (String)(flexField + ".hg"), (QFilter)joinOnFilter, (ORMHint.JoinHint)joinHint, (boolean)false));
                if (isUseFlexPropAsAlias) {
                    selectFields.add(String.format("%s.assval %s", flexField, entry.getProperty()));
                } else {
                    selectFields.add(String.format("%s.assval assval%s", flexField, index == 0 ? "" : Integer.valueOf(index)));
                }
                ++index;
            }
            return Triple.of((Object)voucherEntity, qFilters, selectFields);
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException(e);
        }
    }

    public static List<Tuple<String, String>> buildAssTypenameList(ReportQueryParam reportQueryParam) {
        ArrayList<Tuple<String, String>> assTypenameList = new ArrayList<Tuple<String, String>>();
        List<AssistFilterEntry> assistFilterEntries = FlexUtils.loadAssistFilterInfo(reportQueryParam);
        for (AssistFilterEntry assistFilterEntry : assistFilterEntries) {
            FlexProperty flexProperty = assistFilterEntry.getFlexProperty();
            String valType = flexProperty.getValueType();
            String entityId = null;
            switch (valType) {
                case "1": {
                    entityId = flexProperty.getValueSource();
                    break;
                }
                case "2": {
                    entityId = "bos_assistantdata_detail";
                }
            }
            String disprops = flexProperty.getDisplayProp();
            String flexName = flexProperty.getName().getLocaleValue();
            if (StringUtils.isNotEmpty((CharSequence)disprops)) {
                String dispProp = JSONObject.parseObject((String)disprops).getJSONObject("disp").getString("dispprop");
                if ("1".equals(dispProp)) {
                    assTypenameList.add(new Tuple<String, String>(flexName, entityId + ",number"));
                    continue;
                }
                if ("3".equals(dispProp)) {
                    assTypenameList.add(new Tuple<String, String>(flexName, entityId + ",name,number"));
                    continue;
                }
                assTypenameList.add(new Tuple<String, String>(flexName, entityId));
                continue;
            }
            assTypenameList.add(new Tuple<String, String>(flexName, entityId));
        }
        return assTypenameList;
    }

    public static void preInitFlexItem(FilterInfo filterInfo, boolean isLink) {
        List flexFilterItems = filterInfo.getFlexFilterItems();
        ArrayList propNames = new ArrayList(flexFilterItems.size());
        flexFilterItems.stream().forEach(x -> propNames.add(x.getPropName()));
        Map<String, FlexProperty> flexProps = FlexUtils.batchGetFlexProperty(propNames.toArray(new String[0]));
        int detailLimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.assistdetail.limit", (int)5000);
        flexFilterItems.stream().forEach(x -> {
            String propName = x.getPropName();
            FlexProperty flexProperty = (FlexProperty)flexProps.get(propName);
            String entityName = flexProperty.getValueSource();
            if (FlexUtils.isNoneDetailAssgrp(flexProperty) && CollectionUtils.isNotEmpty((Collection)((Collection)x.getValue()))) {
                if (specialEntity.contains(entityName)) {
                    long viewId = SubsiDiaryHelper.getOrgViewId("1", entityName, propName);
                    ArrayList orgIds = new ArrayList(16);
                    ((Collection)x.getValue()).stream().forEach(id -> orgIds.add(Long.valueOf(id.toString())));
                    List orglist = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, orgIds, (boolean)true, (boolean)true);
                    if (CollectionUtils.isNotEmpty((Collection)orglist)) {
                        Set<Object> orgIdSet = new HashSet(orglist);
                        if (orglist.size() > detailLimit && isLink) {
                            orgIdSet = orglist.stream().limit(detailLimit).collect(Collectors.toSet());
                        }
                        x.setValue(orgIdSet);
                    }
                } else {
                    HashSet flexValueSet = (HashSet)x.getValue();
                    Set<Object> allLeafValueSet = FlexUtils.getAllLeafIdSet(flexValueSet, entityName, true);
                    if (allLeafValueSet.size() > detailLimit && isLink) {
                        allLeafValueSet = allLeafValueSet.stream().limit(detailLimit).collect(Collectors.toSet());
                    }
                    x.setValue(allLeafValueSet);
                }
            }
        });
    }

    public static Map<String, String> getFlex() {
        HashMap<String, String> flex = (HashMap<String, String>)ThreadCache.get((Object)FLEXPROPERTY);
        if (Objects.isNull(flex)) {
            List<FlexProperty> allFlexType = FlexUtils.getAllFlexType();
            flex = new HashMap<String, String>(allFlexType.size());
            for (FlexProperty flexPro : allFlexType) {
                String type = flexPro.getValueType();
                String flexfield = flexPro.getFlexField();
                String valuesource = flexPro.getValueSource();
                if (type.equalsIgnoreCase("1")) {
                    if ("bd_admindivision".equals(valuesource)) continue;
                    if ("bos_org".equals(valuesource)) {
                        String func = "15";
                        StringBuilder baseType = new StringBuilder(valuesource);
                        long orgfunc = flexPro.getOrgFunc();
                        if (orgfunc != 0L) {
                            func = String.valueOf(orgfunc);
                        }
                        baseType.append("+").append(func);
                        flex.put(flexfield, baseType.toString());
                        continue;
                    }
                    if ("bos_adminorg".equals(valuesource)) {
                        flex.put(flexfield, valuesource);
                        continue;
                    }
                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)valuesource);
                    DataEntityPropertyCollection properties = dataEntityType.getProperties();
                    HashSet<String> propSet = new HashSet<String>();
                    for (IDataEntityProperty prop : properties) {
                        if (prop.getAlias() == null) continue;
                        propSet.add(prop.getName());
                    }
                    if (!propSet.contains("parent") || !propSet.contains("isleaf")) continue;
                    flex.put(flexfield, valuesource);
                    continue;
                }
                if (!type.equalsIgnoreCase("2")) continue;
                String entity = "bos_assistantdata_detail";
                flex.put(flexfield, entity + "-" + flexPro.getAssistantType());
            }
            ThreadCache.put((Object)FLEXPROPERTY, flex);
        }
        return flex;
    }

    public static boolean isNotLeafData(String valuesource, Long pkId) {
        HashMap<String, Set<Long>> nonLeaf = (HashMap<String, Set<Long>>)ThreadCache.get((Object)PARENTDATA);
        if (Objects.isNull(nonLeaf)) {
            nonLeaf = new HashMap<String, Set<Long>>(20);
            Set<Long> ids = FlexUtils.getParentData(valuesource);
            nonLeaf.put(valuesource, ids);
            ThreadCache.put((Object)PARENTDATA, nonLeaf);
            return ids.contains(pkId);
        }
        Set<Long> ids = (Set<Long>)nonLeaf.get(valuesource);
        if (Objects.isNull(ids)) {
            ids = FlexUtils.getParentData(valuesource);
            nonLeaf.put(valuesource, ids);
            return ids.contains(pkId);
        }
        return ids.contains(pkId);
    }

    public static Set<Long> getParentData(String valueSource) {
        HashSet<Long> ids = new HashSet<Long>(100);
        QFilter fisleaf = new QFilter("isleaf", "=", (Object)false);
        if (valueSource.startsWith("bos_org")) {
            String view = valueSource.substring(8);
            QFilter fview = new QFilter("view", "=", (Object)Long.valueOf(view));
            Map objs = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{fview, fisleaf});
            objs.values().stream().forEach(x -> ids.add(x.getLong("org_id")));
        } else if (valueSource.startsWith("bos_adminorg")) {
            QFilter fview = new QFilter("view", "=", (Object)1L);
            Map objs = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{fview, fisleaf});
            objs.values().stream().forEach(x -> ids.add(x.getLong("org_id")));
        } else if (valueSource.startsWith("bos_assistantdata_detail")) {
            String[] vs = valueSource.split("-");
            QFilter type = new QFilter("group", "=", (Object)Long.valueOf(vs[1]));
            Map objs = BusinessDataServiceHelper.loadFromCache((String)vs[0], (String)"isleaf", (QFilter[])new QFilter[]{fisleaf, type});
            objs.values().stream().forEach(x -> ids.add(x.getLong("id")));
        } else {
            Map objs = BusinessDataServiceHelper.loadFromCache((String)valueSource, (String)"isleaf", (QFilter[])new QFilter[]{fisleaf});
            objs.values().stream().forEach(x -> ids.add(x.getLong("id")));
        }
        return ids;
    }

    public static String getFlexPropertyLocalName(FlexProperty flexProperty) {
        if (flexProperty == null) {
            return "";
        }
        LocaleString name = flexProperty.getName();
        if (name != null) {
            return name.getLocaleValue();
        }
        return flexProperty.getGLName();
    }

    public static boolean isBaseDataAndMasteridProperty(String flexField) {
        Boolean isBaseDataAndMasterid;
        HashMap<String, Boolean> flexPropMap = LocalCacheHelper.get(CacheKey.getCacheKey(CacheKeyPrefix.IS_BASEDATA_AND_MASTERID_PROPERTY, new Object[0]), Map.class);
        if (flexPropMap == null) {
            flexPropMap = new HashMap<String, Boolean>(16);
        }
        if ((isBaseDataAndMasterid = (Boolean)flexPropMap.get(flexField)) == null) {
            DynamicProperty masteridProperty;
            FlexProperty flexProperty = FlexUtils.getFlexProperty(flexField);
            if (flexProperty != null && AssistValueType.isBaseData(flexProperty.getValueType()) && (masteridProperty = MetadataServiceHelper.getDataEntityType((String)flexProperty.getValueSource()).getProperty("masterid")) != null && StringUtils.isNotBlank((CharSequence)masteridProperty.getAlias())) {
                isBaseDataAndMasterid = true;
            }
            if (isBaseDataAndMasterid == null) {
                isBaseDataAndMasterid = false;
            }
            flexPropMap.put(flexField, isBaseDataAndMasterid);
            LocalCacheHelper.put(CacheKey.getCacheKey(CacheKeyPrefix.IS_BASEDATA_AND_MASTERID_PROPERTY, new Object[0]), flexPropMap);
        }
        return isBaseDataAndMasterid;
    }

    private static /* synthetic */ Object lambda$batchSaveFlexData$14(Map masterIds, Object x) {
        return masterIds.get(x) == null ? x : masterIds.get(x);
    }

    static {
        specialEntity.add("bos_org");
        specialEntity.add("bos_adminorg");
        specialEntityMap = new HashMap<String, String>(2, 1.0f);
        specialEntityMap.put("bos_org", "bos_org_structure");
        specialEntityMap.put("bos_adminorg", "bos_adminorg_structure");
        MAIN_ENTITY_TYPE = null;
    }

    public static class AssistFilterEntry
    implements Serializable {
        private static final long serialVersionUID = 3821145997517017882L;
        private String property;
        private Set<Object> filterVals = new HashSet<Object>(8);
        private transient FlexProperty flexProperty;

        public AssistFilterEntry(String property, Set<Object> filterVals, FlexProperty flexProperty) {
            this.property = property;
            this.filterVals = filterVals;
            this.flexProperty = flexProperty;
        }

        public AssistFilterEntry() {
        }

        @Transient
        public boolean isManualAssist() {
            return StringUtils.isEmpty((CharSequence)this.getFlexProperty().getValueSource());
        }

        @Transient
        public boolean isQueryZero() {
            return this.filterVals != null && (this.filterVals.contains(0L) || this.filterVals.contains(0) || this.filterVals.contains(""));
        }

        @Transient
        public boolean isQueryAll() {
            return CollectionUtils.isEmpty(this.filterVals);
        }

        public String getProperty() {
            return this.property;
        }

        public Set<Object> getFilterVals() {
            return this.filterVals;
        }

        @Transient
        public FlexProperty getFlexProperty() {
            if (this.flexProperty == null) {
                this.flexProperty = FlexUtils.getFlexProperty(this.property);
            }
            return this.flexProperty;
        }

        public String toString() {
            return GLUtil.toJsonStr(this);
        }
    }
}

