/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.sdk.exception.BeginDtxException;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.closeperiod.VoucherIntermitNOInfo;

public class GLBreakPointUtil {
    public static final ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);

    public static DynamicObjectCollection getCodeRuleEntry(CodeRuleInfo coderule) {
        return GLBreakPointUtil.getCodeRuleEntry(coderule.getId());
    }

    public static DynamicObjectCollection getCodeRuleEntry(String codeRuleId) {
        return (DynamicObjectCollection)ThreadCache.get((Object)("GLBreakPointUtil" + codeRuleId), () -> {
            String selectedFields = "id,ruleentry.seq,ruleentry.attributetype attributetype,ruleentry.isvisable isvisable,ruleentry.issortitem issortitem,ruleentry.splitsignentry splitsignentry,ruleentry.length length,ruleentry.fixval fixval,ruleentry.format format,ruleentry.valueatribute valueatribute,ruleentry.attusingmode attusingmode,ruleentry.addchar addchar,ruleentry.addstyle addstyle,ruleentry.cutstyle cutstyle";
            QFilter qid = new QFilter("id", "=", (Object)codeRuleId);
            return QueryServiceHelper.query((String)"bos_coderule", (String)selectedFields, (QFilter[])new QFilter[]{qid}, (String)"ruleentry.seq asc");
        });
    }

    public static boolean isMatchCodeRule(String number, String templateNumber, int indexOfserial, int lengthOfserial) {
        if (number.length() != templateNumber.length()) {
            return false;
        }
        try {
            String n = number.substring(0, indexOfserial) + number.substring(indexOfserial + lengthOfserial);
            String t = templateNumber.substring(0, indexOfserial) + templateNumber.substring(indexOfserial + lengthOfserial);
            String serial = number.substring(indexOfserial, indexOfserial + lengthOfserial);
            Pattern pattern = Pattern.compile("[0-9]*");
            if (!pattern.matcher(serial).matches()) {
                return false;
            }
            if (!n.equals(t)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static List<HashMap<String, String>> getAttributeFromCodeRuleEntry(DynamicObjectCollection ruleEntry) {
        ArrayList<HashMap<String, String>> l = new ArrayList<HashMap<String, String>>(ruleEntry.size());
        for (int i = 0; i < ruleEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)ruleEntry.get(i);
            boolean isvisable = entry.getBoolean("isvisable");
            HashMap<String, String> map = new HashMap<String, String>(12);
            boolean issortitem = entry.getBoolean("issortitem");
            String attributetype = entry.getString("attributetype");
            String attusingmode = entry.getString("attusingmode");
            String valueatribute = entry.getString("valueatribute");
            String fixval = entry.getString("fixval");
            String format = entry.getString("format");
            String length = entry.getString("length");
            String splitsignentry = entry.getString("splitsignentry");
            String addchar = entry.getString("addchar");
            String addstyle = entry.getString("addstyle");
            String cutstyle = entry.getString("cutstyle");
            switch (attributetype) {
                case "1": {
                    length = format.length() + "";
                    break;
                }
                case "2": {
                    format = entry.getString("format");
                    length = format.length() + "";
                    break;
                }
            }
            map.put("attributetype", attributetype);
            map.put("attusingmode", attusingmode);
            map.put("valueatribute", valueatribute);
            map.put("length", length);
            map.put("splitsignentry", splitsignentry);
            map.put("issortitem", issortitem + "");
            map.put("isvisable", isvisable + "");
            map.put("fixval", fixval);
            map.put("format", format);
            map.put("addchar", addchar);
            map.put("addstyle", addstyle);
            map.put("cutstyle", cutstyle);
            l.add(map);
        }
        return l;
    }

    public static List<List<DynamicObject>> getIssortitemvouchers(List<HashMap<String, String>> codeRuleEntryAttributes, DynamicObject[] voucherList) {
        ArrayList<List<DynamicObject>> issortitemvouchers = new ArrayList<List<DynamicObject>>();
        ArrayList<DynamicObject> l = new ArrayList<DynamicObject>();
        List<Map<String, String>> issortitemFields = GLBreakPointUtil.getIssortitemFields(codeRuleEntryAttributes, false);
        StringBuilder issortitemValues = new StringBuilder();
        for (int i = 0; i < voucherList.length; ++i) {
            DynamicObject voucher = voucherList[i];
            String lastVoIssortitemValues = issortitemValues.toString();
            issortitemValues = new StringBuilder();
            for (Map<String, String> map : issortitemFields) {
                issortitemValues.append(GLBreakPointUtil.getOneSortItemString(map, GLBreakPointUtil.getVoucherInfo(voucher, issortitemFields)));
                issortitemValues.append("+");
            }
            if (i == 0) {
                l.add(voucher);
            } else if (lastVoIssortitemValues.equals(issortitemValues.toString())) {
                l.add(voucher);
            } else {
                issortitemvouchers.add(l);
                l = new ArrayList();
                l.add(voucher);
            }
            if (i != voucherList.length - 1) continue;
            issortitemvouchers.add(l);
        }
        return issortitemvouchers;
    }

    public static List<Map<String, String>> getIssortitemFields(List<HashMap<String, String>> codeRuleEntryAttributes, boolean isNotissortitem) {
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        for (HashMap<String, String> map : codeRuleEntryAttributes) {
            String issortitem = map.get("issortitem");
            if (!isNotissortitem) {
                if (!"true".equals(issortitem)) continue;
                l.add(map);
                continue;
            }
            String valueatribute = map.get("valueatribute");
            if (StringUtils.isEmpty((CharSequence)valueatribute.trim())) continue;
            l.add(map);
        }
        return l;
    }

    public static List<QFilter> getVouFiltersByCodeRule(QFilter addFilter, List<HashMap<String, String>> codeRuleEntryAttributes, Map<String, Object> voucherInfo) {
        ArrayList<QFilter> qs = new ArrayList<QFilter>();
        qs.add(addFilter);
        for (HashMap<String, String> map : codeRuleEntryAttributes) {
            String issortitem = map.get("issortitem");
            String attributetype = map.get("attributetype");
            if (!"true".equals(issortitem) || !"8".equals(attributetype) && !"2".equals(attributetype)) continue;
            String valueatribute = map.get("valueatribute");
            QFilter q = new QFilter(valueatribute, "=", voucherInfo.get(valueatribute));
            qs.add(q);
        }
        return qs;
    }

    public static DataSet queryVoucherDataset(Map<String, Object> map, List<HashMap<String, String>> codeRuleEntryAttributes, QFilter qFilter, int seletedFieldstype, int ordByFieldstype, int dateordertype) {
        QFilter[] qfilters = GLBreakPointUtil.getFilters(map, qFilter);
        String selectedField = GLBreakPointUtil.getSelectedField(codeRuleEntryAttributes, 1);
        DataSet voucherDataSet = VoucherQueryUtils.queryDataSet((String)selectedField, (QFilter[])qfilters, null, (int)-1);
        voucherDataSet = GLBreakPointUtil.getOrderByVoucherDataSet(voucherDataSet, codeRuleEntryAttributes, dateordertype);
        return voucherDataSet;
    }

    public static DataSet getOrderByVoucherDataSet(DataSet voucherDataSet, List<HashMap<String, String>> codeRuleEntryAttributes, int dateordertype) {
        int seriallenth = Integer.parseInt(codeRuleEntryAttributes.get(codeRuleEntryAttributes.size() - 1).get("length"));
        voucherDataSet = voucherDataSet.addField("right(billno," + seriallenth + ")", "serialno");
        StringBuilder orderbyFields = new StringBuilder();
        for (HashMap<String, String> entrymap : codeRuleEntryAttributes) {
            String attributetype;
            String issortitem = entrymap.get("issortitem");
            if (!"true".equals(issortitem)) continue;
            String valueatribute = entrymap.get("valueatribute").trim();
            switch (attributetype = entrymap.get("attributetype")) {
                case "2": {
                    String format = entrymap.get("format");
                    String datefield = String.format("TO_CHAR(%s,'%s')", valueatribute, format);
                    voucherDataSet = voucherDataSet.addField(datefield, "orderdate");
                    orderbyFields.append("orderdate,");
                    break;
                }
                case "4": 
                case "8": {
                    String attusingmode = entrymap.get("attusingmode");
                    if (!"3".equals(attusingmode)) {
                        String length = entrymap.get("length");
                        String cutstyle = entrymap.get("cutstyle");
                        String substrfield = "true".equals(cutstyle) ? String.format("left(%s,%s)", valueatribute, length) : String.format("right(%s,%s)", valueatribute, length);
                        String orderField = String.format("order%s", valueatribute);
                        voucherDataSet = voucherDataSet.addField(substrfield, orderField);
                        orderbyFields.append(orderField).append(",");
                        break;
                    }
                    if (valueatribute.startsWith("org")) break;
                    orderbyFields.append(valueatribute).append(",");
                    break;
                }
            }
        }
        if (dateordertype == 1) {
            orderbyFields.append("bookeddate,");
        } else if (dateordertype == 2) {
            orderbyFields.append("bizdate,");
        } else if (dateordertype == 3) {
            orderbyFields.append("submitter.id,");
        }
        orderbyFields.append("serialno");
        return voucherDataSet.orderBy(orderbyFields.toString().split(","));
    }

    public static DynamicObject[] queryVoucher(Map<String, Object> map, List<HashMap<String, String>> codeRuleEntryAttributes, QFilter qFilter) {
        QFilter[] qfilters = GLBreakPointUtil.getFilters(map, qFilter);
        String selectedField = GLBreakPointUtil.getSelectedField(codeRuleEntryAttributes, 1);
        DynamicObject[] voucherList = BusinessDataServiceHelper.load((String)"gl_voucher", (String)selectedField, (QFilter[])qfilters, (String)"billno");
        return voucherList;
    }

    private static QFilter[] getFilters(Map<String, Object> map, QFilter qFilter) {
        QFilterBuilder qFilterBuilder = new QFilterBuilder().addEqual("org", (Object)Long.parseLong(String.valueOf(map.get("orgId")))).addEqual("booktype", (Object)Long.parseLong(String.valueOf(map.get("booktype")))).addEqual("period", (Object)Long.parseLong(String.valueOf(map.get("period"))));
        if (Boolean.TRUE.equals(map.get("condition")) || !map.containsKey("condition")) {
            qFilterBuilder.addIn("billstatus", (Object)new String[]{"B", "C", "D"});
        }
        if (qFilter != null) {
            qFilterBuilder.add(qFilter);
        }
        return qFilterBuilder.toArray(new QFilter[0]);
    }

    private static String getSelectedField(List<HashMap<String, String>> codeRuleEntryAttributes, int seletedFieldstype) {
        StringBuilder seletedFields = new StringBuilder("id,vouchertype,vouchertype.name,bizdate,bookeddate,billno,billstatus,submitter.id,org.id,sourcetype, booktype.id booktypeid , period.id periodid ");
        for (HashMap<String, String> attri : codeRuleEntryAttributes) {
            String valueatribute;
            String attributetype = attri.get("attributetype");
            if (!"2".equals(attributetype) && !"4".equals(attributetype) && !"8".equals(attributetype) || (valueatribute = attri.get("valueatribute")) == null || "".equals(valueatribute.trim())) continue;
            if (seletedFieldstype == 1) {
                if (seletedFields.toString().contains(valueatribute.trim())) continue;
                seletedFields.append(",");
                seletedFields.append(valueatribute.trim());
                continue;
            }
            String[] s = valueatribute.split("\\.");
            if (s.length > 1) {
                seletedFields.append(",");
                seletedFields.append(s[0]);
            }
            seletedFields.append(",");
            seletedFields.append(valueatribute.trim());
        }
        return seletedFields.toString();
    }

    public static String getOneSortItemString(Map<String, String> attributeMap, Map<String, Object> vocherinfo) {
        String attributetype;
        String result = "";
        switch (attributetype = attributeMap.get("attributetype")) {
            case "1": {
                result = attributeMap.get("format");
                break;
            }
            case "2": {
                String format = attributeMap.get("format");
                try {
                    String valueatribute = attributeMap.get("valueatribute");
                    String date = GLBreakPointUtil.getDate(valueatribute, vocherinfo);
                    SimpleDateFormat formatter = new SimpleDateFormat(format);
                    result = formatter.format(Long.parseLong(date));
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38...", (String)"GLBreakPointUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), e);
                }
            }
            case "4": 
            case "8": {
                String attusingmode = attributeMap.get("attusingmode");
                String valueatribute = attributeMap.get("valueatribute");
                String value = null;
                if (vocherinfo.get(valueatribute) instanceof Date) {
                    Date t = (Date)vocherinfo.get(valueatribute);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    value = sdf.format(t);
                } else {
                    value = String.valueOf(vocherinfo.get(valueatribute));
                }
                if ("3".equals(attusingmode)) {
                    result = value;
                    break;
                }
                String length = attributeMap.get("length");
                if (value.length() < Integer.parseInt(length)) {
                    String addchar = attributeMap.get("addchar");
                    int numOfaddchars = Integer.parseInt(length) - value.length();
                    StringBuilder add = new StringBuilder();
                    for (int j = 0; j < numOfaddchars; ++j) {
                        add.append(addchar);
                    }
                    String addstyle = attributeMap.get("addstyle");
                    String addStr = add.toString();
                    if ("true".equals(addstyle)) {
                        result = value + addStr;
                        break;
                    }
                    result = addStr + value;
                    break;
                }
                if (value.length() > Integer.parseInt(length)) {
                    String cutstyle = attributeMap.get("cutstyle");
                    if ("true".equals(cutstyle)) {
                        result = value.substring(0, Integer.parseInt(length));
                        break;
                    }
                    result = value.substring(value.length() - Integer.parseInt(length), value.length());
                    break;
                }
                result = value;
                break;
            }
            case "16": {
                break;
            }
        }
        return result;
    }

    public static Map<String, String> resetBreakNumber(String codeRuleId, String breaknumberSerial, Map<String, Object> vocherinfo) {
        HashMap<String, String> m = new HashMap<String, String>();
        List<HashMap<String, String>> codeRuleEntryAttributes = GLBreakPointUtil.getAttributeFromCodeRuleEntry(GLBreakPointUtil.getCodeRuleEntry(codeRuleId));
        StringBuilder resetNumber = new StringBuilder();
        int indexOfSerial = 0;
        int lengthOfSerial = 0;
        for (int i = 0; i < codeRuleEntryAttributes.size(); ++i) {
            String splitsignentry;
            HashMap<String, String> map = codeRuleEntryAttributes.get(i);
            String isvisable = map.get("isvisable");
            if ("false".equals(isvisable)) continue;
            if (i != 0 && !"".equals((splitsignentry = map.get("splitsignentry")).trim())) {
                resetNumber.append(splitsignentry);
            }
            resetNumber.append(GLBreakPointUtil.getOneSortItemString(map, vocherinfo));
            if (!"16".equals(map.get("attributetype"))) continue;
            String seriallength = map.get("length");
            indexOfSerial = resetNumber.length();
            lengthOfSerial = Integer.parseInt(seriallength);
            int numOfzeros = lengthOfSerial - breaknumberSerial.length();
            for (int j = 0; j < numOfzeros; ++j) {
                resetNumber.append("0");
            }
            resetNumber.append(breaknumberSerial);
        }
        m.put("resetNumber", resetNumber.toString());
        m.put("indexOfSerial", String.valueOf(indexOfSerial));
        m.put("lengthOfSerial", String.valueOf(lengthOfSerial));
        return m;
    }

    private static String getDate(String attributetype, Map<String, Object> vocherinfo) {
        String propertyValue = null;
        if (vocherinfo != null && vocherinfo.get(attributetype) != null) {
            try {
                propertyValue = String.valueOf(((Date)vocherinfo.get(attributetype)).getTime());
            }
            catch (Exception e) {
                return null;
            }
        }
        return propertyValue;
    }

    public static String[] checkConsistent(String coderuleid, List<HashMap<String, String>> codeRuleEntryAttributes, Map<String, Object> paramMap, int dateordertype, boolean isNoneBreak) {
        String[] result = new String[3];
        boolean sortbyorg = false;
        boolean sortbyperiod = false;
        for (int i = 0; i < codeRuleEntryAttributes.size(); ++i) {
            HashMap<String, String> codeRuleEntryMap = codeRuleEntryAttributes.get(i);
            String issortitem = codeRuleEntryMap.get("issortitem");
            String valueatribute = codeRuleEntryMap.get("valueatribute");
            if ("true".equals(issortitem) && valueatribute.startsWith("org.")) {
                sortbyorg = true;
            }
            if ("true".equals(issortitem) && valueatribute.startsWith("period.")) {
                sortbyperiod = true;
            }
            String attributetype = codeRuleEntryMap.get("attributetype");
            if (i != codeRuleEntryAttributes.size() - 1 || "16".equals(attributetype)) continue;
            result[0] = "2";
            result[1] = ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u4e0d\u5728\u7f16\u7801\u6700\u540e\u6bb5\uff0c\u4e0d\u68c0\u67e5\u65ad\u53f7", (String)"GLBreakPointUtil_1", (String)"fi-gl-common", (Object[])new Object[0]);
            return result;
        }
        if (!sortbyorg || !sortbyperiod) {
            if (!isNoneBreak) {
                result[0] = "2";
                result[1] = ResManager.loadKDString((String)"\u5f53\u524d\u7f16\u7801\u89c4\u5219\u5141\u8bb8\u65ad\u53f7\uff0c\u4e14\u6d41\u6c34\u53f7\u4f9d\u636e\u4e2d\u4e0d\u5305\u542b\u7ec4\u7ec7\u548c\u671f\u95f4\uff0c\u4e0d\u68c0\u67e5\u65ad\u53f7\u3002", (String)"GLBreakPointUtil_2", (String)"fi-gl-common", (Object[])new Object[0]);
                return result;
            }
            List<Map<String, String>> issortitemFields = GLBreakPointUtil.getIssortitemFields(codeRuleEntryAttributes, false);
            List<Map<String, String>> issortitemTrueFields = GLBreakPointUtil.getIssortitemFields(codeRuleEntryAttributes, true);
            StringBuilder breakSb = new StringBuilder();
            StringBuilder unmatchSb = new StringBuilder();
            boolean isBreak = false;
            HashMap<String, VoucherIntermitNOInfo> sortItemKeyBreakNosMap = new HashMap<String, VoucherIntermitNOInfo>();
            Throwable throwable = null;
            try (DataSet voucherDataset = GLBreakPointUtil.queryVoucherDataset(paramMap, codeRuleEntryAttributes, null, 1, 1, dateordertype);){
                String sortItemValue = null;
                String lastSortItemValue = null;
                Map<String, Object> voucherinfo = null;
                Row row = null;
                Map<String, String> resetNumMap = null;
                String templateNumber = null;
                String number = null;
                int lastSerialNum = 0;
                while (voucherDataset.hasNext()) {
                    row = voucherDataset.next();
                    voucherinfo = GLBreakPointUtil.getVoucherInfo(issortitemTrueFields, row);
                    sortItemValue = GLBreakPointUtil.getSortitemvalue(issortitemFields, voucherinfo);
                    VoucherIntermitNOInfo noInfo = (VoucherIntermitNOInfo)sortItemKeyBreakNosMap.get(sortItemValue);
                    if (noInfo == null) {
                        noInfo = new VoucherIntermitNOInfo(GLBreakPointUtil.getBreakNos(coderuleid, sortItemValue), 0L, 0L);
                        sortItemKeyBreakNosMap.put(sortItemValue, noInfo);
                    }
                    resetNumMap = GLBreakPointUtil.resetBreakNumber(coderuleid, "1", voucherinfo);
                    templateNumber = resetNumMap.get("resetNumber");
                    number = row.getString("billno");
                    boolean ismatch = GLBreakPointUtil.isMatchCodeRule(number, templateNumber, Integer.parseInt(resetNumMap.get("indexOfSerial")), Integer.parseInt(resetNumMap.get("lengthOfSerial")));
                    if (ismatch) {
                        int indexOfSerial = Integer.parseInt(resetNumMap.get("indexOfSerial"));
                        int lengthOfSerial = Integer.parseInt(resetNumMap.get("lengthOfSerial"));
                        int serialNum = Integer.parseInt(number.substring(indexOfSerial, indexOfSerial + lengthOfSerial));
                        if (lastSortItemValue == null) {
                            lastSortItemValue = sortItemValue;
                            lastSerialNum = serialNum;
                        } else if (!lastSortItemValue.equals(sortItemValue)) {
                            lastSerialNum = serialNum;
                        } else {
                            if (dateordertype != 0 && lastSerialNum > serialNum) {
                                isBreak = true;
                            }
                            lastSerialNum = serialNum;
                        }
                        if (noInfo.getMinserial() == 0L || noInfo.getMinserial() > (long)serialNum) {
                            noInfo.setMinserial(serialNum);
                        }
                        if (noInfo.getMaxserial() != 0L && noInfo.getMaxserial() >= (long)serialNum) continue;
                        noInfo.setMaxserial(serialNum);
                        continue;
                    }
                    result[0] = "0";
                    isBreak = true;
                    result[1] = ResManager.loadKDString((String)"\u5b58\u5728\u65ad\u53f7,\u6709\u51ed\u8bc1\u53f7\u4e0d\u6ee1\u8db3\u7f16\u7801\u89c4\u5219", (String)"GLBreakPointUtil_3", (String)"fi-gl-common", (Object[])new Object[0]);
                    Long voucherId = row.getLong("id");
                    if (unmatchSb.length() == 0) {
                        String orgName = String.valueOf(paramMap.get("orgName"));
                        unmatchSb.append(orgName).append(ResManager.loadKDString((String)"\u4e0b\u5217\u51ed\u8bc1\u53f7\u4e0d\u6ee1\u8db3\u7f16\u7801\u89c4\u5219\uff1a", (String)"GLBreakPointUtil_4", (String)"fi-gl-common", (Object[])new Object[0])).append("\n");
                        unmatchSb.append(number);
                        continue;
                    }
                    if (unmatchSb.length() > 30000) {
                        unmatchSb.append("\n").append("...");
                        break;
                    }
                    unmatchSb.append(MultiLangPunc.comma()).append(number);
                }
            }
            catch (Throwable sortItemValue) {
                Throwable throwable2 = sortItemValue;
                throw sortItemValue;
            }
            block20: for (Map.Entry entry : sortItemKeyBreakNosMap.entrySet()) {
                VoucherIntermitNOInfo info = (VoucherIntermitNOInfo)entry.getValue();
                Queue<Long> breakNos = info.getBreakNos();
                for (Long breakNo : breakNos) {
                    if (info.getMinserial() == 0L || breakNo >= info.getMaxserial()) continue;
                    result[0] = "0";
                    isBreak = true;
                    result[1] = ResManager.loadKDString((String)"\u5b58\u5728\u65ad\u53f7", (String)"GLBreakPointUtil_5", (String)"fi-gl-common", (Object[])new Object[0]);
                    if (breakSb.length() == 0) {
                        String orgName = String.valueOf(paramMap.get("orgName"));
                        breakSb.append(orgName).append(ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u6d41\u6c34\u53f7\u65ad\u53f7\uff1a", (String)"GLBreakPointUtil_6", (String)"fi-gl-common", (Object[])new Object[0])).append("\n").append(breakNo);
                        continue;
                    }
                    if (breakSb.length() > 30000) {
                        breakSb.append("\n").append("...");
                        continue block20;
                    }
                    breakSb.append(MultiLangPunc.comma()).append(breakNo);
                }
            }
            if (dateordertype == 0) {
                if (breakSb.length() > 0 || unmatchSb.length() > 0) {
                    if (breakSb.length() > 0) {
                        breakSb.append("\n");
                    }
                    if (unmatchSb.length() > 0) {
                        unmatchSb.append("\n");
                    }
                    result[2] = breakSb.append((CharSequence)unmatchSb).toString();
                } else {
                    result[0] = "1";
                    result[1] = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u5b58\u5728\u65ad\u53f7\u3002", (String)"GLBreakPointUtil_7", (String)"fi-gl-common", (Object[])new Object[0]);
                }
            } else if (isBreak) {
                result[0] = "0";
                result[1] = ResManager.loadKDString((String)"\u5b58\u5728\u65ad\u53f7", (String)"GLBreakPointUtil_5", (String)"fi-gl-common", (Object[])new Object[0]);
            } else {
                result[0] = "1";
                result[1] = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u5b58\u5728\u65ad\u53f7\u3002", (String)"GLBreakPointUtil_7", (String)"fi-gl-common", (Object[])new Object[0]);
            }
        } else {
            try (DataSet voucherDataset = GLBreakPointUtil.queryVoucherDataset(paramMap, codeRuleEntryAttributes, null, 1, 1, dateordertype);){
                List<Map<String, String>> issortitemFields = GLBreakPointUtil.getIssortitemFields(codeRuleEntryAttributes, false);
                List<Map<String, String>> issortitemTrueFields = GLBreakPointUtil.getIssortitemFields(codeRuleEntryAttributes, true);
                StringBuilder issortitemValues = new StringBuilder();
                Row row = null;
                Object var15_26 = null;
                Map<String, String> m = null;
                String templateNumber = null;
                String number = null;
                String typeName = null;
                boolean ismatch = false;
                int lastSerialNum = 0;
                String lastNumber = "*";
                Long lastVoucherId = 0L;
                StringBuilder unmatchSb = new StringBuilder();
                StringBuilder breakSb = new StringBuilder();
                while (voucherDataset.hasNext()) {
                    row = voucherDataset.next();
                    Long voucherId = row.getLong("id");
                    String lastVoIssortitemValues = issortitemValues.toString();
                    issortitemValues = new StringBuilder();
                    typeName = row.getString("vouchertype.name");
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(issortitemTrueFields.size());
                    for (Map<String, String> map : issortitemTrueFields) {
                        String field = map.get("valueatribute");
                        hashMap.put(field, row.get(field));
                    }
                    for (Map<String, String> map : issortitemFields) {
                        issortitemValues.append(GLBreakPointUtil.getOneSortItemString(map, hashMap));
                        issortitemValues.append("+");
                    }
                    if (!lastVoIssortitemValues.isEmpty() && !issortitemValues.toString().equals(lastVoIssortitemValues)) {
                        lastSerialNum = 0;
                    }
                    m = GLBreakPointUtil.resetBreakNumber(coderuleid, "1", hashMap);
                    templateNumber = m.get("resetNumber");
                    number = row.getString("billno");
                    ismatch = GLBreakPointUtil.isMatchCodeRule(number, templateNumber, Integer.parseInt(m.get("indexOfSerial")), Integer.parseInt(m.get("lengthOfSerial")));
                    if (ismatch) {
                        int lengthOfSerial;
                        int indexOfSerial = Integer.parseInt(m.get("indexOfSerial"));
                        int serialNum = Integer.parseInt(number.substring(indexOfSerial, indexOfSerial + (lengthOfSerial = Integer.parseInt(m.get("lengthOfSerial")))));
                        if (serialNum != lastSerialNum + 1) {
                            result[0] = "0";
                            result[1] = ResManager.loadKDString((String)"\u5b58\u5728\u65ad\u53f7", (String)"GLBreakPointUtil_5", (String)"fi-gl-common", (Object[])new Object[0]);
                            if (breakSb.length() == 0) {
                                String orgName = String.valueOf(paramMap.get("orgName"));
                                breakSb.append(orgName).append(ResManager.loadKDString((String)"\u4e0b\u5217\u51ed\u8bc1\u53f7\u4e4b\u95f4\u5b58\u5728\u65ad\u53f7\uff1a", (String)"GLBreakPointUtil_8", (String)"fi-gl-common", (Object[])new Object[0])).append("\n");
                                breakSb.append(typeName).append(" ").append(lastNumber).append(ResManager.loadKDString((String)"\u81f3", (String)"GLBreakPointUtil_9", (String)"fi-gl-common", (Object[])new Object[0])).append(typeName).append(" ").append(number);
                            } else {
                                if (breakSb.length() > 30000) {
                                    breakSb.append("\n").append("...");
                                    break;
                                }
                                breakSb.append(MultiLangPunc.comma()).append(typeName).append(" ").append(lastNumber).append(ResManager.loadKDString((String)"\u81f3", (String)"GLBreakPointUtil_9", (String)"fi-gl-common", (Object[])new Object[0])).append(typeName).append(" ").append(number);
                            }
                        }
                        lastSerialNum = serialNum;
                        lastNumber = number;
                    } else {
                        result[0] = "0";
                        result[1] = ResManager.loadKDString((String)"\u5b58\u5728\u65ad\u53f7,\u6709\u51ed\u8bc1\u53f7\u4e0d\u6ee1\u8db3\u7f16\u7801\u89c4\u5219", (String)"GLBreakPointUtil_3", (String)"fi-gl-common", (Object[])new Object[0]);
                        if (unmatchSb.length() == 0) {
                            String orgName = String.valueOf(paramMap.get("orgName"));
                            unmatchSb.append(orgName).append(ResManager.loadKDString((String)"\u4e0b\u5217\u51ed\u8bc1\u53f7\u4e0d\u6ee1\u8db3\u7f16\u7801\u89c4\u5219\uff1a", (String)"GLBreakPointUtil_4", (String)"fi-gl-common", (Object[])new Object[0])).append("\n");
                            unmatchSb.append(number);
                        } else {
                            if (unmatchSb.length() > 30000) {
                                unmatchSb.append("\n").append("...");
                                break;
                            }
                            unmatchSb.append(MultiLangPunc.comma()).append(number);
                        }
                    }
                    lastVoucherId = voucherId;
                }
                if (breakSb.length() > 0 || unmatchSb.length() > 0) {
                    if (breakSb.length() > 0) {
                        breakSb.append("\n");
                    }
                    if (unmatchSb.length() > 0) {
                        unmatchSb.append("\n");
                    }
                    result[2] = breakSb.append((CharSequence)unmatchSb).toString();
                } else {
                    result[0] = "1";
                    result[1] = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u5b58\u5728\u65ad\u53f7\u3002", (String)"GLBreakPointUtil_7", (String)"fi-gl-common", (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    public static void saveVouchers(List<Object[]> paramList, DynamicObject[] vobks, String TXName) {
        try (TXHandle h = TX.requiresNew((String)TXName);){
            try {
                String vosql = "update t_gl_voucher set fnumber=? where fid=?";
                String bpssql = "update t_gl_voucherbreakpoint set fcurvoucherno=?,fisadjust='2' where fvoucherid=? and (fisadjust='0' or fisadjust='2')";
                if (!paramList.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)vosql, paramList);
                    SaveServiceHelper.save((DynamicObject[])vobks);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)bpssql, paramList);
                    GLBreakPointUtil.asyncUpdateVchNo(paramList);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void asyncUpdateVchNo(List<Object[]> paramList) {
        block3: {
            DynamicObject dynObj = QueryServiceHelper.queryOne((String)"ict_relacctrecord", (String)"id", null);
            if (Objects.isNull(dynObj)) {
                return;
            }
            try {
                ECGlobalSession.begin((String)"adjust_voucher", (DBRoute)DBRoute.of((String)"fi"), (boolean)true);
                ECGlobalSession.setBusinessType((String)"gl_voucher");
                ECGlobalSession.setBusinessInfo(paramList.stream().map(v -> String.valueOf(v[1])).collect(Collectors.toList()));
                ECGlobalSession.setAsync((boolean)true);
                Lists.partition(paramList, (int)1000).forEach(v -> {
                    CommonParam param = new CommonParam();
                    param.put((Object)"vchInfo", v);
                    ECGlobalSession.register((String)"fi", (String)"ict", (String)"IctVoucherNoAdjustService", (Param)param, (String)"adjust_voucher_ict_record");
                });
            }
            catch (Exception bde) {
                if (bde instanceof BeginDtxException && DtxErrorCodeConstants.NEST_DTX_ERROR.getErrorCode().equals(((BeginDtxException)bde).getErrorCode().getCode())) break block3;
                throw bde;
            }
        }
    }

    public static Map<String, Object> getVoucherInfo(DynamicObject voucher, List<Map<String, String>> issortitemFields) {
        HashMap<String, Object> m = new HashMap<String, Object>(issortitemFields.size());
        for (Map<String, String> map : issortitemFields) {
            String field = map.get("valueatribute");
            m.put(field, voucher.get(field));
        }
        return m;
    }

    public static Map<String, Object> getVoucherPropValue(DynamicObject voucher, List<Map<String, String>> issortitemFields) {
        HashMap<String, Object> m = new HashMap<String, Object>(issortitemFields.size());
        for (Map<String, String> map : issortitemFields) {
            String field = map.get("valueatribute").split("\\.")[0];
            m.put(field, voucher.get(field));
        }
        return m;
    }

    public static Map<String, Object> getVoucherInfo(List<Map<String, String>> issortitemTrueFields, Row row) {
        HashMap<String, Object> info = new HashMap<String, Object>(1);
        for (Map<String, String> fieldmap : issortitemTrueFields) {
            String field = fieldmap.get("valueatribute");
            info.put(field, row.get(field));
        }
        return info;
    }

    public static Queue<Long> getBreakNos(String coderuleid, String sortitemValue) {
        Queue idList = (Queue)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)"select fserial from T_CR_IntermitNO where fcoderuleid=? and fsortitemvalue=? order by fserial", (Object[])new Object[]{coderuleid, sortitemValue}, (ResultSetHandler)new ResultSetHandler<Queue<Long>>(){

            public Queue<Long> handle(ResultSet rs) throws Exception {
                LinkedList<Long> list = new LinkedList<Long>();
                while (rs.next()) {
                    list.add(rs.getLong("fserial"));
                }
                return list;
            }
        });
        return idList;
    }

    public static String getSortitemvalue(List<Map<String, String>> issortitemFields, Map<String, Object> voucherInfo) {
        StringBuilder issortitemValues = new StringBuilder();
        for (Map<String, String> fieldmap : issortitemFields) {
            if (issortitemValues.length() != 0) {
                issortitemValues.append("_split_");
            }
            issortitemValues.append(GLBreakPointUtil.getOneSortItemString(fieldmap, voucherInfo));
        }
        String issortitemvalue = issortitemValues.toString();
        if (StringUtils.isEmpty((CharSequence)issortitemvalue)) {
            issortitemvalue = "_split_";
        }
        return issortitemvalue;
    }
}

