/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.DateUtil;

public class GLFabulousOperation {
    public static final String URL = "/icons/pc/state/praised.png";

    public static Map<Long, Integer> getFabulous(Collection<Long> tagetUserID, String formid, boolean isTodyDay, boolean isAll) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        QFilter tagetUserFilter = new QFilter("bythumbupuser", "in", tagetUserID);
        if (StringUtils.isNotBlank((CharSequence)formid)) {
            QFilter formidFilter = new QFilter("sourcebillnumber", "=", (Object)formid);
            qfilters.add(formidFilter);
        }
        qfilters.add(tagetUserFilter);
        GLFabulousOperation.processDateFilter(isTodyDay, qfilters);
        GLFabulousOperation.processPersonFabulous(isAll, qfilters);
        return GLFabulousOperation.getData(qfilters, null, 0);
    }

    public static Map<Long, Integer> getData(List<QFilter> filters, String order, int top) {
        DataSet dataSet = null;
        DataSet result = null;
        DataSet orderResult = null;
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)"gl.getFabulous", (String)"gl_fabulous", (String)"id,bythumbupuser", (QFilter[])filters.toArray(new QFilter[0]), null);
            GroupbyDataSet groupByDataSet = dataSet.groupBy(new String[]{"bythumbupuser"});
            groupByDataSet.count();
            result = groupByDataSet.finish();
            orderResult = "DESC".equalsIgnoreCase(order) ? result.orderBy(new String[]{"count desc"}) : ("ASC".equalsIgnoreCase(order) ? result.orderBy(new String[]{"count"}) : result);
            Iterator iterator = orderResult.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                map.put(row.getLong("bythumbupuser"), row.getInteger("count"));
                if (top <= 0 || ++count <= top) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException(e);
        }
        finally {
            if (orderResult != null) {
                orderResult.close();
            }
            if (result != null) {
                result.close();
            }
            if (dataSet != null) {
                dataSet.close();
            }
        }
        return map;
    }

    public static Map<Long, Integer> getFabulousTop(String formid, boolean isTodyDay, boolean isAll, String order, int top) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        QFilter formidFilter = new QFilter("sourcebillnumber", "=", (Object)formid);
        qfilters.add(formidFilter);
        GLFabulousOperation.processDateFilter(isTodyDay, qfilters);
        GLFabulousOperation.processPersonFabulous(isAll, qfilters);
        return GLFabulousOperation.getData(qfilters, order, top);
    }

    public static void processDateFilter(boolean isTodyDay, List<QFilter> qfilters) {
        if (isTodyDay) {
            try {
                qfilters.add(new QFilter("createdate", "=", (Object)GLFabulousOperation.getDay()));
            }
            catch (Exception e1) {
                throw new BOSException(e1);
            }
        }
    }

    public static void processPersonFabulous(boolean isAll, List<QFilter> qfilters) {
        if (!isAll) {
            long userid = ContextUtil.getUserId();
            qfilters.add(new QFilter("thumbupuser", "=", (Object)userid));
        }
    }

    public static int getFabulousOne(Long targetUserId, String formid, boolean isTodyDay, boolean isAll) {
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(targetUserId);
        Map<Long, Integer> map = GLFabulousOperation.getFabulous(idList, formid, isTodyDay, isAll);
        return map.get(targetUserId) == null ? 0 : map.get(targetUserId);
    }

    public static boolean isThumbUp(long targetUserId, String formid) {
        return GLFabulousOperation.getFabulousOne(targetUserId, formid, true, false) < 1;
    }

    public static boolean isCanThumbUp(long targetUserId, String formid) {
        long userid = ContextUtil.getUserId();
        return targetUserId == 0L || targetUserId == userid ? false : GLFabulousOperation.isThumbUp(targetUserId, formid);
    }

    public static Object[] createFabulous(long targetUserId, String formid) {
        DynamicObject fabulous = BusinessDataServiceHelper.newDynamicObject((String)"gl_fabulous");
        Long userid = ContextUtil.getUserId();
        fabulous.set("bythumbupuser", (Object)targetUserId);
        fabulous.set("thumbupuser", (Object)userid);
        fabulous.set("sourcebillnumber", (Object)formid);
        try {
            fabulous.set("createdate", (Object)GLFabulousOperation.getDay());
        }
        catch (Exception e1) {
            throw new BOSException(e1);
        }
        return BusinessDataWriter.save((IDataEntityType)fabulous.getDataEntityType(), (Object[])new Object[]{fabulous});
    }

    private static Date getDay() {
        return DateUtil.makeDateOnDayStrart(new Date());
    }
}

