/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.constant.Constant;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.interfaces.service.dap.IDAPService;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.SystemParamHelper;
import org.apache.commons.lang3.StringUtils;

public class GLUtil {
    private static final Log LOG = LogFactory.getLog(GLUtil.class);
    public static final Long MAX_PERIOD = 99999999999L;
    public static final Long TYPE_PERIOD_L = 100000000L;
    public static final Long YEAR_PERIOD_L = 10000L;
    public static final String entityID_exchangeRate = "bd_exrate_tree";
    private static final String ACCOUNTTYPE = "local-accttype-key";
    private static final String ASSGRPMAP = "assgrp-local-map";
    private static final Set<String> budgetTypes = new HashSet<String>(Arrays.asList("A", "B", "C"));
    private static final int FILTER_LEN_LIMIT = 500;

    private static IDAPService getDAPService() {
        return GLServiceFactory.getService(IDAPService.class);
    }

    public static long retainPeriodType(long period) {
        return period / TYPE_PERIOD_L * TYPE_PERIOD_L;
    }

    public static long retainPeriodYear(long period) {
        return period / YEAR_PERIOD_L * YEAR_PERIOD_L;
    }

    public static boolean isZero(BigDecimal val) {
        return val.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean isPkValNull(Object pkVal) {
        return kd.bos.dataentity.utils.StringUtils.isBlank((Object)pkVal) || "0".equals(String.valueOf(pkVal));
    }

    public static boolean isPkValNotNull(Object pkVal) {
        return !GLUtil.isPkValNull(pkVal);
    }

    public static void getLeafIds(Set<Long> acctIds, Set<Long> leafIds, boolean isLeaf) {
        GLUtil.getLeafIds(acctIds, leafIds, isLeaf, null);
    }

    public static void getLeafIds(Set<Long> acctIds, Set<Long> leafIds, boolean isLeaf, QFilter baseDataF) {
        QFilter fparent = new QFilter("parent", "in", acctIds);
        if (baseDataF != null) {
            fparent.and(baseDataF);
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_accountview", (String)"id,parent,level,isleaf", (QFilter[])fparent.toArray());
        HashSet<Long> unLeafAcctIds = new HashSet<Long>();
        if (col != null) {
            for (DynamicObject obj : col) {
                long acctId = obj.getLong("id");
                if (isLeaf) {
                    if (obj.getBoolean("isleaf")) {
                        leafIds.add(acctId);
                        continue;
                    }
                    unLeafAcctIds.add(acctId);
                    continue;
                }
                leafIds.add(acctId);
                unLeafAcctIds.add(acctId);
            }
        }
        if (unLeafAcctIds.size() > 0) {
            GLUtil.getLeafIds(unLeafAcctIds, leafIds, isLeaf, baseDataF);
        }
    }

    public static long getYear(long periodid) {
        return periodid / YEAR_PERIOD_L - periodid / TYPE_PERIOD_L * TYPE_PERIOD_L / YEAR_PERIOD_L;
    }

    public static DynamicObject getMaxPeriodByType(long periodType) {
        QFilter typeFilter = new QFilter("periodtype", "=", (Object)periodType);
        DynamicObjectCollection dataSet = QueryServiceHelper.query((String)"GLUtil.getMaxPeriodByType", (String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[]{typeFilter}, (String)"id desc", (int)1);
        return (DynamicObject)dataSet.get(0);
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType) {
        return GLUtil.getPeriodByDate(date, periodType, Boolean.TRUE);
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType, Boolean includeAdjust) {
        String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
        DynamicObjectCollection period = GLUtil.getPeriodByDate(date, selectField, periodType, includeAdjust);
        if (!period.isEmpty()) {
            return (DynamicObject)period.get(0);
        }
        return null;
    }

    public static DynamicObjectCollection getPeriodByDate(Date date, String selectField, long periodType, Boolean includeAdjust) {
        return GLUtil.getPeriodByDate(date, date, selectField, periodType, includeAdjust);
    }

    public static DynamicObjectCollection getPeriodByDate(Date begin, Date date, String selectField, long periodType, Boolean includeAdjust) {
        Date end = DateUtil.makeDateOnDayEnd(date);
        QFilter f = new QFilter("beginDate", "<=", (Object)end);
        QFilter g = new QFilter("enddate", ">=", (Object)begin);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        if (!includeAdjust.booleanValue()) {
            t = t.and(new QFilter("isadjustperiod", "=", (Object)includeAdjust));
        }
        return QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t}, (String)"id desc");
    }

    public static DynamicObjectCollection getPeriodByDate(Date date, String selectField, long periodType) {
        return GLUtil.getPeriodByDate(date, selectField, periodType, Boolean.TRUE);
    }

    public static Set<Long> getPeriodIdSet(Date beginDate, Date endDate, long periodType, Boolean includeAdjust) {
        List ids;
        QFilter beginDateFilter = new QFilter("begindate", "<=", (Object)endDate);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)beginDate);
        QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodType);
        if (!includeAdjust.booleanValue()) {
            periodTypeFilter = periodTypeFilter.and(new QFilter("isadjustperiod", "=", (Object)includeAdjust));
        }
        return (ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])new QFilter[]{beginDateFilter, endDateFilter, periodTypeFilter}, null, (int)-1)).isEmpty() ? Collections.emptySet() : new HashSet(ids);
    }

    public static Set<Long> getPeriodIdSet(Date beginDate, Date endDate) {
        QFilter beginDateFilter = new QFilter("begindate", "<=", (Object)endDate);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)beginDate);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{beginDateFilter, endDateFilter});
        HashSet<Long> pdIdSet = new HashSet<Long>();
        for (DynamicObject pd : coll) {
            pdIdSet.add(pd.getLong("id"));
        }
        return pdIdSet;
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        return GLUtil.getPreviousPeriod(curPeriodId, 1);
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId, int count) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (String)entityName, (String)"periodtype,periodyear");
        if (currPeriod == null) {
            return null;
        }
        QFilter filterDate = new QFilter("id", "<", curPeriodId);
        Object periodtypeid = currPeriod.get("periodtype_id");
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id desc", (int)count);
        if (coll == null || coll.isEmpty() || coll.size() < count) {
            return null;
        }
        return (DynamicObject)coll.get(count - 1);
    }

    public static DynamicObject getNextPeriod(Object curPeriodId) {
        return GLUtil.getNextPeriod(curPeriodId, true);
    }

    public static DynamicObject getNextPeriod(Object curPeriodId, boolean isAdjustPeriod) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String entityName = "bd_period";
            String selector = "id,name,number,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            try {
                DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (String)entityName, (String)"periodtype,periodyear");
                Object periodtypeid = currPeriod.get("periodtype_id");
                QFilter filterDate = new QFilter("id", ">", curPeriodId);
                QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
                DynamicObjectCollection coll = null;
                if (isAdjustPeriod) {
                    coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id", (int)1);
                } else {
                    QFilter filterAdjustPeriod = new QFilter("isadjustperiod", "=", (Object)isAdjustPeriod);
                    coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, filterAdjustPeriod}, (String)"id", (int)1);
                }
                if (coll != null && !coll.isEmpty()) {
                    nextPeriod = (DynamicObject)coll.get(0);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return nextPeriod;
    }

    public static DynamicObject getPreviousYearLastPeriod(long curPeriodId) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (String)entityName, (String)"periodtype,periodyear");
            Object periodtypeid = currPeriod.get("periodtype_id");
            long periodyear = currPeriod.getLong("periodyear") - 1L;
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            QFilter filterYear = new QFilter("periodyear", "=", (Object)periodyear);
            DynamicObjectCollection coll = null;
            coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterType, filterYear}, (String)"id desc", (int)1);
            if (coll != null && !coll.isEmpty()) {
                nextPeriod = (DynamicObject)coll.get(0);
            }
        }
        return nextPeriod;
    }

    public static DynamicObject getPreviousYearMinPeriod(long curPeriodId) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (String)entityName, (String)"periodtype,periodyear");
            Object periodtypeid = currPeriod.get("periodtype_id");
            long periodyear = currPeriod.getLong("periodyear") - 1L;
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            QFilter filterYear = new QFilter("periodyear", "=", (Object)periodyear);
            DynamicObjectCollection coll = null;
            coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterType, filterYear}, (String)"id", (int)1);
            if (coll != null && !coll.isEmpty()) {
                nextPeriod = (DynamicObject)coll.get(0);
            }
        }
        return nextPeriod;
    }

    public static long getPreviousYearSamePeriod(long curPeriodId) {
        long samePeriod = 0L;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            long num = curPeriodId % YEAR_PERIOD_L;
            samePeriod = (curPeriodId / YEAR_PERIOD_L - 1L) * YEAR_PERIOD_L + num;
            boolean exists = QueryServiceHelper.exists((String)"bd_period", (Object)samePeriod);
            if (!exists) {
                samePeriod = 0L;
            }
        }
        return samePeriod;
    }

    public static boolean isCashAcct(DynamicObject acct) {
        return acct != null && (acct.getBoolean("iscash") || acct.getBoolean("isbank") || acct.getBoolean("iscashequivalent"));
    }

    public static boolean isAccheckAcct(DynamicObject acct) {
        return acct != null && acct.getBoolean("accheck");
    }

    public static boolean isCashAcct(Row row) {
        return row.getBoolean("entries.account.iscash") != false || row.getBoolean("entries.account.isbank") != false || row.getBoolean("entries.account.iscashequivalent") != false;
    }

    public static boolean isPLAcct(DynamicObject acct) {
        if (acct == null) {
            return false;
        }
        boolean isBudgetAccount = AccountType.isBudgetType(acct.getLong("accounttype_id"));
        return !isBudgetAccount && !"0".equals(acct.getString("pltype"));
    }

    public static boolean isNCashNPLAcct(DynamicObject acct) {
        if (acct == null) {
            return false;
        }
        boolean isBudgetAccount = AccountType.isBudgetType(acct.getLong("accounttype_id"));
        return !isBudgetAccount && !GLUtil.isCashAcct(acct) && !GLUtil.isPLAcct(acct);
    }

    public static Map<Long, Boolean> getAcctType() {
        HashMap<Long, Boolean> map = (HashMap<Long, Boolean>)ThreadCache.get((Object)ACCOUNTTYPE);
        if (null == map) {
            map = new HashMap<Long, Boolean>();
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_accounttype", (String)"id,accounttype", null);
            for (DynamicObject obj : col) {
                if ("4".equals(obj.getString("accounttype"))) {
                    map.put(obj.getLong("id"), Boolean.TRUE);
                    continue;
                }
                map.put(obj.getLong("id"), Boolean.FALSE);
            }
            ThreadCache.put((Object)ACCOUNTTYPE, map);
        }
        return map;
    }

    public static boolean isPLAcct(long acctTypeId) {
        if (acctTypeId == 0L) {
            return false;
        }
        Map<Long, Boolean> map = GLUtil.getAcctType();
        return map.get(acctTypeId) == null ? false : map.get(acctTypeId);
    }

    public static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add(field.getName());
        }
        return list;
    }

    public static List<Long> getPeriodIds(Long begin, Long end) {
        if (end == 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            return ids;
        }
        return (List)ThreadCache.get((Object)String.format("GLUtil_getPeriodIds_start:%s_end:%s", begin, end), () -> {
            ArrayList<Long> result = new ArrayList<Long>();
            QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(end / TYPE_PERIOD_L));
            QFilter beginFilter = new QFilter("id", ">=", (Object)begin);
            QFilter endFilter = new QFilter("id", "<=", (Object)end);
            try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, beginFilter, endFilter}, (String)"id");){
                for (Row r : rs) {
                    result.add(r.getLong(0));
                }
            }
            return result;
        }, (boolean)true);
    }

    public static long getMaxPeriodIdByCount(long startPeriodId, int count) {
        long maxPeriodId = 0L;
        if (startPeriodId == 0L) {
            return maxPeriodId;
        }
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(startPeriodId / TYPE_PERIOD_L));
        QFilter beginFilter = new QFilter("id", ">=", (Object)startPeriodId);
        QFilter adjustFilter = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, beginFilter, adjustFilter}, (String)"id asc", (int)count);){
            for (Row r : rs) {
                long id = r.getLong("id");
                if (maxPeriodId >= id) continue;
                maxPeriodId = id;
            }
            long l = maxPeriodId;
            return l;
        }
    }

    @Deprecated
    public static DataSet getCurYearMaxPeriod(long periodId, String sel) {
        if (periodId == 0L) {
            return null;
        }
        String entityName = "bd_period";
        QFilter fid = new QFilter("id", "=", (Object)periodId);
        DataSet periodSet = QueryServiceHelper.queryDataSet((String)"GLUtil.getCurYearMaxPeriod", (String)entityName, (String)"id, periodtype, periodyear, periodnumber", (QFilter[])fid.toArray(), null);
        Iterator iterator = periodSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            QFilter filterType = new QFilter("periodtype.id", "=", row.get("periodtype"));
            QFilter filterYear = new QFilter("periodyear", "=", row.get("periodyear"));
            QFilter filterNum = new QFilter("periodnumber", ">=", row.get("periodnumber"));
            try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getCurYearMaxPeriod", (String)entityName, (String)sel, (QFilter[])new QFilter[]{filterType, filterYear, filterNum}, (String)"id desc", (int)1);){
                DataSet dataSet = rs;
                return dataSet;
            }
        }
        return null;
    }

    public static Long getCurYearMaxPeriod(long periodId) {
        if (periodId == 0L) {
            return 0L;
        }
        QFilter fid = new QFilter("id", "=", (Object)periodId);
        DynamicObject row = QueryServiceHelper.queryOne((String)"bd_period", (String)"id, periodtype, periodyear, periodnumber", (QFilter[])fid.toArray());
        QFilter filterType = new QFilter("periodtype.id", "=", row.get("periodtype"));
        QFilter filterYear = new QFilter("periodyear", "=", row.get("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">=", row.get("periodnumber"));
        return (Long)QueryServiceHelper.queryPrimaryKeys((String)"GLUtil.getCurYearMaxPeriod", (String)"bd_period", (QFilter[])new QFilter[]{filterType, filterYear, filterNum}, (String)"id desc", (int)1).get(0);
    }

    public static DynamicObject getCurYearMinPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", currPeriod.get("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<=", currPeriod.get("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)"periodnumber");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static String toSerializedString(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw new BOSException(e);
        }
    }

    public static Object fromSerializedString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Exception e) {
            throw new BOSException(e);
        }
    }

    public static DynamicObjectCollection getSetCoderules(String billStatus, String ordId) {
        QFilter[] qfilters;
        QFilter fenable = new QFilter("enable", "=", (Object)"1");
        QFilter fbizobjectid = new QFilter("bizobjectid", "=", (Object)"gl_voucher");
        QFilter fpro = new QFilter("conditionentry.property.bizobjectid", "=", (Object)"gl_voucher");
        QFilter fpro1 = new QFilter("conditionentry.property.number", "=", (Object)"billstatus");
        if ("B".equals(billStatus) || "C".equals(billStatus)) {
            QFilter fvalue = new QFilter("conditionentry.propertyvalue.value", "=", (Object)billStatus);
            qfilters = new QFilter[]{fenable, fbizobjectid, fpro, fpro1, fvalue};
        } else {
            qfilters = new QFilter[]{fenable, fbizobjectid};
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_coderule", (String)"id,appmode", (QFilter[])qfilters);
        return col;
    }

    public static Map<String, List<Long>> getBookTypeAndAccountTable(Long org) {
        QFilter f1 = new QFilter("org", "=", (Object)org);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"accounttable, bookstype.accounttype type", (QFilter[])new QFilter[]{f1});
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        for (DynamicObject dyn : dyns) {
            String type = dyn.getString("type");
            if (result.get(type) == null) {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(dyn.getLong("accounttable"));
                result.put(type, list);
                continue;
            }
            ((List)result.get(type)).add(dyn.getLong("accounttable"));
        }
        return result;
    }

    public static List<Long> getAccounttableIdByOrg(Long org) {
        QFilter f1 = new QFilter("org", "=", (Object)org);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{f1});
        ArrayList<Long> list = new ArrayList<Long>();
        for (DynamicObject dyn : dyns) {
            list.add(dyn.getLong("accounttable"));
        }
        return list;
    }

    public static DynamicObject getParentsControl(Long orgId, List<Long> voucherTypeIds, List<Long> accountTables) {
        QFilter f1 = new QFilter("org.id", "=", (Object)orgId);
        QFilter f2 = new QFilter("view.treetype", "=", (Object)"10");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{f1, f2});
        if (dyn == null || dyn.getLong("parent") == orgId.longValue()) {
            return null;
        }
        Long parentId = dyn.getLong("parent");
        if (parentId == null || parentId == 0L) {
            return null;
        }
        DynamicObject controlInformation = GLUtil.getControlMsg(parentId, voucherTypeIds);
        if (controlInformation != null && accountTables.contains(controlInformation.get("accounttable"))) {
            return controlInformation;
        }
        DynamicObject control = GLUtil.getParentsControl(parentId, voucherTypeIds, accountTables);
        return control;
    }

    public static DynamicObject getParentsControl(Long orgId, List<Long> voucherTypeIds, Long accountTableId) {
        QFilter f1 = new QFilter("org.id", "=", (Object)orgId);
        QFilter f2 = new QFilter("view.treetype", "=", (Object)"10");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{f1, f2});
        if (dyn == null || dyn.getLong("parent") == orgId.longValue()) {
            return null;
        }
        Long parentId = dyn.getLong("parent");
        if (parentId == null || parentId == 0L) {
            return null;
        }
        DynamicObject controlInformation = GLUtil.getControlMsg(parentId, voucherTypeIds);
        if (controlInformation != null && accountTableId.longValue() == controlInformation.getLong("accounttable")) {
            return controlInformation;
        }
        DynamicObject control = GLUtil.getParentsControl(parentId, voucherTypeIds, accountTableId);
        return control;
    }

    public static DynamicObject getControlMsg(Long orgId, List<Long> voucherTypeIds) {
        QFilter typeIdFilter = new QFilter("vouchertype", "in", voucherTypeIds);
        QFilter orgIdDilter = new QFilter("orgid", "=", (Object)orgId);
        DynamicObject controlInformation = QueryServiceHelper.queryOne((String)"gl_controlinformation", (String)"id,accounttable", (QFilter[])new QFilter[]{orgIdDilter, typeIdFilter});
        return controlInformation;
    }

    public static Long getMastIdById(Long typeid) {
        QFilter f1 = new QFilter("id", "=", (Object)typeid);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query_gl_voucher_getMasterid", (String)"gl_vouchertype", (String)"masterid", (QFilter[])new QFilter[]{f1}, null);){
            if (ds.hasNext()) {
                Long l = ds.next().getLong("masterid");
                return l;
            }
        }
        return 0L;
    }

    public static List<Long> getIdsByMasterId(Long masterId) {
        QFilter f1 = new QFilter("masterid", "=", (Object)masterId);
        ArrayList<Long> typeIds = new ArrayList<Long>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query_gl_voucher_getIds", (String)"gl_vouchertype", (String)"id", (QFilter[])new QFilter[]{f1}, null);){
            for (Row rs : ds) {
                typeIds.add(rs.getLong("id"));
            }
        }
        return typeIds;
    }

    public static int getCFItemMaxLevel(Object orgId) {
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)((Long)orgId));
        DynamicObjectCollection dync = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"level", (QFilter[])new QFilter[]{qFilter}, (String)"level desc", (int)1);
        String level = "0";
        if (dync != null && !dync.isEmpty()) {
            level = ((DynamicObject)dync.get(0)).getString("level");
        }
        return Integer.parseInt(level);
    }

    public static Map<Long, String> getVoucherLinkUpBills(List<Long> voucherIds) {
        BillToVchRelationDto voucherRelations = GLUtil.getDAPService().getBillToVchRelationDtoByVchIDSet(new HashSet<Long>(voucherIds));
        HashMap<Long, String> sourceInfos = new HashMap<Long, String>();
        for (BillToVchRelationDto.BillToVoucherRelation relation : voucherRelations) {
            Long billId = relation.getBillId();
            String billType = relation.getBillType();
            Long[] ids = new Long[]{billId};
            List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)billType, (String)"", (Long[])ids);
            sourceInfos.put(billId, billType);
            List<BFRowLinkUpNode> childNodes = GLUtil.getChildNodes(bfRowLinkUpNodes);
            for (BFRowLinkUpNode node : childNodes) {
                Long tableId = node.getRowId().getMainTableId();
                TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId);
                String sourcebillType = tableDefine.getEntityNumber();
                sourceInfos.put(node.getRowId().getBillId(), sourcebillType);
            }
        }
        return sourceInfos;
    }

    public static Map<Long, String> getVoucherLinkUpBillsInFast(List<Long> voucherIds) {
        BillToVchRelationDto voucherRelations = GLUtil.getDAPService().getBillToVchRelationDtoByVchIDSet(new HashSet<Long>(voucherIds));
        Map<String, List<Long>> groupedBill = GLUtil.groupDirectUpStreamBill(voucherRelations);
        HashMap<Long, String> sourceInfos = new HashMap<Long, String>();
        for (Map.Entry<String, List<Long>> entry : groupedBill.entrySet()) {
            entry.getValue().forEach(id -> {
                String cfr_ignored_0 = (String)sourceInfos.put((Long)id, (String)entry.getKey());
            });
            Long[] idArray = new Long[entry.getValue().size()];
            entry.getValue().toArray(idArray);
            List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)entry.getKey(), (String)"", (Long[])idArray);
            List<BFRowLinkUpNode> childNodes = GLUtil.getChildNodes(bfRowLinkUpNodes);
            for (BFRowLinkUpNode node : childNodes) {
                Long tableId = node.getRowId().getMainTableId();
                TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId);
                String sourcebillType = tableDefine.getEntityNumber();
                sourceInfos.put(node.getRowId().getBillId(), sourcebillType);
            }
        }
        return sourceInfos;
    }

    private static Map<String, List<Long>> groupDirectUpStreamBill(BillToVchRelationDto dyos) {
        HashMap<String, List<Long>> groupedBill = new HashMap<String, List<Long>>();
        dyos.forEach(dyo -> {
            String billType = dyo.getBillType();
            List ids = groupedBill.getOrDefault(billType, new LinkedList());
            ids.add(dyo.getBillId());
            groupedBill.put(billType, ids);
        });
        return groupedBill;
    }

    private static List<BFRowLinkUpNode> getChildNodes(List<BFRowLinkUpNode> bfRowLinkUpNodes) {
        ArrayList<BFRowLinkUpNode> childNodes = new ArrayList<BFRowLinkUpNode>();
        for (BFRowLinkUpNode node : bfRowLinkUpNodes) {
            if (node.findAllSourceNodes() != null && !node.findAllSourceNodes().isEmpty()) {
                childNodes.add(node);
                childNodes.addAll(GLUtil.getChildNodes(node.findAllSourceNodes()));
                continue;
            }
            childNodes.add(node);
        }
        return childNodes;
    }

    @Deprecated
    public static Long getAccIdByMasterId(long orgId, long masterid) {
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        DynamicObject acct = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{acctFilter, new QFilter("masterid", "=", (Object)masterid)});
        return acct == null ? null : Long.valueOf(acct.getLong("id"));
    }

    public static DynamicObject getAccIdByMasterId(long orgId, long masterid, Date endDate) {
        QFilter fstartDate = new QFilter("startdate", "<=", (Object)endDate);
        QFilter fendDate = new QFilter("enddate", ">=", (Object)endDate);
        QFilter fmasterId = new QFilter("masterid", "=", (Object)masterid);
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (QFilter[])new QFilter[]{acctFilter, fstartDate, fendDate, fmasterId});
        return acct;
    }

    public static DynamicObject[] getAccIdsByMasterIds(long orgId, Set<Long> masterIds, Date endDate) {
        QFilter fstartDate = new QFilter("startdate", "<=", (Object)endDate);
        QFilter fendDate = new QFilter("enddate", ">=", (Object)endDate);
        QFilter fmasterId = new QFilter("masterid", "in", masterIds);
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        DynamicObject[] acctArray = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{acctFilter, fstartDate, fendDate, fmasterId});
        return acctArray;
    }

    public static List<Object> getIdsFromDynCollection(DynamicObjectCollection dyos, String keyfield) {
        ArrayList<Object> r = new ArrayList<Object>();
        for (DynamicObject dyo : dyos) {
            r.add(dyo.get(keyfield));
        }
        return r;
    }

    public static DynamicObjectCollection getRealAccts(long orgId, long acctTableId, List<String> numbers, String selectFields) {
        QFilter qids = AccountUtils.getAccountDataFilter((long)orgId, (long)acctTableId);
        QFilter qtable = new QFilter("accounttable", "=", (Object)acctTableId);
        QFilter qnum = new QFilter("number", "in", numbers);
        QFilter[] qfilters = new QFilter[]{qtable, qids, qnum};
        DynamicObjectCollection accts = QueryServiceHelper.query((String)"bd_accountview", (String)selectFields, (QFilter[])qfilters);
        return accts;
    }

    public static String queryActDCByMasterID(Long orgId, Long masterid, String defaultDC) {
        String actDC = defaultDC;
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("masterid", "=", (Object)masterid)};
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"dc", (QFilter[])filters);
        if (obj != null) {
            actDC = obj.getString("dc");
        }
        return actDC;
    }

    public static String printError(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(GLUtil.printError(t.getCause())).append("\n");
        }
        StringWriter sW = new StringWriter();
        try (PrintWriter writer = new PrintWriter(sW);){
            t.printStackTrace(writer);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upper.append(sW.toString()).toString();
    }

    public static Map<String, Long> getAssgrpValue(String assgrpJson) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (assgrpJson == null) {
            return map;
        }
        JSONObject valueJson = JSONObject.parseObject((String)assgrpJson);
        Set ks = valueJson.keySet();
        for (String k : ks) {
            String formid;
            QFilter q = new QFilter("flexfield", "=", (Object)k);
            Map asstacttypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"number,valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{q});
            if (asstacttypes.isEmpty()) continue;
            if (asstacttypes.size() > 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u5f02\u5e38,flexfield = %s \u91cd\u590d", (String)"GLUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), k));
            }
            DynamicObject asstacttype = (DynamicObject)asstacttypes.values().iterator().next();
            if ("1".equals(asstacttype.getString("valuetype")) && (formid = asstacttype.getString("valuesource.id")) != null) {
                map.put(formid, valueJson.getLong(k));
            }
            if (!"2".equals(asstacttype.getString("valuetype"))) continue;
            map.put(asstacttype.getString("assistanttype"), valueJson.getLong(k));
        }
        return map;
    }

    public static List<Object> getIdsByMasterIds(String entityId, Collection<Long> masterIds, String orderBys, int top) {
        QFilter masterIdFilter = new QFilter("masterid", "in", masterIds);
        return QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])masterIdFilter.toArray(), (String)orderBys, (int)top);
    }

    public static void lockVouchers(List<Long> vchs) {
        if (vchs.size() == 0) {
            return;
        }
        if (vchs.size() > 999) {
            LOG.warn("A huge voucher ids would be locked: " + vchs.size());
        }
        Lists.partition(vchs, (int)999).forEach(subVchs -> {
            StringBuilder sql = new StringBuilder("update t_gl_voucher set fmodifytime=now() where fid in ");
            ArrayList ids = new ArrayList(subVchs.size());
            for (int i = 0; i < subVchs.size(); ++i) {
                sql.append(i > 0 ? "," : "(").append("?");
                ids.add(subVchs.get(i));
            }
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql.append(")").toString(), (Object[])ids.toArray(new Long[0]));
        });
    }

    public static Object getSystemParam(String paramName, Long org) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        AppParam param = new AppParam(appId, "10", org, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramName);
    }

    public static Map<Long, Object> batchGetSystemParam(String paramKey, Long[] orgIds, Object defaultVal) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        AppParam appParam = new AppParam(appId, "10", Long.valueOf(-1L), Long.valueOf(0L));
        Map fullOrgParamMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, Arrays.asList(orgIds));
        return fullOrgParamMap.entrySet().stream().collect(Collectors.toMap(e -> Long.parseLong((String)e.getKey()), e -> Optional.ofNullable(((Map)e.getValue()).get(paramKey)).orElse(defaultVal)));
    }

    public static String getAcctNameBySysParam(Long org) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        AppParam param = new AppParam(appId, "10", org, Long.valueOf(0L));
        Object showFullName = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"showfullname");
        boolean isShowFullName = showFullName == null ? Boolean.FALSE : (Boolean)showFullName;
        return isShowFullName ? "fullname" : "name";
    }

    public static boolean getEnableBizVoucherBySysParam(Long org) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        AppParam param = new AppParam(appId, "10", org, Long.valueOf(0L));
        Object bizvoucher = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"isbizvoucher");
        Boolean isbizvoucher = bizvoucher == null ? Boolean.FALSE : (Boolean)bizvoucher;
        return isbizvoucher;
    }

    public static Date getDateBizVoucherSystemParam(Long orgId) {
        Object bizvoucherdate = SystemParamServiceHelper.getSystemParameter(null, (String)"83bfebc8000017ac", (String)"10", (Long)orgId, (String)"bizvoucherdate");
        if (null != bizvoucherdate) {
            Date bizDate = (Date)bizvoucherdate;
            return bizDate;
        }
        return null;
    }

    public static List<Object> getAssistPKByOrg(Long orgId) {
        List<Long> superOrg = GLUtil.getAllSuperiorOrgIdsOrderByLevel(orgId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("flexid", "=", (Object)2));
        QFilter allCtrl = new QFilter("ctrlstrategy", "=", (Object)"5");
        if (superOrg != null && !superOrg.isEmpty()) {
            QFilter orgFilter = new QFilter("createorg.id", "in", superOrg).and(new QFilter("ctrlstrategy", "=", (Object)"6"));
            filters.add(allCtrl.or(orgFilter));
        } else {
            filters.add(allCtrl);
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_asstacttype", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
    }

    public static List<Object> getAssgrRelaPKByOrg(Long orgId) {
        return (List)ThreadCache.get((Object)ThreadCacheKey.getAssgrRelaPKByOrgKey(orgId), () -> {
            List<Long> superOrg = GLUtil.getAllSuperiorOrgIdsOrderByLevel(orgId);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            QFilter allCtrl = new QFilter("ctrlstrategy", "=", (Object)"5");
            if (superOrg != null && !superOrg.isEmpty()) {
                QFilter orgFilter = new QFilter("createorg.id", "in", superOrg).and(new QFilter("ctrlstrategy", "=", (Object)"6"));
                filters.add(allCtrl.or(orgFilter));
            } else {
                filters.add(allCtrl);
            }
            return QueryServiceHelper.queryPrimaryKeys((String)"gl_assgrprelation", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
        });
    }

    public static List<Long> getAllSuperiorOrgIdsOrderByLevel(long orgid) {
        return (List)ThreadCache.get((Object)ThreadCacheKey.getAllSuperiorOrgIdsOrderByLevelKey(orgid), () -> {
            ArrayList<Long> ids = new ArrayList<Long>();
            if (orgid == 0L) {
                return ids;
            }
            QFilter f2 = new QFilter("view.number", "=", (Object)"10");
            QFilter f3 = new QFilter("org", "=", (Object)orgid);
            String longNumber = "";
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)PresetCashItemUtil.class.getName(), (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, null);){
                if (ds.hasNext()) {
                    Row row = ds.next();
                    longNumber = row.getString("longnumber");
                }
            }
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)longNumber) || longNumber.indexOf("!") == 0) {
                return ids;
            }
            String[] numbers = kd.bos.dataentity.utils.StringUtils.substringBeforeLast((String)longNumber, (String)"!").split("!");
            QFilter numberFilter = new QFilter("org.number", "in", (Object)numbers);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)PresetCashItemUtil.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, numberFilter}, (String)"level");){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    ids.add(row.getLong("org"));
                }
            }
            if (!ids.contains(orgid)) {
                ids.add(orgid);
            }
            return ids;
        });
    }

    public static BigDecimal getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        ExchangeRate exchangeRate = RateServiceHelper.getExchangeRate((Long)sourceCurrencyID, (Long)targetCurrencyID, (Long)exchangeTableID, (Date)date);
        return exchangeRate == null ? null : exchangeRate.getValue();
    }

    public static DataSet getEmptyDS(Class<?> clazz) {
        return Algo.create((String)(clazz.getName() + "#emptyDs")).createDataSet(Collections.emptyIterator(), new RowMeta(new Field[0]));
    }

    public static DataSet getEmptyDS(Class<?> clazz, RowMeta rowMeta) {
        return Algo.create((String)(clazz.getName() + "#emptyDs")).createDataSet(Collections.emptyIterator(), rowMeta);
    }

    public static int getRatePrecision(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        return RateServiceHelper.getRatePrecision((Long)sourceCurrencyID, (Long)targetCurrencyID, (Long)exchangeTableID, (Date)date);
    }

    @Deprecated
    public static DynamicObject getExchangeRateInfo(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        ORM orm = ORM.create();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter exchangeTableFilter = new QFilter("exctable", "=", (Object)exchangeTableID);
        filterList.add(exchangeTableFilter);
        QFilter sourceCurrencyFilter = new QFilter("orgcur", "=", (Object)sourceCurrencyID);
        filterList.add(sourceCurrencyFilter);
        QFilter targetCurrencyFilter = new QFilter("cur", "=", (Object)targetCurrencyID);
        filterList.add(targetCurrencyFilter);
        QFilter targetEnableFilter = new QFilter("enable", "=", (Object)"1");
        filterList.add(targetEnableFilter);
        if (date != null) {
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            filterList.add(dateFilter);
        }
        String selectFields = "id,excval,indirectexrate,precision,foreignexcid,effectdate";
        String orderBys = "effectdate desc";
        int top = 3;
        QFilter[] filters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            filters[i] = (QFilter)filterList.get(i);
        }
        DynamicObjectCollection list = orm.query(entityID_exchangeRate, selectFields, filters, orderBys, top);
        if (list != null) {
            if (list.size() == 0) {
                return null;
            }
            if (list.size() == 1) {
                return (DynamicObject)list.get(0);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            DynamicObject[] result = new DynamicObject[3];
            String dateStr = null;
            for (DynamicObject obj : list) {
                if (dateStr != null) {
                    if (!dateStr.equals(format.format(obj.getDate("effectdate")))) break;
                    GLUtil.resolve(result, obj);
                    continue;
                }
                dateStr = format.format(obj.getDate("effectdate"));
                GLUtil.resolve(result, obj);
            }
            return result[1] != null ? result[1] : (result[0] != null ? result[0] : result[2]);
        }
        return null;
    }

    private static void resolve(DynamicObject[] result, DynamicObject obj) {
        String excid = obj.getString("foreignexcid");
        if (excid.equals("1")) {
            result[0] = obj;
        } else if (excid.equals("2") || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)excid)) {
            result[1] = obj;
        } else if (excid.equals("3")) {
            result[2] = obj;
        }
    }

    public static List<Long> getCustomFilterIds(IFormView view, String fieldName) {
        IListView listView = (IListView)view;
        ControlFilters c = listView.getControlFilters();
        if (c == null) {
            return null;
        }
        List result = c.getFilter(fieldName);
        ArrayList<Long> ids = new ArrayList<Long>(result.size());
        for (Object v : result) {
            if ("".equals(v.toString())) continue;
            ids.add(Long.valueOf(v.toString()));
        }
        return ids;
    }

    public static Long getCustomFilterId(IFormView view, String fieldName) {
        List<Long> list = GLUtil.getCustomFilterIds(view, fieldName);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private static Map<Object, DynamicObject> getAsstacttypes(String flexfield) {
        if (ThreadCache.get((Object)ASSGRPMAP) == null) {
            QFilter q = new QFilter("flexfield", "=", (Object)flexfield);
            Map asstacttypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"number,valuetype,valuesource,assistanttype, disprops", (QFilter[])new QFilter[]{q});
            HashMap<String, Map> assMap = new HashMap<String, Map>();
            assMap.put(flexfield, asstacttypes);
            ThreadCache.put((Object)ASSGRPMAP, assMap);
            return asstacttypes;
        }
        Map assMap = (Map)ThreadCache.get((Object)ASSGRPMAP);
        if (assMap.containsKey(flexfield)) {
            return (Map)assMap.get(flexfield);
        }
        QFilter q = new QFilter("flexfield", "=", (Object)flexfield);
        Map asstacttypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"number,valuetype,valuesource,assistanttype, disprops", (QFilter[])new QFilter[]{q});
        assMap.put(flexfield, asstacttypes);
        return asstacttypes;
    }

    public static String dealAssgrp(JSONObject valueJson, String splitStr) {
        StringBuilder itemsStr = new StringBuilder();
        for (Map.Entry entry : valueJson.entrySet()) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            Map<Object, DynamicObject> asstacttypes = GLUtil.getAsstacttypes(k);
            if (asstacttypes.isEmpty()) continue;
            if (asstacttypes.size() > 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u5f02\u5e38,flexfield = %s \u91cd\u590d", (String)"GLUtil_0", (String)"fi-gl-common", (Object[])new Object[0]), k));
            }
            DynamicObject asstacttype = asstacttypes.values().iterator().next();
            String assttype = asstacttype.getString("valuetype");
            String flexName = asstacttype.getString("name");
            String disprop = "";
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)asstacttype.getString("disprops"))) {
                try {
                    Map map = (Map)SerializationUtils.fromJsonString((String)asstacttype.getString("disprops"), Map.class);
                    disprop = (String)((Map)map.get("disp")).get("dispprop");
                }
                catch (Exception map) {
                    // empty catch block
                }
            }
            if ("1".equals(assttype)) {
                String formid = asstacttype.getString("valuesource.id");
                if (formid == null) {
                    itemsStr.append(flexName).append(":").append(v).append(splitStr);
                } else {
                    BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)formid);
                    String num = entityType.getNumberProperty();
                    String name = entityType.getNameProperty();
                    DynamicObject valueDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(v + ""), (String)formid, (String)("id," + num + "," + name));
                    GLUtil.appendAssgrpProp(valueDyn, flexName, itemsStr, disprop, name, num, splitStr);
                }
            }
            if ("2".equals(assttype)) {
                BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)"bos_assistantdata_detail");
                String num = entityType.getNumberProperty();
                String name = entityType.getNameProperty();
                DynamicObject assistantdata = BusinessDataServiceHelper.loadSingleFromCache(v, (String)"bos_assistantdata_detail", (String)("id," + num + "," + name));
                GLUtil.appendAssgrpProp(assistantdata, flexName, itemsStr, disprop, name, num, splitStr);
            }
            if (!"3".equals(assttype)) continue;
            itemsStr.append(flexName).append(":").append(v).append(splitStr);
        }
        if (itemsStr.length() > 0) {
            itemsStr.setLength(itemsStr.length() - splitStr.length());
        }
        return itemsStr.toString();
    }

    public static String dealAssgrp(JSONObject valueJson, String splitStr, Map<String, Map<Object, DynamicObject>> formId2valueDyn, Map<String, String[]> formId2nameAndNumberProp) {
        StringBuilder itemsStr = new StringBuilder();
        Map<String, FlexProperty> flexPropertyMap = FlexUtils.batchGetFlexProperty(valueJson.keySet().toArray(new String[0]));
        for (Map.Entry entry : valueJson.entrySet()) {
            FlexProperty flexProperty;
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof Integer) {
                v = Long.parseLong(v.toString());
            }
            if ((flexProperty = flexPropertyMap.get(k)) == null) continue;
            String assttype = flexProperty.getValueType();
            String flexName = flexProperty.getName().getLocaleValue();
            String disprop = "";
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)flexProperty.getDisplayProp())) {
                try {
                    Map map = (Map)SerializationUtils.fromJsonString((String)flexProperty.getDisplayProp(), Map.class);
                    disprop = (String)((Map)map.get("disp")).get("dispprop");
                }
                catch (Exception map) {
                    // empty catch block
                }
            }
            if ("3".equals(assttype)) {
                itemsStr.append(flexName).append(":").append(v).append(splitStr);
                continue;
            }
            String formId = flexProperty.getValueSource();
            if ("2".equals(flexProperty.getValueType())) {
                formId = "bos_assistantdata_detail";
            }
            Map idDynMap = formId2valueDyn.getOrDefault(formId, Collections.emptyMap());
            GLUtil.appendAssgrpProp((DynamicObject)idDynMap.get(v), flexName, itemsStr, disprop, formId2nameAndNumberProp.get(formId)[1], formId2nameAndNumberProp.get(formId)[0], splitStr);
        }
        if (itemsStr.length() > 0) {
            itemsStr.setLength(itemsStr.length() - splitStr.length());
        }
        return itemsStr.toString();
    }

    public static void batchDealAssgrp(Table<Long, Date, Set<String>> orgBookedDateAssGrpValTable, Map<String, String> flexFieldFormIdMap, Map<String, String[]> formIdDisplayPropMap, Table<Long, Date, Map<String, Set<Object>>> formIdValueIdsMap) {
        orgBookedDateAssGrpValTable.rowKeySet().stream().forEach(x -> {
            Map cachedFormIdValues = orgBookedDateAssGrpValTable.row(x);
            cachedFormIdValues.entrySet().stream().forEach(entry -> {
                HashMap<String, Set<Object>> formIdValueIds = new HashMap<String, Set<Object>>(64);
                GLUtil.batchDealAssgrp((Set)entry.getValue(), flexFieldFormIdMap, formIdDisplayPropMap, formIdValueIds);
                formIdValueIdsMap.put(x, entry.getKey(), formIdValueIds);
            });
        });
    }

    public static void batchDealAssgrp(Set<String> flexValueJsonSet, Map<String, String> flexFieldFormIdMap, Map<String, String[]> formIdDisplayPropMap, Map<String, Set<Object>> formIdValueIdsMap) {
        for (String flexValueJson : flexValueJsonSet) {
            JSONObject flexValueMap = JSONObject.parseObject((String)flexValueJson);
            for (Map.Entry valueEntry : flexValueMap.entrySet()) {
                String flexField = (String)valueEntry.getKey();
                Object value = valueEntry.getValue();
                String formId = flexFieldFormIdMap.get(flexField);
                if (formId == null) {
                    FlexProperty flexProperty = FlexUtils.getFlexProperty(flexField);
                    if (!"1".equals(flexProperty.getValueType()) && !"2".equals(flexProperty.getValueType())) continue;
                    formId = flexProperty.getValueSource();
                    if ("2".equals(flexProperty.getValueType())) {
                        formId = "bos_assistantdata_detail";
                    }
                    BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)formId);
                    String numProp = entityType.getNumberProperty();
                    String nameProp = entityType.getNameProperty();
                    flexFieldFormIdMap.put(flexField, formId);
                    formIdDisplayPropMap.put(formId, new String[]{numProp, nameProp});
                    Set valueIdSet = formIdValueIdsMap.computeIfAbsent(formId, k -> new HashSet(1));
                    valueIdSet.add(value);
                    continue;
                }
                Set valueIdSet = formIdValueIdsMap.computeIfAbsent(formId, k -> new HashSet(1));
                valueIdSet.add(value);
            }
        }
    }

    private static void appendAssgrpProp(DynamicObject basedata, String flexName, StringBuilder itemStr, String disprop, String nameProp, String numberProp, String splitStr) {
        if (null == basedata) {
            return;
        }
        if (null == disprop) {
            disprop = "2";
        }
        switch (disprop) {
            case "1": {
                itemStr.append(flexName).append(":").append(basedata.getString(numberProp)).append(splitStr);
                break;
            }
            case "2": {
                itemStr.append(flexName).append(":").append(basedata.getString(nameProp)).append(splitStr);
                break;
            }
            case "3": {
                itemStr.append(flexName).append(":").append(basedata.getString(numberProp)).append(",").append(basedata.getString(nameProp)).append(splitStr);
                break;
            }
            default: {
                itemStr.append(flexName).append(":").append(basedata.getString(nameProp)).append(splitStr);
            }
        }
    }

    public static boolean hasPermission(String permItemId, Long orgId, String entityNum) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        return GLUtil.hasPermission(permItemId, orgIds, entityNum);
    }

    public static boolean hasPermission(String permItemId, List<Long> orgIds, String entityNum) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        int result = PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (String)"DIM_ORG", orgIds, (String)appId, (String)entityNum, (String)permItemId);
        return result == 1;
    }

    public static List<List<Object>> getAllUseOrg(String entityType) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appid = "gl";
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityType, (String)"47150e89000000ac");
        ArrayList<List<Object>> viewOrgIds = new ArrayList<List<Object>>();
        if (result == null) {
            return viewOrgIds;
        }
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        String orgFuncPro = "org.fisaccounting";
        QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)"1");
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        String view = null;
        view = null == ctrlview ? "16" : ctrlview.getString("id");
        QFilter f2 = new QFilter("view.id", "=", (Object)Long.valueOf(view));
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)"1");
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3, orgFuncFilter} : new QFilter[]{idsFilter, f2, f3, orgFuncFilter};
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)"getAllUseOrg", (String)"bos_org_structure", (String)"org.id,org.name", (QFilter[])qfilters, null);){
            while (dt.hasNext()) {
                Row row = dt.next();
                ArrayList<Object> par = new ArrayList<Object>(2);
                par.add(row.getLong("org.id"));
                par.add(row.getString("org.name"));
                viewOrgIds.add(par);
            }
        }
        return viewOrgIds;
    }

    public static String getDefaultUseOrg(List<List<Object>> col) {
        String defaultUseOrg = null;
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(col.get(0).get(0));
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (List<Object> obj : col) {
            if (longinOrg != Long.parseLong(String.valueOf(obj.get(0)))) continue;
            defaultUseOrg = String.valueOf(longinOrg);
        }
        return defaultUseOrg;
    }

    public static long getFilterInitDefOrgId(IPageCache pageCache, String entityId) {
        String orgidStr = pageCache.get("orgid");
        if (orgidStr != null) {
            return Long.parseLong(orgidStr);
        }
        long deforgId = 0L;
        String deforg = pageCache.get("deforg");
        if (deforg == null) {
            deforg = GLUtil.getDefaultUseOrg(GLUtil.getAllUseOrg(entityId));
            if (deforg != null) {
                pageCache.put("deforg", deforg);
                deforgId = Long.parseLong(deforg);
            }
        } else {
            deforgId = Long.parseLong(deforg);
        }
        return deforgId;
    }

    public static String getErrorInfoByOperationResult(OperationResult result) {
        StringBuilder msg = new StringBuilder();
        if (!result.isSuccess()) {
            int successCount = result.getSuccessPkIds().size();
            if (successCount > 0) {
                msg.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f%d\u6761\u6570\u636e\uff0c\u90e8\u5206\u5931\u8d25", (String)"GLUtil_2", (String)"fi-gl-common", (Object[])new Object[0]), successCount));
            } else {
                msg.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"GLUtil_3", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            List infos = result.getAllErrorOrValidateInfo();
            for (IOperateInfo info : infos) {
                msg.append("\n");
                msg.append(info.getMessage());
            }
        }
        return msg.toString();
    }

    public static List<Long> getOpenPeriod(long orgId, long bookTypeId) {
        return (List)ThreadCache.get((Object)(GLUtil.class.getName() + "#getOpenPeriod_" + orgId + "_" + bookTypeId), () -> {
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("org", "=", orgId);
            qfBuilder.add("booktype", "=", bookTypeId);
            Map openPeiodDynCache = BusinessDataServiceHelper.loadFromCache((String)"gl_openedperiod", (String)"period.id", (QFilter[])qfBuilder.toArray());
            return openPeiodDynCache.values().stream().map(x -> x.getLong("period.id")).sorted(Comparator.comparing(x -> x)).collect(Collectors.toList());
        });
    }

    public static Table<Long, Long, List<Long>> batchGetOpenPeriod(Collection<Long> orgIds, Long bookTypeId) {
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        HashBasedTable res = HashBasedTable.create();
        int batchSize = BillParamUtil.getIntegerValue((String)"P9H6JC5EVP1", (String)"fi.bd.util.batchprocessutil.size", (int)1000);
        for (List batchList : Lists.partition(new ArrayList<Long>(orgIds), (int)batchSize)) {
            DataSet openPeriodDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.GLUtil.batchGetOpenPeriod", (String)"gl_openedperiod", (String)String.join((CharSequence)",", "org.id", "booktype.id", "period.id"), (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)batchList), bookTypeFilter}, null);
            Throwable throwable = null;
            try {
                while (openPeriodDataSet.hasNext()) {
                    ArrayList<Long> openPeriod;
                    Row next = openPeriodDataSet.next();
                    long org = next.getLong("org.id");
                    List<Long> list = openPeriod = CollectionUtils.isEmpty((Collection)((Collection)res.get((Object)bookTypeId, (Object)org))) ? new ArrayList<Long>() : (List)res.get((Object)bookTypeId, (Object)org);
                    if (openPeriod != null) {
                        openPeriod.add(next.getLong("period.id"));
                    }
                    res.put((Object)bookTypeId, (Object)org, openPeriod);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (openPeriodDataSet == null) continue;
                if (throwable != null) {
                    try {
                        openPeriodDataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                openPeriodDataSet.close();
            }
        }
        return res;
    }

    public static void removeOpenedPeriodCache(long orgId, long booktypeId) {
        CacheKey key = CacheKey.getCacheKey(CacheKeyPrefix.GL_OPENPERIOD, orgId, booktypeId);
        LocalCacheHelper.remove(key);
    }

    public static Date getEndDate() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            return dt.parse("2999-12-31");
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"GLUtil_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
    }

    public static Date getInitBeginDate() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            return dt.parse("1900-01-01");
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"GLUtil_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
    }

    public static IFormView getSpecifiedUpperFormView(IFormView curView, Constant formConstant) {
        return GLUtil.getSpecifiedUpperFormView(curView, formConstant.getEntityKey());
    }

    public static IFormView getSpecifiedUpperFormView(IFormView curView, String formKey) {
        String curPageId = curView.getPageId();
        IFormView originalView = curView;
        while (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)curPageId) && !Objects.isNull(curView)) {
            if (formKey.equals(curView.getEntityId())) {
                return curView;
            }
            curPageId = curView.getFormShowParameter().getParentPageId();
            curView = originalView.getViewNoPlugin(curPageId);
        }
        return null;
    }

    public static void registerListener(BasedataEdit f7Control, List<QFilter> customsFilters, boolean idNeedClearOriginal) {
        f7Control.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            if (idNeedClearOriginal) {
                filters.clear();
            }
            filters.addAll(customsFilters);
            f7Control.getFieldKey();
        });
    }

    public static Long transferStr2Long(Object strID) {
        if (strID instanceof String) {
            return Long.parseLong(strID.toString());
        }
        throw new IllegalStateException("error transfer at Object: " + strID.toString());
    }

    public static Collection<Long> groupTransferStr2Long(Iterable toTrans, Collection<Long> resCol) {
        Objects.requireNonNull(resCol, "illegal method invoke for toTrans param");
        Objects.requireNonNull(toTrans, "illegal method invoke for result collection param");
        toTrans.forEach(objID -> resCol.add(Long.parseLong(objID.toString())));
        return resCol;
    }

    public static String assgrpId2String(Long assgrpid) {
        return (String)ThreadCache.get((Object)("GLUtil.assgrpId2String." + assgrpid.toString()), () -> {
            DynamicObject assgrp = QueryServiceHelper.queryOne((String)"gl_assist", (String)"assvals", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assgrpid)});
            if (assgrp == null) {
                return "";
            }
            String value = assgrp.getString("assvals");
            return GLUtil.dealAssgrp(JSONObject.parseObject((String)value), ";");
        });
    }

    public static boolean isDirectRate(long baseCur, long targetCur, Date date) {
        RateType rateType = RateServiceHelper.getRateType((long)baseCur, (long)targetCur, (Date)date);
        return rateType.getValue() == false;
    }

    public static int getCurrencyScale(Long currencyId) {
        return (Integer)ThreadCache.get((Object)ThreadCacheKey.getCurrencyPrecisionKey(currencyId, "amt"), () -> BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency").getInt("amtprecision"));
    }

    public static int getCurrencyPriceScale(Long currencyId) {
        return (Integer)ThreadCache.get((Object)ThreadCacheKey.getCurrencyPrecisionKey(currencyId, "pri"), () -> BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency").getInt("priceprecision"));
    }

    public static String serializeQFilter(QFilter ... filters) {
        return Arrays.stream(filters).filter(Objects::nonNull).map(QFilter::toSerializedString).collect(Collectors.joining("|"));
    }

    public static QFilter[] deserializeQFilter(String filterStr) {
        return Arrays.stream(kd.bos.dataentity.utils.StringUtils.split((String)filterStr, (String)"|")).map(QFilter::fromSerializedString).collect(Collectors.toList()).toArray(new QFilter[0]);
    }

    public static void setShortCuts(Collection<String> shortCuts, IFormView view) {
        JSONArray arrayItem = new JSONArray();
        shortCuts.forEach(shortcut -> arrayItem.add((Object)new JSONObject((Map)ImmutableMap.of((Object)"type", (Object)"keyDown", (Object)"shortCuts", (Object)shortcut))));
        JSONArray jsonArray = new JSONArray(Collections.singletonList(arrayItem));
        ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("setShortCuts", (Object)jsonArray);
    }

    public static int calInitialCapacity(int n) {
        return (int)((float)n / 0.75f + 1.0f);
    }

    public static boolean isLastVersionFilter(QFilter qFilter) {
        return qFilter.getProperty().equals("enddate") && qFilter.getCP().equals("=") && qFilter.getValue().equals(GLUtil.getEndDate());
    }

    public static boolean isClosePeriod(long orgId, long bookTypeId, long periodId) {
        AccountBookInfo bookDyn;
        boolean result = true;
        List<Long> openPeriod = GLUtil.getOpenPeriod(orgId, bookTypeId);
        if (!CollectionUtils.isEmpty(openPeriod) && openPeriod.contains(periodId)) {
            result = false;
        }
        if ((bookDyn = AccSysUtil.getBookFromAccSys(orgId, bookTypeId)) != null) {
            long curPeriod = bookDyn.getCurPeriodId();
            if (periodId == curPeriod) {
                result = false;
            } else {
                Date beginDate = new Date();
                Date curEnddate = new Date();
                DynamicObjectCollection periodDyn = QueryServiceHelper.query((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter("id", "in", Arrays.asList(periodId, curPeriod)).toArray());
                for (DynamicObject dyn : periodDyn) {
                    long id = dyn.getLong("id");
                    if (id == periodId) {
                        beginDate = dyn.getDate("begindate");
                        continue;
                    }
                    if (id != curPeriod) continue;
                    curEnddate = dyn.getDate("begindate");
                }
                if (beginDate.after(curEnddate)) {
                    result = false;
                }
            }
        }
        return result;
    }

    public static int getCurrencyScale(DynamicObject currencyDyn) {
        return (Integer)ThreadCache.get((Object)ThreadCacheKey.getCurrencyPrecisionKey((Long)currencyDyn.getPkValue()), () -> {
            int scale;
            try {
                scale = currencyDyn.getInt("amtprecision");
            }
            catch (Exception e) {
                scale = GLUtil.getCurrencyScale((Long)currencyDyn.getPkValue());
            }
            return scale;
        });
    }

    public static DynamicObjectType getDTByPropName(DynamicObject dynamicObject, String propName) {
        if (dynamicObject.getDataEntityType() instanceof MainEntityType) {
            MainEntityType entityType = (MainEntityType)dynamicObject.getDataEntityType();
            IDataEntityProperty property = entityType.findProperty(propName);
            if (property instanceof IComplexProperty) {
                return (DynamicObjectType)((IComplexProperty)property).getComplexType((Object)dynamicObject);
            }
            throw new KDBizException("property not instance of IComplexProperty");
        }
        throw new KDBizException("dynamic object not instance of MainEntityType");
    }

    public static LoadingCache<Long, DynamicObject> getDyoLoadingCache(String entityName, String selectFields, long maximumSize, QFilter ... initFilters) {
        LoadingCache cache = CacheBuilder.newBuilder().maximumSize(maximumSize).build(GLUtil.getCacheLoader(entityName, selectFields));
        Map<Long, DynamicObject> collect = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectFields, (QFilter[])initFilters).entrySet().stream().collect(Collectors.toMap(entry -> (Long)entry.getKey(), Map.Entry::getValue));
        cache.putAll(collect);
        return cache;
    }

    private static CacheLoader<Long, DynamicObject> getCacheLoader(String entityName, String selectFields) {
        return CacheLoader.from(pk -> BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)entityName, (String)selectFields));
    }

    public static Set<String> getBudgetTypes() {
        return new HashSet<String>(budgetTypes);
    }

    public static <T, U> List<T> extractToList(Collection<U> collection, Function<U, T> mapper) {
        return collection.stream().map(mapper).collect(Collectors.toList());
    }

    public static boolean isCurrentVoucherAllowModifyCF(long orgId, long bookTypeId, long vchPeriodId, String billStatus) {
        boolean isAllowAuditModifyCFItem;
        return !"C".equals(billStatus) || (isAllowAuditModifyCFItem = SystemParamHelper.getBooleanParam("mdifyauditcfitem", orgId, true)) || GLUtil.isClosePeriod(orgId, bookTypeId, vchPeriodId);
    }

    public static String formatFilterAsString(Stream<QFilter> filterStream) {
        return StringUtils.join((Iterable)filterStream.map(x -> {
            if (null == x) {
                return "null";
            }
            String fullString = x.toString();
            return fullString.length() <= 500 ? fullString : fullString.substring(0, 500) + String.format("--ignore %s chars -- ", fullString.length() - 500);
        }).collect(Collectors.toList()), (String)" | ");
    }

    public static List<Object> getValuesFromQFilterValue(Object value) {
        ArrayList<Object> res = new ArrayList<Object>(8);
        if (value instanceof Collection) {
            res.addAll((Collection)value);
        } else {
            res.add(value);
        }
        return res;
    }

    public static DataSet queryBalanceByAssist(MainEntityType ormBalanceEntity, String selectors, QFilter[] filters, String queryOrder, int limit, String entity) {
        Preconditions.checkArgument((ormBalanceEntity != null ? 1 : 0) != 0);
        ORM orm = ORM.create();
        orm.setDataEntityType(entity, (IDataEntityType)ormBalanceEntity);
        if (DebugTrace.enable()) {
            LOG.info("balance_query filters :{}, order: {}, limit: {}", new Object[]{String.join((CharSequence)" | ", Arrays.asList(filters).stream().map(x -> StringUtils.truncate((String)x.toString(), (int)1000)).collect(Collectors.toList())), queryOrder, limit});
        }
        long qTick = System.currentTimeMillis();
        DataSet balance = orm.queryDataSet(GLUtil.class.getName(), entity, selectors, Arrays.asList(filters).toArray(new QFilter[0]), queryOrder, limit);
        LOG.info("query balance table cost: {}", (Object)(System.currentTimeMillis() - qTick));
        return balance;
    }

    public static int compareLongArr(long[] a1, long[] a2) {
        return (int)IntStream.range(0, a1.length).mapToLong(i -> a1[i] - a2[i]).filter(i -> i != 0L).findFirst().orElse(0L);
    }

    public static int compareObj(Object obj1, Object obj2) {
        int compare;
        if (obj1 == null && obj2 == null) {
            compare = 0;
        } else if (obj1 == null) {
            compare = 1;
        } else if (obj2 == null) {
            compare = -1;
        } else if (obj1 instanceof Long) {
            compare = Long.compare((Long)obj1, (Long)obj2);
        } else if (obj1 instanceof Integer) {
            compare = Integer.compare((Integer)obj1, (Integer)obj2);
        } else if (obj1 instanceof String) {
            compare = ((String)obj1).compareTo((String)obj2);
        } else if (obj1 instanceof Timestamp) {
            compare = ((Timestamp)obj1).compareTo((Timestamp)obj2);
        } else if (obj1 instanceof BigDecimal) {
            compare = ((BigDecimal)obj1).compareTo((BigDecimal)obj2);
        } else if (obj1 instanceof Date) {
            compare = ((Date)obj1).compareTo((Date)obj2);
        } else {
            compare = 0;
            LOG.info(String.format("undeal type : [%s, %s]", obj1.getClass(), obj2.getClass()));
        }
        return compare;
    }

    public static String toJsonStr(Object obj) {
        try {
            return JSONUtils.toString((Object)obj);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    public static int getRoundMode(String precisionAccount) {
        switch (precisionAccount) {
            case "2": {
                return 1;
            }
            case "3": {
                return 0;
            }
        }
        return 4;
    }

    public static <T> Comparator<T> longArrComparator(Function<T, long[]> extractor) {
        return (o1, o2) -> GLUtil.compareLongArr((long[])extractor.apply(o1), (long[])extractor.apply(o2));
    }

    public static String getEntityDisplayName(String entityId) {
        Preconditions.checkArgument((boolean)kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)entityId), (Object)("blank entityId:" + entityId));
        return EntityMetadataCache.getDataEntityType((String)entityId).getDisplayName().getLocaleValue();
    }
}

