/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MasterBaseDataUtils {
    public static boolean isMasterBaseData(String entityName) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return false;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (dataEntityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
            int masterIdType = basedataEntityType.getMasteridType();
            return masterIdType != 0 && StringUtils.isNotBlank((CharSequence)basedataEntityType.getMasteridPropName());
        }
        return false;
    }

    public static String getMasterIdField(String entityName) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return "";
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (dataEntityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
            int masterIdType = basedataEntityType.getMasteridType();
            String masterIdPropName = basedataEntityType.getMasteridPropName();
            if (masterIdType != 0 && StringUtils.isNotBlank((CharSequence)masterIdPropName)) {
                return masterIdPropName;
            }
        }
        return "";
    }

    public static long reloadMasterId(String entityId, Object originalPk) {
        String idField = MasterBaseDataUtils.getMasterIdField(entityId);
        idField = StringUtils.isBlank((CharSequence)idField) ? "id" : idField;
        DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)originalPk, (String)entityId, (String)idField);
        return baseData == null ? 0L : baseData.getLong(idField);
    }

    public static long getMasterId(String entityName, Object pkValue) {
        Map<Object, Long> batchResults = MasterBaseDataUtils.batchGetMasterIds(entityName, pkValue);
        return batchResults.getOrDefault(pkValue, 0L);
    }

    public static Map<Object, Long> batchGetMasterIds(String entityName, Object ... pkValues) {
        Objects.requireNonNull(entityName);
        Objects.requireNonNull(pkValues);
        String masterIdField = MasterBaseDataUtils.getMasterIdField(entityName);
        if (StringUtils.isBlank((CharSequence)masterIdField)) {
            return Collections.emptyMap();
        }
        Map cacheValues = BusinessDataServiceHelper.loadFromCache((Object[])pkValues, (String)entityName);
        return cacheValues.entrySet().stream().collect(Collectors.toMap(x -> x.getKey(), x -> ((DynamicObject)x.getValue()).getLong(masterIdField)));
    }
}

