/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;

public class MulCurReportUtil {
    private static final Map<String, MCT> BALANCE_LOCAL_TO_MCT_AMOUNTS = new HashMap<String, MCT>();
    private static final Map<String, MCT> VOUCHER_LOCAL_TO_MCT_AMOUNTS;

    public static String getSingleBalanceLocalField(String mulcur, MCT mct, String rawField, String alias) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            return rawField + " " + alias;
        }
        LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
        return localCurrencyConfigVO.getBalanceField(mct).getMetaId() + " " + alias;
    }

    public static void addBalanceAmountFields(Collection<String> selList, String inputAmountField, String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            Collections.addAll(selList, inputAmountField.replace("#", "local").split(","));
        } else {
            LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
            selList.add(localCurrencyConfigVO.getBalanceField(MCT.BEGIN).getMetaId() + " beginlocal");
            selList.add(localCurrencyConfigVO.getBalanceField(MCT.DEBIT).getMetaId() + " debitlocal");
            selList.add(localCurrencyConfigVO.getBalanceField(MCT.CREDIT).getMetaId() + " creditlocal");
            selList.add(localCurrencyConfigVO.getBalanceField(MCT.YEAR_DEBIT).getMetaId() + " yeardebitlocal");
            selList.add(localCurrencyConfigVO.getBalanceField(MCT.YEAR_CREDIT).getMetaId() + " yearcreditlocal");
            selList.add(localCurrencyConfigVO.getBalanceField(MCT.END).getMetaId() + " endlocal");
        }
    }

    public static void addBalanceAmountFields(Collection<String> amountFields, String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            amountFields.add("beginlocal");
            amountFields.add("debitlocal");
            amountFields.add("creditlocal");
            amountFields.add("yeardebitlocal");
            amountFields.add("yearcreditlocal");
            amountFields.add("endlocal");
        } else {
            LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
            amountFields.add(localCurrencyConfigVO.getBalanceField(MCT.BEGIN).getMetaId() + " beginlocal");
            amountFields.add(localCurrencyConfigVO.getBalanceField(MCT.DEBIT).getMetaId() + " debitlocal");
            amountFields.add(localCurrencyConfigVO.getBalanceField(MCT.CREDIT).getMetaId() + " creditlocal");
            amountFields.add(localCurrencyConfigVO.getBalanceField(MCT.YEAR_DEBIT).getMetaId() + " yeardebitlocal");
            amountFields.add(localCurrencyConfigVO.getBalanceField(MCT.YEAR_CREDIT).getMetaId() + " yearcreditlocal");
            amountFields.add(localCurrencyConfigVO.getBalanceField(MCT.END).getMetaId() + " endlocal");
        }
    }

    public static String getBalanceLogAmountFields(String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            return "debitlocal,creditlocal";
        }
        LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
        String debitLocal = localCurrencyConfigVO.getBalanceLogField(MCT.DEBIT).getMetaId() + " debitlocal";
        String creditLocal = localCurrencyConfigVO.getBalanceLogField(MCT.CREDIT).getMetaId() + " creditlocal";
        return debitLocal + "," + creditLocal;
    }

    public static void addBalanceLogAmountFields(List<String> sels, String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            sels.add("debitlocal-creditlocal beginlocal");
            sels.add("debitlocal");
            sels.add("creditlocal");
        } else {
            LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
            String debitLocal = localCurrencyConfigVO.getBalanceLogField(MCT.DEBIT).getMetaId();
            String creditLocal = localCurrencyConfigVO.getBalanceLogField(MCT.CREDIT).getMetaId();
            sels.add(debitLocal + "-" + creditLocal + " beginlocal");
            sels.add(debitLocal + " debitlocal");
            sels.add(creditLocal + " creditlocal");
        }
    }

    public static void addBalanceLogAmountFields2(List<String> sels, String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            sels.add("debitlocal");
            sels.add("creditlocal");
        } else {
            LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
            String debitLocal = localCurrencyConfigVO.getBalanceLogField(MCT.DEBIT).getMetaId();
            String creditLocal = localCurrencyConfigVO.getBalanceLogField(MCT.CREDIT).getMetaId();
            sels.add(debitLocal + " debitlocal");
            sels.add(creditLocal + " creditlocal");
        }
    }

    public static String getSingleBalanceLogLocalField(String mulcur, MCT mct, String rawField, String alias) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            return rawField + " " + alias;
        }
        LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
        return localCurrencyConfigVO.getBalanceLogField(mct).getMetaId() + " " + alias;
    }

    public static String getVoucherLocalAmountFields(String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            return "entries.debitlocal vdebitlocal,entries.creditlocal vcreditlocal";
        }
        LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
        String debitLocal = "entries." + localCurrencyConfigVO.getVoucherField(MCT.DEBIT).getMetaId() + " vdebitlocal";
        String creditLocal = "entries." + localCurrencyConfigVO.getVoucherField(MCT.CREDIT).getMetaId() + " vcreditlocal";
        return debitLocal + "," + creditLocal;
    }

    public static String getSingleVoucherLocalField(String mulcur, MCT mct, String prefix, String rawField, String alias) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            return prefix + rawField + " " + alias;
        }
        LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
        return prefix + localCurrencyConfigVO.getVoucherField(mct).getMetaId() + " " + alias;
    }

    public static String getVoucherLocalAmountFields2(String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            return "entries.debitlocal debitlocal,entries.creditlocal creditlocal";
        }
        LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
        String debitLocal = "entries." + localCurrencyConfigVO.getVoucherField(MCT.DEBIT).getMetaId() + " debitlocal";
        String creditLocal = "entries." + localCurrencyConfigVO.getVoucherField(MCT.CREDIT).getMetaId() + " creditlocal";
        return debitLocal + "," + creditLocal;
    }

    public static String getVoucherLocalAmountFields4(String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            return "entries.debitlocal,entries.creditlocal";
        }
        LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
        String debitLocal = "entries." + localCurrencyConfigVO.getVoucherField(MCT.DEBIT).getMetaId() + " entries.debitlocal";
        String creditLocal = "entries." + localCurrencyConfigVO.getVoucherField(MCT.CREDIT).getMetaId() + " entries.creditlocal";
        return debitLocal + "," + creditLocal;
    }

    public static String replaceVchLocalAmountFields(String selectFields, String mulcur) {
        if (!Objects.isNull(mulcur) && !Objects.equals(mulcur, "LocalCurrency")) {
            LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
            String debitLocal = "entries." + localCurrencyConfigVO.getVoucherField(MCT.DEBIT).getMetaId() + " entries.debitlocal";
            String creditLocal = "entries." + localCurrencyConfigVO.getVoucherField(MCT.CREDIT).getMetaId() + " entries.creditlocal";
            selectFields = selectFields.replace("entries.debitlocal", debitLocal).replace("entries.creditlocal", creditLocal);
        }
        return selectFields;
    }

    public static List<String> getVoucherLocalAmountFields3(String mulcur) {
        return Lists.newArrayList((Object[])MulCurReportUtil.getVoucherLocalAmountFields2(mulcur).split(","));
    }

    public static void addVoucherAmountFields(List<String> sels, String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            sels.add("entries.debitlocal debitlocal");
            sels.add("entries.creditlocal creditlocal");
        } else {
            LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
            sels.add("entries." + localCurrencyConfigVO.getVoucherField(MCT.DEBIT).getMetaId() + " debitlocal");
            sels.add("entries." + localCurrencyConfigVO.getVoucherField(MCT.CREDIT).getMetaId() + " creditlocal");
        }
    }

    public static String getInitBalanceLocalAmountFields(String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            return "yeardebitlocal,yearcreditlocal,yearprofitdebitlocal,yearprofitcreditlocal";
        }
        LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
        String yearDebitLocal = localCurrencyConfigVO.getInitBalanceField(MCT.YEAR_DEBIT).getMetaId() + " yeardebitlocal";
        String yearCreditLocal = localCurrencyConfigVO.getInitBalanceField(MCT.YEAR_CREDIT).getMetaId() + " yearcreditlocal";
        String yearProfitDebitLocal = localCurrencyConfigVO.getInitBalanceField(MCT.YEAR_PROFIT_DEBIT).getMetaId() + " yearprofitdebitlocal";
        String yearProfitCreditLocal = localCurrencyConfigVO.getInitBalanceField(MCT.YEAR_PROFIT_CREDIT).getMetaId() + " yearprofitcreditlocal";
        return yearDebitLocal + "," + yearCreditLocal + "," + yearProfitDebitLocal + "," + yearProfitCreditLocal;
    }

    public static void addInitBalanceLocalAmountField(List<String> selList, String mulcur) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            selList.add("yeardebitlocal");
            selList.add("yearcreditlocal");
            selList.add("yearprofitdebitlocal");
            selList.add("yearprofitcreditlocal");
        } else {
            LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
            selList.add(localCurrencyConfigVO.getInitBalanceField(MCT.YEAR_DEBIT).getMetaId() + " yeardebitlocal");
            selList.add(localCurrencyConfigVO.getInitBalanceField(MCT.YEAR_CREDIT).getMetaId() + " yearcreditlocal");
            selList.add(localCurrencyConfigVO.getInitBalanceField(MCT.YEAR_PROFIT_DEBIT).getMetaId() + " yearprofitdebitlocal");
            selList.add(localCurrencyConfigVO.getInitBalanceField(MCT.YEAR_PROFIT_CREDIT).getMetaId() + " yearprofitcreditlocal");
        }
    }

    public static List<String> getInitBalanceLocalAmountFields2(String mulcur) {
        return Lists.newArrayList((Object[])MulCurReportUtil.getInitBalanceLocalAmountFields(mulcur).split(","));
    }

    public static String getSingleInitBalanceLocalField(String mulcur, MCT mct, String rawField, String alias) {
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            return rawField + " " + alias;
        }
        LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulcur);
        return localCurrencyConfigVO.getInitBalanceField(mct).getMetaId() + " " + alias;
    }

    public static boolean localCurrency(String mulCur) {
        return Objects.isNull(mulCur) || Objects.equals(mulCur, "LocalCurrency");
    }

    public static Map<String, MCT> getBalanceLocalToMctAmounts() {
        return Collections.unmodifiableMap(BALANCE_LOCAL_TO_MCT_AMOUNTS);
    }

    private static List<String> mulCurAmountToLocalAlias(List<String> fieldList, String mulCur, String tableName) {
        if (!MulCurReportUtil.localCurrency(mulCur)) {
            LocalCurrencyConfigVO localCurrencyConfigVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulCur);
            if ("gl_balance".equals(tableName)) {
                fieldList.replaceAll(x -> {
                    MCT mulMCT = BALANCE_LOCAL_TO_MCT_AMOUNTS.get(x.trim());
                    if (Objects.nonNull(mulMCT)) {
                        return localCurrencyConfigVO.getBalanceField(mulMCT).getMetaId() + " " + x;
                    }
                    return x;
                });
            }
            if ("gl_voucher".equals(tableName)) {
                fieldList.replaceAll(x -> {
                    String[] fields = x.split(" ");
                    if (fields.length == 2 && fields[0].trim().startsWith("entries.")) {
                        String oriField = fields[0].trim().substring(8);
                        String alias = fields[1].trim();
                        MCT mulMCT = VOUCHER_LOCAL_TO_MCT_AMOUNTS.get(oriField);
                        if (Objects.nonNull(mulMCT)) {
                            return "entries." + localCurrencyConfigVO.getVoucherField(mulMCT).getMetaId() + " " + alias;
                        }
                    }
                    return x;
                });
            }
        }
        return fieldList;
    }

    public static List<String> mulCurBalAmountToLocalAlias(List<String> balanceList, String mulCur) {
        if (!MulCurReportUtil.localCurrency(mulCur)) {
            MulCurReportUtil.mulCurAmountToLocalAlias(balanceList, mulCur, "gl_balance");
        }
        return balanceList;
    }

    public static String mulCurBalAmountToLocalAlias(String balances, String mulCur) {
        String[] fields = balances.split(",");
        List<String> balanceList = Arrays.asList(fields);
        balanceList = MulCurReportUtil.mulCurBalAmountToLocalAlias(balanceList, mulCur);
        return String.join((CharSequence)",", balanceList);
    }

    public static List<String> mulCurVoucherAmountToLocalAlias(List<String> voucherList, String mulCur) {
        if (!MulCurReportUtil.localCurrency(mulCur)) {
            voucherList = MulCurReportUtil.mulCurAmountToLocalAlias(voucherList, mulCur, "gl_voucher");
        }
        return voucherList;
    }

    public static String mulCurVoucherAmountToLocalAlias(String vouchers, String mulCur) {
        String[] fields = vouchers.split(",");
        List<String> voucherList = Arrays.asList(fields);
        voucherList = MulCurReportUtil.mulCurVoucherAmountToLocalAlias(voucherList, mulCur);
        return String.join((CharSequence)",", voucherList);
    }

    public static long getMulCurrency(String mulCur, long orgId, long bookTypeId, long baseCurrencyId) {
        if (MulCurReportUtil.localCurrency(mulCur)) {
            return baseCurrencyId;
        }
        LocalCurrencyConfigVO configVO = LocalCurrencyConfigService.getCurrencyConfig((String)mulCur);
        long currencyId = configVO.getCurrencyId(orgId, bookTypeId);
        return currencyId;
    }

    static {
        BALANCE_LOCAL_TO_MCT_AMOUNTS.put("beginlocal", MCT.BEGIN);
        BALANCE_LOCAL_TO_MCT_AMOUNTS.put("debitlocal", MCT.DEBIT);
        BALANCE_LOCAL_TO_MCT_AMOUNTS.put("creditlocal", MCT.CREDIT);
        BALANCE_LOCAL_TO_MCT_AMOUNTS.put("yeardebitlocal", MCT.YEAR_DEBIT);
        BALANCE_LOCAL_TO_MCT_AMOUNTS.put("yearcreditlocal", MCT.YEAR_CREDIT);
        BALANCE_LOCAL_TO_MCT_AMOUNTS.put("endlocal", MCT.END);
        VOUCHER_LOCAL_TO_MCT_AMOUNTS = new HashMap<String, MCT>();
        VOUCHER_LOCAL_TO_MCT_AMOUNTS.put("debitlocal", MCT.DEBIT);
        VOUCHER_LOCAL_TO_MCT_AMOUNTS.put("creditlocal", MCT.CREDIT);
    }
}

