/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;

public class MutexRequireHelper {
    private static Log logger = LogFactory.getLog(MutexRequireHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> batchRequire(String entityKey, Set<Long> billIds, String operationKey) {
        HashSet<Long> lockIds = new HashSet<Long>();
        if (billIds.size() == 0) {
            return lockIds;
        }
        boolean isStrict = true;
        String netGroupId = "default_netctrl";
        ArrayList mutexRequireList = new ArrayList(billIds.size());
        for (Long billid : billIds) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
            requireParam.put("dataObjId", billid.toString());
            requireParam.put("groupId", netGroupId);
            requireParam.put("entityKey", entityKey);
            requireParam.put("operationKey", operationKey);
            requireParam.put("isStrict", isStrict);
            mutexRequireList.add(requireParam);
        }
        try (DataMutex dataMutex = DataMutex.create();){
            ArrayList<Long> failIds = new ArrayList<Long>(16);
            Map mutexResult = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String objId = (String)mutexItem.getKey();
                boolean required = (Boolean)mutexItem.getValue();
                Long id = 0L;
                id = Long.valueOf(objId);
                if (required) {
                    lockIds.add(id);
                    continue;
                }
                failIds.add(id);
            }
            logger.info("require_lock_fail:{}", failIds);
        }
        catch (Exception e) {
            logger.info("require_lock_error:{}", (Object)e.getMessage());
            lockIds.clear();
        }
        return lockIds;
    }

    public static void batchRelease(String entityKey, Set<Long> billIds, String operationKey) {
        if (!billIds.isEmpty()) {
            String netGroupId = "default_netctrl";
            ArrayList mutexRequireList = new ArrayList(billIds.size());
            for (Long lockId : billIds) {
                HashMap<String, String> requireParam = new HashMap<String, String>(8);
                requireParam.put("dataObjId", lockId.toString());
                requireParam.put("groupId", netGroupId);
                requireParam.put("entityKey", entityKey);
                requireParam.put("operationKey", operationKey);
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (releaseRet) continue;
                    logger.info("release_object_fail:{}", (Object)objId);
                }
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"MutexRequireHelper_5", (String)"fi-gl-common", (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
        }
    }
}

