/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.QFBuilder;

public class OrgFilterUtils {
    public static void addOrgFilterToF7ByEntityId(BeforeF7SelectEvent e, String entityId, boolean onlyLeaf) {
        OrgFilterUtils.addFilterToF7(e, OrgFilterUtils.getOrgFilterByEntityId(entityId, onlyLeaf));
    }

    public static void addOrgFilterToF7ByViewType(BeforeF7SelectEvent e, String orgViewType, boolean onlyLeaf) {
        OrgFilterUtils.addFilterToF7(e, OrgFilterUtils.getOrgFilterByViewType(orgViewType, onlyLeaf));
    }

    public static QFilter getOrgFilterByEntityId(String entityId, boolean onlyLeaf) {
        if ("bos_org".equals(entityId)) {
            return OrgFilterUtils.getOrgFilterByViewType("15", onlyLeaf);
        }
        if ("bos_adminorg".equals(entityId)) {
            return OrgFilterUtils.getOrgFilterByViewType("01", onlyLeaf);
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public static QFilter getOrgFilterByViewType(String orgViewType, boolean onlyLeaf) {
        ArrayList orgIds = new ArrayList(64);
        QFBuilder qfBuilder = new QFBuilder().add("view.treetype", "=", orgViewType).add("view.isdefault", "=", true);
        if (onlyLeaf) {
            qfBuilder.add("isLeaf", "=", true);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)OrgFilterUtils.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])qfBuilder.toArray(), null);){
            ds.forEachRemaining(row -> orgIds.add(row.getLong("org")));
        }
        return new QFilter("id", "in", orgIds);
    }

    private static void addFilterToF7(BeforeF7SelectEvent e, QFilter filter) {
        ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
        List qFilters = list.getListFilterParameter().getQFilters();
        qFilters.add(filter);
    }
}

