/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.SubsiDiaryHelper;

public class SubsiDiaryLeftQueryHelper {
    private static final Log log = LogFactory.getLog(SubsiDiaryLeftQueryHelper.class);
    private static final String entryKey = "entryentity";
    private static final String groupStandard = "groupstandard";
    private static final String FIELD_NAME = "fieldname";
    private static final String showType = "showtype";
    private static final String treeName = "treename";
    private static final String treeEntryKey = "treeentryentity";
    private static final String assistBd = "gl_assist_bd";
    private static final String assistTxt = "gl_assist_txt";
    private static final String assType = "asstype";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private FilterInfo filterInfo;
    private List<String> typeList = new ArrayList<String>();
    private long standardId = 0L;
    private String treeAlias;
    private String entityId;
    private long orgViewId = 1L;

    private DataSet query(ReportQueryParam param, String hyperFormId) {
        FilterInfo filter;
        this.filterInfo = filter = param.getFilter();
        DataSet result = this.dealAssrg(hyperFormId);
        return result;
    }

    private DataSet dealAssrg(String hyperFormId) {
        this.typeList.clear();
        String balanceSel = "account,assgrp.id assid";
        DataSet balanceData = SubsiDiaryHelper.getBalance(this.filterInfo, balanceSel, null);
        HashSet<Long> hgSet = new HashSet<Long>();
        for (Row row : balanceData.copy()) {
            long assId = row.getLong("assid");
            hgSet.add(assId);
        }
        DataSet result = null;
        HashMap<String, List<String>> entityNameFlexsMap = new HashMap<String, List<String>>();
        boolean isOnlyQueryeAssist = this.isOnlyQueryeAssist(hyperFormId);
        List fItemInfos = this.filterInfo.getFlexFilterItems();
        int i = 0;
        boolean preFilter = false;
        boolean curFilter = false;
        boolean hasFilter = false;
        for (FilterItemInfo itemInfo : fItemInfos) {
            String propName = itemInfo.getPropName();
            String entityId = this.fillAssistTypeName(propName);
            String entityName = assistBd;
            if (entityId == null) {
                entityName = assistTxt;
            }
            if (isOnlyQueryeAssist) {
                List<String> flexs;
                if (entityNameFlexsMap.get(entityName) == null) {
                    flexs = new ArrayList<String>();
                    flexs.add(propName);
                    entityNameFlexsMap.put(entityName, flexs);
                } else {
                    flexs = (List)entityNameFlexsMap.get(entityName);
                    flexs.add(propName);
                }
            }
            QFilter typeFilter = new QFilter(assType, "=", (Object)propName);
            if (StringUtils.isNotBlank((Object)itemInfo.getValue()) && itemInfo.getValue() instanceof HashSet && ((HashSet)itemInfo.getValue()).size() > 0) {
                HashSet assVals = (HashSet)itemInfo.getValue();
                typeFilter.and(new QFilter("assval", "in", (Object)assVals));
                curFilter = true;
                hasFilter = true;
            } else {
                if (assistTxt.equals(entityName)) {
                    typeFilter.and(new QFilter("assval", "!=", (Object)"0"));
                } else {
                    typeFilter.and(new QFilter("assval", "!=", (Object)0));
                }
                curFilter = false;
            }
            if (hgSet.size() < 1000) {
                typeFilter.and(new QFilter("hg", "in", hgSet));
            }
            String selectFields = i == 0 ? "hg id, assval " + propName : "hg id1, assval " + propName;
            DataSet assSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])typeFilter.toArray(), null);
            if (result == null) {
                result = assSet;
            } else {
                List<String> selField = SubsiDiaryHelper.getSetField(result);
                List<String> newField = SubsiDiaryLeftQueryHelper.getSel(selField, propName);
                JoinType joinType = preFilter && curFilter ? JoinType.INNER : (preFilter ? JoinType.LEFT : (curFilter ? JoinType.RIGHT : JoinType.FULL));
                result = result.join(assSet, joinType).on("id", "id1").select(selField.toArray(new String[0]), new String[]{"id1", propName}).finish().select(newField.toArray(new String[0]));
            }
            this.typeList.add(propName);
            preFilter = curFilter || preFilter;
            ++i;
        }
        if (isOnlyQueryeAssist) {
            result = SubsiDiaryHelper.acctBalanceHyper(result, entityNameFlexsMap);
        }
        List<String> fileds = SubsiDiaryHelper.getSetField(result);
        JoinType type = hasFilter ? JoinType.INNER : JoinType.LEFT;
        result = balanceData.join(result, type).on("assid", "id").select(fileds.toArray(new String[0])).finish();
        result = result.groupBy(this.typeList.toArray(new String[0])).finish();
        result = result.orderBy(this.typeList.toArray(new String[this.typeList.size()]));
        return result;
    }

    private static List<String> getSel(List<String> sel, String assType) {
        ArrayList<String> result = new ArrayList<String>(10);
        for (String field : sel) {
            if (field.equalsIgnoreCase("id")) continue;
            result.add(field);
        }
        result.add(assType);
        result.add("case when id is null then id1 else id end id");
        return result;
    }

    private boolean isOnlyQueryeAssist(String hyperFormId) {
        return "gl_rpt_accountbalance".equals(hyperFormId);
    }

    private String fillAssistTypeName(String propName) {
        QFilter qFilter = new QFilter("flexfield", "=", (Object)propName);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)ASSIST_TYPE, (String)"name,valuesource,valuetype", (QFilter[])new QFilter[]{qFilter});
        String valType = queryOne.getString("valuetype");
        String entityId = null;
        switch (valType) {
            case "1": {
                entityId = queryOne.getString("valuesource");
                break;
            }
            case "2": {
                entityId = "bos_assistantdata_detail";
            }
        }
        return entityId;
    }

    private List<String> getFieldsByDs(DataSet dataSet) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (dataSet != null) {
            Field[] fields;
            for (Field field : fields = dataSet.getRowMeta().getFields()) {
                fieldNames.add(field.getAlias());
            }
        }
        return fieldNames;
    }

    public BasedataField createBaseDataField(String id, String key, String baseEntityId) {
        BasedataField basedataField = new BasedataField();
        basedataField.setId(id);
        basedataField.setKey(key);
        basedataField.setBaseEntityId(baseEntityId);
        return basedataField;
    }

    public TextField createTextField(String id, String key) {
        TextField field = new TextField();
        field.setId(id);
        field.setKey(key);
        return field;
    }

    public EntryFieldAp createEntryFieldAp(String id, String key, String name) {
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setId("");
        fieldAp.setKey("");
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        return fieldAp;
    }

    public Map<String, Object> getEntryGroupVal(IDataModel model) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            DynamicObject fieldNameDyn;
            String showVal = (String)model.getValue(showType, i);
            if ("1".equals(showVal) || (fieldNameDyn = (DynamicObject)model.getValue(FIELD_NAME, i)) == null) continue;
            String valuetype = fieldNameDyn.getString("valuetype");
            DynamicObject valueSourceDyn = null;
            if ("1".equals(valuetype)) {
                valueSourceDyn = fieldNameDyn.getDynamicObject("valuesource");
                this.entityId = valueSourceDyn.get("id").toString();
                if (this.getGroupAssistKey().contains(valueSourceDyn.get("id"))) {
                    String groupVal = (String)model.getValue(groupStandard, i);
                    this.standardId = Long.parseLong(groupVal);
                    map.put("standardId", this.standardId);
                }
            } else if ("2".equals(valuetype)) {
                valueSourceDyn = fieldNameDyn.getDynamicObject("assistanttype");
                this.entityId = "bos_assistantdata_detail";
            }
            map.put("entityId", this.entityId);
            map.put("showType", showVal);
            map.put("treeAlias", fieldNameDyn.getString("flexfield"));
        }
        return map;
    }

    private DataSet buildMulTreeEntrySet(DataSet assistSet) {
        if (assistSet != null && this.entityId != null && this.getGroupAssistKey().contains(this.entityId)) {
            HashSet<Long> groupIds = new HashSet<Long>();
            HashMap<Long, Long> pidToLeafIdMap = new HashMap<Long, Long>();
            Set<Long> ids = this.getFieldVal(assistSet, this.treeAlias);
            assistSet = this.queryTreeName(assistSet, ids);
            DataSet groupSet = this.queryGroupDetail(ids);
            for (Row row : groupSet.copy()) {
                long groupId = row.getLong(0);
                long id = row.getLong("id");
                groupIds.add(groupId);
                pidToLeafIdMap.put(id, groupId);
            }
            DataSet detailAssistSet = this.getIdToPidDetail(assistSet, groupSet);
            String groupEntityId = this.entityId + "group";
            HashMap<Long, Integer> levelMap = new HashMap<Long, Integer>();
            HashMap<Long, String> longNumberMap = new HashMap<Long, String>();
            HashMap<Long, Map<Long, Long>> leafIdToMap = new HashMap<Long, Map<Long, Long>>();
            HashMap<Long, Long> relationMap = new HashMap<Long, Long>();
            HashMap<String, Long> indexMap = new HashMap<String, Long>();
            indexMap.put("index", 1L);
            SubsiDiaryHelper.getMulTreeLeafIdToMap(leafIdToMap, pidToLeafIdMap, groupIds, groupEntityId, new HashSet<Long>(), levelMap, longNumberMap, relationMap, indexMap, new HashSet<Long>());
            DataSet parentSet = null;
            if (!leafIdToMap.isEmpty()) {
                List<String> parentFieldList = this.treeFields();
                DataSet relationSet = SubsiDiaryHelper.buildTreeByMap(relationMap);
                parentSet = SubsiDiaryHelper.createMulTreeMapSet(leafIdToMap, groupEntityId, parentFieldList, levelMap, longNumberMap, relationMap, relationSet);
                List<String> assistRelatList = this.getFieldsByDs(detailAssistSet);
                assistRelatList.remove("pid");
                DataSet detailSet = detailAssistSet.join(relationSet, JoinType.LEFT).on("pid", "id").select(assistRelatList.toArray(new String[0]), new String[]{"pid"}).finish();
                parentFieldList.add(treeName);
                parentFieldList.add("treenumber");
                parentFieldList.remove("leafid");
                List<String> otherAssistList = this.getFieldsByDs(assistSet);
                otherAssistList.remove("id");
                otherAssistList.remove(treeName);
                otherAssistList.remove("treenumber");
                parentSet = assistSet.join(parentSet, JoinType.RIGHT).on(this.treeAlias, "leafid").select(otherAssistList.toArray(new String[0]), parentFieldList.toArray(new String[0])).finish();
                List<String> allList = this.getFieldsByDs(detailSet);
                parentSet = parentSet.groupBy(allList.toArray(new String[0])).finish();
                otherAssistList.clear();
                otherAssistList.addAll(allList);
                otherAssistList.removeAll(this.getMulTreeFields());
                detailAssistSet = parentSet.union(detailSet).orderBy(allList.toArray(new String[0]));
            }
            return detailAssistSet;
        }
        return null;
    }

    public List<String> treeFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("pid");
        list.add("id");
        list.add("leafid");
        list.add("isgroupnode");
        list.add("level");
        list.add("longnumber");
        return list;
    }

    public DataSet queryTreeName(DataSet assistSet, Set<Long> ids) {
        List<String> assistList = this.getFieldsByDs(assistSet);
        assistList.removeIf(x -> x.equals("id"));
        QFilter fassistNameIds = new QFilter("id", "in", ids);
        DataSet assistNameSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityId, (String)"id,name treename,number treenumber", (QFilter[])new QFilter[]{fassistNameIds}, null);
        assistSet = assistSet.join(assistNameSet, JoinType.LEFT).on(this.treeAlias, "id").select(assistList.toArray(new String[0]), new String[]{"id", treeName, "treenumber"}).finish();
        return assistSet;
    }

    public DataSet queryGroupDetail(Set<Long> ids) {
        String groupKey = this.entityId.substring(3);
        QFilter fid = new QFilter(groupKey, "in", ids);
        QFilter fgroup = new QFilter("standard", "=", (Object)this.standardId);
        String sel = "group pid, group.level level,group.longnumber longnumber,group.number treenumber," + groupKey + " id";
        DataSet groupSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)(this.entityId + "groupdetail"), (String)sel, (QFilter[])new QFilter[]{fid, fgroup}, null);
        return groupSet;
    }

    public DataSet getIdToPidDetail(DataSet assistSet, DataSet groupSet) {
        List<String> assistList = this.getFieldsByDs(assistSet);
        DataSet detailAssistSet = assistSet.copy().join(groupSet, JoinType.LEFT).on("id", "id").select(assistList.toArray(new String[0]), new String[]{"pid", "level", "longnumber"}).finish();
        detailAssistSet = detailAssistSet.addField("0", "isgroupnode");
        assistList.clear();
        assistList.addAll(this.getFieldsByDs(detailAssistSet));
        assistList.removeIf(x -> x.equals("level"));
        assistList.add("case when level=null then 1 else level+1 end as level");
        detailAssistSet = detailAssistSet.select(assistList.toArray(new String[0]));
        return detailAssistSet;
    }

    public Set<Long> getFieldVal(DataSet assistSet, String alias) {
        HashSet<Long> ids = new HashSet<Long>();
        for (Row row : assistSet.copy()) {
            if (row.get(this.treeAlias) != null) {
                long id = row.getLong(this.treeAlias);
                ids.add(id);
                continue;
            }
            ids.add(0L);
        }
        return ids;
    }

    public List<String> getMulTreeFields() {
        ArrayList<String> mulTeeFieldList = new ArrayList<String>();
        mulTeeFieldList.add("pid");
        mulTeeFieldList.add("id");
        mulTeeFieldList.add("isgroupnode");
        mulTeeFieldList.add("level");
        mulTeeFieldList.add(treeName);
        mulTeeFieldList.add("longnumber");
        return mulTeeFieldList;
    }

    private DataSet buildTreeEntrySet(DataSet assistSet) {
        if (assistSet != null) {
            HashSet<Long> ids = new HashSet<Long>();
            HashMap<Long, Long> idToPidMap = new HashMap<Long, Long>();
            for (Row row : assistSet.copy()) {
                if (row.getLong(this.treeAlias) == null) continue;
                long id = row.getLong(this.treeAlias);
                ids.add(id);
                idToPidMap.put(id, id);
            }
            if (ids.isEmpty()) {
                return null;
            }
            HashSet<Long> noLeafIds = new HashSet<Long>();
            HashMap<Long, Integer> levelMap = new HashMap<Long, Integer>();
            HashMap<Long, String> longNumberMap = new HashMap<Long, String>();
            HashMap<Long, Map<Long, Long>> leafIdToMap = new HashMap<Long, Map<Long, Long>>();
            HashMap<Long, Long> relationMap = new HashMap<Long, Long>();
            HashMap<String, Long> indexMap = new HashMap<String, Long>();
            indexMap.put("index", 1L);
            HashSet<Long> pids = new HashSet<Long>();
            SubsiDiaryHelper.getTreeLeafIdToMap(leafIdToMap, idToPidMap, ids, this.entityId, noLeafIds, levelMap, longNumberMap, relationMap, indexMap, pids, this.orgViewId);
            SubsiDiaryHelper.getDetailOrParent(pids, leafIdToMap, relationMap, indexMap);
            ArrayList<String> listField = new ArrayList<String>();
            listField.add(this.treeAlias);
            listField.addAll(this.treeFields());
            DataSet treeSet = SubsiDiaryHelper.createTreeMapSet(leafIdToMap, listField, noLeafIds, levelMap, longNumberMap, relationMap);
            listField.clear();
            listField.addAll(this.getFieldsByDs(treeSet));
            listField.remove("leafid");
            List<String> assistList = this.getFieldsByDs(assistSet);
            assistList.remove(this.treeAlias);
            assistSet = assistSet.join(treeSet, JoinType.LEFT).on(this.treeAlias, "leafid").select(assistList.toArray(new String[0]), listField.toArray(new String[0])).finish();
            assistList.addAll(listField);
            assistSet = assistSet.groupBy(assistList.toArray(new String[0])).finish();
            assistList.removeAll(listField);
            assistSet = assistSet.orderBy(assistList.toArray(new String[0]));
            return assistSet;
        }
        return null;
    }

    private List<String> getGroupAssistKey() {
        return Arrays.asList("bd_customer", "bd_supplier", "bd_material");
    }

    public DataSet getLeftSet(ReportQueryParam param, Map<String, Object> paramMap, boolean isNullable) throws Throwable {
        String showType = (String)paramMap.get("showType");
        String hyperFormId = paramMap.get("hyperFormId") == null ? "" : paramMap.get("hyperFormId").toString();
        DataSet ds = this.query(param, hyperFormId);
        if (showType != null) {
            this.entityId = (String)paramMap.get("entityId");
            this.treeAlias = (String)paramMap.get("treeAlias");
            if (paramMap.get("standardId") != null) {
                this.standardId = Long.parseLong(paramMap.get("standardId").toString());
                ds = this.buildMulTreeEntrySet(ds);
            } else {
                this.setOrgViewId();
                ds = this.buildTreeEntrySet(ds);
            }
            if (ds == null) {
                return null;
            }
            List<String> fieldList = this.getFieldsByDs(ds);
            fieldList.remove("pid");
            fieldList.remove("id");
            fieldList.add("case when pid=null then 0 else pid end as pid");
            fieldList.add("case when id=null then -1 else id end as id");
            ds = ds.select(fieldList.toArray(new String[0]));
        }
        return ds;
    }

    private void setOrgViewId() {
        QFilter filter = new QFilter("flexfield", "=", (Object)this.treeAlias);
        DynamicObject assisType = QueryServiceHelper.queryOne((String)ASSIST_TYPE, (String)"valuesource.number number,flexfield,valuetype", (QFilter[])new QFilter[]{filter});
        String valuetype = assisType.getString("valuetype");
        String entityName = assisType.getString("number");
        String flexField = assisType.getString("flexfield");
        this.orgViewId = SubsiDiaryHelper.getOrgViewId(valuetype, entityName, flexField);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createMulTreeValue(DataSet ds, TableValueSetter vs, AbstractFormDataModel model, Map<String, String> keyMap, IFormView view) {
        int idIndex;
        List fields;
        HashMap<String, Map> flexfieldToMasteridAndId;
        String preAssistVal = "";
        int _index = 0;
        List<String> otherAssistList = this.getFieldsByDs(ds);
        List<String> mulTreeFieldList = this.getMulTreeFields();
        otherAssistList.removeAll(mulTreeFieldList);
        if (this.treeAlias != null) {
            otherAssistList.remove(this.treeAlias);
        }
        HashSet<Long> idSet = new HashSet<Long>();
        ArrayList<Object[]> tempList = new ArrayList<Object[]>(10);
        Iterator iterator = ds.iterator();
        while (true) {
            Iterator<String> iterator2;
            Object[] obj;
            int i;
            Row row;
            if (iterator.hasNext()) {
                row = (Row)iterator.next();
                i = 0;
                obj = new Object[vs.getFields().size()];
                StringBuilder curAssistValBuf = new StringBuilder();
                for (String assistField : otherAssistList) {
                    curAssistValBuf = curAssistValBuf.append(row.get(assistField));
                }
                if (!preAssistVal.equals(curAssistValBuf.toString())) {
                    _index = 10000000 + _index;
                }
                preAssistVal = curAssistValBuf.toString();
                iterator2 = vs.getFields().iterator();
            } else {
                flexfieldToMasteridAndId = new HashMap<String, Map>(16);
                fields = vs.getFields();
                idIndex = fields.indexOf("id");
                int treeNameIndex = fields.indexOf(treeName);
                break;
            }
            while (iterator2.hasNext()) {
                block29: {
                    String field = iterator2.next();
                    if ("pid".equals(field)) {
                        Long o = row.getLong("pid");
                        obj[i] = o > 0L ? Long.valueOf((long)_index + o) : o;
                    } else if ("id".equals(field)) {
                        if (row.getBoolean("isgroupnode") != null && row.getBoolean("isgroupnode").booleanValue()) {
                            if (idSet.add(row.getLong("id"))) {
                                obj[i] = row.getLong("id") + (long)_index;
                                break block29;
                            } else {
                                i = 0;
                                break;
                            }
                        }
                        obj[i] = row.getLong("id");
                    } else {
                        obj[i] = field.equals(treeName) ? row.get(treeName) : row.get(keyMap.get(field));
                    }
                }
                ++i;
            }
            if (i == 0) continue;
            tempList.add(obj);
        }
        for (int i = 0; i < fields.size(); ++i) {
            String field = (String)fields.get(i);
            String fieldName = keyMap.get(field);
            if (!FlexUtils.isBaseDataAndMasteridProperty(fieldName)) continue;
            int fieldIndex = i;
            if (treeName.equals(field)) {
                fieldIndex = idIndex;
            }
            for (Object[] objectArray : tempList) {
                flexfieldToMasteridAndId.computeIfAbsent(fieldName, k -> new HashMap()).put((Long)objectArray[fieldIndex], (Long)objectArray[fieldIndex]);
            }
        }
        if (DebugTrace.enable()) {
            log.info("{}_flexfieldToMasteridAndId_1:{}", (Object)this.getClass().getName(), (Object)DebugTraceHelper.toString(flexfieldToMasteridAndId));
        }
        HashMap<Long, String> flexfieldToIdAndName = new HashMap<Long, String>(flexfieldToMasteridAndId.size());
        long orgid = ((DynamicObject)model.getValue("org")).getLong("id");
        Date enddate = ((DynamicObject)model.getValue("endperiod")).getDate("enddate");
        for (Map.Entry entry : flexfieldToMasteridAndId.entrySet()) {
            String flexfield = (String)entry.getKey();
            String valuesource = FlexUtils.getFlexProperty(flexfield).getValueSource();
            if (StringUtils.isEmpty((CharSequence)valuesource)) continue;
            String nameField = "name";
            String nameNumberField = "number,name";
            String nameFieldCache = view.getPageCache().get(valuesource);
            if (StringUtils.isNotEmpty((CharSequence)nameFieldCache)) {
                nameNumberField = nameFieldCache;
                String[] fieldArr = nameFieldCache.split(",");
                nameField = fieldArr[0];
                if (Objects.equals(fieldArr[0], fieldArr[1])) {
                    nameNumberField = fieldArr[0];
                }
            }
            Map value = (Map)entry.getValue();
            Set ids = value.keySet();
            ids.removeIf(x -> x == null || x == 0L);
            if (ids.size() <= 0) continue;
            for (List batchIds : Lists.partition(new ArrayList(ids), (int)1000)) {
                QFilter qFilter = new QFilter("masterid", "in", (Object)batchIds);
                DynamicObjectCollection assistObjs = BaseDataServiceHelper.queryBaseDataByDate((String)valuesource, (Long)orgid, (QFilter)qFilter, (String)("id,masterid," + nameNumberField), (Date)enddate);
                for (DynamicObject assistObj : assistObjs) {
                    value.put(assistObj.getLong("masterid"), assistObj.getLong("id"));
                    flexfieldToIdAndName.put(assistObj.getLong("id"), assistObj.getString(nameField));
                }
            }
        }
        if (DebugTrace.enable()) {
            log.info("{}_flexfieldToMasteridAndId_2:{}", (Object)this.getClass().getName(), (Object)DebugTraceHelper.toString(flexfieldToMasteridAndId));
        }
        int i = 0;
        while (true) {
            block31: {
                Iterator tempIterator;
                Map masteridAndIds;
                String string;
                block32: {
                    block30: {
                        if (i >= fields.size()) break block30;
                        string = (String)fields.get(i);
                        String fieldName = keyMap.get(string);
                        if (!FlexUtils.isBaseDataAndMasteridProperty(fieldName)) break block31;
                        masteridAndIds = (Map)flexfieldToMasteridAndId.get(fieldName);
                        tempIterator = tempList.iterator();
                        break block32;
                    }
                    Iterator iterator3 = tempList.iterator();
                    while (true) {
                        if (!iterator3.hasNext()) {
                            model.beginInit();
                            model.deleteEntryData(treeEntryKey);
                            model.batchCreateNewEntryRow(treeEntryKey, vs);
                            model.endInit();
                            view.updateView(treeEntryKey);
                            return;
                        }
                        Object[] objectArray = (Object[])iterator3.next();
                        vs.addRow(objectArray);
                    }
                }
                while (tempIterator.hasNext()) {
                    Long newId;
                    Object[] tempObj = (Object[])tempIterator.next();
                    if (treeName.equals(string)) {
                        newId = (Long)masteridAndIds.get(tempObj[idIndex]);
                        tempObj[idIndex] = newId;
                        String newNme = (String)flexfieldToIdAndName.get(newId);
                        if (!StringUtils.isNotEmpty((CharSequence)newNme)) continue;
                        tempObj[treeNameIndex] = newNme;
                        continue;
                    }
                    if (tempObj[i] == null) continue;
                    newId = (Long)masteridAndIds.get(tempObj[i]);
                    tempObj[i] = newId;
                }
            }
            ++i;
        }
    }
}

