/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.ManageItemCell;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.TaxReportFetchrule;
import kd.fi.gl.reciprocal.ReciprocalContext;
import kd.fi.gl.report.GLReportQueryParams;
import kd.fi.gl.taxreport.BalanceSheetDataHandler;
import kd.fi.gl.taxreport.CashFLowDataHandler;
import kd.fi.gl.taxreport.ITaxReportDataHandler;
import kd.fi.gl.taxreport.IncomeDataHandler;
import kd.fi.gl.taxreport.TaxDataHandler;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.TaxReportParam;

public class TaxReportFormHelper {
    private static final String ALGO_KEY = "kd.fi.gl.util.TaxReportFormHelper.getAcctIdByMasterId";
    private static final String RPTITEM = "rptitem";
    private static final String ISTOTALROW = "istotalrow";
    private static final String NUMBER = "number";
    private static final String MASTERID = "masterid";
    private static final String FETCHRULE = "fetchrule";
    private static final String ITEMID = "itemid";
    private static final String SIGN = "sign";
    private static final String incomeEdit = "gl_incomeedit";
    private static final String incomExpressionFormId = "gl_incomeexpression";
    private static final String balancesheetEdit = "gl_balancesheetedit";
    private static final String balanceExpressionFormId = "gl_balancesheetexpression";
    private static final String org = "org";
    private static final String accTable = "accounttable";
    private static final String balrowId = "balrowid";
    private static final String dbRowid = "dbrowid";
    private static final String rowtag = "rowtag";
    private static final String seq = "seq";
    private static final String entryEntity = "entryentity";
    private static final String columnKey = "columnkey";
    private static final String assetEntryKey = "assetentryentity";
    private static final String equityEntryKey = "equityentryentity";
    private static final String EXP_FIELD = "org orgid, balrowid,rowtag, columnkey, istotalrow,entryentity.project.name name, entryentity.project.number number, entryentity.project.masterid masterid, entryentity.sign sign, entryentity.fetchrule fetchrule,entryentity.project.id accountid, entryentity.rptitem.id itemid";
    private static final String BALANCE_Asset_FIELD = "assetentryentity.seq seq,assetentryentity.assetrowid dbRowid, assetentryentity.asset asset, assetentryentity.asset.istotalrow assettype";
    private static final String BALANCE_Equity_FIELD = "equityentryentity.seq seq,equityentryentity.equityrowid dbRowid, equityentryentity.equity equity, equityentryentity.equity.istotalrow equitytype";
    private static final String INCOME_FIELD = "entryentity.balrowid balrowid,entryentity.rowid dbRowid, entryentity.project project, entryentity.project.istotalrow projecttype";
    private static final String Default_BalSheet_Query_Fields = "org.id orgid, assetentryentity.seq balrowid, accounttable, booktype,  assetentryentity.asset asset, assetentryentity.asset.masterid assetmasterid, equityentryentity.equity equity, equityentryentity.equity.masterid equitymasterid, assetentryentity.seq seq";
    private static final String Default_BalSheet_Asset_Query_Fields = "org.id orgid, assetentryentity.seq seq, accounttable, booktype,assetentryentity.assetrowid dbRowid,  assetentryentity.asset asset, assetentryentity.asset.masterid assetmasterid,1 as type";
    private static final String Default_BalSheet_Equity_Query_Fields = "org.id orgid, equityentryentity.seq seq, accounttable, booktype, equityentryentity.equityrowid dbRowid, equityentryentity.equity equity, equityentryentity.equity.masterid equitymasterid,2 as type";
    private static final String Default_BalSheet_Asset_OrderBys = "assetentryentity.seq asc";
    private static final String Default_BalSheet_Equity_OrderBys = "equityentryentity.seq asc";
    private static final String Default_IncomeEdit_Query_Fields = "org.id orgid, entryentity.project project, entryentity.project.masterid projectmasterid, entryentity.balrowid balrowid,entryentity.rowid dbRowid,entryentity.seq seq";
    private static final Log logger = LogFactory.getLog(ReciprocalContext.class);
    private static final String[] sumFields = new String[]{"beginlocal", "endlocal", "debitlocal", "creditlocal", "yeardebitlocal", "yearcreditlocal"};

    public static DynamicObjectCollection getIncomeEdit(Set<Long> orgIds, long accTableId, String type, QFilter[] qFilters) {
        return TaxReportFormHelper.getIncomeEdits(orgIds, accTableId, type, qFilters, Default_IncomeEdit_Query_Fields);
    }

    public static DynamicObjectCollection getIncomeEdits(Set<Long> orgIds, long accTableId, String type, QFilter[] qFilters) {
        return TaxReportFormHelper.getIncomeEdits(orgIds, accTableId, type, qFilters, "org.id orgid, entryentity.project.number number, entryentity.balrowid balrowid");
    }

    public static DynamicObjectCollection getIncomeEdits(Set<Long> orgIds, long accTableId, String type, QFilter[] qFilters, String selectFields) {
        QFilter ftype = new QFilter("type", "=", (Object)type);
        List<QFilter> qFilterList = TaxReportFormHelper.getQFilters(orgIds, accTableId);
        qFilterList.add(ftype);
        if (qFilters != null) {
            qFilterList.addAll(Arrays.asList(qFilters));
        }
        return QueryServiceHelper.query((String)incomeEdit, (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"entryentity.seq asc");
    }

    public static DynamicObjectCollection getIncomeExps(Set<Long> orgIds, long accTableId, long bookTypeId, String taxType) {
        QFilter orgFilter = new QFilter(org, "in", orgIds);
        QFilter accountTableFilter = new QFilter(accTable, "=", (Object)accTableId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter ftype = new QFilter("type", "=", (Object)taxType);
        return QueryServiceHelper.query((String)incomExpressionFormId, (String)EXP_FIELD, (QFilter[])new QFilter[]{orgFilter, accountTableFilter, bookTypeFilter, ftype});
    }

    public static List<List<BigDecimal>> getIncomeExpValue(DynamicObjectCollection collection, DynamicObjectCollection expCollection, Set<Long> orgIds, Set<Long> childOrgIds, long bookTypeId, long accTableId, long periodID, String type, int amtprecision, boolean isCalTotalRow, Map<Long, String> taxProjects) {
        return TaxReportFormHelper.getBalSheetExpValue(collection, expCollection, orgIds, childOrgIds, bookTypeId, accTableId, periodID, type, null, amtprecision, isCalTotalRow, taxProjects);
    }

    public static DynamicObjectCollection getBalSheet(Set<Long> orgIds, long accTableId, QFilter[] qFilters) {
        return TaxReportFormHelper.getBalSheets(orgIds, accTableId, qFilters, Default_BalSheet_Query_Fields);
    }

    public static DynamicObjectCollection getBalSheets(Set<Long> orgIds, long accTableId, QFilter[] qFilters, String selectFields) {
        List<QFilter> list = TaxReportFormHelper.getQFilters(orgIds, accTableId);
        if (list != null && qFilters != null) {
            list.addAll(Arrays.asList(qFilters));
        }
        return QueryServiceHelper.query((String)balancesheetEdit, (String)selectFields, (QFilter[])list.toArray(new QFilter[0]), (String)"assetentryentity.assetrowid asc");
    }

    public static DynamicObjectCollection getBalSheets(Set<Long> orgIds, long accTableId, QFilter[] qFilters, String selectFields, String entryName) {
        List<QFilter> list = TaxReportFormHelper.getQFilters(orgIds, accTableId);
        if (list != null && qFilters != null) {
            list.addAll(Arrays.asList(qFilters));
        }
        String orderByField = null;
        if (assetEntryKey.equals(entryName)) {
            orderByField = Default_BalSheet_Asset_OrderBys;
        } else if (equityEntryKey.equals(entryName)) {
            orderByField = Default_BalSheet_Equity_OrderBys;
        }
        return QueryServiceHelper.query((String)balancesheetEdit, (String)selectFields, (QFilter[])list.toArray(new QFilter[0]), (String)orderByField);
    }

    public static DynamicObjectCollection getBalSheetsByEntityType(Set<Long> orgIds, long accTableId, QFilter[] qFilters, String selectFields, String orderby) {
        List<QFilter> list = TaxReportFormHelper.getQFilters(orgIds, accTableId);
        if (list != null && qFilters != null) {
            list.addAll(Arrays.asList(qFilters));
        }
        return QueryServiceHelper.query((String)balancesheetEdit, (String)selectFields, (QFilter[])list.toArray(new QFilter[0]), (String)orderby);
    }

    public static DynamicObjectCollection getBalSheets(Set<Long> orgIds, long accTableId, QFilter[] qFilters) {
        return TaxReportFormHelper.getBalSheets(orgIds, accTableId, qFilters, "org.id orgid,entryentity.balrowid balrowid, entryentity.asset.number asset, entryentity.equity.number equity");
    }

    public static DynamicObjectCollection getBalSheetsByEntryName(Set<Long> orgIds, long accTableId, QFilter[] qFilters, String entryName) {
        if (assetEntryKey.equals(entryName)) {
            return TaxReportFormHelper.getBalSheets(orgIds, accTableId, qFilters, "org.id orgid,assetentryentity.assetrowid balrowid, assetentryentity.asset.number asset", entryName);
        }
        if (equityEntryKey.equals(entryName)) {
            return TaxReportFormHelper.getBalSheets(orgIds, accTableId, qFilters, "org.id orgid,equityentryentity.equityrowid balrowid, equityentryentity.equity.number equity", entryName);
        }
        return null;
    }

    private static List<QFilter> getQFilters(Set<Long> orgIds, long accTableId) {
        ArrayList<QFilter> flist = new ArrayList<QFilter>();
        QFilter forg = new QFilter(org, "in", orgIds);
        QFilter faccTable = new QFilter(accTable, "=", (Object)accTableId);
        flist.add(forg);
        flist.add(faccTable);
        return flist;
    }

    public static DynamicObjectCollection getBalSheetExps(Set<Long> orgIds, long accTableId, long bookTypeId) {
        QFilter orgFilter = new QFilter(org, "in", orgIds);
        QFilter accountTableFilter = new QFilter(accTable, "=", (Object)accTableId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        return QueryServiceHelper.query((String)balanceExpressionFormId, (String)EXP_FIELD, (QFilter[])new QFilter[]{orgFilter, accountTableFilter, bookTypeFilter});
    }

    public static List<List<BigDecimal>> getBalSheetExpValue(DynamicObjectCollection collection, DynamicObjectCollection expCollection, Set<Long> orgIds, Set<Long> childOrgIds, long bookTypeId, long accTableId, long periodId, String type, String entityType, int amtprecision, boolean isCalTotalRow, Map<Long, String> taxProjects) {
        LinkedHashMap<String, List<BigDecimal>> resultList = new LinkedHashMap<String, List<BigDecimal>>();
        if (collection != null && collection.size() > 0) {
            Map<String, Map<String, BigDecimal>> accBalance = TaxReportFormHelper.getAccBalanceByType("period", childOrgIds, bookTypeId, accTableId, periodId, expCollection, type, amtprecision, taxProjects);
            LinkedHashMap<String, ManageItemCell> cellAndItemMap = new LinkedHashMap<String, ManageItemCell>();
            HashMap<String, List<String>> expKeyMap = new HashMap<String, List<String>>();
            TaxReportFormHelper.complie(expCollection, cellAndItemMap, expKeyMap);
            HashMap<Long, String> itemIdAndRowIndexMap = new HashMap<Long, String>();
            for (DynamicObject dyn : collection) {
                int index = 1;
                int size = 5;
                String rowId = dyn.getString(dbRowid);
                if (assetEntryKey.equals(entityType) || equityEntryKey.equals(entityType)) {
                    index = assetEntryKey.equals(entityType) ? 1 : 3;
                    int n = size = assetEntryKey.equals(entityType) ? 3 : 5;
                }
                if ("income".equals(type)) {
                    size = 3;
                }
                ArrayList<BigDecimal> vals = new ArrayList<BigDecimal>(size);
                for (int i = index; i < size; ++i) {
                    String key = rowId + "," + i;
                    BigDecimal amount = BigDecimal.ZERO;
                    ManageItemCell cell = (ManageItemCell)cellAndItemMap.get(key);
                    if (cell != null) {
                        Long itemId = TaxReportFormHelper.getItemId(type, dyn, i);
                        cell.setItemId(itemId);
                        itemIdAndRowIndexMap.put(itemId, rowId);
                    } else {
                        List expList = (List)expKeyMap.get(key);
                        if (expList != null) {
                            amount = TaxReportFormHelper.parseExp(expList, accBalance);
                        }
                    }
                    vals.add(amount);
                }
                resultList.put(rowId, vals);
            }
            if (isCalTotalRow) {
                TaxReportFormHelper.loadDetailCellRowAndColIdx(cellAndItemMap, itemIdAndRowIndexMap);
                TaxReportFormHelper.handleTotalRows(type, entityType, orgIds, accTableId, resultList, expKeyMap, cellAndItemMap);
            }
        }
        Collection valueCollection = resultList.values();
        return new ArrayList<List<BigDecimal>>(valueCollection);
    }

    private static void complie(DynamicObjectCollection expCollection, Map<String, ManageItemCell> cellAndItemMap, Map<String, List<String>> expKeyMap) {
        if (expCollection != null) {
            for (DynamicObject dyn : expCollection) {
                if (dyn.getString(FETCHRULE) == null || "null".equals(dyn.getString(FETCHRULE))) continue;
                String key = dyn.getString(rowtag) + "," + dyn.getString(columnKey);
                Boolean isTotalRow = dyn.getBoolean(ISTOTALROW);
                String val = "";
                if (isTotalRow.booleanValue()) {
                    val = dyn.get(ITEMID) + "," + dyn.get(SIGN);
                    ManageItemCell cell = cellAndItemMap.computeIfAbsent(key, p -> new ManageItemCell(dyn.getString(rowtag), dyn.getString(columnKey)));
                    cell.addDetailItemId(dyn.getLong(ITEMID));
                } else {
                    val = dyn.getString(NUMBER) + "," + dyn.getString(SIGN) + "," + dyn.getString(FETCHRULE);
                }
                if (expKeyMap.containsKey(key)) {
                    List<String> list = expKeyMap.get(key);
                    list.add(val);
                    expKeyMap.put(key, list);
                    continue;
                }
                ArrayList<String> expList = new ArrayList<String>();
                expList.add(val);
                expKeyMap.put(key, expList);
            }
        }
    }

    private static void loadDetailCellRowAndColIdx(Map<String, ManageItemCell> cellAndItemMap, Map<Long, String> itemIdAndRowIndexMap) {
        for (ManageItemCell cell : cellAndItemMap.values()) {
            Set<Long> detailItemIds = cell.getDetailItemIds();
            String colIndex = cell.getColIdx();
            for (Long detailItemId : detailItemIds) {
                String rowIndex = itemIdAndRowIndexMap.get(detailItemId);
                if (StringUtils.isEmpty((CharSequence)rowIndex)) continue;
                cell.addDetailCell(rowIndex + "," + colIndex);
            }
        }
    }

    private static Long getItemId(String type, DynamicObject dyn, int colIndex) {
        Long itemId = 0L;
        if ("income".equals(type)) {
            itemId = dyn.getLong("project");
        } else if ("balancesheet".equals(type)) {
            itemId = colIndex >= 1 && colIndex <= 2 ? Long.valueOf(dyn.getLong("asset")) : Long.valueOf(dyn.getLong("equity"));
        }
        return itemId;
    }

    private static Long getItemIdByEntityType(String type, DynamicObject dyn, String entryEntity) {
        Long itemId = 0L;
        if ("income".equals(type)) {
            itemId = dyn.getLong("project");
        } else if ("balancesheet".equals(type)) {
            itemId = assetEntryKey.equals(entryEntity) ? Long.valueOf(dyn.getLong("asset")) : Long.valueOf(dyn.getLong("equity"));
        }
        return itemId;
    }

    public static void handleTotalRows(String type, String entityType, Set<Long> orgIds, long accTableId, Map<String, List<BigDecimal>> resultList, Map<String, List<String>> expKeyMap, Map<String, ManageItemCell> cellAndItemMap) {
        if (!"income".equals(type) && !"balancesheet".equals(type)) {
            return;
        }
        List<String> totalRowCellSeq = TaxReportFormHelper.sortByLevel(cellAndItemMap);
        Map<Long, Set<String>> itemIdAndRowIdxMap = TaxReportFormHelper.queryItemAndCellMap(type, entityType, orgIds, accTableId);
        for (int i = totalRowCellSeq.size() - 1; i >= 0; --i) {
            String[] cell;
            String key = totalRowCellSeq.get(i);
            List<String> vals = expKeyMap.get(key);
            if (vals == null || vals.isEmpty() || (cell = key.split(",")).length != 2) continue;
            TaxReportFormHelper.logInfo("balancesheet handleTotalRows cell: " + cell + "; vals: " + vals);
            String rowIdx = cell[0];
            int colIdx = 0;
            colIdx = assetEntryKey.equals(entityType) ? Integer.parseInt(cell[1]) - 1 : (equityEntryKey.equals(entityType) ? Integer.parseInt(cell[1]) - 3 : Integer.parseInt(cell[1]) - 1);
            if (colIdx > 1 || colIdx < 0) continue;
            BigDecimal value = BigDecimal.ZERO;
            for (String val : vals) {
                value = TaxReportFormHelper.parseTotalRow(resultList, itemIdAndRowIdxMap, colIdx, value, val);
            }
            List<BigDecimal> rowAmount = resultList.get(rowIdx);
            if (CollectionUtils.isEmpty(rowAmount)) continue;
            rowAmount.set(colIdx, value);
            TaxReportFormHelper.logInfo(String.format(ResManager.loadKDString((String)"\u5408\u8ba1\u884c%1$s\uff0c\u8868\u8fbe\u5f0f %2$s\uff0c \u503c\u4e3a%3$s\u3002", (String)"TaxReportFormHelper_0", (String)"fi-gl-common", (Object[])new Object[0]), key, vals, value));
        }
    }

    private static void buildCellTree(ManageItemCell cell, Map<String, ManageItemCell> cellAndItemMap) {
        Set<String> detailCellKeys = cell.getDetailCells();
        if (detailCellKeys == null || detailCellKeys.isEmpty()) {
            return;
        }
        for (String detailCellKey : detailCellKeys) {
            ManageItemCell detailCellObj = cellAndItemMap.get(detailCellKey);
            if (detailCellObj == null) continue;
            cell.addChildCellObj(detailCellObj);
            cellAndItemMap.remove(detailCellKey);
            TaxReportFormHelper.buildCellTree(detailCellObj, cellAndItemMap);
        }
    }

    private static List<String> sortByLevel(Map<String, ManageItemCell> cellAndItemMap) {
        HashSet<String> keys = new HashSet<String>(cellAndItemMap.keySet());
        for (String key : keys) {
            ManageItemCell cell = cellAndItemMap.get(key);
            if (cell == null) continue;
            TaxReportFormHelper.buildCellTree(cell, cellAndItemMap);
        }
        TaxReportFormHelper.logInfo(ResManager.loadKDString((String)"\u6784\u5efa\u5c42\u7ea7\u5173\u7cfb\u5b8c\u6210\uff0c\u6839\u636e\u5c42\u7ea7\u5173\u7cfb\u9010\u5c42\u8bfb\u53d6\u8282\u70b9\u3002", (String)"TaxReportFormHelper_1", (String)"fi-gl-common", (Object[])new Object[0]));
        ArrayList<String> totalRowCells = new ArrayList<String>();
        for (ManageItemCell cell : cellAndItemMap.values()) {
            TaxReportFormHelper.readItemsBySequence(cell, totalRowCells);
        }
        TaxReportFormHelper.logInfo(String.format(ResManager.loadKDString((String)"\u6392\u5e8f\u7ed3\u679c\uff1a%s\u3002", (String)"TaxReportFormHelper_2", (String)"fi-gl-common", (Object[])new Object[0]), ((Object)totalRowCells).toString()));
        return totalRowCells;
    }

    private static void readItemsBySequence(ManageItemCell cell, List<String> totalRowCells) {
        TaxReportFormHelper.logInfo(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u8ba1\u884c\u8282\u70b9\u52a0\u5165\u5230\u961f\u5217\uff1a%s\u3002", (String)"TaxReportFormHelper_3", (String)"fi-gl-common", (Object[])new Object[0]), cell.getKey()));
        totalRowCells.add(cell.getKey());
        Set<ManageItemCell> childCells = cell.getChildCellObjs();
        if (childCells == null || childCells.isEmpty()) {
            return;
        }
        for (ManageItemCell childCell : childCells) {
            TaxReportFormHelper.readItemsBySequence(childCell, totalRowCells);
        }
    }

    private static BigDecimal parseTotalRow(Map<String, List<BigDecimal>> resultList, Map<Long, Set<String>> itemIdAndCellMap, int colIdx, BigDecimal value, String val) {
        String[] split = val.split(",");
        if (split.length != 2) {
            return value;
        }
        Long rptItemId = Long.valueOf(split[0]);
        String sign = split[1];
        Set<String> detailCellRowIdx = itemIdAndCellMap.get(rptItemId);
        if (CollectionUtils.isEmpty(detailCellRowIdx)) {
            return value;
        }
        for (String detailRowId : detailCellRowIdx) {
            List<BigDecimal> rowAmount = resultList.get(detailRowId);
            if (rowAmount == null || colIdx >= rowAmount.size()) continue;
            BigDecimal amount = rowAmount.get(colIdx);
            if (sign.trim().equals("+")) {
                value = value.add(amount);
                continue;
            }
            value = value.subtract(amount);
        }
        return value;
    }

    private static void logInfo(String msg) {
        logger.info(msg);
    }

    private static Map<Long, Set<String>> queryItemAndCellMap(String type, String entityType, Set<Long> orgIds, long accTableId) {
        String orderby;
        HashMap<Long, Set<String>> itemIdAndCellMap = new HashMap<Long, Set<String>>();
        QFilter forg = new QFilter(org, "in", orgIds);
        QFilter faccTable = new QFilter(accTable, "=", (Object)accTableId);
        QFilter[] filters = new QFilter[]{forg, faccTable};
        String entityName = "";
        String selectFields = "";
        if ("balancesheet".equals(type)) {
            entityName = balancesheetEdit;
            selectFields = assetEntryKey.equals(entityType) ? BALANCE_Asset_FIELD : BALANCE_Equity_FIELD;
            orderby = assetEntryKey.equals(entityType) ? Default_BalSheet_Asset_OrderBys : Default_BalSheet_Equity_OrderBys;
        } else {
            entityName = incomeEdit;
            selectFields = INCOME_FIELD;
            orderby = "entryentity.balrowid asc";
        }
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"TaxReportFormHelper.queryItemAndCellMap", (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderby);){
            for (Row row : dSet) {
                String rowId = row.getString(dbRowid);
                Long project = 0L;
                project = "balancesheet".equals(type) ? (assetEntryKey.equals(entityType) ? row.getLong("asset") : row.getLong("equity")) : row.getLong("project");
                if (itemIdAndCellMap.containsKey(project)) {
                    ((Set)itemIdAndCellMap.get(project)).add(rowId);
                    continue;
                }
                HashSet<String> set = new HashSet<String>(1);
                set.add(rowId);
                itemIdAndCellMap.put(project, set);
            }
        }
        return itemIdAndCellMap;
    }

    private static Map<String, Map<String, BigDecimal>> getAccBalanceByType(String periodType, Set<Long> orgIds, long bookTypeId, long accTableId, long periodId, DynamicObjectCollection exps, String type, int amtprecision, Map<Long, String> taxProjects) {
        Map<String, Map<String, BigDecimal>> accBalance = new HashMap<String, Map<String, BigDecimal>>();
        long beginPeriodId = 0L;
        long endPeriodId = 0L;
        if ("period".equals(periodType)) {
            beginPeriodId = periodId;
            endPeriodId = periodId;
        } else if ("quarter".equals(periodType)) {
            // empty if block
        }
        if (periodId != 0L) {
            accBalance = TaxReportFormHelper.getAccBalance(orgIds, bookTypeId, accTableId, beginPeriodId, endPeriodId, exps, type, amtprecision, taxProjects);
        }
        return accBalance;
    }

    private static Map<String, Map<String, BigDecimal>> getAccBalance(Set<Long> orgIds, long bookTypeId, long accTableId, long beginPeriodId, long endPeriodId, DynamicObjectCollection exps, String type, int amtprecision, Map<Long, String> taxProjects) {
        HashMap<String, Map<String, BigDecimal>> map = new HashMap<String, Map<String, BigDecimal>>(exps.size());
        Tuple<Set<Long>, Set<String>> normalAccts = new Tuple<Set<Long>, Set<String>>(new HashSet(exps.size()), new HashSet(exps.size()));
        Tuple<Set<Long>, Set<String>> curPeriodPlAccts = new Tuple<Set<Long>, Set<String>>(new HashSet(exps.size()), new HashSet(exps.size()));
        Tuple<Set<Long>, Set<String>> lastSamePeriodPlAccts = new Tuple<Set<Long>, Set<String>>(new HashSet(exps.size()), new HashSet(exps.size()));
        Tuple<Set<Long>, Set<String>> lastYearPlAccts = new Tuple<Set<Long>, Set<String>>(new HashSet(exps.size()), new HashSet(exps.size()));
        boolean isBalanceSheet = "balancesheet".equals(type);
        if (!isBalanceSheet) {
            for (DynamicObject exp : exps) {
                TaxReportFetchrule fetchrule;
                String fetchRuleVal = exp.getString(FETCHRULE);
                Long itemId = exp.getLong(ITEMID);
                if (!CollectionUtils.isEmpty(taxProjects)) {
                    fetchRuleVal = taxProjects.get(itemId);
                }
                if (StringUtils.isEmpty((CharSequence)fetchRuleVal) || (fetchrule = TaxReportFetchrule.getValue(fetchRuleVal)) == null) continue;
                long acctid = exp.getLong(MASTERID);
                String acctNumber = exp.getString(NUMBER);
                if (fetchrule.isCurPL()) {
                    ((Set)curPeriodPlAccts.item1).add(acctid);
                    ((Set)curPeriodPlAccts.item2).add(acctNumber);
                    continue;
                }
                if (fetchrule.isLastSamePeriodPL()) {
                    ((Set)lastSamePeriodPlAccts.item1).add(acctid);
                    ((Set)lastSamePeriodPlAccts.item2).add(acctNumber);
                    continue;
                }
                if (fetchrule.isLastYearPL()) {
                    ((Set)lastYearPlAccts.item1).add(acctid);
                    ((Set)lastYearPlAccts.item2).add(acctNumber);
                    continue;
                }
                ((Set)normalAccts.item1).add(acctid);
                ((Set)normalAccts.item2).add(acctNumber);
            }
        } else {
            for (DynamicObject exp : exps) {
                Long itemId = exp.getLong(ITEMID);
                if (!CollectionUtils.isEmpty(taxProjects)) {
                    if (!taxProjects.containsKey(itemId)) continue;
                    ((Set)normalAccts.item1).add(exp.getLong(MASTERID));
                    ((Set)normalAccts.item2).add(exp.getString(NUMBER));
                    continue;
                }
                ((Set)normalAccts.item1).add(exp.getLong(MASTERID));
                ((Set)normalAccts.item2).add(exp.getString(NUMBER));
            }
        }
        long begin = System.currentTimeMillis();
        TaxReportFormHelper.getAcctIdByMasterId(normalAccts, orgIds, accTableId);
        TaxReportFormHelper.getAcctIdByMasterId(curPeriodPlAccts, orgIds, accTableId);
        TaxReportFormHelper.getAcctIdByMasterId(lastSamePeriodPlAccts, orgIds, accTableId);
        TaxReportFormHelper.getAcctIdByMasterId(lastYearPlAccts, orgIds, accTableId);
        long end = System.currentTimeMillis();
        logger.info("TaxReportFormHelper query acct cost : " + (end - begin));
        if (DebugTrace.enable()) {
            logger.info("balancesheet getAccBalance orgIds : " + orgIds.toString() + ", beginPeriodId : " + beginPeriodId + ", normalAccts :" + normalAccts.toString() + ", curPeriodPlAccts : " + curPeriodPlAccts.toString() + ", lastSamePeriodPlAccts : " + lastSamePeriodPlAccts.toString() + ", lastYearPlAccts : " + lastYearPlAccts.toString());
        }
        if (!((Set)normalAccts.item1).isEmpty()) {
            TaxReportFormHelper.getBalance(orgIds, bookTypeId, accTableId, beginPeriodId, endPeriodId, (Set)normalAccts.item1, Boolean.FALSE, map, isBalanceSheet, Boolean.FALSE, Boolean.FALSE, amtprecision);
            if (DebugTrace.enable()) {
                logger.info("balancesheet getAccBalance normalAccts map : " + ((Object)map).toString());
            }
        }
        begin = System.currentTimeMillis();
        logger.info("TaxReportFormHelper query normalAcctsBalance cost : " + (begin - end));
        if (!((Set)curPeriodPlAccts.item1).isEmpty()) {
            TaxReportFormHelper.getBalance(orgIds, bookTypeId, accTableId, beginPeriodId, endPeriodId, (Set)curPeriodPlAccts.item1, Boolean.TRUE, map, isBalanceSheet, Boolean.FALSE, Boolean.FALSE, amtprecision);
            if (DebugTrace.enable()) {
                logger.info("balancesheet getAccBalance curPeriodPlAccts map : " + ((Object)map).toString());
            }
        }
        end = System.currentTimeMillis();
        logger.info("TaxReportFormHelper query curPeriodPlAcctsBalance cost : " + (end - begin));
        if (!((Set)lastSamePeriodPlAccts.item1).isEmpty()) {
            long previousYearSamePeriod = GLUtil.getPreviousYearSamePeriod(beginPeriodId);
            if (previousYearSamePeriod > 0L) {
                TaxReportFormHelper.getBalance(orgIds, bookTypeId, accTableId, previousYearSamePeriod, previousYearSamePeriod, (Set)lastSamePeriodPlAccts.item1, Boolean.TRUE, map, isBalanceSheet, Boolean.TRUE, Boolean.TRUE, amtprecision);
            }
            if (DebugTrace.enable()) {
                logger.info("balancesheet getAccBalance lastSamePeriodPlAccts map : " + ((Object)map).toString());
            }
        }
        begin = System.currentTimeMillis();
        logger.info("TaxReportFormHelper query lastSamePeriodPlAcctsBalance cost : " + (begin - end));
        if (!((Set)lastYearPlAccts.item1).isEmpty()) {
            DynamicObject previousYearLastPeriod = GLUtil.getPreviousYearLastPeriod(beginPeriodId);
            if (previousYearLastPeriod != null) {
                long periodid = previousYearLastPeriod.getLong("id");
                TaxReportFormHelper.getBalance(orgIds, bookTypeId, accTableId, periodid, periodid, (Set)lastYearPlAccts.item1, Boolean.TRUE, map, isBalanceSheet, Boolean.FALSE, Boolean.TRUE, amtprecision);
            }
            if (DebugTrace.enable()) {
                logger.info("balancesheet getAccBalance lastYearPlAccts map : " + ((Object)map).toString());
            }
        }
        end = System.currentTimeMillis();
        logger.info("TaxReportFormHelper query lastYearPlAcctsBalance cost : " + (end - begin));
        return map;
    }

    private static void getAcctIdByMasterId(Tuple<Set<Long>, Set<String>> accts, Set<Long> orgIds, long accTableId) {
        HashSet<Long> normalAccts = (HashSet<Long>)accts.item1;
        if (CollectionUtils.isEmpty((Collection)normalAccts) || CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(new QFilter(NUMBER, "in", accts.item2));
        try (DataSet dataSet = AccountUtils.queryAccountDataSet(orgIds, (long)accTableId, (String)"id,masterid", filters, null);){
            for (Row row : dataSet) {
                normalAccts.add(row.getLong("id"));
                normalAccts.add(row.getLong(MASTERID));
            }
        }
        HashSet<Long> acctIds = new HashSet<Long>(normalAccts.size());
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT a.fid id FROM T_BD_ACCOUNT AS a LEFT JOIN T_BD_ACCOUNT_U AS u ON u.fdataid = a.fid WHERE", new Object[0]);
        sql.appendIn(" a.fmasterid", new ArrayList(normalAccts));
        sql.append(" AND", new Object[0]).appendIn(" u.fuseorgid", new ArrayList<Long>(orgIds));
        sql.append(" UNION ", new Object[0]).append("SELECT c.fid id FROM T_BD_ACCOUNT as c where c.fctrlstrategy='5'", new Object[0]);
        sql.append(" AND", new Object[0]).appendIn(" c.fmasterid", new ArrayList(normalAccts));
        try (DataSet ds = DB.queryDataSet((String)"kd.fi.gl.util.TaxReportFormHelper", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : ds) {
                acctIds.add(row.getLong("id"));
            }
        }
        normalAccts = acctIds;
    }

    private static void getBalance(Set<Long> orgIds, long booktypeid, long accounttableid, long beginPeriod, long endperiod, Set<Long> accountids, boolean ispl, Map<String, Map<String, BigDecimal>> valMap, boolean isBalanceSheet, boolean isLastSamePeriod, boolean isLastYear, int amtprecision) {
        String selector = "beginlocal,endlocal,debitlocal,creditlocal,yeardebitlocal,yearcreditlocal,account.dc dc,account.masterid masterid,account.number number";
        QueryParam param = new QueryParam();
        QFilter accountFilter = new QFilter("id", "in", accountids);
        param.setAccountFilter(accountFilter);
        param.setSpecialAccount(Boolean.TRUE.booleanValue());
        param.setSubstractPL(ispl);
        DataSet balanceDs = BalanceQueryExecutor.getInstance().getBalance(selector, orgIds.toArray(new Long[orgIds.size()]), booktypeid, accounttableid, beginPeriod, endperiod, param);
        if (balanceDs != null) {
            GroupbyDataSet groupbyDataSet = balanceDs.groupBy(new String[]{"dc", NUMBER});
            for (String sumField : sumFields) {
                groupbyDataSet.sum(sumField);
            }
            try (DataSet ds = groupbyDataSet.finish();){
                for (Row row : ds) {
                    logger.info("balancesheet getBalance  masterid: " + row.getString(NUMBER) + ",beginlocal" + row.getBigDecimal("beginlocal") + ",beginlocal" + row.getBigDecimal("beginlocal") + ",endlocal" + row.getBigDecimal("endlocal") + ",debitlocal" + row.getBigDecimal("debitlocal") + ",creditlocal" + row.getBigDecimal("creditlocal") + ",yeardebitlocal" + row.getBigDecimal("yeardebitlocal") + ",yearcreditlocal" + row.getBigDecimal("yearcreditlocal"));
                    TaxReportFormHelper.handelRow(row, valMap, ispl, isBalanceSheet, isLastSamePeriod, isLastYear, amtprecision);
                }
            }
        }
    }

    private static void handelRow(Row row, Map<String, Map<String, BigDecimal>> valMap, boolean ispl, boolean isBalanceSheet, boolean isLastSamePeriod, boolean isLastYear, int amtprecision) {
        Map<String, BigDecimal> typeToAmount;
        String key = row.getString(NUMBER);
        BigDecimal dcVal = new BigDecimal(row.getString("dc"));
        BigDecimal debitlocal = row.getBigDecimal("debitlocal");
        BigDecimal creditlocal = row.getBigDecimal("creditlocal");
        BigDecimal yearDebitLocal = row.getBigDecimal("yeardebitlocal");
        BigDecimal yearCreditLocal = row.getBigDecimal("yearcreditlocal");
        if (ispl) {
            typeToAmount = valMap.get(key);
            if (typeToAmount == null) {
                typeToAmount = new HashMap<String, BigDecimal>(4);
            }
            if (isLastYear) {
                if (isLastSamePeriod) {
                    typeToAmount.put(TaxReportFetchrule.LASTSAMEPERIODDEBIT.getType(), debitlocal);
                    typeToAmount.put(TaxReportFetchrule.LASTSAMEPERIODCREDIT.getType(), creditlocal);
                    typeToAmount.put(TaxReportFetchrule.LASTSAMEPERIODYDEBIT.getType(), yearDebitLocal);
                    typeToAmount.put(TaxReportFetchrule.LASTSAMEPERIODYCREDIT.getType(), yearCreditLocal);
                } else {
                    typeToAmount.put(TaxReportFetchrule.LASTYEARDEBITLOCAL.getType(), yearDebitLocal);
                    typeToAmount.put(TaxReportFetchrule.LASTYEARCREDITLOCAL.getType(), yearCreditLocal);
                }
            } else {
                typeToAmount.put(TaxReportFetchrule.PLDEBITLOCAL.getType(), debitlocal);
                typeToAmount.put(TaxReportFetchrule.PLCREDITLOCAL.getType(), creditlocal);
                typeToAmount.put(TaxReportFetchrule.YEARPLDEBITLOCAL.getType(), yearDebitLocal);
                typeToAmount.put(TaxReportFetchrule.YEARPLCREDITLOCAL.getType(), yearCreditLocal);
            }
        } else {
            typeToAmount = new HashMap<String, BigDecimal>(7);
            BigDecimal beginlocal = row.getBigDecimal("beginlocal").multiply(dcVal);
            BigDecimal endLocal = row.getBigDecimal("endlocal").multiply(dcVal);
            BigDecimal yearbeginlocal = endLocal.subtract(yearDebitLocal.subtract(yearCreditLocal).multiply(dcVal));
            typeToAmount.put(TaxReportFetchrule.BEGINLOCAL.getType(), beginlocal);
            typeToAmount.put(TaxReportFetchrule.ENDLOCAL.getType(), endLocal);
            typeToAmount.put(TaxReportFetchrule.DEBITLOCAL.getType(), debitlocal);
            typeToAmount.put(TaxReportFetchrule.CREDITLOCAL.getType(), creditlocal);
            typeToAmount.put(TaxReportFetchrule.YEARDEBITLOCAL.getType(), yearDebitLocal);
            typeToAmount.put(TaxReportFetchrule.YEARCREDITLOCAL.getType(), yearCreditLocal);
            if (isBalanceSheet) {
                typeToAmount.put(TaxReportFetchrule.YEARBEGINLOCAL.getType(), yearbeginlocal);
            } else {
                typeToAmount.put(TaxReportFetchrule.YEARBEGINLOCALX.getType(), yearbeginlocal);
            }
        }
        valMap.put(key, typeToAmount);
    }

    private static BigDecimal parseExp(List<String> expList, Map<String, Map<String, BigDecimal>> accBalance) {
        BigDecimal value = BigDecimal.ZERO;
        for (String exp : expList) {
            Map<String, BigDecimal> map;
            String[] split = exp.split(",");
            if (split.length != 3) continue;
            String accNumber = split[0];
            String sign = split[1];
            String fetchRuleStr = split[2];
            if (StringUtils.isBlank((CharSequence)fetchRuleStr) || (map = accBalance.get(accNumber)) == null || map.get(fetchRuleStr) == null) continue;
            if (sign.trim().equals("+")) {
                value = value.add(map.get(fetchRuleStr));
                continue;
            }
            value = value.subtract(map.get(fetchRuleStr));
        }
        return value;
    }

    public static int getPercentValue(BigDecimal num, BigDecimal denom) {
        int val = BigDecimal.ZERO.compareTo(denom) == 0 ? 0 : (int)Math.rint(num.multiply(BigDecimal.valueOf(100L)).divide(denom, 4).setScale(0, 4).doubleValue());
        return val;
    }

    public static FormShowParameter FinMainIndexFormShow(String tag, Set<Long> childOrgSet, List<Long> orgIds, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, Map<String, List<String>> map, int amtprecision) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("gl_financialindex");
        para.getOpenStyle().setTargetKey("finanindex");
        para.getOpenStyle().setShowType(ShowType.InContainer);
        para.setCustomParam("tag", (Object)tag);
        para.setCustomParam("childOrgSet", (Object)GLUtil.toSerializedString(childOrgSet));
        para.setCustomParam("orgs", (Object)GLUtil.toSerializedString(orgIds));
        para.setCustomParam("orgView", (Object)orgViewId.toString());
        para.setCustomParam("bookType", (Object)bookTypeId.toString());
        para.setCustomParam("accTable", (Object)accTableId.toString());
        para.setCustomParam("periodType", (Object)periodTypeId.toString());
        para.setCustomParam("period", (Object)periodId.toString());
        para.setCustomParam("amtprecision", (Object)(amtprecision + ""));
        para.setCustomParam("map", map);
        return para;
    }

    public static List<Long> getProjects(String type) {
        ArrayList<Long> ids;
        block4: {
            block5: {
                block3: {
                    ids = new ArrayList<Long>();
                    if (!"income".equals(type)) break block3;
                    for (long i = 100101L; i <= 100137L; ++i) {
                        ids.add(i);
                    }
                    break block4;
                }
                if (!"cashflow".equals(type)) break block5;
                for (long i = 100201L; i <= 100267L; ++i) {
                    ids.add(i);
                }
                break block4;
            }
            if (!"taxshow".equals(type)) break block4;
            for (long i = 100301L; i <= 100351L; ++i) {
                ids.add(i);
            }
        }
        return ids;
    }

    public static long getCurPeriod(long orgId, long bookType) {
        AccountBookInfo bookDyn = AccSysUtil.getBookFromAccSys(orgId, bookType);
        if (bookDyn == null) {
            return -1L;
        }
        long curPeriod = bookDyn.getCurPeriodId();
        if (curPeriod == 0L) {
            return -2L;
        }
        return curPeriod;
    }

    public static long getDefaultPeriod(long orgId, long bookTypeId, Map<String, Object> value) {
        long curPeriod = 0L;
        AccountBookInfo bookDyn = AccSysUtil.getBookFromAccSys(orgId, bookTypeId);
        if (bookDyn == null) {
            return -1L;
        }
        long periodTypeId = bookDyn.getPeriodTypeId();
        if (value != null && value.get("periodDate") != null && value.get("periodDate") instanceof Date) {
            DynamicObject curDyn = GLUtil.getPeriodByDate((Date)value.get("periodDate"), periodTypeId);
            curPeriod = curDyn.getLong("id");
        } else {
            curPeriod = bookDyn.getCurPeriodId();
        }
        return curPeriod;
    }

    public static Set<Long> getOrgView(Long orgId) {
        Set<Long> mainViewIds = AccSysUtil.getViewByOrg(orgId);
        return mainViewIds;
    }

    public static void getBookTypeAndChildLeafOrg(long orgId, long orgViewId, String entityId, Set<Long> bookTypes, Set<Long> childOrgSet) {
        HashSet<Long> orgParent = new HashSet<Long>();
        orgParent.add(orgId);
        Set<Long> childOrgIds = AccSysUtil.getChildOrgId("10", orgViewId, orgParent, true);
        List<Long> permOrgList = AccSysUtil.getAcctOrgPkList(entityId, true, PermissonType.VIEW);
        childOrgSet.addAll(childOrgIds);
        childOrgSet.retainAll(permOrgList);
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        Map<Long, List<Long>> orgBTMap = viewOrgBTMap.get(orgViewId);
        if (orgBTMap != null) {
            childOrgSet.retainAll(orgBTMap.keySet());
            for (Map.Entry<Long, List<Long>> entry : orgBTMap.entrySet()) {
                if (!childOrgSet.contains(entry.getKey())) continue;
                bookTypes.addAll((Collection<Long>)entry.getValue());
            }
        }
    }

    public static List<List<BigDecimal>> collectBal(List<Long> orgIds, Set<Long> childOrgSet, long orgViewId, long bookTypeId, long accTableId, long periodTypeId, long periodId, String type, int columnCount, int amtprecision) {
        return TaxReportFormHelper.collectBal(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, type, null, amtprecision, true);
    }

    public static List<List<BigDecimal>> collectBal(List<Long> orgIds, Set<Long> childOrgSet, long orgViewId, long bookTypeId, long accTableId, long periodTypeId, long periodId, String type, String entityType, int amtprecision, boolean isCalTotalRow) {
        if (orgIds.size() == 1) {
            return TaxReportFormHelper.collectOrgBal(orgIds.get(0), childOrgSet, bookTypeId, accTableId, periodId, type, entityType, amtprecision, isCalTotalRow, null);
        }
        TaxReportParam taxRptParam = new TaxReportParam();
        taxRptParam.setType(type);
        long parentOrg = AccSysUtil.getParentOrgByChildre(orgIds);
        taxRptParam.setParentOrg(parentOrg);
        taxRptParam.setAccTableId(accTableId);
        taxRptParam.setBookTypeId(bookTypeId);
        taxRptParam.setAmtprecision(amtprecision);
        taxRptParam.setChildOrgSet(childOrgSet);
        taxRptParam.setOrgViewId(orgViewId);
        taxRptParam.setPeriodId(periodId);
        taxRptParam.setPeriodTypeId(periodTypeId);
        taxRptParam.setEntityType(entityType);
        if (assetEntryKey.equals(entityType)) {
            taxRptParam.setSelectField(Default_BalSheet_Asset_Query_Fields);
            taxRptParam.setOrderBys(Default_BalSheet_Asset_OrderBys);
        } else if (equityEntryKey.equals(entityType)) {
            taxRptParam.setSelectField(Default_BalSheet_Equity_Query_Fields);
            taxRptParam.setOrderBys(Default_BalSheet_Equity_OrderBys);
        }
        return TaxReportFormHelper.collectMultOrgBal(taxRptParam);
    }

    public static Map<Long, List<BigDecimal>> collectBal(List<Long> orgIds, Set<Long> childOrgSet, long orgViewId, long bookTypeId, long accTableId, long periodType, long periodId, String type, String entityType, int amtprecision, boolean isCalTotalRow, Map<Long, String> taxProjects) {
        HashMap<Long, List<BigDecimal>> resultMap;
        block5: {
            resultMap = new HashMap<Long, List<BigDecimal>>(16);
            if (orgIds.size() != 1) break block5;
            Long orgId = orgIds.get(0);
            HashSet<Long> orgIdSet = new HashSet<Long>(1);
            orgIdSet.add(orgId);
            if ("balancesheet".equals(type)) {
                DynamicObjectCollection assetCollection = TaxReportFormHelper.getBalSheetsByEntityType(new HashSet<Long>(orgIds), accTableId, new QFilter("booktype", "=", (Object)bookTypeId).toArray(), Default_BalSheet_Asset_Query_Fields, Default_BalSheet_Asset_OrderBys);
                List<List<BigDecimal>> assetResultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodType, periodId, "balancesheet", assetEntryKey, 4, true);
                for (int i = 0; i < assetCollection.size(); ++i) {
                    Long itemId = TaxReportFormHelper.getItemIdByEntityType(type, (DynamicObject)assetCollection.get(i), assetEntryKey);
                    resultMap.put(itemId, assetResultList.get(i));
                }
                DynamicObjectCollection equityCollection = TaxReportFormHelper.getBalSheetsByEntityType(new HashSet<Long>(orgIds), accTableId, new QFilter("booktype", "=", (Object)bookTypeId).toArray(), Default_BalSheet_Equity_Query_Fields, Default_BalSheet_Equity_OrderBys);
                List<List<BigDecimal>> equityResultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, orgViewId, bookTypeId, accTableId, periodType, periodId, "balancesheet", equityEntryKey, 4, true);
                for (int i = 0; i < equityCollection.size(); ++i) {
                    Long itemId = TaxReportFormHelper.getItemIdByEntityType(type, (DynamicObject)equityCollection.get(i), equityEntryKey);
                    resultMap.put(itemId, equityResultList.get(i));
                }
            } else {
                List<List<BigDecimal>> amountList = TaxReportFormHelper.collectOrgBal(orgId, childOrgSet, bookTypeId, accTableId, periodId, type, entityType, amtprecision, isCalTotalRow, taxProjects);
                DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdit(orgIdSet, accTableId, type, new QFilter("booktype", "=", (Object)bookTypeId).toArray());
                for (int i = 0; i < collection.size(); ++i) {
                    Long itemId = TaxReportFormHelper.getItemId(type, (DynamicObject)collection.get(i), 0);
                    resultMap.put(itemId, amountList.get(i));
                }
            }
        }
        return resultMap;
    }

    private static List<List<BigDecimal>> collectOrgBal(Long orgId, Set<Long> childOrgSet, long bookTypeId, long accTableId, long periodId, String type, String entityType, int amtprecision, boolean isCalTotalRow, Map<Long, String> taxProjects) {
        DynamicObjectCollection expCollection;
        DynamicObjectCollection collection;
        HashSet<Long> orgIds = new HashSet<Long>();
        orgIds.add(orgId);
        if ("balancesheet".equals(type)) {
            collection = assetEntryKey.equals(entityType) ? TaxReportFormHelper.getBalSheetsByEntityType(orgIds, accTableId, new QFilter("booktype", "=", (Object)bookTypeId).toArray(), Default_BalSheet_Asset_Query_Fields, Default_BalSheet_Asset_OrderBys) : TaxReportFormHelper.getBalSheetsByEntityType(orgIds, accTableId, new QFilter("booktype", "=", (Object)bookTypeId).toArray(), Default_BalSheet_Equity_Query_Fields, Default_BalSheet_Equity_OrderBys);
            expCollection = TaxReportFormHelper.getBalSheetExps(orgIds, accTableId, bookTypeId);
        } else {
            collection = TaxReportFormHelper.getIncomeEdit(orgIds, accTableId, type, new QFilter("booktype", "=", (Object)bookTypeId).toArray());
            expCollection = TaxReportFormHelper.getIncomeExps(orgIds, accTableId, bookTypeId, type);
        }
        List<List<BigDecimal>> resultList = "balancesheet".equals(type) ? TaxReportFormHelper.getBalSheetExpValue(collection, expCollection, orgIds, childOrgSet, bookTypeId, accTableId, periodId, type, entityType, amtprecision, isCalTotalRow, taxProjects) : TaxReportFormHelper.getIncomeExpValue(collection, expCollection, orgIds, childOrgSet, bookTypeId, accTableId, periodId, type, amtprecision, isCalTotalRow, taxProjects);
        return resultList;
    }

    public static String parseExpRow(String exp, String number, String name, String fetchName, String sign) {
        exp = StringUtils.isBlank((CharSequence)exp) ? ("-".equals(sign) ? sign + number + " " + name + "(" + fetchName + ") " : number + " " + name + "(" + fetchName + ") ") : exp + sign + number + " " + name + "(" + fetchName + ") ";
        return exp;
    }

    public static String parseExpTotalRow(String exp, String name, String sign) {
        exp = StringUtils.isBlank((CharSequence)exp) ? ("-".equals(sign) ? sign + " " + name + " " : " " + name + " ") : exp + sign + " " + name + " ";
        return exp;
    }

    public static DynamicObject copyBalanceSheetEditDyn(DynamicObject balanceDyn) {
        DynamicObject newBalanceExpDyn = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)balancesheetEdit));
        ArrayList<String> headFields = new ArrayList<String>();
        headFields.add(accTable);
        headFields.add("booktype");
        ArrayList<String> entryFields = new ArrayList<String>();
        entryFields.add("assetrowid");
        entryFields.add("asset");
        entryFields.add("assetbegin");
        entryFields.add("assetclose");
        entryFields.add(seq);
        TaxReportFormHelper.copyDyn(newBalanceExpDyn, balanceDyn, headFields, entryFields, assetEntryKey);
        headFields.clear();
        entryFields.clear();
        entryFields.add("equityrowid");
        entryFields.add("equity");
        entryFields.add("equitybegin");
        entryFields.add("equityclose");
        entryFields.add(seq);
        TaxReportFormHelper.copyDyn(newBalanceExpDyn, balanceDyn, headFields, entryFields, equityEntryKey);
        return newBalanceExpDyn;
    }

    public static DynamicObject copyIncomeDyn(DynamicObject incomeEditDyn) {
        DynamicObject newBalanceExpDyn = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)incomeEdit));
        ArrayList<String> headFields = new ArrayList<String>();
        headFields.add(accTable);
        headFields.add("booktype");
        headFields.add("type");
        ArrayList<String> entryFields = new ArrayList<String>();
        entryFields.add("index");
        entryFields.add("project");
        entryFields.add(balrowId);
        entryFields.add("rowid");
        entryFields.add(seq);
        TaxReportFormHelper.copyDyn(newBalanceExpDyn, incomeEditDyn, headFields, entryFields, entryEntity);
        return newBalanceExpDyn;
    }

    public static DynamicObject copyBalanceSheetExpDyn(DynamicObject balanceExpDyn) {
        DynamicObject newBalanceExpDyn = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)balanceExpressionFormId));
        ArrayList<String> headFields = new ArrayList<String>();
        headFields.add(accTable);
        headFields.add("booktype");
        headFields.add(balrowId);
        headFields.add(columnKey);
        headFields.add(accTable);
        headFields.add(ISTOTALROW);
        headFields.add(rowtag);
        ArrayList<String> entryFields = new ArrayList<String>();
        entryFields.add("project");
        entryFields.add(SIGN);
        entryFields.add(FETCHRULE);
        entryFields.add(RPTITEM);
        TaxReportFormHelper.copyDyn(newBalanceExpDyn, balanceExpDyn, headFields, entryFields, entryEntity);
        return newBalanceExpDyn;
    }

    public static DynamicObject copyIncomeExpDyn(DynamicObject incomeExpDyn) {
        DynamicObject newBalanceExpDyn = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)incomExpressionFormId));
        ArrayList<String> headFields = new ArrayList<String>();
        headFields.add(accTable);
        headFields.add("booktype");
        headFields.add(balrowId);
        headFields.add(columnKey);
        headFields.add(accTable);
        headFields.add("type");
        headFields.add(ISTOTALROW);
        headFields.add(rowtag);
        ArrayList<String> entryFields = new ArrayList<String>();
        entryFields.add("project");
        entryFields.add(SIGN);
        entryFields.add(FETCHRULE);
        entryFields.add(RPTITEM);
        TaxReportFormHelper.copyDyn(newBalanceExpDyn, incomeExpDyn, headFields, entryFields, entryEntity);
        return newBalanceExpDyn;
    }

    public static void copyDyn(DynamicObject newBalanceExpDyn, DynamicObject oldExpDyn, List<String> headFields, List<String> entryFields, String entryEntity) {
        for (String field : headFields) {
            newBalanceExpDyn.set(field, oldExpDyn.get(field));
        }
        DynamicObjectCollection entryColl = oldExpDyn.getDynamicObjectCollection(entryEntity);
        DynamicObjectType rowType = entryColl.getDynamicObjectType();
        DynamicObjectCollection newColl = newBalanceExpDyn.getDynamicObjectCollection(entryEntity);
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject rowDyn = new DynamicObject(rowType);
            DynamicObject oldRowDyn = (DynamicObject)entryColl.get(i);
            for (String entryField : entryFields) {
                rowDyn.set(entryField, oldRowDyn.get(entryField));
            }
            newColl.add((Object)rowDyn);
        }
    }

    public static void filterTaxProject(long orgId, ListShowParameter param, String taxType) {
        if (param != null) {
            List filters = param.getListFilterParameter().getQFilters();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("balancesheet", "gl_balancesheet");
            map.put("income", "gl_showincome");
            map.put("cashflow", "gl_cashflowstat");
            map.put("taxshow", "gl_taxshow");
            if (map.get(taxType) != null) {
                String taxTypeVal = (String)map.get(taxType);
                QFilter filter = new QFilter("rptunit", "=", (Object)taxTypeVal);
                filters.add(filter);
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_manage_rptitem", (Long)orgId);
                filters.add(orgFilter);
                param.setCustomParam("useorg", (Object)orgId);
            }
        }
    }

    public static Map<Integer, List<BigDecimal>> getIncomeIndexAmount(List<List<BigDecimal>> list) {
        HashMap<Integer, List<BigDecimal>> resultMap = new HashMap<Integer, List<BigDecimal>>();
        if (list == null || list.isEmpty()) {
            return resultMap;
        }
        int position = 16;
        String exp = "1,-2,-3,-4,-5,-6,-7,10,11,13,-14,15";
        List<BigDecimal> workProfit = TaxReportFormHelper.getSum(list, exp);
        resultMap.put(position, workProfit);
        position = 19;
        exp = "1,-2,-3,-4,-5,-6,-7,10,11,13,-14,15,17,-18";
        List<BigDecimal> totalProfit = TaxReportFormHelper.getSum(list, exp);
        resultMap.put(position, totalProfit);
        position = 21;
        ArrayList<BigDecimal> netProfit = new ArrayList<BigDecimal>();
        netProfit.add(totalProfit.get(0).subtract(list.get(19).get(0)));
        netProfit.add(totalProfit.get(1).subtract(list.get(19).get(1)));
        resultMap.put(position, netProfit);
        position = 25;
        exp = "26,27";
        List<BigDecimal> unclassifiable = TaxReportFormHelper.getSum(list, exp);
        resultMap.put(position, unclassifiable);
        position = 28;
        exp = "29,30,31,32,33";
        List<BigDecimal> classifiable = TaxReportFormHelper.getSum(list, exp);
        resultMap.put(position, classifiable);
        position = 24;
        exp = "26,27,29,30,31,32,33";
        List<BigDecimal> otherNetProfit = TaxReportFormHelper.getSum(list, exp);
        resultMap.put(position, otherNetProfit);
        position = 34;
        ArrayList<BigDecimal> all = new ArrayList<BigDecimal>();
        all.add(((BigDecimal)netProfit.get(0)).add(otherNetProfit.get(0)));
        all.add(((BigDecimal)netProfit.get(1)).add(otherNetProfit.get(1)));
        resultMap.put(position, all);
        position = 35;
        exp = "36,37";
        List<BigDecimal> pro = TaxReportFormHelper.getSum(list, exp);
        resultMap.put(position, pro);
        return resultMap;
    }

    public static List<BigDecimal> getSum(List<List<BigDecimal>> list, String exp) {
        String[] split;
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
        BigDecimal current = BigDecimal.ZERO;
        BigDecimal year = BigDecimal.ZERO;
        for (String index : split = exp.split(",")) {
            int num = Integer.parseInt(index);
            if (num >= 0) {
                current = current.add(list.get(num - 1).get(0));
                year = year.add(list.get(num - 1).get(1));
                continue;
            }
            current = current.subtract(list.get(-1 - num).get(0));
            year = year.subtract(list.get(-1 - num).get(1));
        }
        result.add(current);
        result.add(year);
        return result;
    }

    private static List<List<BigDecimal>> collectMultOrgBal(TaxReportParam param) {
        ITaxReportDataHandler taxReportDataHandler = TaxReportFormHelper.geTaxReportDataHandler(param.getType());
        return taxReportDataHandler.handle(param);
    }

    private static ITaxReportDataHandler geTaxReportDataHandler(String type) {
        if ("balancesheet".equals(type)) {
            return new BalanceSheetDataHandler();
        }
        if ("income".equals(type)) {
            return new IncomeDataHandler();
        }
        if ("taxshow".equals(type)) {
            return new TaxDataHandler();
        }
        return new CashFLowDataHandler();
    }

    public static Long getParentOrg(List<Long> orgIds) {
        if (orgIds.size() == 1) {
            return orgIds.get(0);
        }
        return AccSysUtil.getParentOrgByChildre(orgIds);
    }

    public static Map<Long, List<List<BigDecimal>>> getReportItemCalcValues(GLReportQueryParams reportQueryParam) {
        if (reportQueryParam == null || StringUtils.isEmpty((CharSequence)reportQueryParam.getReportTypeCode()) || reportQueryParam.getOrgIds() == null || reportQueryParam.getOrgIds().isEmpty()) {
            return null;
        }
        HashMap<Long, List<List<BigDecimal>>> rptItemValues = new HashMap<Long, List<List<BigDecimal>>>();
        String reportTypeCode = reportQueryParam.getReportTypeCode();
        HashSet<Long> orgIds = new HashSet<Long>(reportQueryParam.getOrgIds());
        Set<Long> childOrgSet = reportQueryParam.getChildOrgSet();
        Long acctTableId = reportQueryParam.getAcctTableId();
        Long acctBookTypeId = reportQueryParam.getAcctBookTypeId();
        Collection<Long> periodIds = reportQueryParam.getPeriodIds();
        Integer amtPrecision = reportQueryParam.getAmtPrecision();
        if (orgIds.size() == 1) {
            DynamicObjectCollection rptItemExpressions;
            DynamicObjectCollection rptItems;
            QFilter acctBookTypeFilter = new QFilter("booktype", "=", (Object)acctBookTypeId);
            if ("balancesheet".equals(reportTypeCode)) {
                rptItems = TaxReportFormHelper.getBalSheets(orgIds, acctTableId, acctBookTypeFilter.toArray(), "org.id orgid, assetentryentity.seq balrowid, accounttable, booktype,  assetentryentity.asset asset, assetentryentity.asset.masterid assetmasterid, equityentryentity.equity equity, equityentryentity.equity.masterid equitymasterid, assetentryentity.seq seq, entryentity.asset.number assetnumber, entryentity.equity.number equitynumber");
                rptItemExpressions = TaxReportFormHelper.getBalSheetExps(orgIds, acctTableId, acctBookTypeId);
            } else {
                rptItems = TaxReportFormHelper.getIncomeEdits(orgIds, acctTableId, reportTypeCode, acctBookTypeFilter.toArray(), "org.id orgid, entryentity.project project, entryentity.project.masterid projectmasterid, entryentity.balrowid balrowid,entryentity.rowid dbRowid,entryentity.seq seq, entryentity.project.number projectnumber");
                rptItemExpressions = TaxReportFormHelper.getIncomeExps(orgIds, acctTableId, acctBookTypeId, reportTypeCode);
            }
            reportQueryParam.setRptItems(rptItems);
            reportQueryParam.setRptItemExpressions(rptItemExpressions);
            for (Long periodId : periodIds) {
                List<List<BigDecimal>> rptItemValueBufList = TaxReportFormHelper.getBalSheetExpValue(rptItems, rptItemExpressions, orgIds, childOrgSet, acctBookTypeId, acctTableId, periodId, reportTypeCode, null, amtPrecision, true, null);
                rptItemValues.put(periodId, rptItemValueBufList);
            }
        } else {
            TaxReportParam taxRptParam = new TaxReportParam();
            taxRptParam.setType(reportTypeCode);
            long parentOrg = AccSysUtil.getParentOrgByChildre(new ArrayList<Long>(reportQueryParam.getOrgIds()));
            taxRptParam.setParentOrg(parentOrg);
            taxRptParam.setAccTableId(acctTableId);
            taxRptParam.setBookTypeId(acctBookTypeId);
            taxRptParam.setAmtprecision(amtPrecision);
            taxRptParam.setChildOrgSet(childOrgSet);
            taxRptParam.setOrgViewId(reportQueryParam.getOrgViewId());
            taxRptParam.setPeriodTypeId(reportQueryParam.getPeriodTypeId());
            for (Long periodId : periodIds) {
                taxRptParam.setPeriodId(periodId);
                List<List<BigDecimal>> rptItemValueBufList = TaxReportFormHelper.collectMultOrgBal(taxRptParam);
                rptItemValues.put(periodId, rptItemValueBufList);
            }
        }
        return rptItemValues;
    }

    public static Map<Long, Map<String, BigDecimal[]>> getReportItemValues(GLReportQueryParams reportQueryParam) {
        HashMap<Long, Map<String, BigDecimal[]>> resultMap = new HashMap<Long, Map<String, BigDecimal[]>>(16);
        Map<Long, List<List<BigDecimal>>> rptItemValues = TaxReportFormHelper.getReportItemCalcValues(reportQueryParam);
        if (rptItemValues == null || rptItemValues.isEmpty()) {
            return resultMap;
        }
        DynamicObjectType rptItemDynType = reportQueryParam.getRptItems().getDynamicObjectType();
        block8: for (Map.Entry<Long, List<List<BigDecimal>>> en : rptItemValues.entrySet()) {
            List<List<BigDecimal>> itemValueBufList = en.getValue();
            if (itemValueBufList == null || itemValueBufList.isEmpty()) continue;
            HashMap<String, BigDecimal[]> periodRptItemValueMapBuf = new HashMap<String, BigDecimal[]>(itemValueBufList.size());
            resultMap.put(en.getKey(), periodRptItemValueMapBuf);
            Iterator rptItemIter = reportQueryParam.getRptItems().iterator();
            switch (reportQueryParam.getReportTypeCode()) {
                case "balancesheet": {
                    DynamicObject rptItemDyn;
                    Iterator<BigDecimal> dataRowIter;
                    DynamicProperty assetProp = rptItemDynType.getProperty("assetnumber");
                    DynamicProperty equityProp = rptItemDynType.getProperty("equitynumber");
                    for (List<BigDecimal> datarow : itemValueBufList) {
                        dataRowIter = datarow.iterator();
                        rptItemDyn = (DynamicObject)rptItemIter.next();
                        periodRptItemValueMapBuf.put((String)assetProp.getValueFast((Object)rptItemDyn), new BigDecimal[]{dataRowIter.next(), dataRowIter.next()});
                        periodRptItemValueMapBuf.put((String)equityProp.getValueFast((Object)rptItemDyn), new BigDecimal[]{dataRowIter.next(), dataRowIter.next()});
                    }
                    continue block8;
                }
                default: {
                    DynamicObject rptItemDyn;
                    Iterator<BigDecimal> dataRowIter;
                    DynamicProperty rptItemNum = rptItemDynType.getProperty("projectnumber");
                    for (List<BigDecimal> datarow : itemValueBufList) {
                        dataRowIter = datarow.iterator();
                        rptItemDyn = (DynamicObject)rptItemIter.next();
                        periodRptItemValueMapBuf.put((String)rptItemNum.getValueFast((Object)rptItemDyn), new BigDecimal[]{dataRowIter.next(), dataRowIter.next()});
                    }
                    continue block8;
                }
            }
        }
        return resultMap;
    }

    private static Long[] getItemByBalrow() {
        return null;
    }
}

