/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.gl.util.GLUtil;

public class TraceBizVoucherUtil {
    private static final String AI_BIZVOUCHER = "ai_bizvoucher";

    public static void showBizVoucherPage(IFormView view, Set<Long> glVoucherIds) {
        if (glVoucherIds.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8054\u67e5\u7684\u6570\u636e\u3002", (String)"TraceBizVoucherUtil_1", (String)"fi-gl-common", (Object[])new Object[0]));
            return;
        }
        Set<Long> bizVoucherIds = TraceBizVoucherUtil.getBizVoucherIds(glVoucherIds);
        if (bizVoucherIds == null || bizVoucherIds.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u6ca1\u6709\u5173\u8054\u7684\u4e1a\u52a1\u51ed\u8bc1\u3002", (String)"TraceBizVoucherUtil_2", (String)"fi-gl-common", (Object[])new Object[0]));
            return;
        }
        if (bizVoucherIds.size() == 1) {
            Date bizDate;
            long bizVoucherId = bizVoucherIds.iterator().next();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)bizVoucherId);
            showParameter.setFormId(AI_BIZVOUCHER);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            long orgId = 0L;
            Date date = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.TraceBizVoucherUtil.showBizVoucherPage", (String)AI_BIZVOUCHER, (String)"org,createtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizVoucherId)}, null);){
                for (Row row : ds) {
                    orgId = row.getLong("org");
                    date = row.getDate("createtime");
                }
            }
            if (null != date && (null == (bizDate = GLUtil.getDateBizVoucherSystemParam(orgId)) || date.before(bizDate))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u6ca1\u6709\u5173\u8054\u7684\u4e1a\u52a1\u51ed\u8bc1,\u8bf7\u91cd\u65b0\u751f\u6210\u3002", (String)"TraceBizVoucherUtil_3", (String)"fi-gl-common", (Object[])new Object[0]));
                return;
            }
            long userId = Long.parseLong(RequestContext.get().getUserId());
            int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)"gl_voucher", (String)"4715a0df000000ac");
            if (i == 1) {
                showParameter.setStatus(OperationStatus.EDIT);
            } else {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            showParameter.setHasRight(true);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(AI_BIZVOUCHER);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            for (Long pkid : bizVoucherIds) {
                showParameter.addLinkQueryPkId((Object)pkid);
            }
            showParameter.getCustomParams().put("org", "");
            showParameter.getCustomParams().put("booktype", "");
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private static Set<Long> getBizVoucherIds(Set<Long> glVoucherIds) {
        HashSet<Long> bizVoucherIds = new HashSet<Long>(100);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.TraceBizVoucherUtil.getBizVoucherIds", (String)AI_BIZVOUCHER, (String)"id", (QFilter[])new QFilter[]{new QFilter("glvoucherid", "in", glVoucherIds)}, null);){
            for (Row row : ds) {
                bizVoucherIds.add(row.getLong("id"));
            }
        }
        return bizVoucherIds;
    }
}

