/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.gl.util.QFBuilder;

public class ValidateUtils {
    private static Log logger = LogFactory.getLog(ValidateUtils.class);

    public static Optional<String> checkLegalCurrency(DynamicObject account, Long tarCurrency, Long orgId, Long bookTypeId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org.id", "=", orgId);
        qfBuilder.add("bookstype.id", "=", bookTypeId);
        Long locCurrency = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"basecurrency.id", (QFilter[])qfBuilder.toArray()).getLong("basecurrency.id");
        return ValidateUtils.checkLegalCurrency(account, locCurrency, tarCurrency);
    }

    public static Optional<String> checkLegalCurrency(DynamicObject account, Long locCurrency, Long tarCurrency) {
        DynamicObjectCollection currencies;
        List currencyIds;
        if (!QueryServiceHelper.exists((String)"bd_currency", (Object)tarCurrency)) {
            return Optional.of(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u5e01\u79cd\u3002", (String)"ValidateUtils_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        if (locCurrency.equals(tarCurrency)) {
            return Optional.empty();
        }
        String CurrencyCheckType = account.getString("acctcurrency");
        if ("nocurrency".equals(CurrencyCheckType)) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u79d1\u76ee%s\u672a\u6307\u5b9a\u5e01\u79cd\u6838\u7b97\uff0c\u8bf7\u4f7f\u7528\u672c\u4f4d\u5e01\u3002", (String)"ValidateUtils_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), account.getString("number")));
        }
        if ("descurrency".equals(CurrencyCheckType) && !(currencyIds = (currencies = account.getDynamicObjectCollection("currencyentry")).stream().map(c -> c.getLong("currency.id")).collect(Collectors.toList())).contains(tarCurrency)) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u79d1\u76ee%s\u7684\u6838\u7b97\u5e01\u79cd\u4e0d\u542b\u6240\u586b\u5e01\u79cd\uff0c\u8bf7\u66f4\u6362\u5e01\u79cd\u3002", (String)"ValidateUtils_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), account.getString("number")));
        }
        return Optional.empty();
    }

    public static Long checkLegalOrg(String orgNumber) {
        DynamicObject orgObj = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        if (null == orgObj) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"ValidateUtils_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgNumber));
        }
        long orgId = orgObj.getLong("id");
        if (!BDUtil.isBizUnit((long)orgId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u662f\u5b9e\u4f53\u7ec4\u7ec7\u6216\u672a\u5173\u8054\u8d26\u7c3f\u3002", (String)"ValidateUtils_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgNumber));
        }
        return orgId;
    }

    public static List<Long> getSelfBaseDatas(String entity, Long orgId, Long ... pks) {
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)entity, (String)"masterid", (QFilter[])new QFilter("id", "in", (Object)pks).toArray());
        List masterIds = dyns.stream().map(x -> x.getLong("masterid")).collect(Collectors.toList());
        QFilter masterIdFilter = new QFilter("masterid", "in", masterIds);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)orgId);
        DynamicObjectCollection selfBaseDatas = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{baseDataFilter, masterIdFilter});
        return selfBaseDatas.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
    }

    public static boolean checkPermissionForBasedata(String entity, Long orgId, Long pk) {
        return !ValidateUtils.getSelfBaseDatas(entity, orgId, pk).isEmpty();
    }

    public static List<String> validateAcctAvailable(Stream<Tuple<DynamicObject, String>> input) {
        ArrayList<String> result = new ArrayList<String>(8);
        input.forEach(acctTuple -> {
            try {
                DynamicObject acct = (DynamicObject)acctTuple.item1;
                if ("0".equals(acct.getString("enable"))) {
                    result.add(String.format(ResManager.loadKDString((String)"%s\u5df2\u7981\u7528\u3002", (String)"AdjustExchangeRateViewGenVchValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[0]), acctTuple.item2));
                }
                DynamicObjectCollection assistItemEntry = acct.getDynamicObjectCollection("checkitementry");
                for (DynamicObject assistItemRow : assistItemEntry) {
                    long itemId = assistItemRow.getDynamicObject("asstactitem").getLong("id");
                    DynamicObject assistDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)itemId, (String)"bd_asstacttype", (String)"enable");
                    String itemEnable = assistDyn.getString("enable");
                    if (!"0".equals(itemEnable)) continue;
                    result.add(String.format(ResManager.loadKDString((String)"%s\u542b\u6709\u7981\u7528\u7684\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AdjustExchangeRateViewGenVchValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), acctTuple.item2));
                }
            }
            catch (NullPointerException e) {
                logger.error((Throwable)e);
                result.add(String.format(ResManager.loadKDString((String)"%s\u5df2\u5220\u9664\u3002", (String)"AdjustExchangeRateViewGenVchValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[0]), acctTuple.item2));
            }
        });
        return result;
    }
}

