/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.cashflow;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.balcal.CashflowSumCalculator;
import kd.fi.gl.enums.CashStatusType;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.util.BalanceCheckHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.cashflow.FilterContext;
import org.apache.commons.lang3.StringUtils;

public class CashFlowSumHelper {
    public static DataSet getDesignDataSet(FilterContext context) {
        DataSet sumDataSet = CashFlowSumHelper.getCFSumByPeriod(context);
        if (context.getQueryEndData() != null && context.getQueryEndData().compareTo(context.getStartDate()) > 0) {
            DataSet cutDataSet = CashFlowSumHelper.getCutDataSet(context);
            List<String> cols = GLUtil.getDataSetCols(sumDataSet);
            sumDataSet = sumDataSet.join(cutDataSet, JoinType.LEFT).on("id", "id").select(cols.toArray(new String[0]), new String[]{"eamount"}).finish();
            sumDataSet = sumDataSet.addField("samount - (case when eamount is null then 0 else eamount end)", "amount").filter("amount != 0");
        } else {
            sumDataSet = sumDataSet.addField("samount", "amount");
        }
        return sumDataSet;
    }

    private static DataSet getCFSumByPeriod(FilterContext context) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select s.fid id,s.faccountid account,s.fcfitemid cfitem,s.fdc dc,s.famount samount,s.fmaincfassgrpid assgrp,s.ftype type,a.fnumber number,a.fname name,a.flongnumber longnumber,a.fmasterid masterid from t_gl_cashflowsum s inner join t_bd_account a on a.fid = s.faccountid ", new Object[0]);
        if (!context.isCashinit() || context.getQueryEndData() != null && context.getQueryEndData().compareTo(context.getStartDate()) <= 0) {
            sql.append(" where 1 != 1 ", new Object[0]);
        } else {
            CashFlowSumHelper.appendCommonFilter(sql, context);
        }
        DataSet dataSet = DB.queryDataSet((String)"getSumDataSet", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
        return dataSet;
    }

    private static DataSet getCutDataSet(FilterContext context) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select s.fid id,sum(e.feamount) eamount from t_gl_cashflowsumentry e inner join t_gl_cashflowsum s on e.fid = s.fid  inner join t_bd_account a on a.fid = s.faccountid ", new Object[0]);
        CashFlowSumHelper.appendCommonFilter(sql, context);
        sql.append(" and ( e.fbookeddate < ?", new Object[]{context.getStartDate()});
        sql.append(" or e.fbookeddate >= ? )", new Object[]{context.getQueryEndData()});
        sql.append(" group by s.fid", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)"getCutDataSet", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
        return dataSet;
    }

    public static DataSet getDesignInfos(FilterContext context) {
        DataSet dataSet = context.getQueryEndData() != null && context.getQueryEndData().compareTo(context.getStartDate()) > 0 ? CashFlowSumHelper.getCFSumDetailByDate(context) : CashFlowSumHelper.getCFSumDetailByPeriod(context);
        return dataSet;
    }

    public static Set<Long> getVocherIds(FilterContext context) {
        DataSet dataSet = context.getQueryEndData() != null && context.getQueryEndData().compareTo(context.getStartDate()) > 0 ? CashFlowSumHelper.getCFSumDetailByDate(context) : CashFlowSumHelper.getCFSumDetailByPeriod(context);
        HashSet<Long> vocherIds = new HashSet<Long>(16);
        for (Row row : dataSet) {
            vocherIds.add(row.getLong("voucherid"));
        }
        return vocherIds;
    }

    private static DataSet getCFSumDetailByPeriod(FilterContext context) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select s.fid id,e.fvoucherid voucherid ,e.fvchentryid vchentryid,e.feamount eamount from t_gl_cashflowsumentry e inner join t_gl_cashflowsum s on e.fid = s.fid  inner join t_bd_account a on a.fid = s.faccountid ", new Object[0]);
        if (context.getQueryEndData() != null && context.getQueryEndData().compareTo(context.getStartDate()) <= 0) {
            sql.append(" and 1 != 1 ", new Object[0]);
        } else {
            CashFlowSumHelper.appendCommonFilter(sql, context);
        }
        DataSet dataSet = DB.queryDataSet((String)"getCFSumDetailByPeriod", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
        return dataSet;
    }

    private static DataSet getCFSumDetailByDate(FilterContext context) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select s.fid id,e.fvoucherid voucherid ,e.fvchentryid vchentryid,e.feamount eamount from t_gl_cashflowsumentry e inner join t_gl_cashflowsum s on e.fid = s.fid  inner join t_bd_account a on a.fid = s.faccountid ", new Object[0]);
        CashFlowSumHelper.appendCommonFilter(sql, context);
        sql.append(" and e.fbookeddate >= ?", new Object[]{context.getStartDate()});
        sql.append(" and e.fbookeddate < ?", new Object[]{context.getQueryEndData()});
        DataSet dataSet = DB.queryDataSet((String)"getCFSumDetailByDate", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql);
        return dataSet;
    }

    private static void appendCommonFilter(SqlBuilder sql, FilterContext context) {
        sql.append(" where s.forgid = ?", new Object[]{context.getOrgId()});
        sql.append(" and s.fbooktypeid = ?", new Object[]{context.getBookTypeId()});
        if (context.getPeriodIds() != null && context.getPeriodIds().size() > 0) {
            sql.appendIn(" and s.fperiodid ", new ArrayList<Long>(context.getPeriodIds()));
        } else {
            sql.append(" and s.fperiodid = ?", new Object[]{context.getPeriodId()});
        }
        if (context.isCashinit() && context.getInitPeriodId() != null) {
            sql.append(" and s.fperiodid >= ?", new Object[]{context.getInitPeriodId()});
        }
        sql.appendIn(" and s.ftype ", (Object[])context.getTypes());
        if (context.getActNumbers() != null && context.getActNumbers().size() > 0) {
            sql.appendIn(" and a.fnumber ", new ArrayList<String>(context.getActNumbers()));
        }
        if (context.getCfItemIds() != null && context.getCfItemIds().size() > 0) {
            sql.appendIn(" and s.fcfitemid ", new ArrayList<Long>(context.getCfItemIds()));
        }
        if (context.getIsnotdeal() != null && context.getIsnotdeal().booleanValue()) {
            sql.append(" and s.fcfitemid = 0 ", new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)context.getDc())) {
            sql.append(" and s.fdc = ?", new Object[]{context.getDc()});
        }
    }

    public static Map<Long, DataSet> batchQueryDesignInfos(Set<Long> voucherIds, Set<Long> orgIds, Set<Long> periodIds) {
        HashMap<Long, DataSet> designInfos = new HashMap<Long, DataSet>(16);
        if (voucherIds == null || voucherIds.isEmpty()) {
            return designInfos;
        }
        List partList = Lists.partition(new ArrayList<Long>(voucherIds), (int)2000);
        for (List part : partList) {
            designInfos.putAll(CashFlowSumHelper.queryDesignInfos(part, orgIds, periodIds));
        }
        return designInfos;
    }

    private static Map<Long, DataSet> queryDesignInfos(List<Long> voucherIds, Set<Long> orgIds, Set<Long> periodIds) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fvoucherid,fvchentryid,feamount from t_gl_cashflowsumentry e inner join t_gl_cashflowsum s on e.fid = s.fid ", new Object[0]);
        sb.append(" where s.fcfitemid = 0 and s.ftype = ? ", new Object[]{CashStatusType.MAINITEM.getValue()});
        sb.appendIn(" and e.fvoucherid", new ArrayList<Long>(voucherIds));
        sb.appendIn(" and s.fperiodid ", new ArrayList<Long>(periodIds));
        sb.appendIn(" and s.forgid ", new ArrayList<Long>(orgIds));
        HashMap<Long, DataSet> designInfos = new HashMap<Long, DataSet>(16);
        DataSet dataSet = DB.queryDataSet((String)"queryDesignInfos", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sb);
        dataSet = dataSet.orderBy(new String[]{"fvoucherid"});
        long voucherId = 0L;
        ArrayList<Object[]> fvalList = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            Long vid = row.getLong("fvoucherid");
            if (voucherId != 0L && vid != voucherId) {
                designInfos.put(voucherId, CashFlowSumHelper.createVchDataSet(fvalList));
                fvalList.clear();
            }
            voucherId = vid;
            fvalList.add(new Object[]{row.getLong("fvchentryid"), row.getBigDecimal("feamount")});
        }
        if (fvalList.size() > 0) {
            designInfos.put(voucherId, CashFlowSumHelper.createVchDataSet(fvalList));
        }
        return designInfos;
    }

    public static Map<Long, BigDecimal> tranVchDataSetToMap(DataSet dataSet) {
        HashMap<Long, BigDecimal> vMap = new HashMap<Long, BigDecimal>(16);
        if (dataSet == null) {
            return vMap;
        }
        for (Row row : dataSet) {
            vMap.put(row.getLong("fvchentryid"), row.getBigDecimal("feamount"));
        }
        return vMap;
    }

    public static DataSet createVchDataSet(List<Object[]> fvalList) {
        String[] fields = new String[]{"fvchentryid", "feamount"};
        DataType[] dataType = new DataType[]{DataType.LongType, DataType.BigDecimalType};
        return CashFlowSumHelper.createDatSet(fields, dataType, fvalList);
    }

    private static DataSet createDatSet(String[] fields, DataType[] dataType, List<Object[]> fValList) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields, (DataType[])dataType);
        Algo algo = Algo.create((String)CashFlowSumHelper.class.getName());
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (Object[] row : fValList) {
            builder.append(row);
        }
        return builder.build();
    }

    public static boolean reCalculate(Long orgId, Long bookTypeId) {
        boolean result = true;
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fperiodtypeid,fcashinitperiodid from t_bd_accountbooks where ", new Object[0]);
        sqlBuilder.append(" fisbizunit =?", new Object[]{"1"});
        sqlBuilder.append(" and forgid =?", new Object[]{orgId});
        sqlBuilder.append(" and fbookstypeid =?", new Object[]{bookTypeId});
        DataSet ds = DB.queryDataSet((String)CashFlowSumHelper.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        for (Row row : ds) {
            QFilter fid2;
            Long endperiodid;
            long periodTypeId = row.getLong("fperiodtypeid");
            long cashInitPeriodId = row.getLong("fcashinitperiodid");
            if (cashInitPeriodId == 0L || (endperiodid = BalanceCheckHelper.getMaxCFPeriodId(orgId, bookTypeId, 0L)) == 0L) continue;
            QFilter ftypeId = new QFilter("periodtype", "=", (Object)periodTypeId);
            QFilter fid1 = new QFilter("id", ">=", (Object)cashInitPeriodId);
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fid1, fid2 = new QFilter("id", "<=", (Object)endperiodid), ftypeId}, (String)"id");
            if (col.isEmpty()) continue;
            List<Long> periodIds = col.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            CashFlowSumHelper.calculate(orgId, bookTypeId, periodIds);
        }
        return result;
    }

    private static boolean calculate(Long orgId, Long bookTypeId, List<Long> periodIds) {
        LockKey lockKey = LockKey.CashflowCal;
        return Lock.tryLock(orgId, bookTypeId, lockKey, () -> {
            Throwable throwable;
            TXHandle txh;
            int count = 0;
            ICalculator calculator = CalculatorFactory.createCashflowCalculator();
            do {
                txh = TX.requiresNew();
                throwable = null;
                try {
                    try {
                        count = calculator.calculate(orgId, bookTypeId);
                    }
                    catch (Exception e) {
                        txh.markRollback();
                        throw e;
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                    throw e;
                }
                finally {
                    if (txh != null) {
                        if (throwable != null) {
                            try {
                                txh.close();
                            }
                            catch (Throwable e) {
                                throwable.addSuppressed(e);
                            }
                        } else {
                            txh.close();
                        }
                    }
                }
            } while (count > 0);
            txh = TX.requiresNew();
            throwable = null;
            try {
                try {
                    if (!periodIds.isEmpty()) {
                        Iterator e = periodIds.iterator();
                        while (e.hasNext()) {
                            long id = (Long)e.next();
                            new CashflowSumCalculator().reCalculate(orgId, bookTypeId, id);
                        }
                    }
                }
                catch (Exception ex) {
                    txh.markRollback();
                    throw ex;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txh != null) {
                    if (throwable != null) {
                        try {
                            txh.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        txh.close();
                    }
                }
            }
        });
    }
}

