/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.replace;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.fi.bd.business.vo.AssistEntryVO;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.helper.CashFlowItemHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.replace.AssgrpBatchReplacer;

public class CashFlowItemBatchReplacer<T extends IVoucherEntry> {
    private final long periodId;
    private final long orgId;
    protected static final int batchCnt = 999;
    protected final List<T> pendingEntries;
    private final Set<T> changedObjectList;
    private AssgrpBatchReplacer<T> assgrpBatchReplacer;

    public CashFlowItemBatchReplacer(long orgId, long periodId) {
        this.orgId = orgId;
        this.periodId = periodId;
        this.pendingEntries = new ArrayList<T>(10);
        this.changedObjectList = new LinkedHashSet<T>(10);
    }

    private static void clearMainCashFlowInfo(IVoucherEntry entryRow) {
        entryRow.set("maincfitem", null);
        entryRow.set("maincfamount", BigDecimal.ZERO);
        entryRow.set("maincfassgrp", null);
    }

    private static void clearSuppCashFlowInfo(IVoucherEntry entryRow) {
        entryRow.set("suppcfitem", null);
        entryRow.set("suppcfamount", BigDecimal.ZERO);
    }

    public void setAssgrpBatchReplacer(AssgrpBatchReplacer<T> assgrpBatchReplacer) {
        this.assgrpBatchReplacer = Objects.requireNonNull(assgrpBatchReplacer);
    }

    public void addReplace(T replaceObject) {
        this.pendingEntries.add(replaceObject);
        this.checkSize();
    }

    private void checkSize() {
        if (this.pendingEntries.size() >= 999) {
            this.flush();
        }
    }

    public Set<T> finish() {
        this.flush();
        if (this.assgrpBatchReplacer != null) {
            this.changedObjectList.addAll(this.assgrpBatchReplacer.finish());
        }
        return this.changedObjectList;
    }

    public void flush() {
        if (this.pendingEntries.isEmpty()) {
            return;
        }
        this._flush();
        this.pendingEntries.clear();
    }

    protected void _flush() {
        Long[] itemIds = (Long[])this.pendingEntries.stream().map(entry -> Arrays.asList((Long)entry.get(GLField.id_("maincfitem")), (Long)entry.get(GLField.id_("suppcfitem")))).flatMap(Collection::stream).filter(itemId -> itemId > 0L).distinct().toArray(Long[]::new);
        Map versionMap = CashFlowItemHelper.loadForVersion((Long[])itemIds, (Long)this.orgId, (Long)this.periodId, CashFlowItemVO::getLeaf);
        for (IVoucherEntry entry2 : this.pendingEntries) {
            long mainCfItemId = (Long)entry2.get(GLField.id_("maincfitem"));
            long suppCfItemId = (Long)entry2.get(GLField.id_("suppcfitem"));
            CashFlowItemVO mainCashFlowItemVO = (CashFlowItemVO)versionMap.get(mainCfItemId);
            if (mainCfItemId != 0L) {
                if (mainCashFlowItemVO == null) {
                    CashFlowItemBatchReplacer.clearMainCashFlowInfo(entry2);
                    CashFlowItemBatchReplacer.clearSuppCashFlowInfo(entry2);
                    this.changedObjectList.add(entry2);
                    continue;
                }
                if (mainCfItemId != mainCashFlowItemVO.getId()) {
                    entry2.set(GLField.id_("maincfitem"), mainCashFlowItemVO.getId());
                    this.changedObjectList.add(entry2);
                }
            }
            if (suppCfItemId != 0L) {
                CashFlowItemVO suppCashFlowItemVO = (CashFlowItemVO)versionMap.get(suppCfItemId);
                if (suppCashFlowItemVO == null) {
                    CashFlowItemBatchReplacer.clearSuppCashFlowInfo(entry2);
                    this.changedObjectList.add(entry2);
                } else if (suppCfItemId != suppCashFlowItemVO.getId()) {
                    entry2.set(GLField.id_("suppcfitem"), suppCashFlowItemVO.getId());
                    this.changedObjectList.add(entry2);
                }
            }
            if (this.assgrpBatchReplacer == null || mainCashFlowItemVO == null) continue;
            this.assgrpBatchReplacer.addReplace(entry2, new ArrayList<String>(FlexUtils.batchGetFlexFields(BDUtil.extractToList((Collection)mainCashFlowItemVO.getAssistEntryVOS(), AssistEntryVO::getAssistTypeId)).values()), (String)entry2.get("maincfassgrp.value"), (Long)entry2.get(GLField.id_("maincfassgrp")));
        }
        if (this.assgrpBatchReplacer != null) {
            this.assgrpBatchReplacer.flush();
        }
    }
}

