/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.replace;

import com.google.common.collect.ArrayListMultimap;
import java.io.Flushable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.voucher.VoucherHintBuilder;

public class CommonAssistValueReplacer<T>
implements Flushable {
    private static final int batchCnt = 999;
    private static final Log extLogger = ExtLogFactory.getLog(CommonAssistValueReplacer.class, (String)"[CommonAssistValueReplacer]");
    private final BiConsumer<List<CommonAssistProperties>, T> callBackConsumer;
    private final List<CommonAssist> commonAssists;
    private final List<ReplaceTask> pendingTaskList;

    public CommonAssistValueReplacer(long accountTableId, BiConsumer<List<CommonAssistProperties>, T> callBackConsumer) {
        this.callBackConsumer = callBackConsumer;
        ComAssistTable comAssistTable = ComAssistTable.get(accountTableId);
        this.commonAssists = comAssistTable.getCommonAssists();
        this.pendingTaskList = new ArrayList<ReplaceTask>(10);
    }

    public void addReplace(T replaceObject, long entryId, long voucherId) {
        this.pendingTaskList.add(new ReplaceTask(replaceObject, entryId, voucherId));
        this.checkSize();
    }

    private void checkSize() {
        if (this.pendingTaskList.size() >= 999) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        if (this.pendingTaskList.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        this._flush();
        extLogger.info("flush success, processCnt = {}, cost {} ms", (Object)this.pendingTaskList.size(), (Object)(System.currentTimeMillis() - start));
        this.pendingTaskList.clear();
    }

    private void _flush() {
        if (this.commonAssists.isEmpty()) {
            extLogger.warn("not comassist detected, skip flush");
            return;
        }
        Set<Long> voucherIds = this.pendingTaskList.stream().map(task -> ((ReplaceTask)task).voucherId).collect(Collectors.toSet());
        ArrayListMultimap commonAssistValuesMultimap = ArrayListMultimap.create();
        String aliasJoin = this.commonAssists.stream().map(commonAssist -> CommonAssistUtil.getAlias(commonAssist.key)).collect(Collectors.joining(","));
        SqlBuilder sqlBuilder = new SqlBuilder().append("select fentryid,", new Object[0]).append(aliasJoin, new Object[0]).append(" from t_gl_voucherentry ", new Object[0]).appendIn("where fentryid", this.pendingTaskList.stream().map(task -> ((ReplaceTask)task).entryId).distinct().toArray());
        try (ShardingHintContext ignored = VoucherHintBuilder.buildPKHint(voucherIds);
             DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                for (CommonAssist commonAssist2 : this.commonAssists) {
                    commonAssistValuesMultimap.put((Object)row.getLong("fentryid"), (Object)new CommonAssistProperties(commonAssist2, row.getLong(CommonAssistUtil.getAlias(commonAssist2.key))));
                }
            }
        }
        int valuesIndex = 0;
        Collection comAssistValuesCol = commonAssistValuesMultimap.asMap().values();
        while (++valuesIndex <= this.commonAssists.size()) {
            int finalValuesIndex = valuesIndex;
            List<CommonAssistProperties> commonAssistProperties = comAssistValuesCol.stream().flatMap(col -> {
                Iterator iterator = col.iterator();
                CommonAssistProperties res = null;
                for (int i = 0; i < finalValuesIndex; ++i) {
                    res = (CommonAssistProperties)iterator.next();
                }
                return Stream.of(res);
            }).collect(Collectors.toList());
            this.batchFillCommonAssistProperties(commonAssistProperties);
        }
        for (ReplaceTask replaceTask : this.pendingTaskList) {
            ArrayList commonAssistProperties = new ArrayList(commonAssistValuesMultimap.get((Object)replaceTask.entryId));
            this.callBackConsumer.accept((List<CommonAssistProperties>)commonAssistProperties, replaceTask.replaceObject);
        }
    }

    public void finish() {
        this.flush();
    }

    private void batchFillCommonAssistProperties(List<CommonAssistProperties> commonAssistProperties) {
        if (commonAssistProperties.isEmpty()) {
            return;
        }
        Set comAssistIds = BDUtil.extractToSet(commonAssistProperties, p -> ((CommonAssistProperties)p).id);
        String valueSource = ((CommonAssistProperties)commonAssistProperties.get((int)0)).commonAssist.valueSource;
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)valueSource);
        String numberKey = entityType.getNumberProperty();
        String nameKey = entityType.getNameProperty();
        Map pkDynMap = BusinessDataServiceHelper.loadFromCache((String)valueSource, (String)String.join((CharSequence)",", numberKey, nameKey), (QFilter[])QFilterBuilder.create((String)"id", (String)"in", (Object)comAssistIds).toArray(new QFilter[0]));
        for (CommonAssistProperties commonAssistProperty : commonAssistProperties) {
            DynamicObject comAssistDyn = (DynamicObject)pkDynMap.get(commonAssistProperty.id);
            if (comAssistDyn == null) continue;
            commonAssistProperty.number = comAssistDyn.getString(numberKey);
            commonAssistProperty.name = comAssistDyn.getString(nameKey);
        }
    }

    private class ReplaceTask {
        private final T replaceObject;
        private final long entryId;
        private final long voucherId;

        public ReplaceTask(T replaceObject, long entryId, long voucherId) {
            this.replaceObject = replaceObject;
            this.entryId = entryId;
            this.voucherId = voucherId;
        }
    }

    public static class CommonAssistProperties {
        private final CommonAssist commonAssist;
        private final long id;
        private String number;
        private String name;

        public CommonAssistProperties(CommonAssist commonAssist, long id) {
            this.commonAssist = commonAssist;
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public CommonAssist getCommonAssist() {
            return this.commonAssist;
        }
    }
}

