/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.voucher.check;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.util.threads.Consumer;
import kd.fi.gl.util.threads.Producer;
import kd.fi.gl.util.voucher.check.VoucherCheckExecutor;
import kd.fi.gl.util.voucher.check.VoucherCheckType;

public class VoucherEntryCheckProducer
extends Producer {
    private final String logPrefix;
    private final int produceBatchLimit;
    private final int consumeBatchLimit;
    private final long beginEntryId;
    private final String pageId;
    private static final Log LOG = LogFactory.getLog(VoucherEntryCheckProducer.class);
    private final PerformanceWatch watcher;

    public VoucherEntryCheckProducer(BlockingQueue<Callable> sharedQueue, String taskIdentifier, AtomicBoolean isAbort, String pageId) {
        super(sharedQueue, taskIdentifier, isAbort);
        this.pageId = pageId;
        this.logPrefix = "producer for " + taskIdentifier;
        this.watcher = new PerformanceWatch(this.getClass(), "ignore", false);
        this.produceBatchLimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.entrycheck.producelmt", (int)100000);
        this.consumeBatchLimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.entrycheck.consumelmt", (int)100000);
        this.beginEntryId = BillParamUtil.getLongValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.entrycheck.beginid", (long)0L);
    }

    @Override
    public void run() {
        try {
            this.innerRun(this.beginEntryId);
            this.isAllTaskProduced.getAndSet(true);
        }
        catch (Exception e) {
            LOG.error(this.logPrefix + ":put a task error", (Throwable)e);
            this.consumer.getIsAbort().getAndSet(true);
        }
    }

    private void innerRun(long beginEntryId) throws InterruptedException {
        try (DataSet dataSet = DB.queryDataSet((String)"VoucherEntryCheckProducer.batchLoadEntry", (DBRoute)DBRoute.of((String)"fi"), (String)String.format("select top %s fentryid, faccountid, fassgrpid from t_gl_voucherentry where fentryid > %s order by fentryid asc", this.produceBatchLimit, beginEntryId));){
            if (!dataSet.hasNext()) {
                LOG.info("{} has produced completely, producer thread is going to terminate. cost detail:{}", (Object)this.logPrefix, (Object)this.watcher.show());
            } else {
                this.watcher.start("produce task " + this.produceTaskCnt.get());
                ArrayList<EntryParam> entryParams = new ArrayList<EntryParam>(this.consumeBatchLimit);
                for (Row row : dataSet) {
                    beginEntryId = row.getLong("fentryid");
                    entryParams.add(new EntryParam(beginEntryId, row.getLong("faccountid"), row.getLong("fassgrpid")));
                    if (entryParams.size() < this.consumeBatchLimit) continue;
                    int curTaskIndex = this.produceTaskCnt.incrementAndGet();
                    CheckTask newTask = new CheckTask(new ArrayList<EntryParam>(entryParams), this.consumer, this, this.taskIdentifier, curTaskIndex, this.pageId);
                    while (!this.taskQueue.offer(newTask)) {
                        TimeUnit.SECONDS.sleep(2L);
                    }
                    LOG.info("{} put a new task into queue, task index:{}, task size:{}", new Object[]{this.logPrefix, curTaskIndex, entryParams.size()});
                    entryParams.clear();
                }
                if (!entryParams.isEmpty()) {
                    int curTaskIndex = this.produceTaskCnt.incrementAndGet();
                    CheckTask newTask = new CheckTask(entryParams, this.consumer, this, this.taskIdentifier, curTaskIndex, this.pageId);
                    while (!this.taskQueue.offer(newTask)) {
                        TimeUnit.SECONDS.sleep(2L);
                    }
                    LOG.info("{} put a new task into queue, task index:{}, task size:{}", new Object[]{this.logPrefix, curTaskIndex, entryParams.size()});
                }
                this.watcher.stop();
                if (!this.isAbort.get()) {
                    this.innerRun(beginEntryId);
                }
            }
        }
    }

    public static class EntryParam {
        private final long entryId;
        private final long accountId;
        private final long assgrpId;

        public EntryParam(long entryId, long accountId, long assgrpId) {
            this.entryId = entryId;
            this.accountId = accountId;
            this.assgrpId = assgrpId;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public long getAssgrpId() {
            return this.assgrpId;
        }

        public long getEntryId() {
            return this.entryId;
        }
    }

    public static class CheckContext {
        private Map<Object, DynamicObject> accountId2Dyn;
        private Table<Long, String, Object> assgrpId2Flex2Value;

        public Map<Object, DynamicObject> getAccountId2Dyn() {
            return this.accountId2Dyn;
        }

        public void setAccountId2Dyn(Map<Object, DynamicObject> accountId2Dyn) {
            this.accountId2Dyn = accountId2Dyn;
        }

        public Table<Long, String, Object> getAssgrpId2Flex2Value() {
            return this.assgrpId2Flex2Value;
        }

        public void setAssgrpId2Flex2Value(Table<Long, String, Object> assgrpId2Flex2Value) {
            this.assgrpId2Flex2Value = assgrpId2Flex2Value;
        }
    }

    public static class CheckTask
    implements Callable {
        public final List<EntryParam> entryParams;
        public final Consumer consumer;
        public final Producer producer;
        public final int curTaskIndex;
        public final String logPrefix;
        public int checkValue = 7;
        public final String pageId;
        public final CheckContext checkContext;

        public CheckTask(List<EntryParam> entryParams, Consumer consumer, Producer producer, String taskIdentifier, int curTaskIndex, String pageId) {
            this.entryParams = entryParams;
            this.consumer = consumer;
            this.producer = producer;
            this.curTaskIndex = curTaskIndex;
            this.logPrefix = "consumer for " + taskIdentifier;
            this.pageId = pageId;
            this.checkContext = new CheckContext();
        }

        public Void call() throws Exception {
            try {
                VoucherCheckType.getCheckTypes(this.checkValue).stream().map(VoucherCheckType::getConsumer).forEach(c -> c.accept(this));
                VoucherCheckExecutor.VoucherCheckCacheManager.setProgress(this.pageId, String.format("%s/%s", this.curTaskIndex, this.producer.getProduceTaskCnt()));
                if (this.producer.isAllTaskProduced().get() && this.curTaskIndex == this.producer.getProduceTaskCnt().get()) {
                    VoucherCheckExecutor.VoucherCheckCacheManager.setSuccess(this.pageId, Boolean.TRUE);
                }
                LOG.info("{} consumes a task successfully, task index:{}", (Object)this.logPrefix, (Object)this.curTaskIndex);
                return null;
            }
            catch (Exception e) {
                VoucherCheckExecutor.VoucherCheckCacheManager.addErrorData(this.pageId, new VoucherCheckExecutor.CacheValue(-1L, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw e;
            }
        }
    }
}

