/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.carryover.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.balancecarryover.BalanceCarryOverContext;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.voucher.VoucherHintBuilder;
import kd.fi.gl.voucher.carryover.utils.BalanceCarryOverContextCollector;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BalanceCarryOverUtils {
    private static final String RECORD_ENTITY = "gl_carryover_record";
    private static final String VOUCHER_ID = "voucherid";
    private static final String BALANCE_ID = "balanceid";
    private static final String ENTRY_ID = "voucherentryid";
    private static final Log logger = LogFactory.getLog(BalanceCarryOverUtils.class);
    public static final String CARRY_INFO = "carry_info";
    private static final String[] balFields = new String[]{"id", "account", "assgrp", "currency", "measureunit", "endqty", "endfor", "endlocal"};

    public static void logContextsIfEnable(Collection<BalanceCarryOverContext> contexts) {
        if (DebugTrace.enable()) {
            logger.info(contexts.stream().map(context -> {
                try {
                    return String.format("context:%s;diffAssist:%s", SerializationUtils.toJsonString((Object)context), SerializationUtils.toJsonString((Object)context.getAssistDifferentMsg()));
                }
                catch (Exception e) {
                    return "describe error";
                }
            }).collect(Collectors.joining("->")));
        }
    }

    public static Map<Long, AmountInfo> batchParseBalance2AmountInfo(Collection<Long> balances) {
        HashMap<Long, AmountInfo> result = new HashMap<Long, AmountInfo>(64);
        ArrayList<String> selFields = new ArrayList<String>(10);
        selFields.addAll(Arrays.asList(balFields));
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        for (int i = 1; i <= size; ++i) {
            selFields.add("comassist" + i);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BalanceCarryOverFormPlugin.genBalance2AmountInfoMap", (String)"gl_balance", (String)String.join((CharSequence)",", selFields), (QFilter[])new QFilter[]{new QFilter("id", "in", balances)}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<Integer, Long> comAssistIdMap = new HashMap<Integer, Long>(2);
                for (int i = 1; i <= size; ++i) {
                    comAssistIdMap.put(i, row.getLong("comassist" + i));
                }
                result.put(row.getLong("id"), new AmountInfo.Builder().accountId(row.getLong("account")).assgrpId(row.getLong("assgrp")).currencyId(row.getLong("currency")).measureUnitId(row.getLong("measureunit")).qty(row.getBigDecimal("endqty")).oriAmount(row.getBigDecimal("endfor")).locAmount(row.getBigDecimal("endlocal")).dc("1").comAssistIdMap(comAssistIdMap).build());
            }
        }
        return result;
    }

    public static Optional<String> existLog(Collection<BalanceCarryOverContext> contexts) {
        Multimap<String, Integer> numberSeqsMap = CarryOverService.query(contexts);
        if (numberSeqsMap.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder detailTip = new StringBuilder();
        numberSeqsMap.asMap().forEach((num, seqs) -> detailTip.append(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\uff1a%1$s\uff0c\u5206\u5f55\u884c\u53f7\uff1a%2$s\u3002", (String)"BalanceCarryOverUtils_1", (String)"fi-gl-common", (Object[])new Object[0]), num, seqs.stream().map(String::valueOf).collect(Collectors.joining(",")))).append(System.lineSeparator()));
        return Optional.of(String.format("%s%s%s", ResManager.loadKDString((String)"\u5b58\u5728\u4f59\u989d\u7ed3\u8f6c\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u5e94\u7684\u51ed\u8bc1\u6216\u5220\u9664\u5bf9\u5e94\u5206\u5f55\u540e\u91cd\u65b0\u63d0\u4ea4\uff0c\u518d\u751f\u6210\u8be5\u7ed3\u8f6c\u51ed\u8bc1\u3002", (String)"BalanceCarryOverUtils_0", (String)"fi-gl-common", (Object[])new Object[0]), System.lineSeparator(), detailTip));
    }

    public static void writeLog(DynamicObject[] dataEntities, OperateOption option) {
        Arrays.stream(dataEntities).filter(dyn -> "c".equals(dyn.getString("sourcetype"))).forEach(voucherDyn -> {
            if (option.containsVariable(CARRY_INFO)) {
                CarryOverService.save(voucherDyn, option.getVariableValue(CARRY_INFO));
            } else {
                CarryOverService.update(voucherDyn);
            }
        });
    }

    public static void removeLog(DynamicObject[] dateEntities) {
        Set<Object> voucherIds = Arrays.stream(dateEntities).filter(dyn -> "c".equals(dyn.getString("sourcetype"))).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        if (!voucherIds.isEmpty()) {
            CarryOverService.delete(voucherIds);
        }
    }

    public static DynamicObject getReplaceAccount(Long orgId, Long masterId, Long periodId) {
        String key = AccountRefUtils.getVersonKey((Object[])new Object[]{orgId, masterId, periodId});
        return (DynamicObject)ThreadCache.get((Object)key, () -> BalanceCarryOverUtils.getReplaceAccountFromLocalCache(orgId, masterId, periodId));
    }

    private static DynamicObject getReplaceAccountFromLocalCache(Long orgId, Long masterId, Long periodId) {
        String key = AccountRefUtils.getVersonKey((Object[])new Object[]{orgId, masterId, periodId});
        ConcurrentHashMap<String, DynamicObject> accountReplaceMap = LocalCacheHelper.get(CacheKey.getCacheKey(CacheKeyPrefix.GL_ACCOUNT_REPLACE, new Object[0]), Map.class);
        if (accountReplaceMap == null) {
            accountReplaceMap = new ConcurrentHashMap<String, DynamicObject>(16);
        }
        return accountReplaceMap.computeIfAbsent(key, ignore -> AccountRefUtils.getCurAccount((AccountVersionReplaceParam)new AccountVersionReplaceParam(orgId.longValue(), masterId.longValue(), 0L, 0L, null, BalanceCarryOverUtils.getPeriodDyn(periodId), 0L, null, 0L)));
    }

    public static Date getEndDate(Long periodId) {
        return BalanceCarryOverUtils.getPeriodDyn(periodId).getDate("enddate");
    }

    public static DynamicObject getPeriodDyn(Long periodId) {
        return (DynamicObject)ThreadCache.get((Object)periodId, () -> BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period"));
    }

    private static String getUniquePart() {
        StringBuilder sql = new StringBuilder();
        sql.append("(forgid,fbooktypeid,faccountid,fassgrpid,fcurrencyid,fmeasureunitid");
        sql.append(BalanceCarryOverUtils.getCommonFields());
        sql.append(") IN ");
        return sql.toString();
    }

    private static String getCommonFields() {
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        StringBuilder sql = new StringBuilder();
        for (int i = 1; i <= size; ++i) {
            String property = ",fcomassist" + i + "id";
            sql.append(property);
        }
        return sql.toString();
    }

    public static boolean isCarryOverVoucher(DynamicObject voucherDyn) {
        return voucherDyn != null && "c".equals(voucherDyn.getString("sourcetype"));
    }

    private static class CarryOverService {
        private CarryOverService() {
        }

        public static void save(DynamicObject voucherDyn, String variableValue) {
            long voucherId = voucherDyn.getLong("id");
            List contexts = SerializationUtils.fromJsonStringToList((String)variableValue, BalanceCarryOverContext.class);
            Lists.partition((List)voucherDyn.getDynamicObjectCollection("entries"), (int)3000).forEach(dynList -> CarryOverService.batchSave(voucherId, dynList, contexts));
        }

        private static void batchSave(long voucherId, List<DynamicObject> dynList, List<BalanceCarryOverContext> contexts) {
            ArrayList<DynamicObject> toSaveDyns = new ArrayList<DynamicObject>(dynList.size());
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)BalanceCarryOverUtils.RECORD_ENTITY);
            for (DynamicObject entryDyn : dynList) {
                int seq = entryDyn.getInt("seq");
                if (seq % 2 == 0) continue;
                DynamicObject instance = (DynamicObject)entityType.createInstance();
                BalanceCarryOverContext context = contexts.get(seq / 2);
                instance.set(BalanceCarryOverUtils.VOUCHER_ID, (Object)voucherId);
                instance.set(BalanceCarryOverUtils.ENTRY_ID, entryDyn.getPkValue());
                instance.set("org", (Object)context.getOrgId());
                instance.set("booktype", (Object)context.getBookTypeId());
                instance.set("account", (Object)context.getAccountMasterId());
                instance.set("assgrp", (Object)context.getAssgrpId());
                instance.set("currency", (Object)context.getCurrencyId());
                instance.set("measureunit", (Object)context.getMeasureunit());
                List<Long> comassistIds = context.getComassistIds();
                for (int i = 1; i <= comassistIds.size(); ++i) {
                    String property = "comassist" + i;
                    instance.set(property, (Object)comassistIds.get(i - 1));
                }
                toSaveDyns.add(instance);
            }
            SaveServiceHelper.save((DynamicObject[])toSaveDyns.toArray(new DynamicObject[0]));
        }

        public static void update(DynamicObject voucherDyn) {
            Object voucherId = voucherDyn.getPkValue();
            Set entryIds = voucherDyn.getDynamicObjectCollection("entries").stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            QFBuilder qfBuilder = new QFBuilder(BalanceCarryOverUtils.VOUCHER_ID, "=", voucherId).add(BalanceCarryOverUtils.ENTRY_ID, "not in", entryIds);
            DeleteServiceHelper.delete((String)BalanceCarryOverUtils.RECORD_ENTITY, (QFilter[])qfBuilder.toArray());
        }

        public static void delete(Collection<Object> voucherIds) {
            DeleteServiceHelper.delete((String)BalanceCarryOverUtils.RECORD_ENTITY, (QFilter[])new QFilter[]{new QFilter(BalanceCarryOverUtils.VOUCHER_ID, "in", voucherIds)});
        }

        public static Multimap<String, Integer> query(Collection<BalanceCarryOverContext> contexts) {
            HashMultimap result = HashMultimap.create();
            List<VoucherEntry> existedVoucherEntrys = CarryOverService.queryExistedEntries(contexts);
            if (existedVoucherEntrys.isEmpty()) {
                return result;
            }
            Set voucherIds = (Set)CollectionUtils.collect(existedVoucherEntrys, e -> ((VoucherEntry)e).voucherId, new HashSet(4));
            Set entryIds = (Set)CollectionUtils.collect(existedVoucherEntrys, e -> ((VoucherEntry)e).voucherEntryId, new HashSet(4));
            try (ShardingHintContext ignore = VoucherHintBuilder.buildPKHint(voucherIds);
                 DataSet existedDataSet = VoucherQueryUtils.queryDataSet((String)"billno, entries.seq", (QFilter[])QFilterBuilder.create((String)"entries.id", (String)"in", (Object)entryIds).toArray(new QFilter[0]), (String)"billno, entries.seq asc", (int)-1);){
                for (Row row : existedDataSet) {
                    result.put((Object)row.getString("billno"), (Object)row.getInteger("entries.seq"));
                    result.put((Object)row.getString("billno"), (Object)(row.getInteger("entries.seq") + 1));
                }
            }
            return result;
        }

        private static List<VoucherEntry> queryExistedEntries(Collection<BalanceCarryOverContext> contexts) {
            Set accountMasterIds = BDUtil.extractToSet(contexts, BalanceCarryOverContext::getAccountMasterId);
            BalanceCarryOverContext sampleContext = contexts.iterator().next();
            long orgId = sampleContext.getOrgId();
            long bookTypeId = sampleContext.getBookTypeId();
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("SELECT forgid,fbooktypeid,faccountid,fassgrpid,fcurrencyid,fmeasureunitid,fvoucherid,fvoucherentryid", new Object[0]);
            String commonFields = BalanceCarryOverUtils.getCommonFields();
            if (StringUtils.isNotBlank((CharSequence)commonFields)) {
                sqlBuilder.append(commonFields, new Object[0]);
            }
            sqlBuilder.append(" FROM T_GL_CARRYOVER_RECORD ", new Object[0]).append("WHERE forgid = ? and fbooktypeid = ? ", new Object[]{orgId, bookTypeId}).appendIn("AND faccountid ", accountMasterIds.toArray());
            ArrayList<VoucherEntry> result = new ArrayList<VoucherEntry>(contexts.size() / 2);
            try (DataSet dataSet = DB.queryDataSet((String)"BalanceCarryOverUtils.queryExistedEntries", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder).filter(BalanceCarryOverUtils.getUniquePart() + contexts.stream().collect(new BalanceCarryOverContextCollector()));){
                for (Row row : dataSet) {
                    result.add(new VoucherEntry(row.getLong("fvoucherid"), row.getLong("fvoucherentryid")));
                }
            }
            return result;
        }

        private static class VoucherEntry {
            private long voucherId;
            private long voucherEntryId;

            public VoucherEntry(long voucherId, long voucherEntryId) {
                this.voucherId = voucherId;
                this.voucherEntryId = voucherEntryId;
            }
        }
    }
}

