/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.carryover.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ThreadLocals;
import kd.fi.bd.service.account.AccountVersionMatchHelper;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.voucher.carryover.utils.BalanceCarryOverUtils;

public class CarryOverCacheManager {
    public static void initHgId2Assvals(Collection<Long> assgrpids) {
        HashMap<Long, String> cacheMap = new HashMap<Long, String>(assgrpids.size());
        BusinessDataServiceHelper.loadFromCache((String)"gl_assist", (String)String.join((CharSequence)",", "id", "assvals"), (QFilter[])new QFBuilder("id", "in", assgrpids).toArray()).values().forEach(dyn -> cacheMap.put(dyn.getLong("id"), dyn.getString("assvals")));
        ThreadLocalManager.setHgId2Assvals(cacheMap);
    }

    public static void initAccountMatchCollection(Long orgId, Collection<Long> masterIds) {
        ThreadLocalManager.setAccountMatchCollection(AccountVersionMatchHelper.init(Collections.singletonList(orgId), masterIds, (String)String.join((CharSequence)",", "accheck", "id")));
    }

    public static void initDefaultVal(Map<String, Object> defaultVal) {
        ThreadLocalManager.setDefaultValue(defaultVal);
    }

    public static Object getDefaultVal(String flexfield) {
        return ThreadLocalManager.getDefaultValue().get(flexfield);
    }

    public static void initBalanceId2AmountInfo(Collection<Long> balances) {
        ThreadLocalManager.setBalanceId2AmountInfo(BalanceCarryOverUtils.batchParseBalance2AmountInfo(balances));
    }

    public static DynamicObject getAccount(Long orgId, Long masterId, Long periodId) {
        return ThreadLocalManager.getAccountMatchCollection().get(orgId.longValue(), masterId.longValue(), BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodId)}).getDate("enddate"));
    }

    public static String getAssvals(Long assgrpId) {
        return ThreadLocalManager.getHgId2Value().get(assgrpId);
    }

    public static AmountInfo getAmountInfo(Long balanceId) {
        return ThreadLocalManager.getBalanceId2AmountInfo().get(balanceId);
    }

    private static class ThreadLocalManager {
        static ThreadLocal<Map<Long, String>> hgId2AssvalsThreadLocal = ThreadLocals.create();
        static ThreadLocal<AccountVersionMatchHelper.AccountMatchCollection> accountMatchCollectionThreadLocal = ThreadLocals.create();
        static ThreadLocal<Map<String, Object>> defaultValueThreadLocal = ThreadLocals.create();
        static ThreadLocal<Map<Long, AmountInfo>> balanceId2AmountInfoThreadLocal = ThreadLocals.create();

        private ThreadLocalManager() {
        }

        static void setHgId2Assvals(Map<Long, String> hgId2Value) {
            hgId2AssvalsThreadLocal.set(hgId2Value);
        }

        static Map<Long, String> getHgId2Value() {
            return hgId2AssvalsThreadLocal.get();
        }

        static void setAccountMatchCollection(AccountVersionMatchHelper.AccountMatchCollection accountMatchCollection) {
            accountMatchCollectionThreadLocal.set(accountMatchCollection);
        }

        static AccountVersionMatchHelper.AccountMatchCollection getAccountMatchCollection() {
            return accountMatchCollectionThreadLocal.get();
        }

        static void setDefaultValue(Map<String, Object> defaultValue) {
            defaultValueThreadLocal.set(defaultValue);
        }

        static Map<String, Object> getDefaultValue() {
            return defaultValueThreadLocal.get();
        }

        public static void setBalanceId2AmountInfo(Map<Long, AmountInfo> balanceId2AmountInfo) {
            balanceId2AmountInfoThreadLocal.set(balanceId2AmountInfo);
        }

        public static Map<Long, AmountInfo> getBalanceId2AmountInfo() {
            return balanceId2AmountInfoThreadLocal.get();
        }
    }
}

