/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.dimquery;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.vo.SimpleFilter;
import kd.fi.gl.voucher.dimquery.vdf.VDFFactory;
import kd.fi.gl.voucher.dimquery.vdf.VchDimFilterService;

public abstract class AbstractDimVchQuery<R> {
    private static final Log LOGGER = LogFactory.getLog(AbstractDimVchQuery.class);
    private final VchDimFilterService.VDFContext context;

    public AbstractDimVchQuery(VchDimFilterService.VDFContext context) {
        this.context = context;
    }

    public R query(QFilter[] oriFilters, String selectFields, String orderBy, int top) {
        boolean existCustomFilters;
        Optional<List<SimpleFilter>> vchFilters = AbstractDimVchQuery.map2SimplerFilters(oriFilters);
        boolean bl = existCustomFilters = !vchFilters.isPresent() || VDFFactory.existCustomFilter(vchFilters.get().toArray(new SimpleFilter[0]));
        if (existCustomFilters) {
            return this.doCustomFilterQuery(oriFilters, selectFields, orderBy, top);
        }
        ArrayList<QFilter> balDimFilters = new ArrayList<QFilter>(8);
        ArrayList<QFilter> vchExtFilters = new ArrayList<QFilter>(4);
        for (SimpleFilter vchF : vchFilters.get()) {
            VchDimFilterService vdfService = VDFFactory.getVDFService(vchF);
            vdfService.getBalDimFilter(this.context, vchF).ifPresent(balDimFilters::add);
            if (!vdfService.isExtFilter(this.getVchQueryDims())) continue;
            vchExtFilters.add(new QFilter(vchF.getProperty(), vchF.getCP(), vchF.getValue()));
        }
        DataSet balSummaryDs = this.doBalDimSummaryQuery(balDimFilters, this.getBalQueryDims());
        return this.doVchQueryWithBalDimSummary(balSummaryDs, vchExtFilters, oriFilters, selectFields, orderBy, top);
    }

    static Optional<List<SimpleFilter>> map2SimplerFilters(QFilter[] oriFilters) {
        QFilter[] vchFullFilters = VoucherQueryUtils.enhanceFilters((QFilter[])oriFilters, (boolean)true);
        ArrayList<SimpleFilter> vchFilters = new ArrayList<SimpleFilter>(vchFullFilters.length);
        for (QFilter vchFilter : vchFullFilters) {
            Optional<SimpleFilter> simplerFilter = SimpleFilter.tryMapToSimplerFilter(vchFilter);
            if (!simplerFilter.isPresent()) {
                return Optional.empty();
            }
            vchFilters.add(simplerFilter.get());
        }
        return Optional.of(vchFilters);
    }

    protected abstract DataSet doBalDimSummaryQuery(List<QFilter> var1, List<String> var2);

    protected abstract R doVchQueryWithBalDimSummary(DataSet var1, List<QFilter> var2, QFilter[] var3, String var4, String var5, int var6);

    protected abstract R doCustomFilterQuery(QFilter[] var1, String var2, String var3, int var4);

    protected List<String> getVchQueryDims() {
        return new ArrayList<String>(this.context.getVchQueryDims());
    }

    protected List<String> getBalQueryDims() {
        return new ArrayList<String>(this.context.getBalQueryDims());
    }

    public VchDimFilterService.VDFContext getContext() {
        return this.context;
    }
}

