/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.dimquery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.entity.report.FilterInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.voucher.dimquery.SLDimVchQuery;
import kd.fi.gl.voucher.dimquery.vdf.VchDimFilterService;

public class LimitSizeDimVchQuery
extends SLDimVchQuery<Tuple<DataSet, Integer>> {
    private static final Log LOGGER = LogFactory.getLog(LimitSizeDimVchQuery.class);

    public LimitSizeDimVchQuery(FilterInfo filterInfo) {
        super(LimitSizeDimVchQuery.getVDFContext(filterInfo));
    }

    protected static VchDimFilterService.VDFContext getVDFContext(FilterInfo filterInfo) {
        ArrayList<Object> queryDim = new ArrayList<Object>(8);
        queryDim.add(LimitSizeDimVchQuery.VOUCHER.org);
        if ("allcurrency".equals(filterInfo.getString("currency"))) {
            queryDim.add(LimitSizeDimVchQuery.VOUCHER.currency);
        }
        if (filterInfo.getBoolean("showsumqty")) {
            queryDim.add(LimitSizeDimVchQuery.VOUCHER.unit);
        }
        queryDim.add(LimitSizeDimVchQuery.VOUCHER.period);
        List<String> dims = queryDim.stream().map(Prop::toFullName).collect(Collectors.toList());
        return VchDimFilterService.VDFContext.createByVch(filterInfo.getLong("accounttable"), dims);
    }

    @Override
    protected Tuple<DataSet, Integer> doVchQueryWithBalDimSummary(DataSet balDimCountDs, List<QFilter> extraFilters, QFilter[] oriFilters, String selectFields, String orderBy, int top) {
        HashMap<String, Set<Long>> inLimitValues = new HashMap<String, Set<Long>>();
        HashMap<String, Set<Long>> onLimitValues = new HashMap<String, Set<Long>>();
        List<String> balGroupAndOrderBy = this.getBalQueryDims();
        balGroupAndOrderBy.forEach(field -> {
            inLimitValues.put((String)field, new HashSet());
            onLimitValues.put((String)field, new HashSet());
        });
        int count = 0;
        int preCount = 0;
        boolean collectedEnoughData = false;
        boolean containOtherDim = false;
        for (Row row : balDimCountDs) {
            if (!collectedEnoughData) {
                preCount = count;
                if ((count += row.getInteger("count").intValue()) < top) {
                    for (String field2 : balGroupAndOrderBy) {
                        ((Set)inLimitValues.get(field2)).add(row.getLong(field2));
                    }
                    continue;
                }
                collectedEnoughData = true;
                for (String field2 : balGroupAndOrderBy) {
                    ((Set)onLimitValues.get(field2)).add(row.getLong(field2));
                }
                continue;
            }
            containOtherDim = balGroupAndOrderBy.stream().allMatch(field -> ((Set)inLimitValues.get(field)).contains(row.getLong(field)));
            if (!containOtherDim) continue;
            break;
        }
        LOGGER.info(String.format("count %s, preCount %s, collectedEnoughData %s, containOtherDim %s", count, preCount, collectedEnoughData, containOtherDim));
        if (count < top) {
            DataSet allSize = this.doExtVoucherQuery(selectFields, extraFilters.toArray(new QFilter[0]), null, top, inLimitValues);
            return new Tuple((Object)allSize, (Object)count);
        }
        String orderByInSql = null;
        if (containOtherDim) {
            orderByInSql = String.join((CharSequence)", ", this.getVchQueryDims());
        }
        DataSet inSize = this.doExtVoucherQuery(selectFields, extraFilters.toArray(new QFilter[0]), orderByInSql, preCount, inLimitValues);
        DataSet leavedSize = this.doExtVoucherQuery(selectFields, extraFilters.toArray(new QFilter[0]), null, top - preCount, onLimitValues);
        DataSet vchDS = inSize.union(leavedSize);
        return new Tuple((Object)vchDS, (Object)top);
    }

    @Override
    protected Tuple<DataSet, Integer> doCustomFilterQuery(QFilter[] oriFilters, String selectFields, String orderBy, int top) {
        DataSet vchDs = VoucherQueryUtils.queryDataSet((String)selectFields, (QFilter[])oriFilters, null, (int)-1);
        return new Tuple((Object)vchDs, (Object)-1);
    }
}

