/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.dimquery.vdf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.vo.SimpleFilter;
import kd.fi.gl.voucher.dimquery.vdf.AccountVDF;
import kd.fi.gl.voucher.dimquery.vdf.ComAssistVDF;
import kd.fi.gl.voucher.dimquery.vdf.SimpleVDF;
import kd.fi.gl.voucher.dimquery.vdf.StatusVDF;
import kd.fi.gl.voucher.dimquery.vdf.VchDimFilterService;

public class VDFFactory {
    private static final Map<String, String> VCH_2_BAL = new HashMap<String, String>(4){
        {
            this.put("org", "org");
            this.put("booktype", "booktype");
            this.put("period", "period");
            this.put("entries.account.masterid", "account");
            this.put("entries.currency", "currency");
            this.put("entries.measureunit", "measureunit");
        }
    };
    private static final Map<String, String> BAL_2_VCH = VCH_2_BAL.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));

    public static String getVchDim(String balDim) {
        String vchDim = BAL_2_VCH.get(balDim);
        if (balDim.contains("comassist")) {
            vchDim = "entries." + balDim;
        }
        return vchDim;
    }

    public static String getBalDim(String vchDim) {
        String balDim = VCH_2_BAL.get(vchDim);
        if (vchDim.contains("comassist")) {
            balDim = vchDim.split("\\.")[1];
        }
        return balDim;
    }

    public static boolean existCustomFilter(SimpleFilter[] oriVchFilters) {
        return Arrays.stream(oriVchFilters).map(VDFFactory::getOptionalVDFService).anyMatch(vdf -> !vdf.isPresent());
    }

    public static VchDimFilterService getVDFService(SimpleFilter vchFilter) {
        return VDFFactory.getOptionalVDFService(vchFilter).orElseThrow(() -> new IllegalArgumentException(String.format("nonsupport custom filter %s such as account-date-filter.", vchFilter.getProperty())));
    }

    static Optional<VchDimFilterService> getOptionalVDFService(SimpleFilter vchFilter) {
        String filterKey;
        switch (filterKey = vchFilter.getProperty()) {
            case "entries.eorg": 
            case "entries.eperiod": {
                return Optional.of(new VchDimFilterService.RedundancyVDF(filterKey));
            }
            case "org": 
            case "booktype": 
            case "period": 
            case "entries.measureunit": 
            case "entries.currency": {
                return Optional.of(new SimpleVDF(filterKey));
            }
            case "entries.account": {
                return Optional.of(new AccountVDF());
            }
            case "billstatus": {
                HashSet<String> statusSet = new HashSet<String>(4);
                Object value = vchFilter.getValue();
                if (value instanceof String[]) {
                    statusSet.addAll(Arrays.asList((String[])value));
                } else if (value instanceof Collection) {
                    ((Collection)value).forEach(x -> statusSet.add(x.toString()));
                } else {
                    statusSet.add(value.toString());
                }
                if (statusSet.size() == 2 && statusSet.remove("B") && statusSet.remove("C")) {
                    return Optional.of(new StatusVDF());
                }
                return Optional.empty();
            }
        }
        Set vchComAssistKeys = ComAssistTable.getMaxCommonAssistKeys().stream().map(k -> "entries." + k).collect(Collectors.toSet());
        if (vchComAssistKeys.contains(filterKey)) {
            return Optional.of(new ComAssistVDF(filterKey));
        }
        return Optional.empty();
    }

    public static VchDimFilterService getVDFServiceByBalDim(String balDim) {
        String vchDim = VDFFactory.getVchDim(balDim);
        switch (balDim) {
            case "org": 
            case "booktype": 
            case "period": 
            case "measureunit": 
            case "currency": {
                return new SimpleVDF(vchDim);
            }
            case "account": {
                return new AccountVDF();
            }
        }
        HashSet<String> vchComAssistKeys = new HashSet<String>(ComAssistTable.getMaxCommonAssistKeys());
        if (vchComAssistKeys.contains(balDim)) {
            return new ComAssistVDF(vchDim);
        }
        throw new IllegalArgumentException();
    }
}

