/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrent.constant;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;

public class AcccurrentFormula {
    private static final String IS_UNDUE = "1";
    private static final String CACULATE_BY_EXPIREDATE = "1";
    private static final String IS_LOCALCURRENCY = "-1";
    private String key;
    private String acctAssistListStr;
    private String currencyNumber;
    private Date expireDate;
    private int agingDayFrom;
    private int agingDayTo;
    private boolean isCaculatebyExpireDate;
    private boolean isUnDue;
    private boolean isLocalCurrency;
    private Map<Long, Map<String, Set<Object>>> acctToAssistMap;

    public AcccurrentFormula(Map.Entry<String, Object> entry) throws ParseException {
        this.key = entry.getKey();
        List paramFields = (List)entry.getValue();
        this.acctAssistListStr = (String)paramFields.get(2);
        this.currencyNumber = (String)paramFields.get(3);
        Object expireObj = paramFields.get(4);
        if (!StringUtils.isBlank(expireObj)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.expireDate = simpleDateFormat.parse((String)expireObj);
        }
        this.agingDayFrom = Integer.parseInt((String)paramFields.get(5));
        this.agingDayTo = Integer.parseInt((String)paramFields.get(6));
        this.isCaculatebyExpireDate = "1".equals(paramFields.get(7));
        this.isUnDue = "1".equals(paramFields.get(9));
        if (paramFields.size() > 10) {
            this.isLocalCurrency = IS_LOCALCURRENCY.equals(paramFields.get(10));
        }
    }

    public String getKey() {
        return this.key;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public int getAgingDayFrom() {
        return this.agingDayFrom;
    }

    public int getAgingDayTo() {
        return this.agingDayTo;
    }

    public boolean isCaculatebyExpireDate() {
        return this.isCaculatebyExpireDate;
    }

    public boolean isUnDue() {
        return this.isUnDue;
    }

    public void setCurrencyNumber(String currencyNum) {
        this.currencyNumber = currencyNum;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public String getAcctAssistListStr() {
        return this.acctAssistListStr;
    }

    public Map<String, Set<Object>> getAcctToAssistMap(Long accountId) {
        return this.acctToAssistMap.get(accountId);
    }

    public void setAcctToAssistMap(Map<Long, Map<String, Set<Object>>> acctToAssistMap) {
        this.acctToAssistMap = acctToAssistMap;
    }

    public boolean isLocalCurrency() {
        return this.isLocalCurrency;
    }
}

