/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrent.formater;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.acccurrent.constant.AcccurrentFormula;
import kd.fi.gl.acct.handle.MakeBaseDateDetailHelper;
import kd.fi.gl.util.ReClassUtils;

public class AccountNumIDParam {
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private static final String FLEXFIELD = "flexfield";
    private static final String VALUETYPE = "valuetype";
    private Map<String, String> errorInfoMap = new HashMap<String, String>();
    private Set<String> acctNumberSet = new HashSet<String>();
    private Set<String> acctRangeNumberSet = new HashSet<String>();
    private Map<String, Set<String>> assistToValNumbersMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> assistToValRangeNumbersMap = new HashMap<String, Set<String>>();
    private Map<String, Long> acctNumberToIdsMap = new HashMap<String, Long>();
    private Map<String, Set<Long>> acctRangeKeyToIdsMap = new HashMap<String, Set<Long>>();
    private Map<Long, Long> acctIdToMasterIdMap = new HashMap<Long, Long>();
    private Map<Long, Set<Long>> acctToAllLeafMap = new HashMap<Long, Set<Long>>();
    private Set<Long> allLeafMasterIds = new HashSet<Long>();
    private Map<Long, Set<String>> acctToAcccurrentFlexsMap = new HashMap<Long, Set<String>>();
    private Map<String, String> assistToFlexMap = new HashMap<String, String>();
    private Map<String, Object> assistValNumberToObjMap = new HashMap<String, Object>();
    private Map<String, Set<Object>> assistValRangeNumberToObjsMap = new HashMap<String, Set<Object>>();
    private Set<String> assistNumberAllVal = new HashSet<String>();
    private Set<String> flexAllVal = new HashSet<String>();
    private Map<String, Long> standardMap = new HashMap<String, Long>();
    private Map<String, DataSet> groupMap = new HashMap<String, DataSet>();
    private Long orgId;
    private Long bookTypeId;
    private Long acctTableId;
    private Date bookedDate;

    public AccountNumIDParam(Long orgId, Long bookTypeId, Long acctTableId, List<AcccurrentFormula> formulas, Date bookedDate) {
        this.orgId = orgId;
        this.bookTypeId = bookTypeId;
        this.acctTableId = acctTableId;
        this.bookedDate = bookedDate;
        this.parseAcctFormula(formulas);
    }

    private void parseAcctFormula(List<AcccurrentFormula> formulas) {
        for (AcccurrentFormula formula : formulas) {
            String acctToAssistStr = formula.getAcctAssistListStr();
            this.getBatchAcctAndAssist(acctToAssistStr, formula.getKey());
        }
        QFilter facctBaseData = new QFilter("startdate", "<=", (Object)this.bookedDate);
        facctBaseData = facctBaseData.and(new QFilter("enddate", ">=", (Object)this.bookedDate));
        this.queryAcctId(facctBaseData.copy());
        this.queryDLAndALAcct(facctBaseData.copy());
        this.queryAssistId();
    }

    private void queyAllAcctFlexs(Set<Long> acctIds) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid, checkitementry.asstactitem.flexfield flexfield, checkitementry.asstactitem.valuetype valuetype, checkitementry.enaccheck enaccheck", new QFilter[]{new QFilter("id", "in", acctIds)});
        for (Row row : acctSet) {
            long acctId = row.getLong("id");
            long masterId = row.getLong("masterid");
            String flexField = row.getString(FLEXFIELD);
            this.acctIdToMasterIdMap.put(acctId, masterId);
            if (flexField == null || !row.getBoolean("enaccheck").booleanValue()) continue;
            Set flexs = this.acctToAcccurrentFlexsMap.computeIfAbsent(acctId, x -> new HashSet(4));
            flexs.add(flexField);
        }
    }

    private void queryDLAndALAcct(QFilter facctBaseData) {
        HashSet<Long> acctIds = new HashSet<Long>();
        acctIds.addAll(this.acctNumberToIdsMap.values());
        for (Collection collection : this.acctRangeKeyToIdsMap.values()) {
            acctIds.addAll(collection);
        }
        this.getMasterIdByAcctId(acctIds);
        this.queryAcctAllLeaf(facctBaseData.copy());
        this.filterBaseAcct();
        Iterator<Set<Long>> iterator = acctIds.iterator();
        while (iterator.hasNext()) {
            long l = (Long)((Object)iterator.next());
            Set<Long> allLeafAcctIds = this.acctToAllLeafMap.get(l);
            if (Objects.isNull(allLeafAcctIds)) {
                allLeafAcctIds = new HashSet<Long>(8);
                allLeafAcctIds.add(l);
                this.acctToAllLeafMap.put(l, allLeafAcctIds);
                continue;
            }
            if (!allLeafAcctIds.isEmpty()) continue;
            this.acctToAllLeafMap.remove(l);
        }
        HashSet<Long> allActtIds = new HashSet<Long>();
        for (Map.Entry<Long, Set<Long>> entry : this.acctToAllLeafMap.entrySet()) {
            allActtIds.add(entry.getKey());
            allActtIds.addAll((Collection<Long>)entry.getValue());
        }
        this.queyAllAcctFlexs(allActtIds);
    }

    private void filterBaseAcct() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("checkitementry.enaccheck", "=", (Object)Character.valueOf('1')));
        Set acctIds = AccountUtils.queryAccountIds((long)this.orgId, (long)this.acctTableId, filters);
        for (Map.Entry<Long, Set<Long>> entry : this.acctToAllLeafMap.entrySet()) {
            Set<Long> leafSet = entry.getValue();
            leafSet.retainAll(acctIds);
        }
    }

    private void getMasterIdByAcctId(Set<Long> acctIds) {
        DataSet acctSet = this.queryDataSet(this.getClass().getName(), "bd_accountview", "id, masterid", new QFilter[]{new QFilter("id", "in", acctIds)});
        for (Row row : acctSet) {
            long id = row.getLong("id");
            long masterId = row.getLong("masterid");
            acctIds.add(masterId);
            this.acctIdToMasterIdMap.put(id, masterId);
        }
    }

    private void queryAcctAllLeaf(QFilter baseFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(baseFilter);
        filters.add(new QFilter("isleaf", "=", (Object)"1"));
        DataSet leafAcctSet = AccountUtils.queryAccountDataSet((long)this.orgId, (long)this.acctTableId, (String)"id, masterid, number, longnumber, checkitementry.enaccheck enaccheck", filters, null);
        for (Row row : leafAcctSet) {
            String[] split;
            String longNumber = row.getString("longnumber");
            for (String number : split = longNumber.split("_")) {
                if (this.acctNumberToIdsMap.get(number) == null) continue;
                long acctId = this.acctNumberToIdsMap.get(number);
                Set leafSet = this.acctToAllLeafMap.computeIfAbsent(acctId, x -> new HashSet());
                leafSet.add(row.getLong("id"));
                this.allLeafMasterIds.add(row.getLong("masterid"));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void queryAssistId() {
        Object flex;
        QFilter fbasedata;
        String entityId;
        String assistNumber;
        HashMap flexToValIdsMap = new HashMap(this.assistNumberAllVal.size());
        HashSet<String> asstactTypeNumbers = new HashSet<String>();
        asstactTypeNumbers.addAll(this.assistNumberAllVal);
        if (!this.assistToValNumbersMap.keySet().isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValNumbersMap.keySet());
        }
        if (!this.assistToValRangeNumbersMap.keySet().isEmpty()) {
            asstactTypeNumbers.addAll(this.assistToValRangeNumbersMap.keySet());
        }
        HashMap<String, Long> numberToDetailGroupMap = new HashMap<String, Long>();
        HashMap<String, String> assistNnumberToEntityMap = new HashMap<String, String>();
        this.getFlexToAssistTypeMap(assistNnumberToEntityMap, numberToDetailGroupMap, asstactTypeNumbers);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
        for (Map.Entry<String, Set<String>> entry : this.assistToValNumbersMap.entrySet()) {
            assistNumber = entry.getKey();
            entityId = (String)assistNnumberToEntityMap.get(assistNumber);
            Set<String> valNumbers = entry.getValue();
            filters.clear();
            fbasedata = null;
            if (this.orgId != 0L && entityId != null && (fbasedata = this.dealBasedataFilter(entityId, this.orgId)) != null) {
                filters.add(fbasedata);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long assistGroupId = (Long)numberToDetailGroupMap.get(assistNumber);
                QFilter qFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistGroupId, (Long)this.orgId);
                if (qFilter != null) {
                    filters.add(qFilter);
                }
                filters.add(new QFilter("group", "=", (Object)assistGroupId));
            }
            HashMap<String, Object> numberToObjsMap = new HashMap<String, Object>();
            if (entityId == null) {
                for (String string : valNumbers) {
                    numberToObjsMap.put(string, string);
                }
            } else {
                Map<String, Set<Long>> numberToIdsMap1 = detailHelper.getDetailAssists(entityId, valNumbers, filters);
                numberToObjsMap.putAll(numberToIdsMap1);
            }
            for (Map.Entry entry2 : numberToObjsMap.entrySet()) {
                this.assistValNumberToObjMap.put(assistNumber + "*" + (String)entry2.getKey(), entry2.getValue());
            }
            flex = this.assistToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            flexToValIdsMap.put(flex, new HashSet(numberToObjsMap.values()));
        }
        for (Map.Entry<String, Set<String>> entry : this.assistToValRangeNumbersMap.entrySet()) {
            assistNumber = entry.getKey();
            entityId = (String)assistNnumberToEntityMap.get(assistNumber);
            Set<String> rangeValNumber = entry.getValue();
            filters.clear();
            fbasedata = null;
            if (this.orgId != 0L && entityId != null) {
                fbasedata = this.dealBasedataFilter(entityId, this.orgId);
            }
            if ("bos_assistantdata_detail".equals(entityId)) {
                long assistGroupId = (Long)numberToDetailGroupMap.get(assistNumber);
                QFilter qFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistGroupId, (Long)this.orgId);
                if (qFilter != null) {
                    filters.add(qFilter);
                }
                filters.add(new QFilter("group", "=", (Object)assistGroupId));
            }
            HashSet<Object> allValIds = new HashSet<Object>();
            flex = rangeValNumber.iterator();
            while (flex.hasNext()) {
                void var15_25;
                String string;
                String key = string = flex.next();
                HashSet<Object> assistValIds = new HashSet<Object>();
                boolean isNoCategory = ReClassUtils.isCollectionNumber(string);
                if (!isNoCategory) {
                    String string2 = string.substring(1, string.length() - 1);
                }
                String[] assisttContinueNumbers = var15_25.split(",");
                if (entityId == null) {
                    assistValIds.addAll(Arrays.asList(assisttContinueNumbers));
                    allValIds.addAll(assistValIds);
                    this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                    continue;
                }
                DataSet assistSet = null;
                if (!isNoCategory) {
                    if (fbasedata != null) {
                        filters.add(fbasedata.copy());
                    }
                    assistSet = this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), filters, "masterid", entityId);
                } else {
                    assistSet = this.queryAssistValByGroup((String)var15_25, entityId);
                }
                if (assistSet == null) continue;
                for (Row row : assistSet) {
                    assistValIds.add(row.getLong("masterid"));
                }
                if (!isNoCategory && detailHelper.hasParent(entityId)) {
                    Set<Object> assistValIds1 = detailHelper.getDetailAssisttContinueNumbers(entityId, assistValIds, filters);
                    assistValIds.addAll(assistValIds1);
                }
                this.assistValRangeNumberToObjsMap.put(assistNumber + "*" + key, assistValIds);
                allValIds.addAll(assistValIds);
            }
            flex = this.assistToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            Set<Object> set = flexToValIdsMap.get(flex) == null ? new HashSet() : (Set)flexToValIdsMap.get(flex);
            set.addAll(allValIds);
            flexToValIdsMap.put(flex, set);
        }
        for (String assistNumber2 : this.assistNumberAllVal) {
            String flex2 = this.assistToFlexMap.get(assistNumber2);
            if (StringUtils.isBlank((CharSequence)flex2)) continue;
            this.flexAllVal.add(flex2);
        }
        for (String flex3 : this.flexAllVal) {
            flexToValIdsMap.put(flex3, new HashSet());
        }
    }

    private QFilter dealBasedataFilter(String entityId, long orgId) {
        QFilter qf = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId);
        return qf;
    }

    private void getFlexToAssistTypeMap(Map<String, String> numberToEntityMap, Map<String, Long> numberToDetailGroupMap, Set<String> asstactTypeNumbers) {
        QFilter fnumber = new QFilter("number", "in", asstactTypeNumbers);
        QFilter flexidFilter = new QFilter("flexid", "in", (Object)2);
        DataSet asstactSet = this.queryDataSet(this.getClass().getName(), ASSIST_TYPE, "number,valuetype,assistanttype,valuesource,flexfield", new QFilter[]{fnumber, flexidFilter});
        for (Row row : asstactSet) {
            long assistGroupId = 0L;
            String valType = row.getString(VALUETYPE);
            String entityId = null;
            switch (valType) {
                case "1": {
                    entityId = row.getString("valuesource");
                    break;
                }
                case "2": {
                    entityId = "bos_assistantdata_detail";
                    assistGroupId = row.getLong("assistanttype");
                    break;
                }
                case "3": {
                    entityId = null;
                }
            }
            String number = row.getString("number");
            String flex = row.getString(FLEXFIELD);
            this.assistToFlexMap.put(number, flex);
            if (assistGroupId != 0L) {
                numberToDetailGroupMap.put(number, assistGroupId);
            }
            numberToEntityMap.put(number, entityId);
        }
    }

    private void getBatchAcctAndAssist(String acctAssistListStr, String acctKeyId) {
        acctAssistListStr = acctAssistListStr.replaceAll("\\|", "\\| ");
        String[] accountValues = acctAssistListStr.split("\\|");
        String accountNumberStr = "";
        if (accountValues.length == 1) {
            accountNumberStr = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                this.errorInfoMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u683c\u5f0f\u6709\u8bef\u3002", (String)"AccountNumIDParam_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
                return;
            }
            accountNumberStr = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)accountNumberStr)) {
            this.errorInfoMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"AccountNumIDParam_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
            return;
        }
        boolean isContinueAcct = this.isContinueNumber(accountNumberStr);
        if (!isContinueAcct) {
            String[] accts = accountNumberStr.split(",");
            this.acctNumberSet.addAll(Arrays.asList(accts));
        } else {
            this.acctRangeNumberSet.add(accountNumberStr);
        }
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            if (StringUtils.isBlank((CharSequence)assistNumber)) continue;
            HashSet<String> vals = new HashSet<String>();
            String rangeVals = "";
            String valStr = accountValues[i + 1].trim();
            if (!StringUtils.isBlank((CharSequence)valStr)) {
                if (ReClassUtils.isContinueNumber(valStr)) {
                    rangeVals = valStr;
                    HashSet<String> rangeValNumbers = this.assistToValRangeNumbersMap.get(assistNumber) == null ? new HashSet<String>() : this.assistToValRangeNumbersMap.get(assistNumber);
                    rangeValNumbers.add(rangeVals);
                    this.assistToValRangeNumbersMap.put(assistNumber, rangeValNumbers);
                    continue;
                }
                String[] valList = valStr.split(",");
                vals.addAll(Arrays.asList(valList));
                Set<String> valNumbers = this.assistToValNumbersMap.get(assistNumber);
                if (valNumbers == null) {
                    valNumbers = new HashSet<String>();
                    valNumbers.addAll(vals);
                } else {
                    if (valNumbers.size() == 0) continue;
                    valNumbers.addAll(vals);
                }
                this.assistToValNumbersMap.put(assistNumber, valNumbers);
                continue;
            }
            this.assistNumberAllVal.add(assistNumber);
        }
    }

    private boolean isContinueNumber(String numberStr) {
        if (!StringUtils.isBlank((CharSequence)numberStr)) {
            return numberStr.contains("[") && numberStr.contains("]");
        }
        return false;
    }

    private void queryAcctId(QFilter facctBaseData) {
        QFilter fnumbers = new QFilter("number", "in", this.acctNumberSet);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(facctBaseData.copy());
        filters.add(fnumbers);
        DataSet acctSet = AccountUtils.queryAccountDataSet((long)this.orgId, (long)this.acctTableId, (String)"id, number, masterid,dc", filters);
        for (Row row : acctSet) {
            long acctId = row.getLong("id");
            String number = row.getString("number");
            this.acctNumberToIdsMap.put(number, acctId);
        }
        for (String acctRangeNumber : this.acctRangeNumberSet) {
            ArrayList<QFilter> rangFilters = new ArrayList<QFilter>();
            rangFilters.add(facctBaseData.copy());
            String key = acctRangeNumber;
            acctRangeNumber = acctRangeNumber.substring(1, acctRangeNumber.length() - 1);
            String[] acctContinueNumbers = acctRangeNumber.split(",");
            DataSet rangeAcctSet = this.queryContinueNumber(Arrays.asList(acctContinueNumbers), rangFilters, "id,masterid,dc,level,number", "bd_accountview");
            HashSet<Long> acctIds = new HashSet<Long>();
            int level = 0;
            for (Row row : rangeAcctSet) {
                if (level == 0) {
                    level = row.getInteger("level");
                }
                if (level != row.getInteger("level")) continue;
                long acctId = row.getLong("id");
                acctIds.add(acctId);
                this.acctNumberToIdsMap.put(row.getString("number"), acctId);
            }
            this.acctRangeKeyToIdsMap.put(key, acctIds);
        }
    }

    private DataSet queryContinueNumber(List<String> acctNumbers, List<QFilter> filters, String sel, String entityName) {
        if (acctNumbers != null && acctNumbers.size() == 2) {
            String acctNumber0 = acctNumbers.get(0);
            String acctNumber1 = acctNumbers.get(1);
            QFilter filterMin = new QFilter("number", ">=", (Object)acctNumber0);
            QFilter filterMax = new QFilter("number", "<=", (Object)acctNumber1);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.addAll(filters);
            filterList.add(filterMin);
            filterList.add(filterMax);
            DataSet acctSet = QueryServiceHelper.queryDataSet((String)"ReClassUtils.queryDataSet", (String)entityName, (String)sel, (QFilter[])filterList.toArray(new QFilter[0]), (String)"number");
            return acctSet;
        }
        return null;
    }

    private Set<Long> queryLeafCategory(String categoryNumber, String entityId) {
        entityId = entityId + "group";
        String[] assisttContinueNumbers = null;
        String sel = "parent pid, id, isleaf";
        DataSet dataSet = null;
        if (categoryNumber.startsWith("[")) {
            categoryNumber = categoryNumber.substring(1, categoryNumber.length() - 1);
            assisttContinueNumbers = categoryNumber.split(",");
            dataSet = this.queryContinueNumber(Arrays.asList(assisttContinueNumbers), new ArrayList<QFilter>(), sel, entityId);
        } else if (categoryNumber.contains(",")) {
            String[] categroyList = categoryNumber.split(",");
            QFilter fid = new QFilter("number", "in", (Object)categroyList);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        } else {
            QFilter fid = new QFilter("number", "=", (Object)categoryNumber);
            dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        }
        HashSet<Long> allIds = new HashSet<Long>();
        HashSet<Long> noLeafIds = new HashSet<Long>();
        this.getLeafAndNoLeaf(dataSet, noLeafIds, allIds);
        this.getAllLeaf(noLeafIds, entityId, allIds);
        return allIds;
    }

    private DataSet queryAssistValByGroup(String categoryNumber, String entityId) {
        String groupKey = entityId.substring(3);
        String[] categoryList = categoryNumber.split("#");
        if (categoryList.length != 2) {
            return null;
        }
        String standardNumber = categoryList[0];
        long standardId = 0L;
        if (this.standardMap.get(entityId + "*" + standardNumber) == null) {
            DataSet standardSet = this.queryDataSet(this.getClass().getName(), entityId + "groupstandard", "id", new QFilter[]{new QFilter("number", "=", (Object)standardNumber)});
            for (Row row : standardSet) {
                standardId = row.getLong("id");
            }
            this.standardMap.put(entityId + "*" + standardNumber, standardId);
        } else {
            standardId = this.standardMap.get(entityId + "*" + standardNumber);
        }
        String groupNumber = categoryList[1];
        DataSet assistSet = null;
        if (this.groupMap.get(entityId + "*" + groupNumber) == null) {
            Set<Long> allGroupIds = this.queryLeafCategory(groupNumber, entityId);
            QFilter fgid = new QFilter("group", "in", allGroupIds);
            QFilter fstandard = new QFilter("standard", "=", (Object)standardId);
            String sel = groupKey + " masterid";
            assistSet = this.queryDataSet(this.getClass().getName(), entityId + "groupdetail", sel, new QFilter[]{fgid, fstandard});
            this.groupMap.put(entityId + "*" + groupNumber, assistSet);
        } else {
            assistSet = this.groupMap.get(entityId + "*" + groupNumber);
        }
        return assistSet;
    }

    private DataSet queryDataSet(String algoKey, String entityId, String sel, QFilter[] filters) {
        DataSet assistSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityId, (String)sel, (QFilter[])filters, null);
        return assistSet;
    }

    private void getAllLeaf(Set<Long> noLeafIds, String entityId, Set<Long> leafIds) {
        if (noLeafIds.isEmpty()) {
            return;
        }
        QFilter fid = new QFilter("parent", "in", noLeafIds);
        String sel = "id, isleaf";
        DataSet childSet = this.queryDataSet(this.getClass().getName(), entityId, sel, new QFilter[]{fid});
        noLeafIds.clear();
        this.getLeafAndNoLeaf(childSet, noLeafIds, leafIds);
        this.getAllLeaf(noLeafIds, entityId, leafIds);
    }

    private void getLeafAndNoLeaf(DataSet childSet, Set<Long> noLeafIds, Set<Long> allIds) {
        if (childSet == null) {
            return;
        }
        for (Row row : childSet) {
            long id = row.getLong("id");
            if (row.getBoolean("isleaf").booleanValue()) {
                allIds.add(id);
                continue;
            }
            allIds.add(id);
            noLeafIds.add(id);
        }
    }

    public Map<String, Long> getAcctNumberToIdsMap() {
        return this.acctNumberToIdsMap;
    }

    public long getBookTypeId() {
        return this.bookTypeId;
    }

    public Map<String, Set<Long>> getAcctRangeKeyToIdsMap() {
        return this.acctRangeKeyToIdsMap;
    }

    public void setAcctRangeKeyToIdsMap(Map<String, Set<Long>> acctRangeKeyToIdsMap) {
        this.acctRangeKeyToIdsMap = acctRangeKeyToIdsMap;
    }

    public Set<Long> getAllLeafAccounts(Long accountId) {
        return this.acctToAllLeafMap.get(accountId);
    }

    public Set<Long> getAllLeafMasterIds() {
        return this.allLeafMasterIds;
    }

    public Map<Long, Set<String>> getAcctToAcccurrentFlexsMap() {
        return this.acctToAcccurrentFlexsMap;
    }

    public void setAcctToAcccurrentFlexsMap(Map<Long, Set<String>> acctToAcccurrentFlexsMap) {
        this.acctToAcccurrentFlexsMap = acctToAcccurrentFlexsMap;
    }

    public Map<String, String> getAssistToFlexMap() {
        return this.assistToFlexMap;
    }

    public Map<String, Object> getassistValNumberToObjMap() {
        return this.assistValNumberToObjMap;
    }

    public Map<String, Set<Object>> getassistValRangeNumberToObjsMap() {
        return this.assistValRangeNumberToObjsMap;
    }

    public Map<String, String> getErrorInfoMap() {
        return this.errorInfoMap;
    }

    public Long getMasterIdByAcctId(Long acctId) {
        return this.acctIdToMasterIdMap.get(acctId);
    }
}

