/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.acccurrentfloat.constant.AcccurrentFloatParam;
import kd.fi.gl.acccurrentfloat.constant.AcccurrentFormula;
import kd.fi.gl.acccurrentfloat.constant.BCMAcccurrentFloatContext;
import kd.fi.gl.acct.action.AcctBalParseAction;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.ReClassUtils;

public class AcccurrentFloatParseAction {
    private static final String BD_ACCOUNTBOOKSTYPE = "bd_accountbookstype";
    private static final Log log = LogFactory.getLog(AcctBalParseAction.class);

    public Map<String, Map<String, Object>> parseParam(AcccurrentFloatParam floatParam) {
        try {
            this.printLog(floatParam);
            Map<String, Object> paramMap = floatParam.getAcctFormulaMap();
            this.checkFormulaSizeLimit(paramMap);
            boolean isBatch = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.acctage.float.formula.batch", (boolean)false);
            if (isBatch) {
                return this.batchParse(floatParam);
            }
            BCMAcccurrentFloatContext context = this.getContext(floatParam);
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                try {
                    this.addFormulaToContext(entry, context);
                }
                catch (Exception e) {
                    log.error("\u91cd\u5206\u7c7b\u53d6\u6570\u516c\u5f0f\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
                    context.addErrorRst(entry.getKey(), e.getMessage());
                }
            }
            return context.complie();
        }
        catch (Exception e) {
            log.error("\u91cd\u5206\u7c7b\u53d6\u6570\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("error", e.getMessage()), new Object[0]);
        }
    }

    private Map<String, Map<String, Object>> batchParse(AcccurrentFloatParam floatParam) throws Exception {
        Map<String, Object> paramMap = floatParam.getAcctFormulaMap();
        int batchSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.acctage.float.formula.batch.size", (int)100);
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(128);
        HashMap<String, Object> singleParamMap = new HashMap<String, Object>(128);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            singleParamMap.put(entry.getKey(), entry.getValue());
            if (singleParamMap.size() != batchSize) continue;
            resultMap.putAll(this.singleParse(floatParam, singleParamMap));
            singleParamMap.clear();
            this.checkResultMapSize(resultMap);
        }
        if (!singleParamMap.isEmpty()) {
            resultMap.putAll(this.singleParse(floatParam, singleParamMap));
            this.checkResultMapSize(resultMap);
        }
        return resultMap;
    }

    private void checkResultMapSize(Map<String, Map<String, Object>> resultMap) {
        int limitSize;
        int size = resultMap.entrySet().stream().mapToInt(x -> ((Map)x.getValue()).size()).sum();
        if (size > (limitSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.acct.function.result.size", (int)200000))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u67e5\u8be2\u7684\u7ed3\u679c\u6570\u91cf\u8d85\u51fa\u9650\u5236%1$d\uff0c\u8bf7\u8c03\u5c0f\u516c\u5f0f\u91cf\u3002", (String)"AcccurrentParseAction_6", (String)"fi-gl-mservice", (Object[])new Object[0]), limitSize));
        }
    }

    private Map<String, Map<String, Object>> singleParse(AcccurrentFloatParam floatParam, Map<String, Object> singleParamMap) throws Exception {
        BCMAcccurrentFloatContext context = this.getContext(floatParam);
        for (Map.Entry<String, Object> entry : singleParamMap.entrySet()) {
            try {
                this.addFormulaToContext(entry, context);
            }
            catch (Exception e) {
                log.error("\u91cd\u5206\u7c7b\u53d6\u6570\u516c\u5f0f\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
                context.addErrorRst(entry.getKey(), e.getMessage());
            }
        }
        return context.complie();
    }

    private void checkFormulaSizeLimit(Map<String, Object> fomulaMap) {
        int formulaSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.acctage.float.formula.size", (int)500);
        if (fomulaMap != null && fomulaMap.size() > formulaSize) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u7684\u6d6e\u52a8\u516c\u5f0f\u6570\u91cf\u8d85\u51fa\u9650\u5236%1$d", (String)"AcccurrentParseAction_3", (String)"fi-gl-mservice", (Object[])new Object[0]), formulaSize));
        }
    }

    private BCMAcccurrentFloatContext getContext(AcccurrentFloatParam floatParam) {
        String defaultOrgNumber = floatParam.getComOrgNumber();
        Map<String, Long> mainBookTypeMap = this.getMainBookType();
        String mainBookTypeNumber = "";
        if (!mainBookTypeMap.isEmpty()) {
            mainBookTypeNumber = mainBookTypeMap.keySet().iterator().next();
        }
        if (StringUtils.isBlank((CharSequence)mainBookTypeNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u7684\u7ec4\u7ec7\u53d6\u4e0d\u5230\u4e3b\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"AcccurrentParseAction_1", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        Map<String, Object> commMap = floatParam.getCommParamMap();
        if (commMap == null || commMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u4e3a\u7a7a", (String)"AcccurrentParseAction_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        String defaultCurNumber = (String)commMap.get("currency");
        BCMAcccurrentFloatContext context = new BCMAcccurrentFloatContext();
        context.setDefaultOrgNumber(defaultOrgNumber);
        context.setDefaultBookTypeNumber(mainBookTypeNumber);
        context.setDefaultCurNumber(defaultCurNumber);
        context.setDefaultFy(floatParam.getComYear());
        context.setDefaultPeriod(floatParam.getComPeriod());
        context.setRefParamMap(floatParam.getRefParamMap());
        return context;
    }

    private void addFormulaToContext(Map.Entry<String, Object> entry, BCMAcccurrentFloatContext context) {
        String tmpBookTypeNumber;
        List paramFields = (List)entry.getValue();
        String tmpOrgNumber = (String)paramFields.get(0);
        if (StringUtils.isEmpty((CharSequence)tmpOrgNumber)) {
            tmpOrgNumber = context.getDefaultOrgNumber();
        }
        if (StringUtils.isEmpty((CharSequence)(tmpBookTypeNumber = (String)paramFields.get(1)))) {
            tmpBookTypeNumber = context.getDefaultBookTypeNumber();
        }
        Date bookedDate = null;
        try {
            Object strDate = paramFields.get(8);
            if (!StringUtils.isBlank(strDate)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                bookedDate = simpleDateFormat.parse((String)strDate);
            }
            AcccurrentFormula formula = new AcccurrentFormula(entry);
            context.addFormula(tmpOrgNumber, tmpBookTypeNumber, bookedDate, formula);
        }
        catch (ParseException e) {
            context.addErrorRst(entry.getKey(), GLUtil.printError((Throwable)e));
        }
    }

    private Map<String, Long> getMainBookType() {
        HashMap<String, Long> numberToIdMap = new HashMap<String, Long>();
        QFilter ftype = new QFilter("accounttype", "=", (Object)"1");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ftype);
        DataSet bookTypeSet = ReClassUtils.queryDataSet(BD_ACCOUNTBOOKSTYPE, "id,number", filters);
        for (Row row : bookTypeSet) {
            long bookTypeId = row.getLong("id");
            String bookTypeNumber = row.getString("number");
            numberToIdMap.put(bookTypeNumber, bookTypeId);
        }
        return numberToIdMap;
    }

    private void printLog(AcccurrentFloatParam floatParam) {
        this.logInfo(ResManager.loadKDString((String)"\u62a5\u8868\u53c2\u6570\uff1a%1$s,\u7ec4\u7ec7\u7f16\u7801\uff1a%2$s,\u671f\u95f4\uff1a%3$s", (String)"AcccurrentParseAction_2", (String)"fi-gl-mservice", (Object[])new Object[]{floatParam.getComAcctReClass(), floatParam.getComOrgNumber(), floatParam.getComPeriod()}));
        Map<String, Object> paramMap = floatParam.getAcctFormulaMap();
        int logIndex = 1;
        int logCount = 1;
        StringBuilder logBuilder = new StringBuilder();
        if (paramMap.size() > 1000) {
            this.logInfo(paramMap.toString());
            return;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if (logCount > 100) {
                logBuilder.append(entry);
                this.logInfo(logIndex + "\uff1a" + logBuilder);
                logBuilder = new StringBuilder();
                ++logIndex;
                logCount = 0;
                continue;
            }
            logBuilder.append(entry);
            ++logCount;
        }
        if (logIndex == 1) {
            this.logInfo(logBuilder.toString());
        } else {
            this.logInfo(logIndex + "\uff1a" + logBuilder);
        }
    }

    private void logInfo(String msg) {
        log.info("ACCTAGE\u6d6e\u52a8\u516c\u5f0f\uff1a" + msg);
    }
}

