/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat.constant;

import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;

public class AcccurrentFormula {
    private static final String IS_UNDUE = "1";
    private static final String CACULATE_BY_EXPIREDATE = "1";
    private static final String IS_LOCALCURRENCY = "-1";
    private String key;
    private String acctAssistListStr;
    private String currencyNumber;
    private Date expireDate;
    private int agingDayFrom;
    private int agingDayTo;
    private boolean isCaculatebyExpireDate;
    private boolean isUnDue;
    private boolean isLocalCurrency;
    private Set<Long> accountIds;
    private Map<String, Set<Object>> nonFloatAssgrpMap = new HashMap<String, Set<Object>>(4);
    Map<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(1024);
    List<String> floatAssistNumbers = new ArrayList<String>(8);
    List<String> floatFlexList = new ArrayList<String>(4);
    List<String> nonFloatAssistNumbers = new ArrayList<String>(8);
    private String errorMsg;
    private Range<Date> ageDateRange;

    public Map<String, Set<Object>> getNonFloatAssgrpMap() {
        return this.nonFloatAssgrpMap;
    }

    public void setNonFloatAssgrpMap(Map<String, Set<Object>> nonFloatAssgrpMap) {
        this.nonFloatAssgrpMap = nonFloatAssgrpMap;
    }

    public List<String> getNonFloatAssistNumbers() {
        return this.nonFloatAssistNumbers;
    }

    public void addNonFloatAssistNumber(String nonFloatAssistNumber) {
        this.nonFloatAssistNumbers.add(nonFloatAssistNumber);
    }

    public List<String> getFloatAssistNumbers() {
        return this.floatAssistNumbers;
    }

    public List<String> getFloatFlexList() {
        return this.floatFlexList;
    }

    public void setFloatFlexList(List<String> floatFlexList) {
        this.floatFlexList = floatFlexList;
    }

    public Range<Date> getAgeRange() {
        if (this.ageDateRange == null) {
            if (this.expireDate == null) {
                return null;
            }
            int ageFrom = this.agingDayFrom;
            Range daysRange = !this.isUnDue ? Range.closed((Comparable)Integer.valueOf(ageFrom), (Comparable)Integer.valueOf(this.agingDayTo)) : Range.closed((Comparable)Integer.valueOf(-1 * this.agingDayTo), (Comparable)Integer.valueOf(-1 * ageFrom));
            this.ageDateRange = Range.closed((Comparable)AcccurrentFormula.getLastDay(this.expireDate, (Integer)daysRange.upperEndpoint()), (Comparable)AcccurrentFormula.getLastDay(this.expireDate, (Integer)daysRange.lowerEndpoint()));
        }
        return this.ageDateRange;
    }

    private static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public AcccurrentFormula(Map.Entry<String, Object> entry) throws ParseException {
        this.key = entry.getKey();
        List paramFields = (List)entry.getValue();
        this.acctAssistListStr = (String)paramFields.get(2);
        this.currencyNumber = (String)paramFields.get(3);
        Object expireObj = paramFields.get(4);
        if (!StringUtils.isBlank(expireObj)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.expireDate = simpleDateFormat.parse((String)expireObj);
        }
        this.agingDayFrom = Integer.parseInt((String)paramFields.get(5));
        this.agingDayTo = Integer.parseInt((String)paramFields.get(6));
        this.sortAgeDayFromAndTo();
        this.isCaculatebyExpireDate = "1".equals(paramFields.get(7));
        this.isUnDue = "1".equals(paramFields.get(9));
        if (paramFields.size() > 10) {
            this.isLocalCurrency = "basecurrency".equalsIgnoreCase(this.currencyNumber) || StringUtils.isEmpty((CharSequence)this.currencyNumber) ? true : IS_LOCALCURRENCY.equals(paramFields.get(10));
        }
    }

    public void setDefaultExpireDate(Date defaultExpireDate) {
        if (StringUtils.isBlank((Object)this.expireDate)) {
            this.expireDate = defaultExpireDate;
        }
    }

    private void sortAgeDayFromAndTo() {
        if (this.agingDayFrom > this.agingDayTo) {
            int timesMin = this.agingDayTo;
            int timesMax = this.agingDayFrom;
            this.agingDayFrom = timesMin;
            this.agingDayTo = timesMax;
        }
    }

    public void addFloatAssistNumber(String floatAssistNumber) {
        this.floatAssistNumbers.add(floatAssistNumber);
    }

    public void add(BigDecimal amount, Map<String, Set<String>> flexToValNumbersMap) {
        HashSet<StringBuilder> builderSet = new HashSet<StringBuilder>(4);
        HashSet<StringBuilder> lastBuilderSet = new HashSet<StringBuilder>(4);
        StringBuilder emptyBuilder = new StringBuilder();
        builderSet.add(emptyBuilder);
        for (String refFlex : this.floatFlexList) {
            lastBuilderSet.clear();
            lastBuilderSet.addAll(builderSet);
            builderSet.clear();
            Set<String> valNumbers = flexToValNumbersMap.get(refFlex);
            for (StringBuilder lastBuilder : lastBuilderSet) {
                for (String number : valNumbers) {
                    StringBuilder curBuilder = new StringBuilder();
                    curBuilder.append((CharSequence)lastBuilder);
                    curBuilder.append(number);
                    curBuilder.append("|");
                    builderSet.add(curBuilder);
                }
            }
        }
        HashSet<String> numbersKeySet = new HashSet<String>(8);
        for (StringBuilder builder : builderSet) {
            builder.deleteCharAt(builder.length() - 1);
            String key = builder.toString();
            numbersKeySet.add(key);
        }
        for (String numbersKey : numbersKeySet) {
            BigDecimal assAmount = this.resultMap.computeIfAbsent(numbersKey, x -> new BigDecimal("0"));
            assAmount = assAmount.add(amount);
            this.resultMap.put(numbersKey, assAmount);
        }
    }

    public Map<String, BigDecimal> getFormulaAmount() {
        return this.resultMap;
    }

    public String getKey() {
        return this.key;
    }

    public int getAgingDayFrom() {
        return this.agingDayFrom;
    }

    public int getAgingDayTo() {
        return this.agingDayTo;
    }

    public boolean isCaculatebyExpireDate() {
        return this.isCaculatebyExpireDate;
    }

    public boolean isUnDue() {
        return this.isUnDue;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public String getAcctAssistListStr() {
        return this.acctAssistListStr;
    }

    public boolean isLocalCurrency() {
        return this.isLocalCurrency;
    }

    public Set<Long> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Set<Long> accountIds) {
        this.accountIds = accountIds;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Map<String, BigDecimal> getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(Map<String, BigDecimal> resultMap) {
        this.resultMap = resultMap;
    }
}

