/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat.formater;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.gl.acccurrentfloat.formater.AccountNumIDParam;
import kd.fi.gl.util.ReClassUtils;

public class AccountNumberIDFormater {
    public static Tuple<Set<Long>, Map<String, Set<Object>>> parseAcctAssistList(String accountListStr, AccountNumIDParam numberIDParam, String acctKeyId) {
        Map<String, Long> numberToIdMap = numberIDParam.getAcctNumberToIdsMap();
        Map<String, Set<Long>> rangeNumberToIdsMap = numberIDParam.getAcctRangeKeyToIdsMap();
        if (StringUtils.isEmpty((CharSequence)accountListStr)) {
            Map<String, String> errorMap = numberIDParam.getErrorInfoMap();
            errorMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AccountNumberIDFormater_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        String[] accountValues = accountListStr.split("\\|");
        String acctsStr = accountValues[0];
        boolean isContinueAcct = ReClassUtils.isContinueNumber(acctsStr);
        if (StringUtils.isEmpty((CharSequence)acctsStr)) {
            Map<String, String> errorMap = numberIDParam.getErrorInfoMap();
            errorMap.put(acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AccountNumberIDFormater_0", (String)"fi-gl-mservice", (Object[])new Object[0]));
        }
        HashMap<String, Set<Object>> asstMap = new HashMap<String, Set<Object>>();
        Set<Object> acctIds = new HashSet();
        String accountNumber = AccountNumberIDFormater.parseAssistStr(accountListStr, asstMap, numberIDParam);
        if (isContinueAcct) {
            acctIds = rangeNumberToIdsMap.get(accountNumber);
        } else {
            String[] accountList;
            for (String acctNumberStr : accountList = acctsStr.split(",")) {
                Long acctId = numberToIdMap.get(acctNumberStr);
                if (acctId == null) continue;
                acctIds.add(acctId);
            }
        }
        return new Tuple(acctIds, asstMap);
    }

    private static String parseAssistStr(String accountStr, Map<String, Set<Object>> asstMap, AccountNumIDParam numberIDParam) {
        accountStr = accountStr.replaceAll("\\|", "\\| ");
        String[] accountValues = accountStr.split("\\|");
        String accountNumber = "";
        if (accountValues.length == 1) {
            accountNumber = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                return accountNumber;
            }
            accountNumber = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)accountNumber)) {
            return accountNumber;
        }
        Map<String, String> assistNumberToFlexMap = numberIDParam.getAssistToFlexMap();
        Map<String, Set<Object>> valNumberToIdsMap = numberIDParam.getassistValNumberToObjMap();
        Map<String, Set<Object>> valRangeNumberToIdsMap = numberIDParam.getassistValRangeNumberToObjsMap();
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            String flex = assistNumberToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) continue;
            Set<Object> valIds = new HashSet();
            if (StringUtils.isNotEmpty((CharSequence)accountValues[i + 1].trim())) {
                String valStr = accountValues[i + 1].trim();
                boolean isContinue = ReClassUtils.isContinueNumber(valStr);
                if (isContinue) {
                    valIds = valRangeNumberToIdsMap.get(assistNumber + "*" + valStr);
                } else {
                    String[] valList;
                    for (String valNumber : valList = valStr.split(",")) {
                        if (valNumberToIdsMap.get(assistNumber + "*" + valNumber) != null) {
                            valIds.addAll((Collection<Object>)valNumberToIdsMap.get(assistNumber + "*" + valNumber));
                            continue;
                        }
                        valIds.add(null);
                    }
                }
            }
            asstMap.put(flex, valIds);
        }
        return accountNumber;
    }
}

