/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat.matchdata;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import kd.fi.gl.acccurrentfloat.matchdata.AgeAmountVO;

public class AgeDimensionGroup {
    private final long accountId;
    private final long currencyId;
    private final Map<String, Object> flexToValMap;
    private TreeMap<Date, AgeAmountVO> bizAmountMap = new TreeMap();
    private TreeMap<Date, AgeAmountVO> expireAmountMap = new TreeMap();

    public AgeDimensionGroup(Map<String, Object> flexToValMap, long accountId, long currencyId) {
        this.flexToValMap = flexToValMap;
        this.accountId = accountId;
        this.currencyId = currencyId;
    }

    public AgeDimensionGroup putBizDateAmount(Date date, AgeAmountVO amountVO) {
        AgeAmountVO existAmountVO = this.bizAmountMap.get(date = this.clearDateHMS(date));
        if (existAmountVO == null) {
            existAmountVO = new AgeAmountVO(amountVO.getAmountBal(), amountVO.getAmountBalFor());
            this.bizAmountMap.put(date, existAmountVO);
        } else {
            existAmountVO.merge(amountVO);
        }
        return this;
    }

    private Date clearDateHMS(Date date) {
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        return date;
    }

    public AgeAmountVO sumUpBizDateRange(Date fromDate, Date endDate) {
        AgeAmountVO sumVO = new AgeAmountVO(BigDecimal.ZERO, BigDecimal.ZERO);
        this.bizAmountMap.subMap(fromDate, true, endDate, true).entrySet().stream().forEach(x -> sumVO.merge((AgeAmountVO)x.getValue()));
        return sumVO;
    }

    public AgeDimensionGroup putExpireDateAmount(Date date, AgeAmountVO amountVO) {
        AgeAmountVO existAmountVO = this.expireAmountMap.get(date = this.clearDateHMS(date));
        if (existAmountVO == null) {
            existAmountVO = new AgeAmountVO(amountVO.getAmountBal(), amountVO.getAmountBalFor());
            this.expireAmountMap.put(date, existAmountVO);
        } else {
            existAmountVO.merge(amountVO);
        }
        return this;
    }

    public AgeAmountVO sumUpExpireDateRange(Date fromDate, Date endDate) {
        AgeAmountVO sumVO = new AgeAmountVO(BigDecimal.ZERO, BigDecimal.ZERO);
        this.expireAmountMap.subMap(fromDate, true, endDate, true).entrySet().stream().forEach(x -> sumVO.merge((AgeAmountVO)x.getValue()));
        return sumVO;
    }

    public boolean isDimensionEquals(long accountId, long currencyId, Map<String, Object> flexValueMap) {
        return this.accountId == accountId && this.currencyId == currencyId && this.flexToValMap.equals(flexValueMap);
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public Map<String, Object> getFlexToValMap() {
        return this.flexToValMap;
    }

    public void setBizAmountMap(TreeMap<Date, AgeAmountVO> bizAmountMap) {
        this.bizAmountMap = bizAmountMap;
    }

    public void setExpireAmountMap(TreeMap<Date, AgeAmountVO> expireAmountMap) {
        this.expireAmountMap = expireAmountMap;
    }
}

