/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat.matchdata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.gl.acccurrentfloat.constant.AcccurrentFormula;
import kd.fi.gl.acccurrentfloat.matchdata.IFlexToValMatch;

public class SmallMemoryFlexToValMatch
implements IFlexToValMatch {
    Map<String, Map<Object, Set<AcccurrentFormula>>> noFloatFlexToValToFormulaMap = new HashMap<String, Map<Object, Set<AcccurrentFormula>>>(8);
    Map<String, Set<AcccurrentFormula>> floatFlexToFormulasMap = new HashMap<String, Set<AcccurrentFormula>>(4);
    Map<String, Set<Object>> floatFlexToValSetMap;
    Map<String, Set<AcccurrentFormula>> flexToAllValFormulaMap = new HashMap<String, Set<AcccurrentFormula>>(8);

    public SmallMemoryFlexToValMatch(Map<String, Map<String, Set<Object>>> floatFlexValsMap, List<AcccurrentFormula> formulas) {
        for (AcccurrentFormula formula : formulas) {
            List<String> floatFlexList = formula.getFloatFlexList();
            for (String floatFlex : floatFlexList) {
                Set floatFormulaSet = this.floatFlexToFormulasMap.computeIfAbsent(floatFlex, x -> new HashSet(8));
                floatFormulaSet.add(formula);
            }
            Map<String, Set<Object>> nonFloatFormulaAssMap = formula.getNonFloatAssgrpMap();
            for (Map.Entry<String, Set<Object>> entry2 : nonFloatFormulaAssMap.entrySet()) {
                String nonFloatFlex = entry2.getKey();
                Set<Object> objSet = entry2.getValue();
                if (objSet.isEmpty()) {
                    Set allValFormulas = this.flexToAllValFormulaMap.computeIfAbsent(nonFloatFlex, x -> new HashSet(8));
                    allValFormulas.add(formula);
                    continue;
                }
                Map nonFloatFormulaMap = this.noFloatFlexToValToFormulaMap.computeIfAbsent(nonFloatFlex, x -> new HashMap(8));
                for (Object obj : objSet) {
                    Set floatFormulaSet = nonFloatFormulaMap.computeIfAbsent(obj, x -> new HashSet(8));
                    floatFormulaSet.add(formula);
                }
            }
        }
        this.floatFlexToValSetMap = floatFlexValsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).values().stream().flatMap(Collection::stream).collect(Collectors.toSet())));
    }

    @Override
    public Set<AcccurrentFormula> matchFlexValFormula(Map<String, Object> recordeAssMap) {
        HashMap<AcccurrentFormula, Integer> formulaMatchTimes = new HashMap<AcccurrentFormula, Integer>(8);
        for (Map.Entry<String, Object> assMap : recordeAssMap.entrySet()) {
            Set<AcccurrentFormula> allValFormulaSet;
            int matchTime;
            Set<AcccurrentFormula> floatFormulaSet;
            Set<Object> floatVals;
            Set<AcccurrentFormula> valFormulaSet;
            String flex = assMap.getKey();
            Object val = assMap.getValue();
            Map<Object, Set<AcccurrentFormula>> valToFormulasMap = this.noFloatFlexToValToFormulaMap.get(flex);
            if (valToFormulasMap != null && (valFormulaSet = valToFormulasMap.get(val)) != null) {
                for (AcccurrentFormula formula : valFormulaSet) {
                    int matchTime2 = formulaMatchTimes.getOrDefault(formula, 0);
                    formulaMatchTimes.put(formula, ++matchTime2);
                }
            }
            if ((floatVals = this.floatFlexToValSetMap.get(flex)) != null && floatVals.contains(val) && (floatFormulaSet = this.floatFlexToFormulasMap.get(flex)) != null) {
                for (AcccurrentFormula formula : floatFormulaSet) {
                    matchTime = formulaMatchTimes.getOrDefault(formula, 0);
                    formulaMatchTimes.put(formula, ++matchTime);
                }
            }
            if ((allValFormulaSet = this.flexToAllValFormulaMap.get(flex)) == null) continue;
            for (AcccurrentFormula formula : allValFormulaSet) {
                matchTime = formulaMatchTimes.getOrDefault(formula, 0);
                formulaMatchTimes.put(formula, ++matchTime);
            }
        }
        return formulaMatchTimes.entrySet().stream().filter(e -> ((AcccurrentFormula)e.getKey()).getNonFloatAssgrpMap().size() + ((AcccurrentFormula)e.getKey()).getFloatFlexList().size() == (Integer)e.getValue()).map(e -> (AcccurrentFormula)e.getKey()).collect(Collectors.toSet());
    }
}

