/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acct;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.acct.buildparam.AssistIdCollectionType;
import kd.fi.gl.acct.handle.MakeBaseDateDetailHelper;
import kd.fi.gl.acct.param.ReClassNumberIDParam;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.ReClassUtils;

public class AcctUtil {
    public static final String ZERO_PERIOD = "0";
    public static final int EXCEPTION_LEVEL = -1;
    public static final int ERROR_TIP_LEVEL = -2;
    public static final String NONE_KEY = "None";
    private static final int BATCH_SIZE = 1000;
    private static final String COMMON_ASSIST = "commonAssistDim";

    public void acctReClassDeal(int acctReClass, Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, Map<Long, Integer> acctToAssistStyleMap, Map<Long, Set<Long>> acctToRCAcctIdsMap, ReClassNumberIDParam numberIDParam) {
        Map<Long, Set<Long>> directLeafMap = numberIDParam.getAcctToDirectLeafMap();
        Map<Long, Set<Long>> allLeafMap = numberIDParam.getAcctToAllLeafMap();
        Map<Long, Set<String>> acctToFlexMap = numberIDParam.getAcctToFlexsMap();
        HashMap<Long, Map<String, Set<Object>>> acctIdToAssistMapFor = new HashMap<Long, Map<String, Set<Object>>>(64);
        acctIdToAssistMapFor.putAll(acctIdToAssistMap);
        switch (acctReClass) {
            case 1: {
                for (Map.Entry entry : acctIdToAssistMapFor.entrySet()) {
                    long acctId = (Long)entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    if (isSelectAssist) {
                        HashSet<Long> acctIds = new HashSet<Long>(64);
                        acctIds.add(acctId);
                        acctToRCAcctIdsMap.put(acctId, acctIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        Set<Long> directLeafIds = directLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    Set<Long> allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 2: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    Set<Long> allLeafIds;
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    if (isSelectAssist) {
                        allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 3);
                        continue;
                    }
                    allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 3: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    Set<Long> directLeafIds = directLeafMap.get(acctId);
                    if (isSelectAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToRCAcctIdsMap.put(acctId, directLeafIds);
                    acctToAssistStyleMap.put(acctId, 3);
                }
                break;
            }
            case 4: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    Set<Long> allLeafIds = allLeafMap.get(acctId);
                    acctToRCAcctIdsMap.put(acctId, allLeafIds);
                    if (isSelectAssist) {
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
            case 5: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    long acctId = entry.getKey();
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    Set<Long> directLeafIds = directLeafMap.get(acctId);
                    if (isSelectAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctToRCAcctIdsMap.put(acctId, directLeafIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctToRCAcctIdsMap.put(acctId, directLeafIds);
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
            case 6: {
                for (Map.Entry<Long, Map<String, Set<Object>>> entry : acctIdToAssistMap.entrySet()) {
                    HashSet<Long> acctIds;
                    long acctId = entry.getKey();
                    boolean isContainAssist = this.acctIsContainAssistMap(acctToFlexMap, acctId);
                    boolean isSelectAssist = this.isSelectAssist(acctIdToAssistMap, acctId);
                    if (isSelectAssist) {
                        Set<Long> allLeafIds = allLeafMap.get(acctId);
                        acctToRCAcctIdsMap.put(acctId, allLeafIds);
                        acctToAssistStyleMap.put(acctId, 2);
                        continue;
                    }
                    if (!isContainAssist) {
                        acctIds = new HashSet<Long>(16);
                        acctIds.add(acctId);
                        acctToRCAcctIdsMap.put(acctId, acctIds);
                        acctToAssistStyleMap.put(acctId, 1);
                        continue;
                    }
                    acctIds = new HashSet(16);
                    acctIds.add(acctId);
                    acctToRCAcctIdsMap.put(acctId, acctIds);
                    acctToAssistStyleMap.put(acctId, 1);
                }
                break;
            }
        }
    }

    private boolean isSelectAssist(Map<Long, Map<String, Set<Object>>> acctIdToAssistMap, long acctId) {
        Map<String, Set<Object>> assistMap = acctIdToAssistMap.get(acctId);
        boolean isSelectAssist = assistMap != null && !assistMap.isEmpty();
        return isSelectAssist;
    }

    private boolean acctIsContainAssistMap(Map<Long, Set<String>> acctToFlexMap, long acctId) {
        boolean isContainAssist = true;
        Set<String> flexs = acctToFlexMap.get(acctId);
        if (flexs == null || flexs.size() == 0) {
            isContainAssist = false;
        }
        return isContainAssist;
    }

    public boolean isPureCollection(String assistStr, ReClassNumberIDParam numberIDParam) {
        String[] assistValues = assistStr.split("\\|");
        Map<String, String> assistNumberToFlexMap = numberIDParam.getAssistToFlexMap();
        boolean isPureCollection = true;
        for (int i = 1; i < assistValues.length; i += 2) {
            String assistNumber = assistValues[i].trim();
            String flex = assistNumberToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) {
                isPureCollection = false;
                break;
            }
            if (StringUtils.isNotEmpty((CharSequence)assistValues[i + 1].trim())) {
                String valStr = assistValues[i + 1].trim();
                if (ReClassUtils.isCollectionNumber(valStr)) continue;
                isPureCollection = false;
                break;
            }
            isPureCollection = false;
        }
        return isPureCollection;
    }

    public Map<Long, Map<String, Set<Object>>> parseAcctAssistList(String accountListStr, ReClassNumberIDParam numberIDParam, String acctKeyId) {
        HashMap<Long, Map<String, Set<Object>>> acctIdToAssistMap;
        block10: {
            Set<Object> acctIds;
            HashMap<String, Set<Object>> asstMap;
            String acctsStr;
            Map<String, Long> numberToIdMap;
            block9: {
                numberToIdMap = numberIDParam.getAcctNumberToIdsMap();
                Map<String, Set<Long>> rangeNumberToIdsMap = numberIDParam.getAcctRangeKeyToIdsMap();
                if (StringUtils.isEmpty((CharSequence)accountListStr)) {
                    Map<String, Map<String, Object>> errorMap = numberIDParam.getErrorInfoMap();
                    AcctUtil.setErrorMessage(errorMap, acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AcctBalParseAction_14", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                }
                String[] accountValues = accountListStr.split("\\|");
                acctsStr = accountValues[0];
                boolean isContinueAcct = ReClassUtils.isContinueNumber(acctsStr);
                if (StringUtils.isEmpty((CharSequence)acctsStr)) {
                    Map<String, Map<String, Object>> errorMap = numberIDParam.getErrorInfoMap();
                    AcctUtil.setErrorMessage(errorMap, acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u6570\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AcctBalParseAction_14", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                }
                acctIdToAssistMap = new HashMap<Long, Map<String, Set<Object>>>(64);
                asstMap = new HashMap<String, Set<Object>>(8);
                acctIds = new HashSet(16);
                String accountNumber = this.parseAssistStr(accountListStr, asstMap, numberIDParam, acctKeyId);
                if (!isContinueAcct) break block9;
                acctIds = rangeNumberToIdsMap.get(accountNumber);
                if (!CollectionUtils.isNotEmpty(acctIds)) break block10;
                Iterator<Object> iterator = acctIds.iterator();
                while (iterator.hasNext()) {
                    long acctId = (Long)iterator.next();
                    acctIdToAssistMap.put(acctId, asstMap);
                }
                break block10;
            }
            if (StringUtils.isEmpty((CharSequence)acctsStr)) {
                StringBuilder flexsStr = new StringBuilder();
                Set flexs = asstMap.keySet();
                for (String flex : flexs) {
                    flexsStr = flexsStr.append(flex);
                    flexsStr = flexsStr.append("*");
                }
                Map<String, Set<Long>> flexsToAcctIdsMap = numberIDParam.getFlexsToAcctIdsMap();
                acctIds = flexsToAcctIdsMap.get(flexsStr.toString());
                if (acctIds == null) {
                    Map<String, Map<String, Object>> errorMap = numberIDParam.getErrorInfoMap();
                    AcctUtil.setErrorMessage(errorMap, acctKeyId, String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u79d1\u76ee\u4e3a\u7a7a\u4e14\u627e\u4e0d\u5230\u7ef4\u5ea6%s\u5bf9\u5e94\u79d1\u76ee", (String)"AcctUtil_0", (String)"fi-gl-mservice", (Object[])new Object[0]), flexsStr), -1);
                    return acctIdToAssistMap;
                }
                Iterator<Object> iterator = acctIds.iterator();
                while (iterator.hasNext()) {
                    long acctId = (Long)iterator.next();
                    acctIdToAssistMap.put(acctId, asstMap);
                }
            } else {
                String[] accountList;
                for (String acctNumberStr : accountList = acctsStr.split(",")) {
                    Long acctId = numberToIdMap.get(acctNumberStr);
                    if (acctId == null) continue;
                    acctIds.add(acctId);
                    acctIdToAssistMap.put(acctId, asstMap);
                }
            }
        }
        return acctIdToAssistMap;
    }

    private String parseAssistStr(String accountStr, Map<String, Set<Object>> asstMap, ReClassNumberIDParam numberIDParam, String acctKeyId) {
        accountStr = accountStr.replaceAll("\\|", "\\| ");
        String[] accountValues = accountStr.split("\\|");
        String accountNumber = "";
        if (accountValues.length == 1) {
            accountNumber = accountValues[0];
        } else {
            if ((accountValues.length - 1) % 2 != 0) {
                return accountNumber;
            }
            accountNumber = accountValues[0];
        }
        if (StringUtils.isEmpty((CharSequence)accountNumber)) {
            return accountNumber;
        }
        Map<String, String> assistNumberToFlexMap = numberIDParam.getAssistToFlexMap();
        Map<String, Object> valNumberToIdsMap = numberIDParam.getassistValNumberToObjMap();
        Map<String, Set<Object>> valRangeNumberToIdsMap = numberIDParam.getassistValRangeNumberToObjsMap();
        Map<String, Set<Long>> assistFieldValToIdMap = numberIDParam.getAssistFieldValToIdMap();
        Map<String, Set<String>> filedMap = numberIDParam.getFieldToEntryFieldMap();
        boolean isPureCollection = this.isPureCollection(accountStr, numberIDParam);
        for (int i = 1; i < accountValues.length; i += 2) {
            String assistNumber = accountValues[i].trim();
            String flex = assistNumberToFlexMap.get(assistNumber);
            if (StringUtils.isBlank((CharSequence)flex)) {
                Map<String, Map<String, Object>> errorMap = numberIDParam.getErrorInfoMap();
                AcctUtil.setErrorMessage(errorMap, acctKeyId, ResManager.loadKDString((String)"\u516c\u5f0f\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u7f16\u7801\u6709\u8bef\u3002", (String)"AcctUtil_1", (String)"fi-gl-mservice", (Object[])new Object[0]), -1);
                break;
            }
            if (!isPureCollection) {
                Set<Object> valIds = new HashSet<Long>(16);
                if (StringUtils.isNotEmpty((CharSequence)accountValues[i + 1].trim())) {
                    String valStr = accountValues[i + 1].trim();
                    if (valStr.contains(":")) {
                        String[] valStrs = accountValues[i + 1].trim().replaceAll("\\:", "\\,").split("\\,");
                        String fieldNumber = valStrs[0];
                        ArrayList<String> assistFieldVals = new ArrayList<String>(10);
                        for (int j = 1; j < valStrs.length; ++j) {
                            assistFieldVals.add(AcctUtil.buildKey(new Object[]{assistNumber, fieldNumber, valStrs[j]}));
                        }
                        if (null != assistFieldValToIdMap && !assistFieldValToIdMap.isEmpty() && !assistFieldVals.isEmpty()) {
                            for (String assistFieldVal : assistFieldVals) {
                                Set<Long> assistVals = assistFieldValToIdMap.get(assistFieldVal);
                                if (null != assistVals && !assistVals.isEmpty()) {
                                    valIds.addAll(assistVals);
                                    continue;
                                }
                                for (Map.Entry<String, Set<String>> fieldMapEntry : filedMap.entrySet()) {
                                    if (!fieldMapEntry.getValue().contains(assistFieldVal)) continue;
                                    assistFieldVal = AcctUtil.buildKey(new Object[]{fieldMapEntry.getKey(), accountValues[2].split(":")[1]});
                                    assistVals = assistFieldValToIdMap.get(assistFieldVal);
                                }
                                if (assistVals == null || assistVals.isEmpty()) {
                                    valIds.add(0L);
                                    continue;
                                }
                                valIds.addAll(assistVals);
                            }
                        } else {
                            valIds.add(0L);
                        }
                    } else {
                        boolean isContinue = ReClassUtils.isContinueNumber(valStr);
                        if (isContinue) {
                            Set<Object> valueIdSet = valRangeNumberToIdsMap.get(assistNumber + "*" + valStr);
                            if (valueIdSet != null) {
                                valIds = valueIdSet;
                            } else {
                                valIds.add(0L);
                            }
                        } else {
                            String[] valList;
                            for (String valNumber : valList = valStr.split(",")) {
                                if (NONE_KEY.equals(valNumber)) {
                                    valIds.add(null);
                                    continue;
                                }
                                valIds.add(valNumberToIdsMap.get(assistNumber + "*" + valNumber) == null ? Long.valueOf(0L) : valNumberToIdsMap.get(assistNumber + "*" + valNumber));
                            }
                        }
                    }
                }
                asstMap.put(flex, valIds);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)accountValues[i + 1].trim())) continue;
            String valStr = accountValues[i + 1].trim();
            HashSet<Object> value = new HashSet<Object>(0);
            AssistIdCollectionType assistIdCollectionType = numberIDParam.getAssistValCollectionMap().get(assistNumber + "*" + valStr);
            if (Objects.nonNull(assistIdCollectionType)) {
                value.add(assistIdCollectionType);
            } else {
                value.add(0L);
            }
            asstMap.put(flex, value);
        }
        return accountNumber;
    }

    private static String buildKey(Object[] field) {
        return StringUtils.join((Object[])field, (String)"*");
    }

    public static boolean checkPeriodFormat(String periodStr) {
        if (StringUtils.isBlank((CharSequence)periodStr)) {
            return Boolean.FALSE;
        }
        if (periodStr.endsWith("T")) {
            char[] chars;
            if (StringUtils.isBlank((CharSequence)(periodStr = periodStr.substring(0, periodStr.length() - 1)))) {
                return Boolean.FALSE;
            }
            for (char ch : chars = periodStr.toCharArray()) {
                if (Character.isDigit(ch)) continue;
                return Boolean.FALSE;
            }
        } else {
            char[] chars = periodStr.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (i == 0 && '-' == chars[i] || Character.isDigit(chars[i])) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public static String dealYearAndPeriod(String periodStr, int comPeriod, String comAdjustPeriod, String yearStr, int comYear, Map<String, List<String>> periodFromYearMap) {
        String year = AcctUtil.getCurYear(yearStr, String.valueOf(comYear));
        String string = periodStr = StringUtils.isBlank((CharSequence)periodStr) ? ZERO_PERIOD : periodStr;
        if (periodStr.endsWith("T")) {
            return AcctUtil.buildYearAndPeriodKey(year, Integer.parseInt(periodStr.substring(0, periodStr.length() - 1)) + "T");
        }
        int period = Integer.parseInt(periodStr);
        if (period == 0) {
            return AcctUtil.buildYearAndPeriodKey(year, StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(comPeriod));
        }
        if (period < 0) {
            String curPeriod;
            period = Math.abs(period);
            String string2 = curPeriod = StringUtils.isNotBlank((CharSequence)comAdjustPeriod) ? comAdjustPeriod : String.valueOf(comPeriod);
            if (Objects.nonNull(periodFromYearMap)) {
                List<String> curYearPeriodList = periodFromYearMap.get(year);
                if (curYearPeriodList == null) {
                    return ZERO_PERIOD;
                }
                int index = curYearPeriodList.indexOf(curPeriod);
                if (index + 1 > period) {
                    return AcctUtil.buildYearAndPeriodKey(year, curYearPeriodList.get(index - period));
                }
                List<String> lastYearPeriodList = periodFromYearMap.get(String.valueOf(Integer.parseInt(year) - 1));
                if (CollectionUtils.isNotEmpty(lastYearPeriodList) && lastYearPeriodList.size() + index + 1 > period) {
                    return AcctUtil.buildYearAndPeriodKey(String.valueOf(Integer.parseInt(year) - 1), lastYearPeriodList.get(lastYearPeriodList.size() + index - period));
                }
                return ZERO_PERIOD;
            }
        }
        return AcctUtil.buildYearAndPeriodKey(year, String.valueOf(Integer.parseInt(periodStr)));
    }

    public static String getCurYear(String yearStr, String comYear) {
        String year = yearStr = StringUtils.isBlank((CharSequence)yearStr) ? ZERO_PERIOD : yearStr;
        if (Integer.parseInt(yearStr) <= 1000) {
            year = String.valueOf(Integer.parseInt(yearStr) + Integer.parseInt(comYear));
        }
        return year;
    }

    public static String buildYearAndPeriodKey(String year, String period) {
        return year + "-" + period;
    }

    public static Table<Long, String, List<String>> queryPeriodFromYear(Map<Long, Set<Integer>> periodTypeToYearNumMap) {
        HashBasedTable periodNumberFromYearTable = HashBasedTable.create();
        HashSet periodYearNumSet = new HashSet(8);
        periodTypeToYearNumMap.values().forEach(periodYearNumSet::addAll);
        HashSet<Integer> preYearNumSet = new HashSet<Integer>(8);
        for (Integer yearNum : periodYearNumSet) {
            preYearNumSet.add(yearNum - 1);
        }
        periodYearNumSet.addAll(preYearNumSet);
        if (!periodTypeToYearNumMap.keySet().isEmpty()) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
            filterList.add(new QFilter("periodyear", "in", periodYearNumSet));
            filterList.add(new QFilter("periodtype", "in", periodTypeToYearNumMap.keySet()));
            DataSet periodDataSet = QueryServiceHelper.queryDataSet((String)"queryPeriodFromYear", (String)"bd_period", (String)"id,periodtype,periodnumber,periodyear,isadjustperiod", (QFilter[])filterList.toArray(new QFilter[0]), (String)"periodyear,periodnumber,isadjustperiod");
            if (periodDataSet != null) {
                for (Row row : periodDataSet) {
                    String year = row.getString("periodyear");
                    String periodNumber = row.getString("periodnumber");
                    boolean isAdjust = row.getBoolean("isadjustperiod");
                    long periodTypeId = row.getLong("periodtype");
                    if (isAdjust && Integer.parseInt(periodNumber) <= 12) {
                        periodNumber = periodNumber + "T";
                    }
                    if (periodNumberFromYearTable.contains((Object)periodTypeId, (Object)year)) {
                        ((List)periodNumberFromYearTable.get((Object)periodTypeId, (Object)year)).add(periodNumber);
                        continue;
                    }
                    ArrayList<String> periodNumberList = new ArrayList<String>(8);
                    periodNumberList.add(periodNumber);
                    periodNumberFromYearTable.put((Object)periodTypeId, (Object)year, periodNumberList);
                }
            }
        }
        return periodNumberFromYearTable;
    }

    public static Map<String, Set<String>> parseComAssistStr(String comAssistStr) {
        comAssistStr = comAssistStr.replaceAll("\\|", "\\| ");
        String[] comAssistValues = comAssistStr.split("\\|");
        HashMap<String, Set<String>> comAssistKeyToNumMap = new HashMap<String, Set<String>>(8);
        for (int i = 0; i < comAssistValues.length; i += 2) {
            String comAssistKey = comAssistValues[i].trim();
            if (StringUtils.isBlank((CharSequence)comAssistKey)) continue;
            HashSet<String> valueNumberSet = new HashSet<String>(128);
            String rangeVals = "";
            String valStr = comAssistValues[i + 1].trim();
            if (!StringUtils.isBlank((CharSequence)valStr)) {
                if (AcctUtil.isRangeValueNumber(valStr)) {
                    rangeVals = valStr;
                    Set<String> rangeValNumbers = comAssistKeyToNumMap.get(comAssistKey) == null ? new HashSet(128) : (Set)comAssistKeyToNumMap.get(comAssistKey);
                    rangeValNumbers.add(rangeVals);
                    comAssistKeyToNumMap.put(comAssistKey, rangeValNumbers);
                    continue;
                }
                String[] valList = valStr.split(",");
                valueNumberSet.addAll(Arrays.asList(valList));
                HashSet allValNumberSet = (HashSet)comAssistKeyToNumMap.get(comAssistKey);
                if (allValNumberSet == null) {
                    allValNumberSet = new HashSet(128);
                }
                allValNumberSet.addAll(valueNumberSet);
                comAssistKeyToNumMap.put(comAssistKey, allValNumberSet);
                continue;
            }
            comAssistKeyToNumMap.put(comAssistKey, new HashSet());
        }
        return comAssistKeyToNumMap;
    }

    public static boolean isRangeValueNumber(String valueNum) {
        return ReClassUtils.isContinueNumber(valueNum);
    }

    public static boolean checkComAssistFormat(String comDimensionStr, boolean isCheckBlank) {
        if (isCheckBlank && StringUtils.isBlank((CharSequence)comDimensionStr)) {
            return Boolean.FALSE;
        }
        if (StringUtils.isNotBlank((CharSequence)comDimensionStr)) {
            String[] comAssistKeyAndValues = (comDimensionStr = comDimensionStr.replaceAll("\\|", "\\| ")).split("\\|");
            if (comAssistKeyAndValues.length % 2 != 0) {
                return Boolean.FALSE;
            }
            for (int i = 0; i < comAssistKeyAndValues.length; i += 2) {
                if (comAssistKeyAndValues[i].trim().startsWith("comassist")) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public static Table<String, String, Map<String, Set<Long>>> queryComAssistDispersedValueId(Table<String, String, Set<String>> allComAssistToValueNumTable, Map<String, Long> orgNumberToIdMap) {
        HashBasedTable comAssistDispersedValIdTable = HashBasedTable.create();
        for (Table.Cell allAssistToValueNumberCell : allComAssistToValueNumTable.cellSet()) {
            String orgNumber = (String)allAssistToValueNumberCell.getRowKey();
            long orgId = orgNumberToIdMap.getOrDefault(orgNumber, 0L);
            if (orgId == 0L) continue;
            String valueSource = (String)allAssistToValueNumberCell.getColumnKey();
            Set valueNumberSet = (Set)allAssistToValueNumberCell.getValue();
            if (!StringUtils.isNotBlank((CharSequence)valueSource)) continue;
            String entityId = valueSource;
            boolean isAssistantData = Boolean.FALSE;
            if (valueSource.startsWith("bos_assistantdata_detail")) {
                entityId = "bos_assistantdata_detail";
                isAssistantData = Boolean.TRUE;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId);
            if (orgFilter != null) {
                filters.add(orgFilter);
            }
            if (isAssistantData) {
                long groupId = Long.parseLong(valueSource.substring("bos_assistantdata_detail".length() + 1));
                QFilter assistantOrgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)groupId, (Long)orgId);
                if (assistantOrgFilter != null) {
                    filters.add(assistantOrgFilter);
                }
                QFilter groupFilter = new QFilter("group", "=", (Object)groupId);
                filters.add(groupFilter);
            }
            MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
            Map<String, Set<Long>> valueNumToIdsMap = detailHelper.getDetailAssists(entityId, valueNumberSet, filters);
            if (comAssistDispersedValIdTable.contains((Object)orgNumber, (Object)valueSource) && comAssistDispersedValIdTable.get((Object)orgNumber, (Object)valueSource) != null) {
                Map allValNumToIdMap = (Map)comAssistDispersedValIdTable.get((Object)orgNumber, (Object)valueSource);
                for (Map.Entry<String, Set<Long>> valueNumToIdsEntry : valueNumToIdsMap.entrySet()) {
                    HashSet allValueIdSet = (HashSet)allValNumToIdMap.get(valueNumToIdsEntry.getKey());
                    if (CollectionUtils.isNotEmpty((Collection)allValueIdSet)) {
                        allValueIdSet.addAll(valueNumToIdsEntry.getValue());
                        continue;
                    }
                    allValueIdSet = new HashSet(8);
                    allValueIdSet.addAll(valueNumToIdsEntry.getValue());
                    allValNumToIdMap.put(valueNumToIdsEntry.getKey(), allValueIdSet);
                }
                continue;
            }
            comAssistDispersedValIdTable.put((Object)orgNumber, (Object)valueSource, valueNumToIdsMap);
        }
        return comAssistDispersedValIdTable;
    }

    public static Table<String, String, Map<String, Set<Long>>> queryComAssistRangeValueId(Table<String, String, Set<String>> allComAssistToRangeNumTable, Map<String, Long> orgNumberToIdMap, Map<String, Long> standardMap, Map<String, DataSet> groupMap) {
        HashBasedTable comAssistRangeValIdTable = HashBasedTable.create();
        for (Table.Cell allComAssistToRangeNumCell : allComAssistToRangeNumTable.cellSet()) {
            String orgNumber = (String)allComAssistToRangeNumCell.getRowKey();
            long orgId = orgNumberToIdMap.getOrDefault(orgNumber, 0L);
            if (orgId == 0L) continue;
            String valueSource = (String)allComAssistToRangeNumCell.getColumnKey();
            Set rangeValueNumSet = (Set)allComAssistToRangeNumCell.getValue();
            if (!StringUtils.isNotBlank((CharSequence)valueSource)) continue;
            String entityId = valueSource;
            boolean isAssistantData = Boolean.FALSE;
            if (valueSource.startsWith("bos_assistantdata_detail")) {
                entityId = "bos_assistantdata_detail";
                isAssistantData = Boolean.TRUE;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgId);
            if (orgFilter != null) {
                filters.add(orgFilter);
            }
            if (isAssistantData) {
                long groupId = Long.parseLong(valueSource.substring("bos_assistantdata_detail".length() + 1));
                QFilter assistantOrgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)groupId, (Long)orgId);
                if (assistantOrgFilter != null) {
                    filters.add(assistantOrgFilter);
                }
                QFilter groupFilter = new QFilter("group", "=", (Object)groupId);
                filters.add(groupFilter);
            }
            MakeBaseDateDetailHelper detailHelper = new MakeBaseDateDetailHelper();
            Map rangeValNumToIdMap = new HashMap(8);
            if (comAssistRangeValIdTable.contains((Object)orgNumber, (Object)valueSource) && comAssistRangeValIdTable.get((Object)orgNumber, (Object)valueSource) != null) {
                rangeValNumToIdMap = (Map)comAssistRangeValIdTable.get((Object)orgNumber, (Object)valueSource);
            }
            for (String rangeValueNum : rangeValueNumSet) {
                boolean isClassify = ReClassUtils.isCollectionNumber(rangeValueNum);
                DataSet assistDataSet = null;
                if (isClassify) {
                    assistDataSet = AcctUtil.queryAssistValByGroup(rangeValueNum, entityId, standardMap, groupMap);
                } else {
                    String rangeValue = rangeValueNum.substring(1, rangeValueNum.length() - 1);
                    String[] continueValNum = rangeValue.split(",");
                    assistDataSet = AcctUtil.queryContinueNumber(Arrays.asList(continueValNum), filters, "masterid", entityId);
                }
                HashSet<Object> rangeValueIdSet = new HashSet<Object>(8);
                if (assistDataSet != null) {
                    for (Row assist : assistDataSet) {
                        rangeValueIdSet.add(assist.getLong("masterid"));
                    }
                }
                HashSet<Object> allRangeValIdSet = new HashSet<Object>(8);
                if (CollectionUtils.isNotEmpty(rangeValueIdSet)) {
                    allRangeValIdSet.addAll(rangeValueIdSet);
                }
                if (detailHelper.hasParent(entityId)) {
                    Set<Object> detailAssistIdSet = detailHelper.getDetailAssisttContinueNumbers(entityId, rangeValueIdSet, filters);
                    allRangeValIdSet.addAll(detailAssistIdSet);
                }
                Set allRangeValueIdSet = allRangeValIdSet.stream().map(valueId -> Long.parseLong(valueId.toString())).collect(Collectors.toSet());
                rangeValNumToIdMap.put(rangeValueNum, allRangeValueIdSet);
            }
            comAssistRangeValIdTable.put((Object)orgNumber, (Object)valueSource, rangeValNumToIdMap);
        }
        return comAssistRangeValIdTable;
    }

    public static DataSet queryAssistValByGroup(String categoryNumber, String entityId, Map<String, Long> standardMap, Map<String, DataSet> groupMap) {
        String groupKey = entityId.substring(3);
        String[] categoryList = categoryNumber.split("#");
        String standardNumber = categoryList[0];
        long standardId = 0L;
        if (standardMap.get(entityId + "*" + standardNumber) == null) {
            DataSet standardSet = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)(entityId + "groupstandard"), (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)standardNumber)}, null);
            for (Row row : standardSet) {
                standardId = row.getLong("id");
            }
            standardMap.put(entityId + "*" + standardNumber, standardId);
        } else {
            standardId = standardMap.get(entityId + "*" + standardNumber);
        }
        String groupNumber = categoryList[1];
        DataSet assistDataSet = null;
        if (groupMap.get(entityId + "*" + groupNumber) == null) {
            Set<Long> allGroupIds = AcctUtil.queryLeafCategory(groupNumber, entityId);
            QFilter groupIdFilter = new QFilter("group", "in", allGroupIds);
            QFilter standardIdFilter = new QFilter("standard", "=", (Object)standardId);
            String sel = groupKey + " masterid";
            assistDataSet = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)(entityId + "groupdetail"), (String)sel, (QFilter[])new QFilter[]{groupIdFilter, standardIdFilter}, null);
            groupMap.put(entityId + "*" + groupNumber, assistDataSet);
        } else {
            assistDataSet = groupMap.get(entityId + "*" + groupNumber);
        }
        return assistDataSet;
    }

    public static Set<Long> queryLeafCategory(String categoryNumber, String entityId) {
        entityId = entityId + "group";
        String[] assistContinueNumbers = null;
        String sel = "parent pid, id, isleaf";
        DataSet dataSet = null;
        if (categoryNumber.startsWith("[")) {
            assistContinueNumbers = (categoryNumber = categoryNumber.substring(1, categoryNumber.length() - 1)).split(",");
            if (assistContinueNumbers.length == 2) {
                dataSet = AcctUtil.queryContinueNumber(Arrays.asList(assistContinueNumbers), new ArrayList<QFilter>(), sel, entityId);
            }
        } else {
            String[] categoryList = categoryNumber.split(",");
            QFilter numberFilter = new QFilter("number", "in", (Object)categoryList);
            dataSet = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{numberFilter}, null);
        }
        HashSet<Long> allIds = new HashSet<Long>();
        HashSet<Long> noLeafIds = new HashSet<Long>();
        AcctUtil.getLeafAndNoLeaf(dataSet, noLeafIds, allIds);
        AcctUtil.getAllLeaf(noLeafIds, entityId, allIds);
        return allIds;
    }

    public static void getLeafAndNoLeaf(DataSet childSet, Set<Long> noLeafIds, Set<Long> allIds) {
        if (childSet == null) {
            return;
        }
        for (Row row : childSet) {
            long id = row.getLong("id");
            if (row.getBoolean("isleaf").booleanValue()) {
                allIds.add(id);
                continue;
            }
            allIds.add(id);
            noLeafIds.add(id);
        }
    }

    public static void getAllLeaf(Set<Long> noLeafIds, String entityId, Set<Long> leafIds) {
        if (noLeafIds.isEmpty()) {
            return;
        }
        QFilter parentFilter = new QFilter("parent", "in", noLeafIds);
        String sel = "id, isleaf";
        DataSet childSet = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)entityId, (String)sel, (QFilter[])new QFilter[]{parentFilter}, null);
        noLeafIds.clear();
        AcctUtil.getLeafAndNoLeaf(childSet, noLeafIds, leafIds);
        AcctUtil.getAllLeaf(noLeafIds, entityId, leafIds);
    }

    public static DataSet queryContinueNumber(List<String> assistNumbers, List<QFilter> filters, String sel, String entityName) {
        String startNumber = assistNumbers.get(0);
        String endNumber = assistNumbers.get(1);
        QFilter filterMin = new QFilter("number", ">=", (Object)startNumber);
        QFilter filterMax = new QFilter("number", "<=", (Object)endNumber);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(filters);
        filterList.add(filterMin);
        filterList.add(filterMax);
        return QueryServiceHelper.queryDataSet((String)"AcctFloatContext.queryContinueNumber", (String)entityName, (String)sel, (QFilter[])filterList.toArray(new QFilter[0]), (String)"number");
    }

    public static String getPeriodParam(String periodParam) {
        if (StringUtils.isNotBlank((CharSequence)periodParam)) {
            return periodParam;
        }
        return ZERO_PERIOD;
    }

    public static void setErrorMessage(Map<String, Map<String, Object>> allErrorMessageMap, String formulaId, String errorMessage, int errorType) {
        Map errorMessageMap = allErrorMessageMap.computeIfAbsent(formulaId, k -> new HashMap(8));
        errorMessageMap.put("v", errorMessage);
        errorMessageMap.put("type", errorType);
    }

    public static Map<String, Long> getOrgNumIdMap(Set<String> orgNumberSet) {
        HashMap<String, Long> orgNumIdMap = new HashMap<String, Long>();
        Lists.partition(Arrays.asList(orgNumberSet.toArray()), (int)1000).forEach(batch -> {
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)AcctUtil.class.getName(), (String)"bos_org", (String)"id,number", (QFilter[])new QFBuilder("number", "in", batch).toArray(), null);){
                Row row = null;
                while (dt.hasNext()) {
                    row = dt.next();
                    String number = row.getString("number");
                    long orgId = row.getLong("id");
                    orgNumIdMap.put(number, orgId);
                }
            }
        });
        return orgNumIdMap;
    }

    public static String getComAssistFromBCM(Map<String, Object> acctMap) {
        if (acctMap.get(COMMON_ASSIST) == null) {
            return null;
        }
        Map comAssistMap = (Map)acctMap.get(COMMON_ASSIST);
        StringBuilder comAssistSB = new StringBuilder();
        for (Map.Entry comAssistEntry : comAssistMap.entrySet()) {
            String comAssistKey = (String)comAssistEntry.getKey();
            String comAssistVal = String.join((CharSequence)",", (Iterable)comAssistEntry.getValue());
            comAssistSB.append(comAssistKey).append("|").append(comAssistVal).append("|");
        }
        if (comAssistSB.length() > 0) {
            comAssistSB.delete(comAssistSB.length() - 1, comAssistSB.length());
        }
        return comAssistSB.toString();
    }

    public static String checkPermByOrgId(String orgNum, String permName, long orgId, HasPermOrgResult permOrgResult) {
        String errorMsg = "";
        if (BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.service.getbalance.checkpermission", (boolean)false) && !permOrgResult.hasAllOrgPerm() && !permOrgResult.getHasPermOrgs().contains(orgId)) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ec4\u7ec7\u7f16\u7801\u4e3a%1$s\u7684%2$s\u63a5\u53e3\u7684\u6743\u9650\uff0c\u8bf7\u5148\u8fdb\u884c\u7528\u6237\u6388\u6743\u6216\u66f4\u6539\u516c\u5f0f\u914d\u7f6e\u3002", (String)"AcctBalParseAction_22", (String)"fi-gl-mservice", (Object[])new Object[0]), orgNum, permName);
        }
        return errorMsg;
    }
}

